/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.nf;

import java.util.Calendar;
import java.util.logging.Logger;

public class NotifierConstants {
    private static final Logger LOGGER = Logger.getLogger(NotifierConstants.class.getName());
    public static int dailyMailLimit = 500;
    public static int dailySmsLimit = 50;
    private static int numMailsSentToday = 0;
    private static int numSmsSentToday = 0;
    public static Calendar currentDay = Calendar.getInstance();

    public static void init() {
        dailySmsLimit = Integer.parseInt(System.getProperty("EC_dailySMSLimit", "50"));
        if ("disableComplete".equalsIgnoreCase(System.getProperty("mailLimitStatus", "disable"))) {
            dailyMailLimit = -1;
            LOGGER.info("Sms limit set to: " + dailySmsLimit + " mail limit  and set to " + dailyMailLimit);
        } else {
            dailyMailLimit = Integer.parseInt(System.getProperty("EC_dailyMailLimit", "500"));
            LOGGER.info("Sms limit set to: " + dailySmsLimit + " mail limit set to: " + dailyMailLimit + "");
        }
    }

    public static boolean isDailyEmailLimitReached() {
        NotifierConstants.checkAndResetValues();
        if (dailyMailLimit != -1 && numMailsSentToday >= dailyMailLimit) {
            LOGGER.fine("Daily Email Limit reached. ");
            return true;
        }
        return false;
    }

    public static boolean isDailySmsLimitReached() {
        NotifierConstants.checkAndResetValues();
        return numSmsSentToday >= dailySmsLimit;
    }

    private static void checkAndResetValues() {
        Calendar today = Calendar.getInstance();
        if (today.get(6) != currentDay.get(6)) {
            LOGGER.info("Day changed. resetting mail/sms count and current day:" + today);
            numMailsSentToday = 0;
            numSmsSentToday = 0;
            currentDay = today;
        }
    }

    public static void updateSentEmailCount() {
        ++numMailsSentToday;
    }

    public static void updateSentSmsCount() {
        ++numSmsSentToday;
    }
}

