/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.nf;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class NotifierSettings {
    private static final Logger LOGGER = Logger.getLogger(NotifierSettings.class.getName());
    private Map<String, String> mailServerSettings = new HashMap<String, String>();
    private String smsPort = null;
    private int baudRate = 9600;
    private static NotifierSettings instance = null;

    private NotifierSettings() {
    }

    public static synchronized NotifierSettings getInstance() {
        if (instance == null) {
            instance = new NotifierSettings();
        }
        return instance;
    }

    public void init() {
        this.updateMailServerSettings();
        this.updateSmsServerSettings();
    }

    public void updateMailServerSettings() {
        try {
            Row mailSettings = null;
            Table table = new Table("ADSConnectionSecurity");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            sql.addSelectColumn(new Column("ADSConnectionSecurity", "*"));
            sql.addSelectColumn(new Column("ADSMailSettings", "*"));
            sql.addJoin(new Join(new Table("ADSConnectionSecurity"), new Table("ADSMailSettings"), new String[]{"CONNECTION_SECURITY_ID"}, new String[]{"CONNECTION_SECURITY_ID"}, 1));
            DataObject doo = DataAccess.get((SelectQuery)sql);
            mailSettings = doo.getRow("ADSMailSettings");
            if (mailSettings != null) {
                this.mailServerSettings.put("SMTPSERVER", (String)mailSettings.get("SERVER_NAME"));
                this.mailServerSettings.put("PORT", ((String)mailSettings.get("PORT")).toString());
                this.mailServerSettings.put("USERNAME", (String)mailSettings.get("USER_NAME"));
                this.mailServerSettings.put("PASSWORD", (String)mailSettings.get("PASSWORD"));
                boolean is_auth = mailSettings.get("USER_NAME") != null && mailSettings.get("PASSWORD") != null;
                this.mailServerSettings.put("AUTHENTICATE", String.valueOf(is_auth));
                Long connectionid = (Long)mailSettings.get("CONNECTION_SECURITY_ID");
                String tls = (String)doo.getValue("ADSConnectionSecurity", "NAME", new Criteria(new Column("ADSConnectionSecurity", "CONNECTION_SECURITY_ID"), (Object)connectionid, 0));
                this.mailServerSettings.put("TLS", tls);
                this.mailServerSettings.put("FROM", (String)mailSettings.get("FROM_MAIL_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, String> getMailServerSettings() {
        return this.mailServerSettings;
    }

    public void updateSmsServerSettings() {
        this.baudRate = Integer.parseInt(System.getProperty("baudRate", "9600"));
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SmsServerSettings"));
            query.addSelectColumn(new Column("SmsServerSettings", "*"));
            query.setCriteria(new Criteria(new Column("SmsServerSettings", "TYPE"), (Object)"SYSLOG", 0));
            DataObject doo = DataAccess.get((SelectQuery)query);
            Row r = doo.getRow("SmsServerSettings");
            if (r != null) {
                this.smsPort = (String)r.get("PORT");
            }
            LOGGER.info("Sms Settings :" + this.smsPort);
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
        }
    }

    public String getSmsServerPort() {
        return this.smsPort;
    }

    public int getSmsBaudRate() {
        return this.baudRate;
    }
}

