/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.nf;

import com.adventnet.la.CorrelationField;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.fieldgen.LogFormatHandlerImpl;
import com.adventnet.sa.server.nf.NotificationProfile;
import com.adventnet.sa.server.nf.Notifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class ScriptNotifier
implements Notifier {
    private static final Logger LOGGER = Logger.getLogger(ScriptNotifier.class.getName());
    private String scriptName;
    private String args;
    private String prefix;
    private boolean isSourcePresent;
    private boolean isHostNamePresent;
    private boolean isCriticalityPresent;
    private boolean isMessagePresent;
    private List corrfield = Arrays.asList("SOURCEOFLOG", "DHOST");

    public ScriptNotifier(Row r) {
        this.scriptName = (String)r.get("LOCATION");
        this.args = ((String)r.get("ARGUMENTS")).trim();
        String os = System.getProperty("os.name", "Windows");
        if (os.startsWith("Win")) {
            this.prefix = "cmd /c \"\"" + this.scriptName + "\"";
        }
        this.isSourcePresent = this.args.indexOf("$source") >= 0;
        this.isHostNamePresent = this.args.indexOf("$hostname") >= 0;
        this.isCriticalityPresent = this.args.indexOf("$criticality") >= 0;
        this.isMessagePresent = this.args.indexOf("$message") >= 0;
    }

    private boolean executeScript(String tempArgs) {
        String cmd = null;
        try {
            String os = System.getProperty("os.name", "Windows");
            if (os.startsWith("Win")) {
                cmd = this.prefix + " " + tempArgs + "\"";
                Runtime rt = Runtime.getRuntime();
                Process process = rt.exec(cmd);
                LOGGER.info("Going to execute script : " + cmd);
            } else {
                ArrayList<String> command = new ArrayList<String>();
                command.add("sh");
                command.add(this.scriptName);
                StringTokenizer tokens = new StringTokenizer(tempArgs, ",");
                while (tokens.hasMoreTokens()) {
                    command.add(tokens.nextToken());
                }
                Process process = new ProcessBuilder(command).start();
                LOGGER.info("Going to execute script : " + ((Object)command).toString());
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.info("Exception while executing script" + e);
            return false;
        }
    }

    @Override
    public boolean notify(NotificationProfile profile, Hashtable log) {
        String tempArgs = null;
        tempArgs = log.containsValue("FIM") ? this.getFimArguments(profile, log) : this.getArguments(profile, log);
        return this.executeScript(tempArgs);
    }

    @Override
    public boolean processNotification(Hashtable log) {
        String tempArgs = this.getCorrelArguments(log);
        return this.executeScript(tempArgs);
    }

    private String getArguments(NotificationProfile profile, Hashtable log) {
        String[] arg;
        String tempArgs = new String(this.args);
        for (String val : arg = tempArgs.split(",")) {
            if ((val = val.trim()).indexOf("$") >= 0) continue;
            String res = null;
            if ("LOGTYPE".equalsIgnoreCase(val)) {
                if (log.get("HOSTTYPE") != null) {
                    res = log.get("HOSTTYPE").toString();
                } else if (log.get("FORMATID") != null) {
                    res = LogFormatHandlerImpl.getInstance().getFormatNameForId((Long)log.get("FORMATID"));
                }
            } else {
                res = String.valueOf(log.get(val));
            }
            res = Matcher.quoteReplacement(res);
            tempArgs = tempArgs.replaceAll(val, res);
        }
        if (this.isSourcePresent) {
            tempArgs = tempArgs.replaceAll("\\$source", "\"" + Matcher.quoteReplacement((String)log.get("SOURCE")) + "\"");
        }
        if (this.isHostNamePresent) {
            tempArgs = tempArgs.replaceAll("\\$hostname", "\"" + (String)log.get("DISPLAY_NAME") + "\"");
        }
        if (this.isCriticalityPresent) {
            tempArgs = tempArgs.replaceAll("\\$criticality", profile.getCriticality());
        }
        if (this.isMessagePresent) {
            String message = (String)log.get("MESSAGE");
            message = message.replace("\n", "");
            message = message.replace("\r", "");
            tempArgs = tempArgs.replaceAll("\\$message", "\"" + Matcher.quoteReplacement(message) + "\"");
        }
        return tempArgs;
    }

    private String getFimArguments(NotificationProfile profile, Hashtable log) {
        String[] arg;
        String tempArgs = new String(this.args);
        for (String val : arg = tempArgs.split(",")) {
            if ((val = val.trim()).indexOf("$") >= 0) continue;
            String res = null;
            res = String.valueOf(log.get(val));
            res = Matcher.quoteReplacement(res);
            tempArgs = tempArgs.replaceAll(val, res);
        }
        if (this.isSourcePresent) {
            String result = null;
            result = log.get("USERNAME") != null && !"-".equals((String)log.get("USERNAME")) ? (String)log.get("CHANGETYPE") + " by " + log.get("USERNAME") : (String)log.get("CHANGETYPE");
            tempArgs = tempArgs.replaceAll("\\$source", "\"" + Matcher.quoteReplacement(result) + "\"");
        }
        if (this.isHostNamePresent) {
            tempArgs = tempArgs.replaceAll("\\$hostname", "\"" + (String)log.get("DISPLAY_NAME") + "\"");
        }
        if (this.isCriticalityPresent) {
            tempArgs = tempArgs.replaceAll("\\$criticality", profile.getCriticality());
        }
        if (this.isMessagePresent) {
            tempArgs = tempArgs.replaceAll("\\$message", "\"" + Matcher.quoteReplacement((String)log.get("FILENAME")) + "\"");
        }
        return tempArgs;
    }

    private String getCorrelArguments(Hashtable log) {
        String tempArgs = new String(this.args);
        String rid = (String)log.get("RULEID");
        Long ruleid = Long.valueOf(rid);
        this.corrfield = CorrelationField.getList((Long)ruleid) != null ? CorrelationField.getList((Long)ruleid) : this.corrfield;
        for (int i = 0; i < this.corrfield.size(); ++i) {
            if (tempArgs.indexOf((String)this.corrfield.get(i)) < 0) continue;
            String res = (String)log.get(this.corrfield.get(i));
            res = Matcher.quoteReplacement(res);
            tempArgs = tempArgs.replaceAll((String)this.corrfield.get(i), res);
        }
        return tempArgs;
    }
}

