/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.nf;

import com.adventnet.la.CorrelationField;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.cnf.CorrelationConstants;
import com.adventnet.sa.server.nf.NotificationProfile;
import com.adventnet.sa.server.nf.Notifier;
import com.adventnet.sa.server.nf.NotifierConstants;
import com.adventnet.sa.server.nf.NotifierSettings;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.smslib.COutgoingMessage;
import org.smslib.CService;

public class SmsNotifier
implements Notifier {
    private static final Logger LOGGER = Logger.getLogger(SmsNotifier.class.getName());
    private String[] numbers;
    private String descPattern;
    private List corrfield = Arrays.asList("SOURCEOFLOG", "DHOST");

    public SmsNotifier(Row r) {
        this.numbers = ((String)r.get("SMSID")).split(",");
        this.descPattern = (String)r.get("SMS_DESCRIPTION");
    }

    @Override
    public boolean notify(NotificationProfile profile, Hashtable log) {
        boolean notifStatus;
        if (NotifierConstants.isDailySmsLimitReached()) {
            return true;
        }
        String sms = new String(this.descPattern);
        if (sms.indexOf("$alertname") >= 0) {
            sms = sms.replaceAll("\\$alertname", "ALERTNAME : " + profile.getNotifName());
        }
        if (sms.indexOf("$source") >= 0) {
            if (log.containsValue("FIM")) {
                String result = null;
                result = log.get("USERNAME") != null && !"-".equals((String)log.get("USERNAME")) ? log.get("CHANGETYPE").toString().toLowerCase() + " by " + log.get("USERNAME") : log.get("CHANGETYPE").toString().toLowerCase();
                sms = sms.replaceAll("\\$source", " CHANGETYPE : " + result);
            } else {
                sms = sms.replaceAll("\\$source", " SOURCE : " + log.get("SOURCE"));
            }
        }
        if (sms.indexOf("$hostname") >= 0) {
            sms = sms.replaceAll("\\$hostname", " HOSTNAME : " + log.get("DISPLAY_NAME"));
        }
        if (sms.indexOf("$criticality") >= 0) {
            sms = sms.replaceAll("\\$criticality ", " CRITICALITY : " + profile.getCriticality());
        }
        if (sms.indexOf("$NoOfOccurances") >= 0) {
            sms = sms.replaceAll("\\$NoOfOccurances ", " OCCURANCES : " + profile.getOccurances());
        }
        if (sms.indexOf("$message") != -1) {
            sms = log.containsValue("FIM") ? sms.replaceAll("\\$message", " FILENAME : " + log.get("FILENAME").toString().replace("\\", "\\\\")) : sms.replaceAll("\\$message", " MESSAGE : " + log.get("MESSAGE"));
        }
        ResourceBundle rb = ProductBundle.getInstance().getBundle();
        if (sms.indexOf("$") < 0) {
            String[] arg;
            for (String val : arg = sms.split(",")) {
                val = val.trim();
                String replacedValue = "";
                try {
                    replacedValue = rb.getString(val);
                }
                catch (Exception e) {
                    replacedValue = val;
                }
                String res = String.valueOf(log.get(val));
                res = Matcher.quoteReplacement(res);
                sms = sms.replaceAll(val, replacedValue + " : " + res);
            }
        }
        if (notifStatus = this.sendSms(sms)) {
            NotifierConstants.updateSentSmsCount();
        }
        return notifStatus;
    }

    @Override
    public synchronized boolean processNotification(Hashtable log) {
        try {
            if (CorrelationConstants.isDailySmsLimitReached()) {
                LOGGER.info("DailyLimit Exceeded so skiping the CorrelationSMS sending...");
                return true;
            }
            ResourceBundle rb = ProductBundle.getInstance().getBundle();
            String rid = (String)log.get("RULEID");
            Long ruleid = Long.valueOf(rid);
            this.corrfield = CorrelationField.getList((Long)ruleid) != null ? CorrelationField.getList((Long)ruleid) : this.corrfield;
            String sms = new String(this.descPattern);
            for (int i = 0; i < this.corrfield.size(); ++i) {
                if (sms.indexOf((String)this.corrfield.get(i)) < 0) continue;
                String value = rb.getString("CorrelationKey." + this.corrfield.get(i));
                String res = (String)log.get(this.corrfield.get(i));
                res = Matcher.quoteReplacement(res);
                sms = sms.replaceAll((String)this.corrfield.get(i), value + " : " + res);
            }
            boolean notifStatus = this.sendSms(sms);
            if (notifStatus) {
                CorrelationConstants.updateSentSmsCount();
            }
            return notifStatus;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendSms(String sms) {
        String port = NotifierSettings.getInstance().getSmsServerPort();
        int baudRate = NotifierSettings.getInstance().getSmsBaudRate();
        CService srv = new CService(port, baudRate, "Nokia", "6100");
        try {
            int i;
            LOGGER.fine(" sending sms in baudRate(TestSMS)::::::" + baudRate);
            srv.setSimPin("0000");
            srv.connect();
            srv.setSmscNumber("");
            for (i = 0; i < this.numbers.length; ++i) {
                COutgoingMessage msg = new COutgoingMessage(this.numbers[i], sms);
                msg.setMessageEncoding(1);
                msg.setSourcePort(0);
                srv.sendMessage(msg);
            }
            i = 1;
            return i != 0;
        }
        catch (Exception e) {
            LOGGER.info("Exception while sending sms");
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (srv != null && srv.getConnected()) {
                srv.disconnect();
            }
        }
    }
}

