/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.nf.assign;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.assign.AssignToCriteria;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class AssignToProfile {
    private String name = null;
    private Long id = null;
    private Long userId = -1L;
    private Set<AssignToCriteria> crit = new HashSet<AssignToCriteria>();

    public Long getUserId() {
        return this.userId;
    }

    public AssignToProfile(Row r, DataObject doo) {
        try {
            this.name = (String)r.get("RULE_NAME");
            this.id = (Long)r.get("RULE_ID");
            this.populateDeviceCriteria(doo);
            this.populateDeviceGroupCriteria(doo);
            this.populateCustomCriteria(doo);
            this.getUserId(doo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getUserId(DataObject doo) throws DataAccessException {
        Iterator it = doo.getRows("ELA_AssignRulesToUser", new Criteria(Column.getColumn((String)"ELA_AssignRulesToUser", (String)"RULE_ID"), (Object)this.id, 0));
        while (it.hasNext()) {
            Row r = (Row)it.next();
            this.userId = (Long)r.get("USER_ID");
        }
    }

    private void populateDeviceGroupCriteria(DataObject doo) throws DataAccessException {
        Iterator it = doo.getRows("ELA_AssignRulesDeviceGroup", new Criteria(Column.getColumn((String)"ELA_AssignRulesDeviceGroup", (String)"RULE_ID"), (Object)this.id, 0));
        Row r = null;
        while (it.hasNext()) {
            r = (Row)it.next();
            AssignToCriteria ac = new AssignToCriteria();
            ac.setField("HOSTID");
            ac.setCondition((Integer)r.get("CONDITION"));
            Long groupid = (Long)r.get("GROUP_ID");
            DataObject gDO = this.getGroupDO(groupid);
            Iterator row1 = gDO.getRows("HostGroupMapping");
            ArrayList<String> nl = new ArrayList<String>();
            while (row1.hasNext()) {
                Row r1 = (Row)row1.next();
                nl.add(Long.toString((Long)r1.get("HOSTID")));
            }
            ac.setValue(nl);
            this.crit.add(ac);
        }
    }

    private DataObject getGroupDO(Long groupid) throws DataAccessException {
        Table table1 = new Table("HostGroupMapping");
        SelectQueryImpl query = new SelectQueryImpl(table1);
        query.setCriteria(new Criteria(Column.getColumn((String)"HostGroupMapping", (String)"GROUPID"), (Object)groupid, 0));
        query.addSelectColumn(Column.getColumn((String)"HostGroupMapping", (String)"*"));
        return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
    }

    private void populateCustomCriteria(DataObject doo) throws DataAccessException {
        Iterator it = doo.getRows("ELA_AssignRulesCriteria", new Criteria(Column.getColumn((String)"ELA_AssignRulesCriteria", (String)"RULE_ID"), (Object)this.id, 0));
        Row r = null;
        while (it.hasNext()) {
            r = (Row)it.next();
            AssignToCriteria ac = new AssignToCriteria();
            ac.setField((String)r.get("KEY"));
            ac.setCondition((Integer)r.get("CONDITION"));
            ac.setValue((String)r.get("VALUE"));
            this.crit.add(ac);
        }
    }

    private void populateDeviceCriteria(DataObject doo) throws DataAccessException {
        Iterator it = doo.getRows("ELA_AssignRulesDevice", new Criteria(Column.getColumn((String)"ELA_AssignRulesDevice", (String)"RULE_ID"), (Object)this.id, 0));
        Row r = null;
        while (it.hasNext()) {
            r = (Row)it.next();
            AssignToCriteria ac = new AssignToCriteria();
            ac.setField("HOSTID");
            ac.setCondition((Integer)r.get("CONDITION"));
            Long deviceid = (Long)r.get("DEVICE_ID");
            ac.setValue(Long.toString(deviceid));
            this.crit.add(ac);
        }
    }

    public boolean check(Hashtable log) {
        if (this.userId < 0L) {
            return false;
        }
        for (AssignToCriteria cri : this.crit) {
            if (!cri.check(log)) continue;
            return true;
        }
        return false;
    }
}

