/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.nf.assign;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.assign.AssignToProfile;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AssignedToHandler {
    private static AssignedToHandler instance = null;
    private Vector<AssignToProfile> rules = new Vector();
    private static final ReadWriteLock RWLOCK = new ReentrantReadWriteLock(true);

    public static synchronized AssignedToHandler getInstance() {
        if (instance == null) {
            instance = new AssignedToHandler();
        }
        return instance;
    }

    public AssignedToHandler() {
        this.refreshAllProfiles();
    }

    public void refreshAllProfiles() {
        RWLOCK.writeLock().lock();
        try {
            this.rules.clear();
            this.populateProfiles();
        }
        finally {
            RWLOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long process(Hashtable log) {
        Long result = -1L;
        RWLOCK.readLock().lock();
        try {
            for (AssignToProfile profile : this.rules) {
                if (!profile.check(log)) continue;
                Long l = profile.getUserId();
                return l;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            RWLOCK.readLock().unlock();
        }
        return result;
    }

    private void populateProfiles() {
        try {
            DataObject doo = this.getDO();
            if (doo != null && !doo.isEmpty()) {
                Iterator it = doo.getRows("ELA_AssignRules");
                Row r = null;
                while (it.hasNext()) {
                    r = (Row)it.next();
                    AssignToProfile atp = new AssignToProfile(r, doo);
                    this.rules.add(atp);
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private DataObject getDO() throws DataAccessException {
        Table table1 = new Table("ELA_AssignRules");
        Table table2 = new Table("ELA_AssignRulesDevice");
        Table table3 = new Table("ELA_AssignRulesDeviceGroup");
        Table table4 = new Table("ELA_AssignRulesCriteria");
        Table table5 = new Table("ELA_AssignRulesToUser");
        Table table6 = new Table("Hosts");
        SelectQueryImpl query = new SelectQueryImpl(table1);
        Join join1 = new Join(table1, table2, new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1);
        Join join2 = new Join(table1, table3, new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1);
        Join join3 = new Join(table1, table4, new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1);
        Join join4 = new Join(table1, table5, new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1);
        Join join5 = new Join(table2, table6, new String[]{"DEVICE_ID"}, new String[]{"HOST_ID"}, 1);
        query.addJoin(join1);
        query.addJoin(join2);
        query.addJoin(join3);
        query.addJoin(join4);
        query.addJoin(join5);
        query.addSelectColumn(Column.getColumn((String)"ELA_AssignRules", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"ELA_AssignRulesDevice", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"ELA_AssignRulesDeviceGroup", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"ELA_AssignRulesCriteria", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"ELA_AssignRulesToUser", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"Hosts", (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"ELA_AssignRules", (String)"PRIORITY"), true));
        query.setCriteria(new Criteria(Column.getColumn((String)"ELA_AssignRules", (String)"ENABLE"), (Object)true, 0));
        return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
    }
}

