/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.nf.incident;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.NotificationProfile;
import com.adventnet.sa.server.nf.Notifier;
import com.manageengine.ads.fw.util.HttpClientUtil;
import com.manageengine.ela.server.common.config.servicedesk.HttpPostHandler;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class IncidentNotifier
implements Notifier {
    private Long productID = null;
    private String authorization = null;
    private String contentType = null;
    private String authToken = null;
    private String host = null;
    private Long port = null;
    private URL serverUrl = null;
    private String apiUrl = null;
    private String protocol = null;
    private String username = null;
    private String password = null;
    private String bodyFields = null;
    HttpPostHandler postHandler = null;
    private String oAuthToken = null;
    private String arJWTToken = null;
    private static final List<String> WIN_SEVERITY = Arrays.asList("error", "warning", "information", "success", "failure");
    private static final List<String> SYS_SEVERITY = Arrays.asList("emergency", "alert", "critical", "error", "warning", "notice", "information", "debug");

    public IncidentNotifier(Long productID) {
        this.productID = productID;
        try {
            this.populate();
            if (this.isConfigured()) {
                this.postHandler = HttpPostHandler.getInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getAuthentication() {
        if (this.authorization != null) {
            if ("Basic".equalsIgnoreCase(this.authorization)) {
                String login = this.username + ":" + this.password;
                return "Basic " + Base64.getEncoder().encodeToString(login.getBytes());
            }
            if ("OAuth".equalsIgnoreCase(this.authorization)) {
                return this.handleOAuthAuthentication();
            }
            if ("AR-JWT".equalsIgnoreCase(this.authorization)) {
                return this.handleARJWTAuthentication();
            }
        }
        return null;
    }

    private String handleARJWTAuthentication() {
        String token = null;
        try {
            JSONObject authObject = new JSONObject(this.authToken);
            URL serverUrl = new URL(this.protocol, this.host, this.port.intValue(), authObject.getString("authAPI"));
            HttpPost method = new HttpPost(serverUrl.toString());
            method.setHeader("Content-Type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("username", this.username));
            nvps.add(new BasicNameValuePair("password", this.password));
            method.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            CloseableHttpClient client = HttpClientUtil.getConcurrentHttpClient();
            HttpResponse resp = client.execute((HttpUriRequest)method);
            token = EntityUtils.toString((HttpEntity)resp.getEntity());
            this.arJWTToken = "AR-JWT " + token;
            return this.arJWTToken;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String handleOAuthAuthentication() {
        try {
            JSONObject authObject = new JSONObject(this.authToken);
            String authAPI = authObject.getString("authAPI");
            JSONObject authBody = authObject.getJSONObject("authBody");
            URL serverUrl = new URL(this.protocol, this.host, authAPI);
            HttpPost method = new HttpPost(serverUrl.toString());
            method.setConfig(RequestConfig.custom().setSocketTimeout(10000).build());
            method.setHeader("Content-Type", "application/json");
            StringEntity authenticate = new StringEntity(authBody.toString());
            method.setEntity((HttpEntity)authenticate);
            CloseableHttpClient client = HttpClientUtil.getConcurrentHttpClient();
            HttpResponse resp = client.execute((HttpUriRequest)method);
            JSONObject jsonstring = new JSONObject(EntityUtils.toString((HttpEntity)resp.getEntity()));
            this.oAuthToken = "Bearer " + jsonstring.getString("access_token");
            return this.oAuthToken;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public HttpURLConnection getConnection(URL applurl) throws Exception {
        HttpsURLConnection connection = null;
        connection = (HttpsURLConnection)applurl.openConnection();
        return connection;
    }

    private HttpPost getPostMethod() throws Exception {
        HttpPost method = new HttpPost(this.serverUrl.toString());
        method.setConfig(RequestConfig.custom().setSocketTimeout(10000).build());
        method.setHeader("Content-Type", this.contentType);
        if (!"none".equalsIgnoreCase(this.authorization) && !"".equals(this.authorization) && this.authorization != null) {
            method.setHeader("Authorization", this.getAuthentication());
        }
        return method;
    }

    public boolean isConfigured() {
        return this.host != null;
    }

    private void populate() throws Exception {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSIncidentToolConfiguration"));
        query.addSelectColumn(Column.getColumn((String)"ADSIncidentToolConfiguration", (String)"*"));
        query.setCriteria(new Criteria(Column.getColumn((String)"ADSIncidentToolConfiguration", (String)"CONFIG_ID"), (Object)this.productID, 0));
        DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
        if (dobj != null) {
            Iterator itr = dobj.getRows("ADSIncidentToolConfiguration");
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                this.host = (String)r.get("SERVER_NAME");
                this.port = (Long)r.get("PORT");
                this.protocol = (String)r.get("PROTOCOL");
                this.username = (String)r.get("USERNAME");
                this.password = (String)r.get("PASSWORD");
                this.authorization = (String)r.get("AUTHENTICATION");
                this.authToken = (String)r.get("AUTH_TOKENS");
                this.contentType = (String)r.get("CONTENT_TYPE");
                this.apiUrl = (String)r.get("API_URL");
                this.bodyFields = StringEscapeUtils.unescapeHtml4((String)((String)r.get("BODY_FIELDS")));
            }
            if (this.host != null) {
                this.serverUrl = this.port == null ? (this.protocol == null ? new URL("HTTPS", this.host, this.apiUrl) : new URL(this.protocol.toUpperCase(), this.host, this.apiUrl)) : (this.protocol == null ? new URL("HTTPS", this.host, this.port.intValue(), this.apiUrl) : new URL(this.protocol.toUpperCase(), this.host, this.port.intValue(), this.apiUrl));
            }
        }
    }

    @Override
    public boolean notify(NotificationProfile profile, Hashtable log) {
        try {
            HttpPost postmethod = this.getPostMethod();
            if ("application/json".equals(this.contentType)) {
                postmethod.setEntity((HttpEntity)this.getJSONEntity(log, profile));
            } else {
                postmethod.setEntity((HttpEntity)this.getURLEntity(log, profile));
            }
            this.postHandler.add(postmethod);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private StringEntity getJSONEntity(Hashtable log, NotificationProfile profile) throws Exception {
        Pattern pattern = Pattern.compile("\\$(\\w*)");
        Matcher matcher = pattern.matcher(this.bodyFields);
        String fields = this.bodyFields;
        while (matcher.find()) {
            String dynaField = matcher.group(1);
            if (dynaField.trim().isEmpty()) continue;
            if ("alertname".equalsIgnoreCase(dynaField)) {
                fields = fields.replaceAll("\\$" + dynaField, profile.getNotifName());
                continue;
            }
            if ("severity".equalsIgnoreCase(dynaField)) {
                String replacement = "-";
                String hostType = (String)log.get("HOSTTYPE");
                if (hostType == null) {
                    hostType = "application";
                }
                replacement = "windows".equalsIgnoreCase(hostType) ? WIN_SEVERITY.get((Integer)log.get("SEVERITY")) : SYS_SEVERITY.get((Integer)log.get("SEVERITY"));
                fields = fields.replaceAll("\\$" + dynaField, replacement);
                continue;
            }
            String value = "";
            if (log.containsKey(dynaField.trim())) {
                value = log.get(dynaField.trim()).toString();
            }
            value = value.replaceAll("\r", "");
            value = value.replaceAll("\n", " ");
            value = value.replaceAll("\t", "");
            value = value.replaceAll("\"", "");
            value = value.replaceAll(",", "");
            value = value.replaceAll("'", "");
            value = value.replaceAll("\"", "");
            value = value.replaceAll("\\$", "");
            if ((value = value.replaceAll("\\\\", "")) != null && !value.isEmpty() && !value.equals("-")) {
                fields = fields.replaceAll("\\$" + dynaField, Matcher.quoteReplacement(value));
                continue;
            }
            fields = fields.replaceAll("\\$" + dynaField, dynaField + " -");
        }
        fields = fields.trim();
        return new StringEntity(new JSONObject(fields).toString());
    }

    private UrlEncodedFormEntity getURLEntity(Hashtable log, NotificationProfile profile) throws Exception {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        String[] urlFields = this.bodyFields.split("&");
        for (int i = 0; i < urlFields.length; ++i) {
            String[] values = urlFields[i].trim().split("=");
            Pattern pattern = Pattern.compile("\\$(\\w*)");
            Matcher matcher = pattern.matcher(values[1].trim());
            try {
                while (matcher.find()) {
                    String field = matcher.group(1);
                    if (field.trim().isEmpty()) continue;
                    if ("alertname".equalsIgnoreCase(field)) {
                        values[1] = values[1].replaceAll("\\$" + field, profile.getNotifName());
                        continue;
                    }
                    if ("severity".equalsIgnoreCase(field)) {
                        String replacement = "-";
                        String hostType = (String)log.get("HOSTTYPE");
                        if (hostType == null) {
                            hostType = "application";
                        }
                        replacement = "windows".equalsIgnoreCase(hostType) ? WIN_SEVERITY.get((Integer)log.get("SEVERITY")) : SYS_SEVERITY.get((Integer)log.get("SEVERITY"));
                        values[1] = values[1].replaceAll("\\$" + field, replacement);
                        continue;
                    }
                    String value = "";
                    if (log.containsKey(field.trim())) {
                        value = log.get(field.trim()).toString();
                    }
                    value = value.replaceAll("\r", "");
                    value = value.replaceAll("\n", " ");
                    value = value.replaceAll("\t", "");
                    value = value.replaceAll("\"", "");
                    value = value.replaceAll(",", "");
                    value = value.replaceAll("\\$", "");
                    value = value.replaceAll("'", "");
                    value = value.replaceAll("\"", "");
                    if ((value = value.replaceAll("\\\\", "")) != null && !value.isEmpty() && !value.equals("-")) {
                        values[1] = values[1].replaceAll("\\$" + field, value);
                        continue;
                    }
                    values[1] = values[1].replaceAll("\\$" + field, field + " -");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            params.add(new BasicNameValuePair(values[0], values[1]));
        }
        if ("none".equals(this.authorization) || "NONE".equals(this.authorization) || "".equals(this.authorization)) {
            params.add(new BasicNameValuePair("username", this.username));
            params.add(new BasicNameValuePair("password", this.password));
        }
        return new UrlEncodedFormEntity(params);
    }

    @Override
    public boolean processNotification(Hashtable log) {
        return false;
    }
}

