/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.parser;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.LuceneUtil;
import com.adventnet.la.util.MetaTableCache;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.dm.MssqlProcessHandler;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.identifier.Identifier;
import com.adventnet.sa.server.identifier.ParserDetails;
import com.adventnet.sa.server.parser.Field;
import com.adventnet.sa.server.parser.LogFormat;
import com.adventnet.sa.server.parser.ReportCategory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DbUtil {
    private static final Logger LOGGER = Logger.getLogger(DbUtil.class.getName());
    private static DbUtil _instance = null;
    private static boolean dbType = "mysql".equals(System.getProperty("DBType", "mysql"));
    private static boolean isPostgres = "postgres".equals(System.getProperty("DBType", "postgres"));
    private static MssqlProcessHandler mssqlHandler = new MssqlProcessHandler();
    private Hashtable formatMap = new Hashtable();
    private ArrayList updatedFormats = new ArrayList();
    private Persistence persistence = null;
    private Hashtable<Long, String> appIdVsLogTypeNameMap = new Hashtable();

    public static synchronized DbUtil get_instance() {
        if (_instance == null) {
            _instance = new DbUtil();
        }
        return _instance;
    }

    private DbUtil() {
        boolean isAdminServer;
        this.persistence = PersistenceDBUtil.getPersistence();
        boolean bl = isAdminServer = "true".equals(System.getProperty("isAdminServer"));
        if (!isAdminServer) {
            this.updateFormats();
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createReportTable(String tableName, int numFields) {
        boolean retVal = true;
        Statement stat = null;
        Connection conn = null;
        try {
            LOGGER.log(Level.INFO, "Creating table : " + tableName);
            conn = RelationalAPI.getInstance().getConnection();
            stat = conn.createStatement();
            String query = null;
            query = dbType ? (numFields == 6 ? "CREATE TABLE IF NOT EXISTS " + tableName + " like app_reports_hr_trend_sa" : "CREATE TABLE IF NOT EXISTS " + tableName + " like app_longreports_hr_trend_sa") : (isPostgres ? (numFields == 6 ? "CREATE TABLE IF NOT EXISTS " + tableName + " (like app_reports_hr_trend_sa including all)" : "CREATE TABLE IF NOT EXISTS " + tableName + " (like app_longreports_hr_trend_sa including all)") : (numFields == 6 ? mssqlHandler.constructQuery("app_reports_hr_trend_sa", tableName) : mssqlHandler.constructQuery("app_longreports_hr_trend_sa", tableName)));
            stat.execute(query);
        }
        catch (Exception e) {
            retVal = false;
            e.printStackTrace();
        }
        finally {
            try {
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createSeverityTable(String tableName) {
        boolean retVal = true;
        Statement stat = null;
        Connection conn = null;
        try {
            LOGGER.log(Level.INFO, "Creating severity table : " + tableName);
            conn = RelationalAPI.getInstance().getConnection();
            stat = conn.createStatement();
            String query = null;
            query = dbType ? "CREATE TABLE IF NOT EXISTS " + tableName + " like app_hr_trend_sa" : (isPostgres ? "CREATE TABLE IF NOT EXISTS " + tableName + " (like app_hr_trend_sa including all)" : mssqlHandler.constructQuery("app_hr_trend_sa", tableName));
            stat.execute(query);
        }
        catch (Exception e) {
            retVal = false;
            e.printStackTrace();
        }
        finally {
            try {
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    public Collection getAllFormatIds() {
        return this.formatMap.keySet();
    }

    private DataObject getFormatDetailsDO(Long id) throws Exception {
        Table table = new Table("FormatDetails");
        SelectQueryImpl query = new SelectQueryImpl(table);
        query.addSelectColumn(new Column("FormatDetails", "*"));
        Criteria criteria = new Criteria(new Column("FormatDetails", "FORMATID"), (Object)id, 0);
        query.setCriteria(criteria);
        return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
    }

    public Long getFormatId(String formatName) {
        for (Long formatId : this.formatMap.keySet()) {
            if (!this.formatMap.get(formatId).equals(formatName)) continue;
            return formatId;
        }
        Criteria criteria = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATNAME"), (Object)formatName, 0);
        try {
            DataObject dataObject = PersistenceDBUtil.getPersistence().get("FormatDetails", criteria);
            Long formatId = (Long)dataObject.getFirstValue("FormatDetails", "FORMATID");
            this.formatMap.put(formatId, formatName);
            return formatId;
        }
        catch (DataAccessException e) {
            return null;
        }
    }

    public String getFormatName(Long formatId) {
        return (String)this.formatMap.get(formatId);
    }

    public Long getReportId(Long formatId, String reportName) {
        Long id = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("FormatToReportMapping"));
            query.addSelectColumn(new Column("FormatToReportMapping", "REPORTID"));
            Criteria cri = new Criteria(new Column("FormatToReportMapping", "FORMATID"), (Object)formatId, 0);
            Criteria cri1 = new Criteria(new Column("FormatToReportMapping", "REPORTNAME"), (Object)reportName, 0);
            query.setCriteria(cri1.and(cri));
            LOGGER.log(Level.FINE, query.toString());
            DataObject doo = this.persistence.get((SelectQuery)query);
            id = (Long)doo.getFirstValue("FormatToReportMapping", "REPORTID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    private void init() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("FormatDetails"));
            query.addSelectColumn(new Column("FormatDetails", "*"));
            DataObject doo = this.persistence.get((SelectQuery)query);
            Iterator fdRowIt = doo.getRows("FormatDetails");
            while (fdRowIt.hasNext()) {
                Row row = (Row)fdRowIt.next();
                Long formatId = (Long)row.get("FORMATID");
                this.formatMap.put(formatId, (String)row.get("FORMATNAME"));
                this.appIdVsLogTypeNameMap.put(formatId, (String)row.get("FORMATDESC"));
                int isTableCreated = (Integer)row.get("ISTABLECREATED");
                if (isTableCreated != 1) continue;
                this.updatedFormats.add(formatId);
            }
            LOGGER.log(Level.FINE, "Format details Hash : {0}", this.formatMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addToFormatMap(Long formatID, String formatName) {
        if (formatName != null) {
            this.formatMap.put(formatID, formatName);
            this.appIdVsLogTypeNameMap.put(formatID, formatName);
        }
    }

    public void updateFormatNameIntoMap(Long formatID, String newName) {
        this.deleteFromFormatMap(formatID);
        this.formatMap.put(formatID, newName);
        this.appIdVsLogTypeNameMap.put(formatID, newName);
    }

    public void deleteFromFormatMap(Long formatID) {
        this.formatMap.remove(formatID);
        this.appIdVsLogTypeNameMap.remove(formatID);
    }

    public Long getFormatIdForLogType(String logType) {
        for (Long formatId : this.appIdVsLogTypeNameMap.keySet()) {
            if (!this.appIdVsLogTypeNameMap.get(formatId).equals(logType)) continue;
            return formatId;
        }
        return null;
    }

    public String getLogTypeNameForFormatId(Long formatId) {
        return this.appIdVsLogTypeNameMap.get(formatId);
    }

    public Map<Long, String> getAppIdVsLogTypeNameMap() {
        return Collections.unmodifiableMap(this.appIdVsLogTypeNameMap);
    }

    public ArrayList<String> getAllAppLogTypeNames() {
        return new ArrayList<String>(this.appIdVsLogTypeNameMap.values());
    }

    public void updateFormatDetails(LogFormat format) {
        if (format.isConfChanged() || !this.updatedFormats.contains(format.getFormatId())) {
            LOGGER.log(Level.INFO, "Adding format details : " + format.getFormatName());
            Long id = null;
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList dbFields = format.getDbFields();
            for (Field field : dbFields) {
                columns.add(field.getKey());
            }
            columns.add("COMMON_SEVERITY");
            columns.add("MATCHING_REPORTS");
            columns.add("RAWLOG");
            columns.add("MESSAGE");
            columns.add("LOGTYPE");
            columns.add("FORMATID");
            LuceneUtil.addAppToColsMap((String)String.valueOf(format.getFormatId()), columns);
            try {
                id = format.getFormatId();
                LuceneUtil.addViewColsMap((String)(id + ""), columns);
                this.updateFormatFields(format);
                this.updateFormatToReportMapping(format);
                DataObject dObj = this.getFormatDetailsDO(id);
                Integer isTableCreated = (Integer)dObj.getFirstValue("FormatDetails", "ISTABLECREATED");
                if (isTableCreated == 0) {
                    String hrTrendTableName = format.getFormatName() + "_hr_trend_sa";
                    String reportTableName = format.getFormatName() + "_reports_hr_trend_sa";
                    String longReportTableName = format.getFormatName() + "_longreports_hr_trend_sa";
                    boolean sevTableCreated = this.createSeverityTable(hrTrendTableName);
                    boolean reportTableCreated = this.createReportTable(reportTableName, 6);
                    if (format.isContainsLongReport()) {
                        boolean bl = reportTableCreated = reportTableCreated && this.createReportTable(longReportTableName, 10);
                    }
                    if (reportTableCreated && sevTableCreated && dObj.containsTable("FormatDetails")) {
                        Row row = dObj.getRow("FormatDetails");
                        row.set("ISTABLECREATED", (Object)new Integer(1));
                        row.set("HRTRENDTABLENAME", (Object)hrTrendTableName);
                        row.set("REPORTTABLENAME", (Object)reportTableName);
                        if (format.isContainsLongReport()) {
                            row.set("LONGREPORTTABLENAME", (Object)longReportTableName);
                        }
                        dObj.updateRow(row);
                        if (format.isContainsLongReport()) {
                            this.updateMetaTableCache(new String[]{hrTrendTableName, reportTableName, longReportTableName});
                        } else {
                            this.updateMetaTableCache(new String[]{hrTrendTableName, reportTableName});
                        }
                    }
                }
                dObj = this.persistence.update(dObj);
                this.updatedFormats.add(format.getFormatId());
                format.setConfChanged(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetaTableCache(String[] tables) {
        boolean retVal = true;
        Statement stat = null;
        Connection conn = null;
        MetaTableCache cache = MetaTableCache.getInstance();
        try {
            for (int i = 0; i < tables.length; ++i) {
                String tableName = tables[i];
                LOGGER.log(Level.INFO, "Adding metatable entry : " + tableName);
                conn = RelationalAPI.getInstance().getConnection();
                stat = conn.createStatement();
                String query = null;
                query = dbType ? "insert into MetaTable (TABLE_NAME,START_TIME,END_TIME,START_INDEX,END_INDEX,LOOKUP_TABLENAME,STATUS) values('" + tableName + "',now(),0,0,-1,'" + tableName + "','DEFAULT')" : (isPostgres ? "insert into MetaTable (TABLE_NAME,START_TIME,END_TIME,START_INDEX,END_INDEX,LOOKUP_TABLENAME,STATUS) values('" + tableName + "',localtimestamp(0),'1970-01-01 00:00:00',0,-1,'" + tableName + "','DEFAULT')" : "insert into MetaTable (TABLE_NAME,START_TIME,END_TIME,START_INDEX,END_INDEX,LOOKUP_TABLENAME,STATUS) values('" + tableName + "',GETDATE(),'1970-01-01 00:00:00',0,-1,'" + tableName + "','DEFAULT')");
                stat.execute(query);
                cache.add(tableName, tableName, "" + System.currentTimeMillis(), "-1");
            }
        }
        catch (SQLException e) {
            retVal = false;
            e.printStackTrace();
        }
        finally {
            try {
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetaTableCache(String alteredTableName, String tableName, Timestamp startTime, Timestamp endTime) {
        Statement stat = null;
        Connection conn = null;
        MetaTableCache cache = MetaTableCache.getInstance();
        try {
            LOGGER.log(Level.INFO, "Adding metatable entry : " + tableName);
            conn = RelationalAPI.getInstance().getConnection();
            stat = conn.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("insert into MetaTable(TABLE_NAME,START_TIME,END_TIME,START_INDEX,END_INDEX,LOOKUP_TABLENAME,STATUS) values('" + tableName + "','" + startTime + "', '" + endTime + "', -1, -1,'" + alteredTableName + "','DEFAULT')");
            stat.execute(query.toString());
            cache.add(tableName, alteredTableName, "" + startTime.getTime(), "" + endTime.getTime());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updateFormatFields(LogFormat format) throws Exception {
        Table table = new Table("FormatFields");
        SelectQueryImpl query = new SelectQueryImpl(table);
        query.addSelectColumn(new Column("FormatFields", "*"));
        Criteria criteria = new Criteria(new Column("FormatFields", "FORMATID"), (Object)format.getFormatId(), 0);
        query.setCriteria(criteria);
        DataObject dataObject = this.persistence.get((SelectQuery)query);
        for (Field field : format.getDbFields()) {
            Criteria cri = new Criteria(new Column("FormatFields", "FIELDID"), (Object)new Long(field.getId().longValue()), 0);
            Row formatFieldsRow = dataObject.getRow("FormatFields", cri);
            boolean isNewRow = false;
            if (formatFieldsRow == null) {
                formatFieldsRow = new Row("FormatFields");
                isNewRow = true;
            }
            formatFieldsRow.set("FORMATID", (Object)format.getFormatId());
            formatFieldsRow.set("FIELDID", (Object)new Long(field.getId().longValue()));
            formatFieldsRow.set("FIELDNAME", (Object)field.getKey());
            if (!isNewRow) {
                dataObject.updateRow(formatFieldsRow);
                continue;
            }
            dataObject.addRow(formatFieldsRow);
        }
        this.persistence.update(dataObject);
    }

    private void updateFormats() {
        ArrayList parserList = Identifier.get_instance().getParserList();
        try {
            Table table = new Table("FormatDetails");
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(new Column("FormatDetails", "*"));
            DataObject dObj = this.persistence.get((SelectQuery)query);
            ArrayList<String> formatNames = new ArrayList<String>();
            Iterator iterator = dObj.getRows("FormatDetails");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                formatNames.add((String)row.get("FORMATNAME"));
            }
            for (ParserDetails parser : parserList) {
                if (formatNames.contains(parser.getFormatName())) continue;
                Row row = new Row("FormatDetails");
                row.set("FORMATNAME", (Object)parser.getFormatName());
                row.set("FORMATDESC", (Object)parser.getDesc());
                row.set("ISTABLECREATED", (Object)new Integer(0));
                dObj.addRow(row);
            }
            this.persistence.update(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateFormatToReportMapping(LogFormat format) throws Exception {
        Table table = new Table("FormatToReportMapping");
        Table table2 = new Table("ReportToFieldMapping");
        SelectQueryImpl query = new SelectQueryImpl(table);
        query.addSelectColumn(new Column("FormatToReportMapping", "*"));
        query.addSelectColumn(new Column("ReportToFieldMapping", "*"));
        Join join1 = new Join(table, table2, new String[]{"REPORTID"}, new String[]{"REPORTID"}, 1);
        query.addJoin(join1);
        Criteria criteria = new Criteria(new Column("FormatToReportMapping", "FORMATID"), (Object)format.getFormatId(), 0);
        query.setCriteria(criteria);
        DataObject dataObject = this.persistence.get((SelectQuery)query);
        LOGGER.fine("Data Object >>> " + dataObject.toString());
        ArrayList<Boolean> newRows = new ArrayList<Boolean>();
        for (ReportCategory rptCategory : format.getReportCategories()) {
            LOGGER.fine("REPORT NAME >>> " + rptCategory.getName());
            Criteria cri = new Criteria(new Column("FormatToReportMapping", "REPORTNAME"), (Object)rptCategory.getName(), 0);
            Row reportRow = dataObject.getRow("FormatToReportMapping", cri);
            Object rId = null;
            boolean isNewRow = false;
            if (reportRow == null) {
                reportRow = new Row("FormatToReportMapping");
                LOGGER.fine("NEW ROW ADDED");
                isNewRow = true;
                reportRow = new Row("FormatToReportMapping");
                reportRow.set("FORMATID", (Object)format.getFormatId());
                reportRow.set("REPORTNAME", (Object)rptCategory.getName());
                reportRow.set("REPORTDESC", (Object)rptCategory.getDesc());
                reportRow.set("NUMFIELDS", (Object)new Integer(rptCategory.getFields().size()));
                int colSize = rptCategory.getFields().size() + 1;
                String jasperName = "appreport" + colSize + "_table.jasper";
                reportRow.set("JASPERNAME", (Object)jasperName);
                LOGGER.fine("report row >>> " + reportRow.toString());
                dataObject.addRow(reportRow);
            }
            newRows.add(isNewRow);
        }
        LOGGER.finer("DATA OBJECT >>> " + dataObject.toString());
        this.persistence.update(dataObject);
        int i = 0;
        for (ReportCategory rptCategory : format.getReportCategories()) {
            LOGGER.fine("REPORT NAME >>> " + rptCategory.getName());
            Criteria cri = new Criteria(new Column("FormatToReportMapping", "REPORTNAME"), (Object)rptCategory.getName(), 0);
            Row reportRow = dataObject.getRow("FormatToReportMapping", cri);
            Long rId = (Long)reportRow.get("REPORTID");
            if (((Boolean)newRows.get(i++)).booleanValue()) {
                for (Field field : rptCategory.getFields()) {
                    Row row = new Row("ReportToFieldMapping");
                    row.set("REPORTID", reportRow.get("REPORTID"));
                    row.set("FIELDNAME", (Object)field.getKey());
                    row.set("TYPE", (Object)field.getType());
                    LOGGER.finer("ReportToFieldMapping row >>>>> " + row.toString());
                    dataObject.addRow(row);
                }
                continue;
            }
            Criteria cri2 = new Criteria(new Column("ReportToFieldMapping", "REPORTID"), (Object)rId, 0);
            for (Field field : rptCategory.getFields()) {
                Criteria cri3 = new Criteria(new Column("ReportToFieldMapping", "FIELDNAME"), (Object)field.getKey(), 0);
                Row fieldRow = dataObject.getRow("ReportToFieldMapping", cri2.and(cri3));
                if (fieldRow == null) {
                    fieldRow = new Row("ReportToFieldMapping");
                    fieldRow.set("REPORTID", reportRow.get("REPORTID"));
                    fieldRow.set("FIELDNAME", (Object)field.getKey());
                    fieldRow.set("TYPE", (Object)field.getType());
                    LOGGER.fine("Adding new row:: " + fieldRow.toString());
                    dataObject.addRow(fieldRow);
                    continue;
                }
                fieldRow.set("TYPE", (Object)field.getType());
                LOGGER.fine("Updating row:: " + fieldRow.toString());
                dataObject.updateRow(fieldRow);
            }
            dataObject.updateRow(reportRow);
        }
        LOGGER.finer("FINAL DataObject : " + dataObject.toString());
        this.persistence.update(dataObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createLikeTable(String tableName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String tblTime = df.format(new Date());
        String alteredTableName = tableName + "_" + tblTime;
        Statement stat = null;
        Connection conn = null;
        try {
            LOGGER.log(Level.INFO, "Creating table : " + tableName);
            conn = RelationalAPI.getInstance().getConnection();
            stat = conn.createStatement();
            String query = null;
            query = dbType ? "CREATE TABLE IF NOT EXISTS " + alteredTableName + " like " + tableName : mssqlHandler.constructQuery(tableName, alteredTableName);
            stat.execute(query.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return alteredTableName;
    }

    public void updateMetaTableTime(String tableName, Long hourInMillis) {
        try {
            Table table = new Table("MetaTable");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            Column col = new Column("MetaTable", "TABLE_NAME");
            Criteria cri = new Criteria(col, (Object)tableName, 0);
            sql.setCriteria(cri);
            sql.addSelectColumn(new Column("MetaTable", "*"));
            DataObject dob = this.persistence.get((SelectQuery)sql);
            Row row = dob.getRow("MetaTable");
            row.set("START_TIME", (Object)new Timestamp(hourInMillis));
            dob.updateRow(row);
            this.persistence.update(dob);
            MetaTableCache cache = MetaTableCache.getInstance();
            cache.remove(tableName, tableName);
            cache.add(tableName, tableName, hourInMillis.toString(), "-1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Long getGroupId(String groupName) throws Exception {
        SelectQueryImpl groupSql = new SelectQueryImpl(new Table("HostGroup"));
        groupSql.addSelectColumn(new Column("HostGroup", "*"));
        groupSql.setCriteria(new Criteria(new Column("HostGroup", "NAME"), (Object)groupName, 0));
        DataObject groupDO = this.persistence.get((SelectQuery)groupSql);
        return (Long)groupDO.getFirstValue("HostGroup", "ID");
    }
}

