/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.parser;

import com.adventnet.sa.server.parser.Attribute;
import com.adventnet.sa.server.parser.ParsedAttributes;
import com.adventnet.sa.server.parser.ParserRule;
import com.adventnet.sa.server.parser.ParserUtil;
import com.adventnet.sa.server.parser.Rule;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;

public abstract class Parser {
    public static final byte REGEX_RULE = 1;
    public static final byte SEPARATOR_RULE = 2;
    public static final byte DYNAMIC_SEPARATOR_RULE = 4;
    public static final int CRITICAL = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFORMATION = 3;

    public abstract boolean getParams(String var1, ParserRule var2, Hashtable var3);

    public void addDerivedParams(Hashtable paramMap, ParserRule rule) {
        for (Map.Entry entry : rule.getDerivedAttributes().entrySet()) {
            String value = ParserUtil.getDerivedValue((String)entry.getValue(), paramMap);
            if (value == null) continue;
            paramMap.put(entry.getKey(), value);
        }
    }

    public boolean getParsedAttributes(ArrayList parsedAttributes, Hashtable paramMap) {
        for (ParsedAttributes parsedAttribute : parsedAttributes) {
            boolean isPreCheck = this.checkPreConditions(parsedAttribute.getPreConditions(), paramMap);
            if (!isPreCheck || !paramMap.containsKey(parsedAttribute.getKey())) continue;
            Matcher m = parsedAttribute.getMatcher();
            m.reset((CharSequence)paramMap.get(parsedAttribute.getKey()));
            if (!m.find()) continue;
            String value = null;
            for (Attribute attr : parsedAttribute.getAttributes()) {
                value = m.group(attr.getGroupNumber());
                if (value == null) continue;
                paramMap.put(attr.getGroupName(), value);
            }
            paramMap.putAll(parsedAttribute.getOpenAttributes());
        }
        return true;
    }

    private boolean checkPreConditions(ArrayList preConditions, Hashtable paramMap) {
        for (Rule rule : preConditions) {
            if (ParserUtil.applyOperator(rule, (String)paramMap.get(rule.getKey()))) continue;
            return false;
        }
        return true;
    }
}

