/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.parser;

import com.adventnet.sa.server.parser.Attribute;
import com.adventnet.sa.server.parser.Field;
import com.adventnet.sa.server.parser.LogFormat;
import com.adventnet.sa.server.parser.ParsedAttributes;
import com.adventnet.sa.server.parser.ParserRule;
import com.adventnet.sa.server.parser.ReportCategory;
import com.adventnet.sa.server.parser.ReportRule;
import com.adventnet.sa.server.parser.Rule;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ParserRulesPopulator {
    private static ParserRulesPopulator _instance = null;
    private int reportId;
    private int reportCategoryId;

    public static synchronized ParserRulesPopulator get_instance() {
        if (_instance == null) {
            _instance = new ParserRulesPopulator();
        }
        return _instance;
    }

    private ParserRulesPopulator() {
    }

    private ArrayList getDatabaseFields(Element element) {
        ArrayList<Field> fields = new ArrayList<Field>();
        NodeList nodes = element.getElementsByTagName("Field");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            fields.add(this.getField(nodeElement));
        }
        return fields;
    }

    private Field getField(Element element) {
        String key = null;
        String type = null;
        Integer id = null;
        String value = null;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("id")) {
                try {
                    id = new Integer(attr.getValue());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (attr.getName().equals("key")) {
                key = attr.getValue();
                continue;
            }
            if (attr.getName().equals("type")) {
                type = attr.getValue();
                continue;
            }
            if (!attr.getName().equals("value")) continue;
            value = attr.getValue();
        }
        return new Field(id, key, type, value);
    }

    private LogFormat getLogFormat(Element element, LogFormat format) {
        Element nodeElement;
        int i;
        NodeList nodes = element.getElementsByTagName("Key-RuleSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            format.setKeyRules(this.getRuleSet(nodeElement, "Key-Rule"));
            format.setKeyRulePresent(true);
        }
        nodes = element.getElementsByTagName("PreParser-RuleSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            format.setPreParserRules(this.getRuleSet(nodeElement, "PreParser-Rule"));
        }
        nodes = element.getElementsByTagName("Parser-RuleSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            format.setParserRules(this.getRuleSet(nodeElement, "Parser-Rule"));
        }
        nodes = element.getElementsByTagName("Severity-RuleSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            format.setSeverityCategories(this.getReportRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("Report-RuleSet");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            format.setReportCategories(this.getReportRuleSet(nodeElement));
        }
        nodes = element.getElementsByTagName("DB-Fields");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            format.setDbFields(this.getDatabaseFields(nodeElement));
        }
        nodes = element.getElementsByTagName("Regenerate-Reports");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            format.setConfChanged(this.isConfChanged(nodeElement));
        }
        nodes = element.getElementsByTagName("Log-Lines");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            format.setNumLines(this.getNumLines(nodeElement));
            format.setKeyRulePresent(true);
        }
        return format;
    }

    private int getNumLines(Element element) {
        int numLines = 1;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().equals("num")) continue;
            try {
                numLines = Integer.parseInt(attr.getValue());
                return numLines;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    private boolean isConfChanged(Element element) {
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().equals("value") || !attr.getValue().equals("true")) continue;
            element.removeAttribute("value");
            element.setAttribute("value", "false");
            return true;
        }
        return false;
    }

    private HashMap getReportGroups(Element element) {
        HashMap group = new HashMap();
        NodeList nodes = element.getElementsByTagName("Report-Group");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            String groupName = null;
            ArrayList<String> reports = new ArrayList<String>();
            NamedNodeMap attrs = nodeElement.getAttributes();
            for (int j = 0; j < attrs.getLength(); ++j) {
                Attr attr = (Attr)attrs.item(j);
                if (!attr.getName().equals("name")) continue;
                groupName = attr.getValue();
            }
            NodeList nodes2 = nodeElement.getElementsByTagName("Report-Name");
            for (int j = 0; j < nodes2.getLength(); ++j) {
                Element nodeElement2 = (Element)nodes2.item(j);
                reports.add(this.getReportName(nodeElement2));
            }
            group.put(groupName, reports);
        }
        return group;
    }

    private String getReportName(Element element) {
        String reportName = null;
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 3) continue;
            reportName = ((Text)node).getData();
        }
        return reportName;
    }

    private ParserRule getParserRule(Element element, String tagName) {
        Element nodeElement;
        int i;
        ParserRule pRule = new ParserRule();
        NamedNodeMap attrs = element.getAttributes();
        for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
            Attr attr = (Attr)attrs.item(i2);
            if (attr.getName().equals("name")) {
                pRule.setName(attr.getValue());
                continue;
            }
            if (!attr.getName().equals("type")) continue;
            if (attr.getValue().equals("SEPARATOR")) {
                pRule.setParserType((byte)2);
                continue;
            }
            if (!attr.getValue().equals("DYN_SEPARATOR")) continue;
            pRule.setParserType((byte)4);
        }
        NodeList nodes = element.getElementsByTagName("regex");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            if (!nodeElement.getParentNode().getNodeName().equals(tagName)) continue;
            pRule.setRegex(this.getregex(nodeElement));
        }
        nodes = element.getElementsByTagName("Attribute");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            if (!nodeElement.getParentNode().getNodeName().equals(tagName)) continue;
            NamedNodeMap attrs2 = nodeElement.getAttributes();
            String key = null;
            String groupNumber = null;
            String open = null;
            String derived = null;
            for (int j = 0; j < attrs2.getLength(); ++j) {
                Attr attr = (Attr)attrs2.item(j);
                if (attr.getName().equals("groupNumber")) {
                    groupNumber = attr.getValue();
                    continue;
                }
                if (attr.getName().equals("key")) {
                    key = attr.getValue();
                    continue;
                }
                if (attr.getName().equals("open")) {
                    open = attr.getValue();
                    continue;
                }
                if (!attr.getName().equals("derived")) continue;
                derived = attr.getValue();
            }
            if (derived != null && derived.equals("true")) {
                pRule.addDerivedAttribute(key, groupNumber);
                continue;
            }
            if (open != null && open.equals("true")) {
                pRule.addOpenAttribute(key, groupNumber);
                continue;
            }
            try {
                pRule.addAttribute(new Attribute(Integer.valueOf(groupNumber), key));
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        nodes = element.getElementsByTagName("Parsed-Attributes");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            pRule.addParsedAttributes(this.getParsedAttribute(nodeElement, "Parsed-Attributes"));
        }
        return pRule;
    }

    private ParsedAttributes getParsedAttribute(Element element, String tagName) {
        Element nodeElement;
        int i;
        ParsedAttributes pAttr = new ParsedAttributes();
        NamedNodeMap attrs = element.getAttributes();
        for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
            Attr attr = (Attr)attrs.item(i2);
            if (!attr.getName().equals("key")) continue;
            pAttr.setKey(attr.getValue());
        }
        NodeList nodes = element.getElementsByTagName("regex");
        for (int i3 = 0; i3 < nodes.getLength(); ++i3) {
            Element nodeElement2 = (Element)nodes.item(i3);
            if (!nodeElement2.getParentNode().getNodeName().equals(tagName)) continue;
            pAttr.setRegex(this.getregex(nodeElement2));
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        nodes = element.getElementsByTagName("Rule");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            rules.add(this.getRule(nodeElement));
        }
        pAttr.setPreConditions(rules);
        nodes = element.getElementsByTagName("Attribute");
        for (i = 0; i < nodes.getLength(); ++i) {
            nodeElement = (Element)nodes.item(i);
            if (!nodeElement.getParentNode().getNodeName().equals(tagName)) continue;
            NamedNodeMap attrs2 = nodeElement.getAttributes();
            String key = null;
            String groupNumber = null;
            String open = null;
            Object derived = null;
            for (int j = 0; j < attrs2.getLength(); ++j) {
                Attr attr = (Attr)attrs2.item(j);
                if (attr.getName().equals("groupNumber")) {
                    groupNumber = attr.getValue();
                    continue;
                }
                if (attr.getName().equals("key")) {
                    key = attr.getValue();
                    continue;
                }
                if (!attr.getName().equals("open")) continue;
                open = attr.getValue();
            }
            if (open != null && open.equals("true")) {
                pAttr.addOpenAttribute(key, groupNumber);
                continue;
            }
            try {
                pAttr.addAttribute(new Attribute(Integer.valueOf(groupNumber), key));
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return pAttr;
    }

    public synchronized LogFormat getParserRules(String formatName) {
        LogFormat format = new LogFormat();
        format.setFormatName(formatName);
        this.initIds();
        File dir = new File(System.getProperty("server.home") + File.separator + "server" + File.separator + "conf" + File.separator + "ParserRules");
        File[] files = dir.listFiles(new FileNameFilter(formatName));
        try {
            DocumentBuilderFactory dBuildFac = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuild = dBuildFac.newDocumentBuilder();
            boolean rewritten = false;
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                Document doc = dBuild.parse(file);
                Element rootNode = doc.getDocumentElement();
                format = this.getLogFormat(rootNode, format);
                if (!format.isConfChanged() || rewritten) continue;
                rewritten = true;
                this.writeXmlToFile(file, doc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return format;
    }

    private void writeXmlToFile(File file, Document doc) {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        NodeList nodes = doc.getElementsByTagName("Regenerate-Reports");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            NamedNodeMap attrs = nodeElement.getAttributes();
            for (int j = 0; j < attrs.getLength(); ++j) {
                Attr attr = (Attr)attrs.item(j);
                if (!attr.getName().equals("value")) continue;
            }
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private void initIds() {
        this.reportId = 0;
        this.reportCategoryId = 0;
    }

    private String getregex(Element element) {
        String regex = null;
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 4) continue;
            regex = ((CDATASection)node).getData().trim();
        }
        return regex;
    }

    private ReportRule getReportRule(Element element) {
        ReportRule rRule = new ReportRule();
        rRule.setId(new Integer(this.reportId++));
        NodeList nodes = element.getElementsByTagName("Rule");
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            rules.add(this.getRule(nodeElement));
        }
        rRule.setRules(rules);
        return rRule;
    }

    private Vector getReportRuleSet(Element element) {
        Vector<ReportCategory> rRules = new Vector<ReportCategory>();
        NodeList nodes = element.getElementsByTagName("Report-Category");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            rRules.add(this.getReportCategory(nodeElement));
        }
        return rRules;
    }

    private ReportCategory getReportCategory(Element element) {
        ReportCategory rptCategory = new ReportCategory();
        rptCategory.setId(this.reportCategoryId++);
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("name")) {
                rptCategory.setName(attr.getValue());
                continue;
            }
            if (!attr.getName().equals("desc")) continue;
            rptCategory.setDesc(attr.getValue());
        }
        Vector<ReportRule> rRules = new Vector<ReportRule>();
        NodeList nodes = element.getElementsByTagName("Report-Rule");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            rRules.add(this.getReportRule(nodeElement));
        }
        rptCategory.setReportRules(rRules);
        nodes = element.getElementsByTagName("Field");
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            fields.add(this.getField(nodeElement));
        }
        rptCategory.setFields(fields);
        return rptCategory;
    }

    private Rule getRule(Element element) {
        String key = null;
        String target = null;
        int operator = 1;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("key")) {
                key = attr.getValue();
                continue;
            }
            if (attr.getName().equals("target")) {
                target = attr.getValue();
                continue;
            }
            if (!attr.getName().equals("operator")) continue;
            String value = attr.getValue();
            if (value.equals("ne")) {
                operator = 2;
                continue;
            }
            if (!value.equals("rx")) continue;
            operator = 3;
        }
        return new Rule(key, target, (byte)operator);
    }

    private Vector getRuleSet(Element element, String tagName) {
        Vector<ParserRule> rules = new Vector<ParserRule>();
        NodeList nodes = element.getElementsByTagName(tagName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            rules.add(this.getParserRule(nodeElement, tagName));
        }
        return rules;
    }

    private class FileNameFilter
    implements FilenameFilter {
        String formatName = null;

        public FileNameFilter(String formatName) {
            this.formatName = formatName.toLowerCase();
        }

        @Override
        public boolean accept(File dir, String name) {
            if (name.endsWith("xml")) {
                String fileName = name.substring(0, name.lastIndexOf(".xml")).toLowerCase();
                return fileName.startsWith(this.formatName);
            }
            return false;
        }
    }
}

