/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.parser;

import com.adventnet.sa.server.parser.Rule;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParserUtil {
    public static final byte EQUALS = 1;
    public static final byte NOTEQUALS = 2;
    public static final byte REGEX = 3;
    private static SimpleDateFormat hourDf = new SimpleDateFormat("yyyy-MM-dd HH:00:00");

    public static boolean applyOperator(Rule rule, String value) {
        if (value == null) {
            return false;
        }
        switch (rule.getOperator()) {
            case 1: {
                if (rule.getTargetSize() > 1) {
                    return Collections.binarySearch(rule.getTarget(), value) >= 0;
                }
                return value.equalsIgnoreCase((String)rule.getTarget().get(0));
            }
            case 2: {
                if (rule.getTargetSize() > 1) {
                    return Collections.binarySearch(rule.getTarget(), value) < 0;
                }
                return !value.equalsIgnoreCase((String)rule.getTarget().get(0));
            }
            case 3: {
                return Pattern.matches((String)rule.getTarget().get(0), value);
            }
        }
        return false;
    }

    public static String getDerivedValue(String value, Hashtable paramMap) {
        Pattern p = Pattern.compile("_\\(([^\\)]*)\\)");
        Matcher m = p.matcher(value);
        while (m.find()) {
            String key = m.group(1);
            String param = (String)paramMap.get(key);
            if (param == null) {
                return null;
            }
            value = value.replaceAll("_\\(" + key + "\\)", param);
            m.reset(value);
        }
        return value;
    }

    public static boolean getDateTime(Hashtable paramMap) {
        GregorianCalendar cal = new GregorianCalendar();
        String dateString = (String)paramMap.remove("DATE_STRING");
        String timeString = (String)paramMap.get("TIME_STRING");
        String logDate = (String)paramMap.remove("LOG_DATE");
        String logDateFormat = (String)paramMap.get("LOG_DATE_FORMAT");
        ArrayList dateFormats = ParserUtil.getDateFormats(paramMap);
        try {
            if (dateString != null && dateFormats.size() > 0) {
                int year = cal.get(1);
                Date date = null;
                for (String dateFormat : dateFormats) {
                    SimpleDateFormat format = new SimpleDateFormat(dateFormat);
                    try {
                        date = format.parse(dateString);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (date == null) continue;
                    break;
                }
                if (date == null) {
                    cal.setTimeInMillis(System.currentTimeMillis());
                } else {
                    cal.setTime(date);
                }
                if (paramMap.remove("NO_YEAR") != null) {
                    cal.set(1, year);
                }
            } else if (timeString != null && !"".equals(timeString)) {
                cal.setTimeInMillis(Long.parseLong(timeString));
            } else if (logDate != null) {
                SimpleDateFormat format = new SimpleDateFormat(logDateFormat);
                cal.setTime(format.parse(logDate));
            } else if ((dateString == null || dateFormats.size() == 0) && timeString == null) {
                System.out.println("WARNING ::::: Putting current time instead of log time");
                cal.setTimeInMillis(System.currentTimeMillis());
            }
            paramMap.put("TIME", cal.getTimeInMillis());
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            paramMap.put("HOUR", hourDf.format(cal.getTime()));
            paramMap.put("HOUROFDAY", "" + cal.get(11));
            paramMap.put("HOURINMILLIS", String.valueOf(cal.getTimeInMillis()));
            cal.set(11, 0);
            paramMap.put("DAY_FOR_LUCENE", cal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private static ArrayList getDateFormats(Hashtable openAttributes) {
        ArrayList dateFormats = new ArrayList(4);
        for (Map.Entry entry : openAttributes.entrySet()) {
            if (!((String)entry.getKey()).startsWith("DATE_FORMAT")) continue;
            dateFormats.add(entry.getValue());
        }
        return dateFormats;
    }
}

