/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.parser;

import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.sa.server.lc.FieldRepository;
import com.adventnet.sa.server.lc.UploadUtils;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.parser.Attribute;
import com.adventnet.sa.server.parser.DynSeparatorParser;
import com.adventnet.sa.server.parser.Field;
import com.adventnet.sa.server.parser.LogFormat;
import com.adventnet.sa.server.parser.Parser;
import com.adventnet.sa.server.parser.ParserRule;
import com.adventnet.sa.server.parser.ParserUtil;
import com.adventnet.sa.server.parser.RecordWriter;
import com.adventnet.sa.server.parser.RegexParser;
import com.adventnet.sa.server.parser.ReportCategory;
import com.adventnet.sa.server.parser.ReportRecord;
import com.adventnet.sa.server.parser.ReportRule;
import com.adventnet.sa.server.parser.Rule;
import com.adventnet.sa.server.parser.SeparatorParser;
import com.adventnet.sa.server.parser.SeverityRecord;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;

public class RecordParser {
    private Parser parser = null;
    private LogFormat _format = null;
    private Hashtable rptParams = new Hashtable();
    private Hashtable sevParams = new Hashtable();
    private Hashtable rptBitSets = new Hashtable();
    private Hashtable sevBitSets = new Hashtable();
    private Hashtable rptDetails = new Hashtable();
    private ArrayList sevDetails = new ArrayList();
    public RecordWriter[] reportRecordwriters = null;
    public RecordWriter sevRecordwriter = null;
    public boolean containsLongReport = false;
    private Long appId = null;
    private org.apache.lucene.document.Field[] luceneFields = null;
    private LogIndexingAPI indexer = LogIndexingAPI.getInstance();
    Calendar previousTimeStamp = null;
    public boolean MULITILINE_MATCH = false;
    public String HEADER_RECORD = null;
    public long minTime = 0L;
    public long maxTime = 0L;
    private RecordComparator rComparator = new RecordComparator();
    private SeverityComparator sComparator = new SeverityComparator();
    private NotificationManager nfManager = null;
    private LogForwarderFilter logforwarder = null;
    private SimpleDateFormat timeSdf = null;

    public RecordParser(LogFormat format, Long appId) {
        this._format = format;
        this.appId = appId;
        this.initReports();
        this.initSevReports();
        if (appId != null) {
            this.initWriters();
        }
        this.nfManager = NotificationManager.getInstance();
        this.logforwarder = LogForwarderFilter.getInstance();
    }

    private void initSevReports() {
        Vector sevCategories = this._format.getSeverityCategories();
        String key = null;
        int i = 0;
        for (ReportCategory rptCategory : sevCategories) {
            Iterator iterator2 = rptCategory.getReportRules().iterator();
            while (iterator2.hasNext()) {
                int sevBitSet = 0;
                ReportRule rRule = (ReportRule)iterator2.next();
                for (Rule rule : rRule.getRules()) {
                    key = rule.getKey();
                    if (!this.sevParams.containsKey(key)) {
                        this.sevParams.put(key, new Integer(1 << i++));
                    }
                    sevBitSet |= ((Integer)this.sevParams.get(key)).intValue();
                }
                this.sevBitSets.put(rRule.getId(), new Integer(sevBitSet));
            }
        }
    }

    private void initWriters() {
        this.containsLongReport = this._format.isContainsLongReport();
        if (this.containsLongReport) {
            this.reportRecordwriters = new RecordWriter[2];
            this.reportRecordwriters[1] = new RecordWriter(this._format.getFormatName() + "_longreports_hr_trend_sa");
        } else {
            this.reportRecordwriters = new RecordWriter[1];
        }
        this.reportRecordwriters[0] = new RecordWriter(this._format.getFormatName() + "_reports_hr_trend_sa");
        this.sevRecordwriter = new RecordWriter(this._format.getFormatName() + "_hr_trend_sa");
    }

    private boolean applyKeyBasedParsing(String record, Hashtable paramMap) {
        ParserRule pRule;
        String key = null;
        Iterator iterator = this._format.getKeyRules().iterator();
        while (iterator.hasNext() && (key = this.executeKeyRule(record, pRule = (ParserRule)iterator.next())) == null) {
        }
        List ruleList = null;
        if (key != null) {
            ruleList = this._format.getParserRule(key);
        }
        if (ruleList == null) {
            ruleList = this._format.getParserRule("All");
        }
        return this.applyParserRules(record, paramMap, ruleList);
    }

    private boolean applyParserRules(String record, Hashtable paramMap, List ruleList) {
        if (ruleList == null) {
            return false;
        }
        boolean result = false;
        for (ParserRule rule : ruleList) {
            boolean lastExp;
            if (this.parser == null) {
                this.setParser(rule.getParserType());
            }
            if ((lastExp = this.executeParserRule(record, rule, paramMap)) && rule.getName().startsWith("MULTI_LINE")) {
                this.MULITILINE_MATCH = true;
            }
            result = result || lastExp;
        }
        if (result) {
            ParserUtil.getDateTime(paramMap);
        }
        return result;
    }

    private boolean executeParserRule(String record, ParserRule rule, Hashtable paramMap) {
        boolean result = this.parser.getParams(record, rule, paramMap);
        if (result) {
            this.parser.getParsedAttributes(rule.getParsedAttributes(), paramMap);
        }
        if (rule.getName().equals("HEADER")) {
            this.HEADER_RECORD = new String(record);
        }
        return result;
    }

    private void applyReportRules(Hashtable paramMap, String host, int paramBitSet) {
        ArrayList<ReportRule> ruleList = new ArrayList<ReportRule>();
        for (Map.Entry entry : this.rptBitSets.entrySet()) {
            int rptBitSet = (Integer)entry.getValue();
            if (rptBitSet != (rptBitSet & paramBitSet)) continue;
            ruleList.add(this._format.getReportRule((Integer)entry.getKey()));
        }
        if (ruleList.isEmpty()) {
            return;
        }
        ArrayList<ReportCategory> mathcingList = new ArrayList<ReportCategory>(4);
        for (ReportRule rRule : ruleList) {
            boolean isRptMatch = true;
            for (Rule rule : rRule.getRules()) {
                if (ParserUtil.applyOperator(rule, (String)paramMap.get(rule.getKey()))) continue;
                isRptMatch = false;
                break;
            }
            if (!isRptMatch) continue;
            mathcingList.add(this._format.getReportCategoryFromRuleId(rRule.getId()));
        }
        if (mathcingList.isEmpty()) {
            return;
        }
        StringBuffer matchingReports = new StringBuffer();
        for (ReportCategory rptCategory : mathcingList) {
            ArrayList<String> paramList = new ArrayList<String>(4);
            ArrayList<String> paramTypeList = new ArrayList<String>(4);
            boolean containsAggregateField = false;
            for (Field field : rptCategory.getFields()) {
                paramList.add((String)(paramMap.containsKey(field.getKey()) ? paramMap.get(field.getKey()) : field.getValue()));
                paramTypeList.add(field.getType());
                if (containsAggregateField || "SIMPLE".equals(field.getType())) continue;
                containsAggregateField = true;
            }
            ReportRecord record = new ReportRecord();
            record.setHost(host);
            record.setReportName(rptCategory.getName());
            record.setHourInMillis(new Long((String)paramMap.get("HOURINMILLIS")));
            record.setHourOfDay((String)paramMap.get("HOUROFDAY"));
            record.setHour((String)paramMap.get("HOUR"));
            record.setParams(paramList);
            record.setParamTypes(paramTypeList);
            ArrayList records = (ArrayList)this.rptDetails.get(new Integer(rptCategory.getId()));
            int pos = Collections.binarySearch(records, record, this.rComparator);
            if (pos >= 0) {
                ReportRecord recordFromList = (ReportRecord)records.get(pos);
                recordFromList.incCount();
                ArrayList currParamList = recordFromList.getParams();
                if (containsAggregateField) {
                    for (int i = 0; i < paramTypeList.size(); ++i) {
                        if ("SIMPLE".equals(paramTypeList.get(i))) continue;
                        if (paramList.get(i) == null) {
                            paramList.add(i, "0");
                        }
                        Long val = new Long(Long.parseLong((String)currParamList.get(i)) + Long.parseLong((String)paramList.get(i)));
                        currParamList.set(i, String.valueOf(val));
                    }
                }
            } else {
                record.incCount();
                records.add(-pos - 1, record);
            }
            if (records.size() >= 100) {
                RecordWriter writer = this.containsLongReport ? (paramList.size() > 6 ? this.reportRecordwriters[1] : this.reportRecordwriters[0]) : this.reportRecordwriters[0];
                writer.addToFile(this.appId, this._format.getFormatId(), rptCategory.getName(), records);
                records.clear();
            }
            matchingReports.append(rptCategory.getName().replaceAll("\\p{Punct}", "") + " ");
        }
        paramMap.put("MATCHING_REPORTS", matchingReports.toString());
    }

    private String executeKeyRule(String record, ParserRule rule) {
        Matcher m = rule.getMatcher();
        m.reset(record);
        if (!m.find()) {
            return null;
        }
        ArrayList attrs = rule.getAttributes();
        if (!attrs.isEmpty()) {
            String key = null;
            for (Attribute attr : attrs) {
                key = m.group(attr.getGroupNumber());
                if (key == null) continue;
                return key;
            }
        } else {
            Hashtable openAttributes = rule.getOpenAttributes();
            if (openAttributes != null && openAttributes.containsKey("PARSER_KEY")) {
                return (String)openAttributes.get("PARSER_KEY");
            }
        }
        return null;
    }

    private int getParamBitSet(Hashtable paramMap, Hashtable params) {
        int retVal = 0;
        for (Map.Entry entry : params.entrySet()) {
            if (paramMap.get(entry.getKey()) == null || "".equals(paramMap.get(entry.getKey()))) continue;
            retVal |= ((Integer)entry.getValue()).intValue();
        }
        return retVal;
    }

    private void initReports() {
        Vector rptCategories = this._format.getReportCategories();
        String key = null;
        int i = 0;
        for (ReportCategory rptCategory : rptCategories) {
            int repBitSet = 0;
            for (Field field : rptCategory.getFields()) {
                key = field.getKey();
                if (!this.rptParams.containsKey(key)) {
                    this.rptParams.put(key, new Integer(1 << i++));
                }
                repBitSet |= ((Integer)this.rptParams.get(key)).intValue();
            }
            for (ReportRule rRule : rptCategory.getReportRules()) {
                int repBitSet1 = 0;
                for (Rule rule : rRule.getRules()) {
                    key = rule.getKey();
                    if (!this.rptParams.containsKey(key)) {
                        this.rptParams.put(key, new Integer(1 << i++));
                    }
                    repBitSet1 |= ((Integer)this.rptParams.get(key)).intValue();
                }
                this.rptBitSets.put(rRule.getId(), new Integer(repBitSet | repBitSet1));
            }
            this.rptDetails.put(new Integer(rptCategory.getId()), new ArrayList());
        }
    }

    public void getparseRecordForFieldExtractionImport(String data, Hashtable resultMap) {
        String common_Sev;
        this.timeSdf = this.timeSdf == null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : this.timeSdf;
        Hashtable paramMap = new Hashtable();
        String host = "";
        boolean result = false;
        result = this._format.isKeyRulePresent() ? this.applyKeyBasedParsing(data, paramMap) : this.applyParserRules(data, paramMap, this._format.getParserRules());
        if (result) {
            String hostFromRec = (String)paramMap.get("HOSTNAME");
            if (hostFromRec != null && !"".equals(hostFromRec)) {
                host = hostFromRec;
            }
            int paramBitSet = this.getParamBitSet(paramMap, this.rptParams);
            this.applySeverityRules(paramMap, host, this.getParamBitSet(paramMap, this.sevParams));
        }
        if ((common_Sev = (String)paramMap.get("COMMON_SEVERITY")) == null) {
            common_Sev = "information";
        }
        for (String fieldName : FieldRepository.get_instance().getIndexedFields(this._format.getFormatId() + "")) {
            Object value = paramMap.get(fieldName);
            if (value == null || value.toString().length() <= 0) continue;
            resultMap.put(fieldName, value);
        }
        if (resultMap.size() == 0) {
            return;
        }
        resultMap.put("COMMON_SEVERITY", common_Sev);
        resultMap.put("FORMATID", this._format.getFormatId().toString());
        String msgLog = (String)resultMap.remove("log_msg");
        if (msgLog != null) {
            resultMap.put("MESSAGE", msgLog.replaceAll("\\t|\\n|\\x0B|\\f|\\r", " "));
        } else {
            resultMap.put("MESSAGE", data);
        }
        Object time = resultMap.remove("TIME");
        if (time != null) {
            try {
                long timeInLong = Long.parseLong(time.toString());
                String timeStr = this.timeSdf.format(new Date(timeInLong));
                resultMap.put("TIME", timeStr);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    public boolean parseRecord(String data) {
        this.MULITILINE_MATCH = false;
        boolean result = false;
        Hashtable paramMap = new Hashtable();
        String host = "";
        result = this._format.isKeyRulePresent() ? this.applyKeyBasedParsing(data, paramMap) : this.applyParserRules(data, paramMap, this._format.getParserRules());
        if (result) {
            String hostFromRec = (String)paramMap.get("HOSTNAME");
            if (hostFromRec != null && !"".equals(hostFromRec)) {
                host = hostFromRec;
            }
            int paramBitSet = this.getParamBitSet(paramMap, this.rptParams);
            this.applySeverityRules(paramMap, host, this.getParamBitSet(paramMap, this.sevParams));
            this.applyReportRules(paramMap, host, paramBitSet);
            this.addToLuceneBuffer(paramMap, data);
            long time = Long.parseLong((String)paramMap.get("HOURINMILLIS"));
            if (this.minTime == 0L) {
                this.minTime = time;
            }
            if (time > this.maxTime) {
                this.maxTime = time;
            }
            if (time < this.minTime) {
                this.minTime = time;
            }
        }
        return result;
    }

    private void applySeverityRules(Hashtable paramMap, String host, int paramBitSet) {
        String sev = "INFORMATION";
        for (ReportCategory category : this._format.getSeverityCategories()) {
            boolean isMatch = false;
            for (ReportRule rRule : category.getReportRules()) {
                rRule.getId();
                boolean isRptMatch = true;
                int sevBitSet = (Integer)this.sevBitSets.get(rRule.getId());
                if (sevBitSet == (sevBitSet & paramBitSet)) {
                    for (Rule rule : rRule.getRules()) {
                        if (ParserUtil.applyOperator(rule, (String)paramMap.get(rule.getKey()))) continue;
                        isRptMatch = false;
                        break;
                    }
                } else {
                    isRptMatch = false;
                }
                if (!isRptMatch) continue;
                isMatch = true;
                break;
            }
            if (!isMatch) continue;
            sev = category.getName();
            break;
        }
        int severity = 3;
        if (sev.equals("CRITICAL")) {
            severity = 0;
        } else if (sev.equals("ERROR")) {
            severity = 1;
        } else if (sev.equals("WARNING")) {
            severity = 2;
        }
        if (this.appId != null) {
            SeverityRecord record = new SeverityRecord();
            record.setHost(host);
            record.setHourInMillis(new Long((String)paramMap.get("HOURINMILLIS")));
            record.setHourOfDay((String)paramMap.get("HOUROFDAY"));
            record.setHour((String)paramMap.get("HOUR"));
            int pos = Collections.binarySearch(this.sevDetails, record, this.sComparator);
            if (pos >= 0) {
                ((SeverityRecord)this.sevDetails.get(pos)).incCount(severity);
            } else {
                record.incCount(severity);
                this.sevDetails.add(-pos - 1, record);
            }
            if (this.sevDetails.size() >= 100) {
                RecordWriter writer = this.sevRecordwriter;
                writer.addToFile(this.appId, this.sevDetails);
                this.sevDetails.clear();
            }
        }
        paramMap.put("COMMON_SEVERITY", sev);
    }

    private void addToLuceneBuffer(Hashtable paramMap, String data) {
        String msgLog;
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("APPID", this.appId.toString());
        map.put("FORMATID", this._format.getFormatId().toString());
        for (String fieldName : FieldRepository.get_instance().getIndexedFields(this._format.getFormatId() + "")) {
            Object value = paramMap.get(fieldName);
            if (value == null) continue;
            map.put(fieldName, (String)value);
        }
        String common_Sev = (String)paramMap.get("COMMON_SEVERITY");
        if (common_Sev == null) {
            common_Sev = "information";
        }
        map.put("COMMON_SEVERITY", common_Sev);
        String matching_reports = (String)paramMap.get("MATCHING_REPORTS");
        if (matching_reports == null || matching_reports.length() == 0) {
            matching_reports = (String)paramMap.get("null");
        }
        if (matching_reports != null && matching_reports.length() > 0) {
            map.put("MATCHING_REPORTS", matching_reports);
        }
        if ((msgLog = (String)paramMap.get("log_msg")) != null) {
            map.put("RAWLOG", msgLog.replaceAll("\\t|\\n|\\x0B|\\f|\\r", " "));
        } else {
            map.put("RAWLOG", data);
        }
        try {
            SystemCustomPatternHandler.getInstance().parse(map);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        LogIndexingAPI.getInstance().indexRecord(map);
        UploadUtils.uploadLogs(map);
        this.nfManager.notify((Hashtable)map.clone());
        try {
            this.logforwarder.filterAndForward(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setParser(byte parserType) {
        switch (parserType) {
            case 4: {
                this.parser = new DynSeparatorParser();
                break;
            }
            case 2: {
                this.parser = new SeparatorParser();
                break;
            }
            case 1: {
                this.parser = new RegexParser();
                break;
            }
            default: {
                this.parser = new RegexParser();
            }
        }
    }

    public void residualUpdate() {
        this.indexer.flush();
        for (Map.Entry entry : this.rptDetails.entrySet()) {
            int numParams = this._format.getReportCategory((Integer)entry.getKey()).getFields().size();
            RecordWriter writer = this.containsLongReport ? (numParams > 6 ? this.reportRecordwriters[1] : this.reportRecordwriters[0]) : this.reportRecordwriters[0];
            writer.addToFile(this.appId, this._format.getFormatId(), this._format.getReportCategory((Integer)entry.getKey()).getName(), (ArrayList)entry.getValue());
            ((ArrayList)entry.getValue()).clear();
        }
        for (int i = 0; i < this.reportRecordwriters.length; ++i) {
            RecordWriter writer = this.reportRecordwriters[i];
            writer.shutDown();
        }
        this.sevRecordwriter.addToFile(this.appId, this.sevDetails);
        this.sevDetails.clear();
        this.sevRecordwriter.shutDown();
    }

    private class RecordComparator
    implements Comparator {
        private RecordComparator() {
        }

        public int compare(Object o1, Object o2) {
            ReportRecord r1 = (ReportRecord)o1;
            ReportRecord r2 = (ReportRecord)o2;
            int retVal = r1.getHourInMillis().compareTo(r2.getHourInMillis());
            int i = r1.getNumParams();
            if (retVal == 0 && i > 0) {
                ArrayList r1Params = r1.getParams();
                ArrayList r2Params = r2.getParams();
                ArrayList r1ParamTypes = r1.getParamTypes();
                while (--i >= 0) {
                    if (!"SIMPLE".equals(r1ParamTypes.get(i)) || (retVal = ((String)r1Params.get(i)).compareTo((String)r2Params.get(i))) == 0) continue;
                    return retVal;
                }
            } else {
                return retVal;
            }
            return 0;
        }
    }

    private class SeverityComparator
    implements Comparator {
        private SeverityComparator() {
        }

        public int compare(Object o1, Object o2) {
            SeverityRecord r1 = (SeverityRecord)o1;
            SeverityRecord r2 = (SeverityRecord)o2;
            int retVal = r1.getHourInMillis().compareTo(r2.getHourInMillis());
            return retVal;
        }
    }
}

