/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.parser;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.la.util.MetaTableCache;
import com.adventnet.la.util.ResourceCheckerUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.parser.DbUtil;
import com.adventnet.sa.server.parser.ReportRecord;
import com.adventnet.sa.server.parser.SeverityRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecordWriter {
    private static Logger LOGGER = Logger.getLogger(RecordWriter.class.getName());
    private static String recordDelimiter = "|**|**|";
    private String fileName = null;
    private String tableName = null;
    private int numFields = 0;
    private boolean shutdown = false;
    private FileWriter fWriter = null;
    private PrintWriter pWriter = null;
    private int recordCount = 0;
    private Object writeObj = new Object();
    private String fileToDump = null;
    private String currSplitTableName = null;
    private Long currStartTime = null;
    private Long currSplitTableStartTime = null;
    private Long currSplitTableEndTime = null;
    private Long minStartTime = null;
    private ArrayList startTimes = new ArrayList();
    private ArrayList endTimes = new ArrayList();
    private ArrayList tableNames = new ArrayList();
    private static boolean dbType = "mysql".equals(System.getProperty("DBType", "mysql"));
    private static boolean isWinAuthType = "true".equals(System.getProperty("isWinAuthType", "false"));
    private static boolean isPostgres = "postgres".equals(System.getProperty("DBType", "postgres"));
    private static String delimiter = isPostgres ? "~" : "|**|";
    MetaTableCache cache = MetaTableCache.getInstance();
    private HashMap dbParams = null;
    private String bcpParams = null;

    public RecordWriter(String tableName) {
        this.tableName = tableName;
        this.numFields = tableName.indexOf("_longreports_hr_trend_sa") > 0 ? 10 : 6;
        LOGGER.log(Level.INFO, "Instantiating writer with tablename " + tableName + "number of columns : " + this.numFields);
        this.initTempFile();
        this.initCurrentTableTime();
        if (!dbType) {
            String xmlFilePath = System.getProperty("server.home") + File.separator + "conf" + File.separator + "database_params.conf";
            this.dbParams = ResourceCheckerUtil.getConstraints((String)xmlFilePath, (String)"eventlog");
            String dbpass = (String)this.dbParams.get("DBPass");
            dbpass = EnDecryptImplSingleton.getInstance().decrypt(dbpass);
            this.bcpParams = String.format(" -S %s -t \"|**|\" -r \"|**|**|\\n\" -e ..\\logs\\imparcherr.txt -c -k", (String)this.dbParams.get("DBServer"));
            this.bcpParams = this.bcpParams + (isWinAuthType ? " -T" : String.format(" -U %s -P \"%s\"", (String)this.dbParams.get("DBUser"), dbpass));
        }
    }

    private void initCurrentTableTime() {
        Table table = new Table("MetaTable");
        SelectQueryImpl sql = new SelectQueryImpl(table);
        Column col = new Column("MetaTable", "TABLE_NAME");
        Criteria cri = new Criteria(col, (Object)this.tableName, 0);
        sql.setCriteria(cri);
        sql.addSelectColumn(new Column("MetaTable", "*"));
        try {
            DataObject dob = DataAccess.constructDataObject();
            dob = DataAccess.get((SelectQuery)sql);
            this.currSplitTableName = this.tableName;
            this.currStartTime = new Long(((Timestamp)dob.getFirstValue("MetaTable", "START_TIME")).getTime());
            this.currSplitTableStartTime = new Long(this.currStartTime);
            this.currSplitTableEndTime = new Long(-1L);
            Iterator iterator = dob.getRows("MetaTable");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long startTime = new Long(((Timestamp)row.get("START_TIME")).getTime());
                this.startTimes.add(startTime);
                Object endTime = row.get("END_TIME");
                if (endTime != null) {
                    this.endTimes.add(new Long(((Timestamp)endTime).getTime()));
                } else {
                    this.endTimes.add(new Long(-1L));
                }
                this.tableNames.add((String)row.get("LOOKUP_TABLENAME"));
                if (this.minStartTime == null) {
                    this.minStartTime = startTime;
                    continue;
                }
                if (this.minStartTime.compareTo(startTime) <= 0) continue;
                this.minStartTime = startTime;
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private void addToFile(Long app_id, Long reportId, ArrayList records) {
        for (ReportRecord record : records) {
            this.checkCurrentTable(record.getHourInMillis());
            int fieldCount = this.numFields;
            StringBuffer recordData = new StringBuffer();
            if (!isPostgres) {
                recordData.append(delimiter);
            }
            if (dbType) {
                recordData.append("''");
                recordData.append(delimiter);
            }
            recordData.append(app_id);
            recordData.append(delimiter);
            recordData.append(reportId);
            recordData.append(delimiter);
            recordData.append(record.getHourOfDay());
            recordData.append(delimiter);
            recordData.append(record.getHour());
            recordData.append(delimiter);
            for (String param : record.getParams()) {
                recordData.append(param);
                recordData.append(delimiter);
                --fieldCount;
            }
            while (fieldCount > 0) {
                if (dbType) {
                    recordData.append("\\N");
                }
                recordData.append(delimiter);
                --fieldCount;
            }
            recordData.append(record.getCount());
            if (!isPostgres) {
                recordData.append(recordDelimiter);
            }
            this.save(recordData.toString());
        }
        if (this.recordCount > 300) {
            this.flush();
        }
    }

    private void checkCurrentTable(Long hourInMillis) {
        if (hourInMillis.compareTo(this.currStartTime) >= 0) {
            if (!this.currSplitTableName.equals(this.tableName)) {
                if (this.recordCount > 0) {
                    this.flush();
                }
                this.currSplitTableName = this.tableName;
            }
            return;
        }
        if (hourInMillis.compareTo(this.currSplitTableStartTime) >= 0 && hourInMillis.compareTo(this.currSplitTableEndTime) < 0) {
            return;
        }
        if (this.tableNames.size() > 1) {
            if (hourInMillis.compareTo(this.minStartTime) < 0) {
                DbUtil dbUtil = DbUtil.get_instance();
                String alteredTableName = dbUtil.createLikeTable(this.tableName);
                dbUtil.updateMetaTableCache(alteredTableName, this.tableName, new Timestamp(hourInMillis), new Timestamp(this.minStartTime));
                this.currSplitTableStartTime = new Long(hourInMillis);
                this.currSplitTableEndTime = new Long(this.minStartTime);
                this.minStartTime = new Long(hourInMillis);
                this.currSplitTableName = alteredTableName;
                return;
            }
            for (int i = 0; i < this.startTimes.size(); ++i) {
                if (hourInMillis.compareTo((Long)this.startTimes.get(i)) < 0 || hourInMillis.compareTo((Long)this.endTimes.get(i)) >= 0) continue;
                if (this.recordCount > 0) {
                    this.flush();
                }
                this.currSplitTableName = (String)this.tableNames.get(i);
                this.currSplitTableStartTime = (Long)this.startTimes.get(i);
                this.currSplitTableEndTime = (Long)this.endTimes.get(i);
                return;
            }
        } else if (hourInMillis.compareTo(this.currStartTime) < 0) {
            DbUtil.get_instance().updateMetaTableTime(this.tableName, hourInMillis);
            this.currStartTime = new Long(hourInMillis);
            this.currSplitTableStartTime = new Long(hourInMillis);
            this.minStartTime = new Long(hourInMillis);
        }
    }

    public synchronized void addToFile(Long app_id, Long formatId, String reportName, ArrayList records) {
        Long reportId = DbUtil.get_instance().getReportId(formatId, reportName);
        this.addToFile(app_id, reportId, records);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpToDatabase() {
        RelationalAPI rapi = RelationalAPI.getInstance();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (this.fileToDump != null) {
            try {
                File tmpFile = new File(System.getProperty("server.home") + File.separator + "data" + File.separator + this.fileToDump);
                String filePath = tmpFile.getCanonicalPath();
                filePath = filePath.replace('\\', '/');
                if (dbType) {
                    String sql = "load data local infile '" + filePath + "' into table " + this.currSplitTableName + " fields terminated by '|**|' lines terminated by '|**|**|' starting by '|**|'";
                    con = rapi.getConnection();
                    stmt = con.createStatement();
                    int ret = stmt.executeUpdate(sql);
                    LOGGER.log(Level.INFO, ret + "Records written");
                } else if (isPostgres) {
                    con = rapi.getConnection();
                    stmt = con.createStatement();
                    rs = stmt.executeQuery("Select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME='" + this.currSplitTableName + "'");
                    StringBuilder colBuilder = new StringBuilder();
                    String columnNames = "";
                    colBuilder.append(" (");
                    while (rs.next()) {
                        if (rs.isFirst()) continue;
                        columnNames = rs.getString(1);
                        colBuilder.append(columnNames);
                        colBuilder.append(",");
                    }
                    if (colBuilder.length() > 0) {
                        colBuilder.deleteCharAt(colBuilder.length() - 1);
                        colBuilder.append(")");
                    }
                    columnNames = colBuilder.toString();
                    stmt.addBatch("DROP INDEX IF EXISTS " + this.currSplitTableName + "_APPID_IDX," + this.currSplitTableName + "_HOUR_IDX," + this.currSplitTableName + "_HOUROFDAY_IDX," + this.currSplitTableName + "_REPORTID_IDX");
                    stmt.addBatch("copy " + this.currSplitTableName + columnNames + "from  '" + filePath + "' with delimiter '~'");
                    stmt.addBatch("CREATE INDEX " + this.currSplitTableName + "_APPID_IDX ON " + this.tableName + " (APPID)");
                    stmt.addBatch("CREATE INDEX " + this.currSplitTableName + "_HOUR_IDX ON " + this.tableName + " (HOUR)");
                    stmt.addBatch("CREATE INDEX " + this.currSplitTableName + "_HOUROFDAY_IDX ON " + this.tableName + " (HOUROFDAY)");
                    if (this.currSplitTableName.indexOf("reports") > 0) {
                        stmt.addBatch("CREATE INDEX " + this.currSplitTableName + "_REPORTID_IDX ON " + this.tableName + " (REPORTID)");
                    }
                    stmt.executeBatch();
                    LOGGER.log(Level.FINER, "Indexes Recreated");
                } else {
                    this.loadToMssql(filePath, this.currSplitTableName);
                }
                tmpFile.delete();
                this.fileToDump = null;
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                        LOGGER.log(Level.INFO, "Exception while closing resultset");
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                        LOGGER.log(Level.INFO, "Exception while closing statement");
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                        LOGGER.log(Level.INFO, "Exception while closing connection");
                    }
                }
            }
        }
    }

    private synchronized void flush() {
        this.writeToFile();
        this.dumpToDatabase();
    }

    private void initTempFile() {
        this.fileName = this.tableName + System.currentTimeMillis() + ".txt";
        try {
            this.fWriter = new FileWriter(System.getProperty("server.home") + File.separator + "data" + File.separator + this.fileName);
            this.pWriter = new PrintWriter((Writer)new BufferedWriter(this.fWriter), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String row) {
        Object object = this.writeObj;
        synchronized (object) {
            ++this.recordCount;
            this.pWriter.println(row);
        }
    }

    public void shutDown() {
        this.shutdown = true;
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile() {
        Object object = this.writeObj;
        synchronized (object) {
            this.recordCount = 0;
            try {
                this.pWriter.flush();
                this.pWriter.close();
                this.fWriter.close();
                this.pWriter = null;
                this.fWriter = null;
                this.fileToDump = this.fileName;
                this.fileName = null;
                if (!this.shutdown) {
                    this.initTempFile();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void addToFile(Long appId, ArrayList sevDetails) {
        for (SeverityRecord record : sevDetails) {
            int total = 0;
            this.checkCurrentTable(record.getHourInMillis());
            StringBuffer recordData = new StringBuffer();
            if (!isPostgres) {
                recordData.append(delimiter);
            }
            if (dbType) {
                recordData.append("''");
                recordData.append(delimiter);
            }
            recordData.append(appId);
            recordData.append(delimiter);
            recordData.append(record.getHourOfDay());
            recordData.append(delimiter);
            recordData.append(record.getHour());
            recordData.append(delimiter);
            int[] countArray = record.getSevCount();
            for (int i = 0; i < countArray.length; ++i) {
                int count = countArray[i];
                total += count;
                recordData.append(count);
                recordData.append(delimiter);
            }
            recordData.append(total);
            if (!isPostgres) {
                recordData.append(recordDelimiter);
            }
            this.save(recordData.toString());
        }
        if (this.recordCount > 300) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadToMssql(String fileName, String tableName) throws Exception {
        String command = String.format("..\\bin\\bcp.exe [%s].dbo.%s in \"%s\" %s", (String)this.dbParams.get("DBName"), tableName, fileName, this.bcpParams);
        BufferedReader in = null;
        FileOutputStream fos = new FileOutputStream(System.getProperty("server.home") + File.separator + "logs" + File.separator + "appImport.log");
        Process p = Runtime.getRuntime().exec(command);
        try {
            int c;
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((c = in.read()) != -1) {
                fos.write(c);
            }
        }
        catch (IOException ioex) {
            System.out.println("Problem in importing the application file");
            ioex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

