/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.parser;

import com.adventnet.sa.server.parser.Attribute;
import com.adventnet.sa.server.parser.DynSeparatorParser;
import com.adventnet.sa.server.parser.LogFormat;
import com.adventnet.sa.server.parser.Parser;
import com.adventnet.sa.server.parser.ParserRule;
import com.adventnet.sa.server.parser.ParserUtil;
import com.adventnet.sa.server.parser.RegexParser;
import com.adventnet.sa.server.parser.SeparatorParser;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;

public class SysEvtRecordParser {
    private static Parser parser = null;
    private LogFormat _format = null;

    public SysEvtRecordParser(LogFormat format, Long hostId) {
        this._format = format;
    }

    private boolean applyKeyBasedParsing(String record, Hashtable paramMap) {
        ParserRule pRule;
        String key = null;
        Iterator iterator = this._format.getKeyRules().iterator();
        while (iterator.hasNext() && (key = this.executeKeyRule(record, pRule = (ParserRule)iterator.next())) == null) {
        }
        List ruleList = null;
        if (key != null) {
            ruleList = this._format.getParserRule(key);
        }
        if (ruleList == null) {
            ruleList = this._format.getParserRule("All");
        }
        return this.applyParserRules(record, paramMap, ruleList);
    }

    private boolean applyParserRules(String record, Hashtable paramMap, List ruleList) {
        if (ruleList == null) {
            return false;
        }
        boolean result = false;
        for (ParserRule rule : ruleList) {
            if (parser == null) {
                this.setParser(rule.getParserType());
            }
            boolean lastExp = this.executeParserRule(record, rule, paramMap);
            result = result || lastExp;
        }
        if (result) {
            ParserUtil.getDateTime(paramMap);
        }
        return result;
    }

    private boolean executeParserRule(String record, ParserRule rule, Hashtable paramMap) {
        boolean result = parser.getParams(record, rule, paramMap);
        if (paramMap.containsKey("PRI")) {
            int pri = Integer.parseInt((String)paramMap.get("PRI"));
            paramMap.put("SEVERITY", this.getSeverity(pri % 8));
            paramMap.put("FACILITY", this.getFacility(pri / 8));
        }
        if (result) {
            parser.getParsedAttributes(rule.getParsedAttributes(), paramMap);
        }
        return result;
    }

    private String getFacility(int i) {
        switch (i) {
            case 0: {
                return "Kernel";
            }
            case 1: {
                return "User";
            }
            case 2: {
                return "Mail";
            }
            case 3: {
                return "Daemon";
            }
            case 4: {
                return "Auth";
            }
            case 5: {
                return "Syslog";
            }
            case 6: {
                return "Lpr";
            }
            case 7: {
                return "News";
            }
            case 8: {
                return "UUCP";
            }
            case 9: {
                return "Cron";
            }
            case 10: {
                return "AuthPriv";
            }
            case 11: {
                return "FTP";
            }
            case 12: {
                return "NTP";
            }
            case 13: {
                return "LogAudit";
            }
            case 14: {
                return "LogAlert";
            }
            case 15: {
                return "Clock";
            }
            case 16: {
                return "Local0";
            }
            case 17: {
                return "Local1";
            }
            case 18: {
                return "Local2";
            }
            case 19: {
                return "Local3";
            }
            case 20: {
                return "Local4";
            }
            case 21: {
                return "Local5";
            }
            case 22: {
                return "Local6";
            }
            case 23: {
                return "Local7";
            }
        }
        return null;
    }

    private String getSeverity(int i) {
        switch (i) {
            case 0: {
                return "Emergency";
            }
            case 1: {
                return "Alert";
            }
            case 2: {
                return "Critical";
            }
            case 3: {
                return "Error";
            }
            case 4: {
                return "Warning";
            }
            case 5: {
                return "Notice";
            }
            case 6: {
                return "Information";
            }
            case 7: {
                return "Debug";
            }
        }
        return null;
    }

    private String executeKeyRule(String record, ParserRule rule) {
        Matcher m = rule.getMatcher();
        m.reset(record);
        if (!m.find()) {
            return null;
        }
        ArrayList attrs = rule.getAttributes();
        if (!attrs.isEmpty()) {
            String key = null;
            for (Attribute attr : attrs) {
                key = m.group(attr.getGroupNumber());
                if (key == null) continue;
                return key;
            }
        } else {
            Hashtable openAttributes = rule.getOpenAttributes();
            if (openAttributes != null && openAttributes.containsKey("PARSER_KEY")) {
                return (String)openAttributes.get("PARSER_KEY");
            }
        }
        return null;
    }

    public Hashtable parseRecord(String data) {
        return this.parseRecord(data, new Hashtable());
    }

    public Hashtable parseRecord(String data, Hashtable paramMap) {
        boolean result = false;
        result = this._format.isKeyRulePresent() ? this.applyKeyBasedParsing(data, paramMap) : this.applyParserRules(data, paramMap, this._format.getParserRules());
        if (result) {
            return paramMap;
        }
        return null;
    }

    private void setParser(byte parserType) {
        switch (parserType) {
            case 4: {
                parser = new DynSeparatorParser();
                break;
            }
            case 2: {
                parser = new SeparatorParser();
                break;
            }
            case 1: {
                parser = new RegexParser();
                break;
            }
            default: {
                parser = new RegexParser();
            }
        }
    }
}

