/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.tag;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.lc.FieldRepository;
import com.adventnet.sa.server.parser.DbUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TagCriteria {
    private static final int EQUALS = 1;
    private static final int NOT_EQUALS = 2;
    private static final int GREATER_THAN = 3;
    private static final int LESS_THAN = 4;
    private static final int LESS_THAN_EQUAL = 5;
    private static final int GREATER_THAN_EQUAL = 6;
    private static final int STARTS_WITH = 7;
    private static final int ENDS_WITH = 8;
    private static final int CONTAINS = 9;
    private Pattern comparatorExtractor = Pattern.compile(".*?(!=|<=|>=|=|<|>|starts with|ends with)[^\\$]+");
    private LinkedHashMap<Long, Criteria> criteriaList = new LinkedHashMap();
    private HashSet<String> tagNameList = new HashSet();
    private static TagCriteria tagCriteria = null;
    private static final Logger LOGGER = Logger.getLogger(TagCriteria.class.getName());

    private TagCriteria() {
        this.init();
    }

    public static synchronized TagCriteria getInstance() {
        if (tagCriteria == null) {
            tagCriteria = new TagCriteria();
        }
        return tagCriteria;
    }

    public boolean addTag(String criteriaString, String tagName, String noteIfAny, String userInfo, Long userID) {
        boolean statusAdded = true;
        LOGGER.log(Level.FINER, "TagCriteria.addTag() ... About to add the criteria string .... " + criteriaString);
        try {
            DataObject tagDetailsDO = DataAccess.constructDataObject();
            Row tdRow = new Row("TagDetails");
            tdRow.set("USER_ID", (Object)userID);
            tdRow.set("TAG_NAME", (Object)tagName);
            tdRow.set("TAG_CRITERIA", (Object)criteriaString);
            tagDetailsDO.addRow(tdRow);
            if (noteIfAny != null && userInfo != null) {
                Row tgNoteRow = new Row("TagNote");
                tgNoteRow.set("TAG_ID", tdRow.get("TAG_ID"));
                tgNoteRow.set("TAG_NOTE", (Object)noteIfAny);
                tgNoteRow.set("ADDED_BY", (Object)userInfo);
                tgNoteRow.set("USER_ID", (Object)userID);
                tagDetailsDO.addRow(tgNoteRow);
            }
            LOGGER.log(Level.FINER, " DataObject constructed ...  " + tagDetailsDO);
            tagDetailsDO = DataAccess.add((DataObject)tagDetailsDO);
            long tagID = (Long)tagDetailsDO.getFirstValue("TagDetails", "TAG_ID");
            this.criteriaList.put(tagID, new Criteria(criteriaString, tagName, tagID, userID));
            this.tagNameList.add(tagName);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            statusAdded = false;
            LOGGER.log(Level.WARNING, " Error: Unable to add Tag with Name: " + tagName + " and Criteria: " + criteriaString, exp);
        }
        LOGGER.log(Level.FINER, " Finally status of adding the tag is " + statusAdded);
        return statusAdded;
    }

    public void updateTag(String tagCriteria, String tagName, String tagNote, String userInfo, Long userID, Long tagID) {
        try {
            LOGGER.log(Level.FINER, "TagCriteria.updateTag() called .... ");
            SelectQueryImpl tagSQL = new SelectQueryImpl(new Table("TagDetails"));
            tagSQL.addSelectColumn(new Column("TagDetails", "*"));
            tagSQL.addSelectColumn(new Column("TagNote", "*"));
            tagSQL.setCriteria(new com.adventnet.ds.query.Criteria(new Column("TagDetails", "TAG_ID"), (Object)tagID, 0));
            String[] cols = new String[]{"TAG_ID"};
            tagSQL.addJoin(new Join("TagDetails", "TagNote", cols, cols, 1));
            DataObject tagDO = DataAccess.get((SelectQuery)tagSQL);
            LOGGER.log(Level.FINER, "TagCriteria.updateTag() .... tagDO is-->" + tagDO);
            if (tagDO.isEmpty()) {
                return;
            }
            Row tagDetailsRow = null;
            if (tagDO.getTableNames().contains("TagDetails")) {
                tagDetailsRow = tagDO.getFirstRow("TagDetails");
                tagDetailsRow.set("TAG_CRITERIA", (Object)tagCriteria);
                tagDO.updateRow(tagDetailsRow);
            }
            if (tagNote != null) {
                Row tagNoteRow = new Row("TagNote");
                tagNoteRow.set("TAG_ID", tagDetailsRow.get("TAG_ID"));
                tagNoteRow.set("TAG_NOTE", (Object)tagNote);
                if (userInfo != null) {
                    tagNoteRow.set("ADDED_BY", (Object)userInfo);
                }
                tagNoteRow.set("USER_ID", (Object)userID);
                tagDO.addRow(tagNoteRow);
            }
            LOGGER.log(Level.FINER, "TagCriteria.updateTag() final DO is -->" + tagDO);
            tagDO = DataAccess.update((DataObject)tagDO);
            this.criteriaList.put(tagID, new Criteria(tagCriteria, (String)tagDetailsRow.get("TAG_NAME"), tagID, (Long)tagDetailsRow.get("USER_ID")));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public boolean cleanUpTag(Long tagID) {
        if (tagID == null) {
            return false;
        }
        Criteria crt = this.criteriaList.get(tagID);
        if (crt == null) {
            return false;
        }
        String tagName = crt.getTagName();
        this.criteriaList.remove(tagID);
        this.tagNameList.remove(tagName);
        return true;
    }

    private void init() {
        this.loadTagDetailsFrmDB();
    }

    private void loadTagDetailsFrmDB() {
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("TagDetails"));
            sql.addSelectColumn(new Column("TagDetails", "*"));
            DataObject tagDO = DataAccess.get((SelectQuery)sql);
            LOGGER.log(Level.FINER, "DataObject obtained is " + tagDO);
            if (!tagDO.isEmpty()) {
                Iterator itr = tagDO.getRows("TagDetails");
                while (itr.hasNext()) {
                    Row tagRow = (Row)itr.next();
                    String criteriaString = (String)tagRow.get("TAG_CRITERIA");
                    String tagName = (String)tagRow.get("TAG_NAME");
                    Long tagID = (Long)tagRow.get("TAG_ID");
                    this.criteriaList.put(tagID, new Criteria(criteriaString, tagName, tagID, (Long)tagRow.get("USER_ID")));
                    this.tagNameList.add(tagName);
                }
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error: Unable to load the tag Details from DB ", exp);
        }
    }

    public void addTags(HashMap fieldVsValue) {
        LOGGER.log(Level.FINER, "Size = " + this.criteriaList.size());
        Collection<Criteria> criteriaAsCollection = this.criteriaList.values();
        Iterator<Criteria> criteriaItr = criteriaAsCollection.iterator();
        long start = System.currentTimeMillis();
        while (criteriaItr.hasNext()) {
            Criteria crtObj = criteriaItr.next();
            boolean isMatched = true;
            Iterator itr = crtObj.getCriteria();
            while (itr.hasNext()) {
                Map.Entry e = (Map.Entry)itr.next();
                ValueAndComparator holder = (ValueAndComparator)e.getValue();
                String valueFromMap = (String)fieldVsValue.get(e.getKey());
                if (valueFromMap == null) {
                    isMatched = false;
                    break;
                }
                boolean match = this.compare(valueFromMap = this.checkAndRemoveHighlighterTags(valueFromMap.trim()), holder.getValue(), holder.getComparator());
                if (match) continue;
                isMatched = false;
                break;
            }
            if (!isMatched) continue;
            String tagVal = (String)fieldVsValue.get("Tag");
            String toAdd = crtObj.getTagName() + "|" + crtObj.getID();
            tagVal = tagVal == null ? toAdd : tagVal + "," + toAdd;
            fieldVsValue.put("Tag", tagVal);
        }
    }

    private String checkAndRemoveHighlighterTags(String valueFromMap) {
        long start = System.currentTimeMillis();
        valueFromMap = valueFromMap.replaceAll("<em class='searchHighLight'>", "");
        valueFromMap = valueFromMap.replaceAll("</em>", "");
        LOGGER.log(Level.FINE, "Total Time Taken is = " + (System.currentTimeMillis() - start));
        return valueFromMap;
    }

    private boolean compare(String valueFromMap, String[] givenValues, int comparator) {
        String valueFromMapInLowerCase;
        boolean toReturn = false;
        String string = valueFromMapInLowerCase = valueFromMap != null ? valueFromMap.toLowerCase() : null;
        if (valueFromMapInLowerCase == null) {
            return false;
        }
        switch (comparator) {
            case 1: {
                for (String toCompareWith : givenValues) {
                    if (!valueFromMap.equals(toCompareWith)) continue;
                    toReturn = true;
                    break;
                }
                return toReturn;
            }
            case 2: {
                for (String toCompareWith : givenValues) {
                    if (valueFromMap.equals(toCompareWith)) continue;
                    toReturn = true;
                    break;
                }
                return toReturn;
            }
            case 3: {
                String givenValue = givenValues[0];
                try {
                    toReturn = Integer.parseInt(valueFromMap) > Integer.parseInt(givenValue);
                    toReturn = valueFromMap.compareTo(givenValue) > 0;
                }
                catch (Exception exp) {
                    return valueFromMap.compareTo(givenValue) > 0;
                }
                return toReturn;
            }
            case 4: {
                String givenValue = givenValues[0];
                try {
                    toReturn = Integer.parseInt(valueFromMap) < Integer.parseInt(givenValue);
                }
                catch (Exception exp) {
                    toReturn = valueFromMap.compareTo(givenValue) < 0;
                }
                return toReturn;
            }
            case 6: {
                String givenValue = givenValues[0];
                try {
                    toReturn = Integer.parseInt(valueFromMap) >= Integer.parseInt(givenValue);
                }
                catch (Exception exp) {
                    toReturn = valueFromMap.compareTo(givenValue) >= 0;
                }
                return toReturn;
            }
            case 5: {
                String givenValue = givenValues[0];
                try {
                    toReturn = Integer.parseInt(valueFromMap) <= Integer.parseInt(givenValue);
                }
                catch (Exception exp) {
                    toReturn = valueFromMap.compareTo(givenValue) <= 0;
                }
                return toReturn;
            }
            case 7: {
                for (String toCompareWith : givenValues) {
                    if (!valueFromMapInLowerCase.startsWith(toCompareWith.toLowerCase())) continue;
                    toReturn = true;
                    break;
                }
                return toReturn;
            }
            case 8: {
                for (String toCompareWith : givenValues) {
                    if (!valueFromMapInLowerCase.endsWith(toCompareWith.toLowerCase())) continue;
                    toReturn = true;
                    break;
                }
                return toReturn;
            }
            case 9: {
                for (String toCompareWith : givenValues) {
                    if (valueFromMapInLowerCase.indexOf(toCompareWith.toLowerCase()) < 0) continue;
                    toReturn = true;
                    break;
                }
                return toReturn;
            }
        }
        toReturn = false;
        return toReturn;
    }

    public Set getTagNames(Long userID) {
        LOGGER.log(Level.FINER, "TagCriteria.getTagNames() Called ... returning .... " + this.tagNameList);
        return (HashSet)this.tagNameList.clone();
    }

    public String getCriteria(String tagName) {
        if (!this.tagNameList.contains(tagName)) {
            return null;
        }
        StringBuilder tagCriteria = null;
        int count = 0;
        Collection<Criteria> criteriaAsCollection = this.criteriaList.values();
        for (Criteria crtObj : criteriaAsCollection) {
            String currentTagName = crtObj.getTagName();
            if (!currentTagName.equals(tagName)) continue;
            ++count;
            tagCriteria = tagCriteria == null ? new StringBuilder() : tagCriteria.append(" OR ");
            tagCriteria.append(" ( ");
            tagCriteria.append(crtObj.getDisplayString());
            tagCriteria.append(" ) ");
        }
        return count > 1 ? " ( " + tagCriteria.toString() + " ) " : tagCriteria.toString();
    }

    public Criteria getTagInfo(String tagName, long tagID) {
        Criteria toReturn = null;
        Collection<Criteria> criteriaAsCollection = this.criteriaList.values();
        for (Criteria crtObj : criteriaAsCollection) {
            String currentTagName = crtObj.getTagName();
            LOGGER.log(Level.FINER, "TagCriteria.getTagInfo() TagID passed from client is -->" + tagID + " and ID obtained from object is -->" + crtObj.getID());
            if (!currentTagName.equals(tagName) || Long.valueOf(crtObj.getID()).compareTo(tagID) != 0) continue;
            toReturn = crtObj;
        }
        LOGGER.log(Level.FINER, "TagCriteria.getTagInfo() ... finally about to return the value is --->" + toReturn);
        return toReturn;
    }

    public static void main(String[] args) {
    }

    public class Criteria {
        private HashMap store = new HashMap();
        private String tagName;
        private long id;
        private long userID;

        Criteria(String crtString, String tagName, long id, long userID) {
            this.tagName = tagName;
            this.id = id;
            String[] crtList = crtString.split("\\|");
            this.userID = userID;
            for (String tempCrt : crtList) {
                Matcher m = TagCriteria.this.comparatorExtractor.matcher(tempCrt);
                boolean status = m.matches();
                if (!status) {
                    m.reset();
                    status = m.find();
                }
                String[] keyValueList = tempCrt.split("(!=|<=|>=|=|<|>|starts with|ends with|contains)");
                String columnName = keyValueList[0];
                String columnValue = keyValueList[1];
                String comparator = m.group(1);
                this.store.put(columnName.trim(), new ValueAndComparator(columnValue.trim(), comparator.trim()));
            }
        }

        public Iterator getCriteria() {
            return this.store.entrySet().iterator();
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getDisplayString() {
            StringBuilder sb = new StringBuilder();
            Iterator itr = this.getCriteria();
            boolean isFirst = true;
            while (itr.hasNext()) {
                Map.Entry e = (Map.Entry)itr.next();
                ValueAndComparator holder = (ValueAndComparator)e.getValue();
                String columnName = (String)e.getKey();
                StringBuilder stringBuilder = sb = !isFirst ? sb.append(" AND ") : sb;
                if ("LOGTYPE".equals(columnName)) {
                    String[] values = holder.getValue();
                    ArrayList<String> hostTypes = new ArrayList<String>();
                    ArrayList<Long> formatIDList = new ArrayList<Long>();
                    String[] stringArray = values;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String[] sFormatNames;
                        String value = stringArray[i];
                        String formatNames = FieldRepository.get_instance().getFormatName(value);
                        LOGGER.log(Level.FINE, "FormatNames obtained for value=" + value + " is =" + formatNames);
                        formatNames = formatNames == null ? value : formatNames;
                        for (String name : sFormatNames = formatNames.split(",")) {
                            Long formatID = DbUtil.get_instance().getFormatId(name);
                            boolean bl = formatID != null && formatID > 0L ? formatIDList.add(formatID) : hostTypes.add("\"" + name + "\"");
                        }
                    }
                    StringBuilder logTypeCrt = new StringBuilder();
                    this.appendContent(logTypeCrt, hostTypes, " HOSTTYPE ", holder.getStrComparator());
                    this.appendContent(logTypeCrt, formatIDList, " FORMATID ", holder.getStrComparator());
                    sb.append(" ( ");
                    sb.append(logTypeCrt.toString());
                    sb.append(" ) ");
                } else {
                    sb.append(" ");
                    boolean shdAppendOR = false;
                    int totalCrt = holder.getValue().length;
                    sb.append(totalCrt > 1 ? " ( " : "");
                    for (String mCrt : holder.getValue()) {
                        sb.append(!shdAppendOR ? "" : " OR  ");
                        sb.append(columnName);
                        sb.append(holder.getStrComparator());
                        if (!"EVENTID".equals(columnName.trim())) {
                            sb.append("\"");
                            sb.append(mCrt);
                            sb.append("\"");
                        } else {
                            sb.append(mCrt);
                        }
                        shdAppendOR = true;
                    }
                    sb.append(totalCrt > 1 ? " ) " : "");
                }
                sb.append(" ");
                isFirst = false;
            }
            return sb.toString();
        }

        private void appendContent(StringBuilder sb, List values, String columnName, String comparator) {
            for (Object val : values) {
                sb = sb.length() == 0 ? sb : sb.append(" OR ");
                sb.append(columnName);
                sb.append(" ");
                sb.append(comparator);
                sb.append(" ");
                sb.append(val);
            }
        }

        public long getID() {
            return this.id;
        }

        public long getUID() {
            return this.userID;
        }
    }

    public class ValueAndComparator {
        String value;
        int comparator;
        String strComparator;

        ValueAndComparator(String value, String comparator) {
            this.value = value;
            this.strComparator = comparator;
            this.comparator = "=".equals(comparator) ? 1 : ("!=".equals(comparator) ? 2 : (">".equals(comparator) ? 3 : ("<".equals(comparator) ? 4 : ("<=".equals(comparator) ? 5 : (">=".equals(comparator) ? 6 : ("starts with".equals(comparator) ? 7 : ("ends with".equals(comparator) ? 8 : ("contains".equals(comparator) ? 9 : 1))))))));
        }

        String[] getValue() {
            return this.value.split(",");
        }

        int getComparator() {
            return this.comparator;
        }

        public String getStrComparator() {
            return this.strComparator;
        }

        public String getValueString() {
            return this.value;
        }

        String getDisplayString() {
            String formattedValue = this.value.replace("\"", "\\\"");
            formattedValue = "\"" + formattedValue + "\"";
            return this.strComparator + " " + formattedValue;
        }
    }
}

