/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.univlogparser;

import com.adventnet.sa.server.imp.AbstractEncryptionHandler;
import com.adventnet.sa.server.imp.Encryption256Bit;
import com.adventnet.sa.server.imp.EncryptionAPI;
import com.adventnet.sa.server.univlogparser.LineFTPClient;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CustomFileTransferUtil {
    private FileType fileExtentionType = null;
    private String localFileName = null;
    private boolean unSupported = false;
    private InputStream inputStream = null;
    private AbstractEncryptionHandler encryptionBaseObj = null;
    private boolean isEncryptedFile = false;
    private boolean isZIPStream = false;
    private ZipInputStream zin = null;
    private GZIPInputStream gzin = null;
    private BufferedInputStream tempBIS = null;
    private boolean isUTF16File = false;
    private static final Logger LOGGER = Logger.getLogger(CustomFileTransferUtil.class.getName());

    public CustomFileTransferUtil(String remoteFileName, InputStream inputStream) {
        this.inputStream = inputStream;
        this.localFileName = remoteFileName;
        if (remoteFileName.endsWith(".zip")) {
            this.fileExtentionType = FileType.ZIP_FILE;
            this.localFileName = remoteFileName.substring(0, remoteFileName.length() - 4);
        } else if (remoteFileName.endsWith(".zip.gz")) {
            this.fileExtentionType = FileType.ZIP_GZ_FILE;
            this.localFileName = remoteFileName.substring(0, remoteFileName.length() - 7);
        } else if (remoteFileName.endsWith(".gz")) {
            this.fileExtentionType = FileType.GZ_FILE;
            this.localFileName = remoteFileName.substring(0, remoteFileName.length() - 3);
        } else if (remoteFileName.endsWith(".evt") || remoteFileName.endsWith(".evtx")) {
            this.fileExtentionType = FileType.OTHER_BINARY_FILE;
        } else if (remoteFileName.endsWith("_enc")) {
            this.isEncryptedFile = true;
            this.encryptionBaseObj = remoteFileName.endsWith("_256_enc") ? Encryption256Bit.getInstance(remoteFileName) : EncryptionAPI.getInstance(remoteFileName);
            this.fileExtentionType = FileType.ENC;
            this.localFileName = remoteFileName.substring(0, remoteFileName.length() - 4);
        } else {
            this.fileExtentionType = FileType.NORMAL_FILE;
        }
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getLocalFileName() {
        return this.localFileName;
    }

    public boolean isUnSupported() {
        return this.unSupported;
    }

    public boolean isZIPStream() {
        return this.isZIPStream;
    }

    public String readLineFromReader(BufferedReader reader) {
        String s = null;
        if (this.isEncryptedFile) {
            s = this.encryptionBaseObj.readEncryptedLine(reader);
            if (s != null) {
                s = this.encryptionBaseObj.decryptLog(s, !this.isUTF16File);
            }
        } else {
            try {
                s = reader.readLine();
            }
            catch (IOException ex) {
                Logger.getLogger(LineFTPClient.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return s;
    }

    public BufferedReader getBufferedReaderForZipStream() {
        BufferedReader lin = null;
        ZipEntry entry = null;
        try {
            if (this.zin == null) {
                return lin;
            }
            this.zin.available();
        }
        catch (IOException ioexp) {
            LOGGER.log(Level.FINER, "Got IOException - {0}", ioexp.getMessage());
            return lin;
        }
        this.isZIPStream = true;
        try {
            while ((entry = this.zin.getNextEntry()) != null) {
                if ("archivedesc.properties".equals(entry.getName())) continue;
                if (entry.getName().endsWith("_enc")) {
                    this.isEncryptedFile = true;
                    this.encryptionBaseObj = entry.getName().endsWith("_256_enc") ? Encryption256Bit.getInstance(entry.getName()) : EncryptionAPI.getInstance(entry.getName());
                } else {
                    this.isEncryptedFile = false;
                }
                LOGGER.log(Level.INFO, "ZIP Entry Name -> {0}", entry.getName());
                boolean isUTF16 = false;
                try {
                    this.tempBIS = new BufferedInputStream(this.zin);
                    this.tempBIS.mark(5000);
                    byte[] buffer = new byte[64];
                    this.tempBIS.read(buffer);
                    isUTF16 = this.isUTF16(buffer);
                    this.tempBIS.reset();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                lin = isUTF16 ? new BufferedReader(new InputStreamReader((InputStream)this.tempBIS, "UTF16")) : new BufferedReader(new InputStreamReader(this.tempBIS != null ? this.tempBIS : this.zin));
                break;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return lin;
    }

    public void closeAllStreams() {
        if (this.zin != null) {
            try {
                this.zin.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.gzin != null) {
            try {
                this.gzin.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.tempBIS != null) {
            try {
                this.tempBIS.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isUTF16File() {
        return this.isUTF16File;
    }

    public BufferedReader getInputReaderObj(BufferedInputStream bis) throws IOException {
        BufferedReader lin = null;
        try {
            bis.available();
        }
        catch (IOException ioexp) {
            LOGGER.log(Level.FINER, "Got IOException - {0}", ioexp.getMessage());
            return lin;
        }
        this.isEncryptedFile = false;
        switch (this.fileExtentionType) {
            case ZIP_FILE: {
                try {
                    this.zin = this.zin == null ? new ZipInputStream(bis) : this.zin;
                    lin = this.getBufferedReaderForZipStream();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    this.unSupported = true;
                }
                break;
            }
            case GZ_FILE: {
                try {
                    this.gzin = new GZIPInputStream(this.inputStream);
                    if (this.gzin.available() == 1) {
                        this.tempBIS = new BufferedInputStream(this.gzin);
                        this.tempBIS.mark(1024);
                        BufferedReader buf = new BufferedReader(new InputStreamReader(this.tempBIS));
                        String firstLine = buf.readLine();
                        boolean isBinaryData = this.isBinaryFile(firstLine.getBytes());
                        bis.reset();
                        this.tempBIS.reset();
                        if (isBinaryData) {
                            this.zin = this.zin == null ? new ZipInputStream(this.tempBIS) : this.zin;
                            this.fileExtentionType = FileType.ZIP_GZ_FILE;
                            lin = this.getBufferedReaderForZipStream();
                            break;
                        }
                        lin = buf;
                        break;
                    }
                    this.unSupported = true;
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    this.unSupported = true;
                }
                break;
            }
            case ZIP_GZ_FILE: {
                try {
                    this.gzin = new GZIPInputStream(bis);
                    if (this.gzin.available() == 1) {
                        this.zin = this.zin == null ? new ZipInputStream(this.gzin) : this.zin;
                        lin = this.getBufferedReaderForZipStream();
                        break;
                    }
                    this.unSupported = true;
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    this.unSupported = true;
                }
                break;
            }
            case ENC: {
                this.isEncryptedFile = true;
            }
            case NORMAL_FILE: {
                try {
                    boolean isUTF16 = false;
                    try {
                        bis.mark(5000);
                        byte[] buffer = new byte[64];
                        bis.read(buffer);
                        isUTF16 = this.isUTF16(buffer);
                        bis.reset();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                    if (isUTF16) {
                        this.isUTF16File = true;
                        lin = new BufferedReader(new InputStreamReader((InputStream)bis, "UTF16"));
                        break;
                    }
                    lin = new BufferedReader(new InputStreamReader(bis));
                    break;
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    this.unSupported = true;
                }
            }
            default: {
                this.unSupported = true;
            }
        }
        return lin;
    }

    private boolean isUTF16(byte[] buffer) {
        boolean isUTF16 = false;
        try {
            isUTF16 = buffer[0] == -1 && buffer[1] == -2 || buffer[0] == -2 && buffer[1] == -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isUTF16;
    }

    private boolean isBinaryFile(byte[] data) {
        int ascii = 0;
        int other = 0;
        for (int i = 0; i < data.length; ++i) {
            byte b = data[i];
            if (b < 9) {
                return true;
            }
            if (b == 9 || b == 10 || b == 12 || b == 13) {
                ++ascii;
                continue;
            }
            if (b >= 32 && b <= 126) {
                ++ascii;
                continue;
            }
            ++other;
        }
        if (other == 0) {
            return false;
        }
        return (ascii + other) * 100 / other > 95;
    }

    private static enum FileType {
        NORMAL_FILE,
        ZIP_FILE,
        GZ_FILE,
        ZIP_GZ_FILE,
        OTHER_BINARY_FILE,
        ENC;

    }
}

