/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.univlogparser;

import com.adventnet.la.fieldgen.CustomLogTypePatterns;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.la.univlogparser.TimeUtil;
import com.adventnet.sa.server.univlogparser.FormatIdentifier;
import com.adventnet.sa.server.univlogparser.ImportHandler;
import com.google.code.regexp.NamedMatcher;
import com.google.code.regexp.NamedPattern;
import java.io.BufferedReader;
import java.io.File;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class DefaultPatternsProcessor
extends ImportHandler {
    private JSONArray resultJsonArray = new JSONArray();
    private String fileName = null;
    private String host = null;
    private LinkedHashSet parsedFields = null;
    private int maxLogCount = 200;
    private LinkedHashSet<Integer> matchingDefPatternIds = null;
    private boolean identifiedFormat = false;
    private String logTypeName = null;
    private long formatId = -1L;
    private BufferedReader bReader = null;
    private static final Logger LOGGER = Logger.getLogger(DefaultPatternsProcessor.class.getName());

    public DefaultPatternsProcessor(String hostName, String fileName, int maxLogCount) {
        super(hostName, fileName, null, -1L);
        this.fileName = fileName;
        this.parsedFields = new LinkedHashSet();
        this.maxLogCount = maxLogCount;
        this.matchingDefPatternIds = new LinkedHashSet();
        this.host = hostName;
    }

    public JSONObject getPreparsedMapForUnsupportedLogs(BufferedReader bReader) {
        this.bReader = bReader;
        this.startLogImport();
        JSONObject result = new JSONObject();
        try {
            result.put("Details", (Object)this.resultJsonArray);
            result.put("Fields", (Object)new JSONArray((Collection)this.parsedFields));
            LinkedHashSet unparsedFields = new LinkedHashSet();
            unparsedFields.addAll(CustomLogTypePatterns.getCommonFieldNames());
            unparsedFields.removeAll(this.parsedFields);
            result.put("UnMatchedFields", (Object)new JSONArray(unparsedFields));
            result.put("LogType", (Object)this.logTypeName);
            result.put("FileName", (Object)this.fileName);
            result.put("MatchingDefIds", (Object)new JSONArray(this.matchingDefPatternIds));
            result.put("ISKVPorCSV", this.identifiedFormat);
            result.put("IsExistingType", this.formatId > -1L);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return result;
    }

    @Override
    public void startLogImport() {
        boolean isMarkSupported = this.bReader.markSupported();
        this.markOrResetPosition(this.bReader, true, isMarkSupported);
        int formatIdentified = -1;
        formatIdentified = FormatIdentifier.getInstance().identifyFormat(this.bReader);
        LOGGER.log(Level.INFO, "ImportHandler.startImportLog() Value of format identified is :::::: {0}", formatIdentified);
        this.logTypeName = this.host + "-" + this.fileName;
        String trimmedFileName = this.fileName;
        int allowedFileNameLen = 50 - this.host.length();
        if (this.logTypeName.length() > 50) {
            String f = new File(this.fileName).getName();
            trimmedFileName = f.length() < allowedFileNameLen ? f : this.fileName.substring(this.fileName.length() - allowedFileNameLen);
        }
        if (formatIdentified > 0) {
            this.identifiedFormat = true;
            if (trimmedFileName.length() > allowedFileNameLen - 16) {
                trimmedFileName = trimmedFileName.substring(trimmedFileName.length() - 16);
            }
            this.logTypeName = formatIdentified == 1 ? this.host + "-" + trimmedFileName + "_KEY_VALUE_PAIR" : this.host + "-" + trimmedFileName + "_Comma_Separated";
        } else {
            this.logTypeName = this.host + "-" + trimmedFileName;
        }
        this.formatId = SystemCustomPatternHandler.getInstance().getFormatIdForName(this.logTypeName);
        this.markOrResetPosition(this.bReader, false, isMarkSupported);
        this.startLogImport(this.bReader, formatIdentified);
    }

    @Override
    protected void updateFormatAndAddUserDefinedFields(Hashtable output) {
    }

    @Override
    protected boolean store(Hashtable output, String log) {
        if (this.formatId > -1L) {
            output.put("FORMATID", this.formatId);
            SystemCustomPatternHandler.getInstance().parse(output);
        }
        output.remove("FORMATID");
        output.remove("LOGTYPE");
        output.remove("RAWLOG");
        output.put("MESSAGE", log);
        List matchingDefIds = CustomLogTypePatterns.applyAllCommonPatterns((String)log, (Map)output);
        this.matchingDefPatternIds.addAll(matchingDefIds);
        this.parsedFields.addAll(output.keySet());
        JSONObject messageDetails = new JSONObject((Map)output);
        this.resultJsonArray.put((Object)messageDetails);
        LOGGER.log(Level.FINER, "Inside Store.... output = {0} &&& getRecordsProcessedCount() = {1}", new Object[]{output, this.getRecordsProcessedCount()});
        return this.getRecordsProcessedCount() < this.maxLogCount;
    }

    @Override
    protected boolean parseCompleteLog(NamedPattern np, String key) {
        if (this.getRecordsProcessedCount() >= this.maxLogCount) {
            return false;
        }
        boolean toReturn = true;
        ImportHandler.Record toParse = this.getRecordToParse();
        String lineToParse = toParse.getData();
        NamedMatcher nm = np.matcher((CharSequence)lineToParse);
        if (nm.matches()) {
            Map attributes = nm.namedGroups();
            if (attributes != null) {
                this.incrementRecordsProcessedCount();
                LinkedHashMap map = new LinkedHashMap();
                Hashtable<String, Object> output = new Hashtable<String, Object>();
                output.put("MESSAGE", lineToParse);
                if (this.formatId > -1L) {
                    output.put("FORMATID", this.formatId);
                    SystemCustomPatternHandler.getInstance().parse(output);
                }
                output.putAll(attributes);
                new TimeUtil().handleDateTime(output);
                map.putAll(output);
                List matchingDefIds = CustomLogTypePatterns.applyAllCommonPatterns((String)lineToParse, map);
                this.matchingDefPatternIds.addAll(matchingDefIds);
                LOGGER.log(Level.FINER, "Message = {0} &&& parsed data = {1}", new Object[]{lineToParse, map});
                this.parsedFields.addAll(map.keySet());
                JSONObject messageDetails = new JSONObject(map);
                this.resultJsonArray.put((Object)messageDetails);
            }
        } else {
            LOGGER.log(Level.FINE, "ImportFile.parseCompleteLog() Custom Format, Match Status is false for line  {0}", lineToParse);
            toReturn = false;
        }
        return toReturn;
    }
}

