/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.univlogparser;

import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.la.univlogparser.DateTimePatternScanner;
import com.adventnet.la.univlogparser.UniversalLogParserConstants;
import com.google.code.regexp.NamedMatcher;
import com.google.code.regexp.NamedPattern;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class FormatIdentifier {
    private DateTimePatternScanner dScanner;
    private HashMap<String, NamedPattern> customFormatMapping = new HashMap();
    private static FormatIdentifier identifier = null;
    private static final Logger LOGGER = Logger.getLogger(FormatIdentifier.class.getName());

    private FormatIdentifier() {
        this.init();
    }

    private void init() {
        try {
            LOGGER.log(Level.FINE, " FormatIdentifier.init() Called .. about to initialize the DateTimePattern xml ");
            this.dScanner = new DateTimePatternScanner();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static synchronized FormatIdentifier getInstance() {
        if (identifier == null) {
            identifier = new FormatIdentifier();
        }
        return identifier;
    }

    public int identifyFormat(String line) {
        return this.identifyFormat(line, new ArrayList());
    }

    private int identifyFormat(String line, ArrayList logHeaders) {
        LOGGER.log(Level.FINE, " FormatIdentifier.identifyFormat() line to parse is ::: " + line);
        int toReturn = -1;
        LOGGER.log(Level.FINE, " about to match KV Pair !! ");
        Matcher m = UniversalLogParserConstants.KEY_VALUE_PAIR_MATCH.matcher(line);
        if (m.matches()) {
            toReturn = 1;
            LOGGER.log(Level.FINE, " KV Pair Match successfull ");
        } else {
            LOGGER.log(Level.FINE, "FormatIdentifier.identifyFormat() Comma Separated, called with line :::::::: " + line);
            m = UniversalLogParserConstants.COMMA_SEPARATED_HEADER_MATCHER.matcher(line);
            LOGGER.log(Level.FINE, "FormatIdentifier.identifyFormat() ... trying to match with comma separated format and status is " + m.matches());
            int n = toReturn = m.matches() ? 2 : -1;
            if (m.matches()) {
                String[] tempHeaders = line.split(",");
                if (tempHeaders.length <= 1) {
                    return -1;
                }
                logHeaders.add(line);
                LOGGER.log(Level.FINE, "FormatIdentifier.identifyFormat() .... line is ::::::::  " + line);
            }
        }
        return toReturn;
    }

    public int identifyFormat(BufferedReader iReader) {
        return this.identifyFormat(iReader, new ArrayList());
    }

    private int identifyFormat(BufferedReader iReader, ArrayList logHeaders) {
        int toReturn = -1;
        String line = null;
        int linesRead = 0;
        try {
            this.markOrResetPosition(iReader, true);
            while ((line = iReader.readLine()) != null) {
                String string = line = line != null ? line.trim() : null;
                if (line == null) continue;
                ++linesRead;
                toReturn = this.identifyFormat(line, logHeaders);
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.markOrResetPosition(iReader, false);
        return toReturn;
    }

    public Long identifyFormat(String importedFrom, String fileName, String fileStoredAt, String userDefinedFormatName) {
        return this.findFormatInUnSupportedLog(importedFrom, fileName, fileStoredAt, userDefinedFormatName);
    }

    public Long findFormatInUnSupportedLog(String importedFrom, String fileName, String fileStoredAt) {
        return this.findFormatInUnSupportedLog(importedFrom, fileName, fileStoredAt, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long findFormatInUnSupportedLog(String importedFrom, String fileName, String fileStoredAt, String userDefinedFormatName) {
        FileReader fReader = null;
        BufferedReader bReader = null;
        long formatID = -1L;
        boolean linesSkipped = false;
        String key = userDefinedFormatName;
        if (userDefinedFormatName == null && (key = importedFrom + "-" + fileName).length() > 50) {
            String s = new File(fileName).getName();
            int hostLen = importedFrom.length() + 1;
            if (s.length() + hostLen > 50) {
                key = importedFrom + "-" + fileName.substring(fileName.length() - (50 - hostLen));
            }
        }
        Object formatName = null;
        ArrayList logHeaders = new ArrayList();
        try {
            if (fileName.endsWith("gzip")) {
                bReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(fileStoredAt))));
            } else if (fileName.endsWith("zip")) {
                bReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(fileStoredAt))));
            } else {
                fReader = new FileReader(fileStoredAt);
                bReader = new BufferedReader(fReader);
            }
            this.markOrResetPosition(bReader, true);
            int type = this.identifyFormat(bReader, logHeaders);
            this.markOrResetPosition(bReader, false);
            String line = bReader.readLine();
            LOGGER.log(Level.FINE, "FormatIdentifier.findFormatInUnSupportedLog() .... format identified is :::::::::: " + type);
            if (type > 0) {
                if (type == 1) {
                    LOGGER.log(Level.FINE, " Format Identified as KV PAIR");
                    Long l = this.getFormatIDForKeyValuePairLog(line, importedFrom, userDefinedFormatName);
                    this.close(fReader, bReader);
                    return l;
                }
                if (type == 2) {
                    LOGGER.log(Level.FINE, " Format Identified as Comma Separated ");
                    String[] headers = null;
                    LOGGER.log(Level.FINE, " Headers obtained is :::: " + logHeaders);
                    if (logHeaders.size() == 1) {
                        headers = ((String)logHeaders.get(0)).split(",");
                    }
                    Long l = this.getFormatIDForCommaSeparatedLog(line, bReader, importedFrom, headers, userDefinedFormatName);
                    this.close(fReader, bReader);
                    return l;
                }
            } else {
                LOGGER.log(Level.FINE, " Seems the log doesn't match any of the standard log types. So trying to generate the log parser rule automatically ... ");
                Long l = this.getFormatIDForOtherLogs(bReader, line, key);
                this.close(fReader, bReader);
                return l;
            }
            this.close(fReader, bReader);
            return -1L;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return -1L;
        }
        finally {
            this.close(fReader, bReader);
        }
    }

    private long getFormatIDForOtherLogs(BufferedReader bReader, String line, String key) {
        int linesSkipped = 0;
        long formatID = -1L;
        try {
            do {
                NamedMatcher nm;
                String string = line = line != null ? line.trim() : null;
                if ("".equals(line) || line == null) continue;
                NamedPattern np = null;
                LOGGER.log(Level.FINE, " trying to obtain the corresponding custom pattern for key ::::: " + key);
                if (np != null) continue;
                np = this.findPatternForUnSupportedLog(line);
                LOGGER.log(Level.FINE, " Automatically generated pattern for log is ::::::::: " + np);
                if (np == null) {
                    if (++linesSkipped < 5) continue;
                    this.updateCustomLearning(key, UniversalLogParserConstants.PATTERN_IF_NO_DATE_OR_TIME_EXISTS);
                    np = UniversalLogParserConstants.PATTERN_IF_NO_DATE_OR_TIME_EXISTS;
                    LOGGER.log(Level.INFO, " Seem we have exceeded max line to skip before a match is made. So updating the format which doesn't contain date or time.");
                }
                if (!(nm = np.matcher((CharSequence)line)).matches()) {
                    LOGGER.log(Level.INFO, " ImportLogFormatIdentifier.findFormatInUnSupportedLog() Pattern failed ... ");
                    continue;
                }
                Hashtable<String, String> output = new Hashtable<String, String>();
                Map attributes = nm.namedGroups();
                output.putAll(attributes);
                formatID = SystemCustomPatternHandler.getInstance().getExistingFormatId(key);
                LOGGER.info(" FormatID obtained after checking in already existing formats is :::::  " + formatID);
                if (formatID < 0L) {
                    output.put("RAWLOG", line);
                    formatID = SystemCustomPatternHandler.getInstance().getFormatId(output, key, np.toString());
                }
                LOGGER.info(" Inside getFormatIDForOtherLogs() for other logs .... formatid is :::::::: " + formatID);
                break;
            } while ((line = bReader.readLine()) != null);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return formatID;
    }

    private long getFormatIDForKeyValuePairLog(String line, String hostName, String userDefinedFormatName) {
        long toReturn = -1L;
        String formatName = userDefinedFormatName == null ? hostName + "-KEY_VALUE_PAIR" : userDefinedFormatName;
        Hashtable output = this.parseKeyValuePairLog(line);
        if (output != null) {
            toReturn = SystemCustomPatternHandler.getInstance().getExistingFormatId(formatName);
            LOGGER.info("FormatIdentifier.getFormatIDForKeyValuePairLog() ... formatID for formatname <--> " + formatName + " is ::::::::" + toReturn);
            if (toReturn < 0L) {
                output.put("RAWLOG", line);
                toReturn = SystemCustomPatternHandler.getInstance().getFormatId(output, formatName, true);
            }
        }
        return toReturn;
    }

    private long getFormatIDForCommaSeparatedLog(String line, BufferedReader iReader, String importedFrom, String[] headers, String userDefinedFormatName) {
        String formatName = userDefinedFormatName == null ? importedFrom + "-Comma_Separated" : userDefinedFormatName;
        String lineToParse = null;
        try {
            lineToParse = iReader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.info("FormatIdentifier.getFormatIDForCommaSeparatedLog() .... logHeaders are .............. " + headers);
        Hashtable output = this.parseLogUsingDelimiter(",", lineToParse, headers);
        if (output == null) {
            return -1L;
        }
        long toReturn = SystemCustomPatternHandler.getInstance().getExistingFormatId(formatName);
        if (toReturn < 0L) {
            output.put("RAWLOG", lineToParse);
            toReturn = SystemCustomPatternHandler.getInstance().getFormatId(output, formatName, true);
        }
        return toReturn;
    }

    public Hashtable parseKeyValuePairLog(String line) {
        Matcher toParse = UniversalLogParserConstants.KEY_VALUE_PAIR_MATCH.matcher(line);
        if (!toParse.matches()) {
            LOGGER.info("FormatIdentifier.parseKeyValuePairLog() Key Value pair match failed. Hence unable to parse the log");
            return null;
        }
        LOGGER.info("FormatIdentifier.parseKeyValuePairLog() Match successfull and now trying to parse the log !! ");
        toParse = UniversalLogParserConstants.KEY_VALUE_PAIR_FORMAT.matcher(line);
        Hashtable<String, String> parsedContents = new Hashtable<String, String>();
        while (toParse.find()) {
            String key = toParse.group(1);
            String value = toParse.group(2);
            String string = value = value == null ? toParse.group(3) : value;
            if (key == null || value == null) continue;
            parsedContents.put(key.trim(), value.trim());
        }
        LOGGER.info("FormatIdentifier.parseKeyValuePairLog() :::: Parsed Contents is ::::::::::: " + parsedContents);
        return parsedContents.size() > 0 ? parsedContents : null;
    }

    public Hashtable parseLogUsingDelimiter(String delimiter, String lineToParse, String[] headers) {
        int headersSize;
        int n = headersSize = headers != null ? headers.length : -1;
        if (headersSize <= 0) {
            LOGGER.info("FormatIdentifier.parseLogUsingDelimiter() Comma Separated pair match failed. Hence unable to parse the log");
            return null;
        }
        String[] values = lineToParse.split(delimiter);
        int valuesSize = values != null ? values.length : -1;
        Hashtable<String, String> output = new Hashtable<String, String>();
        int i = 0;
        int j = 0;
        while (i < headers.length) {
            String value;
            String headerKey = headers[i];
            String string = value = j < valuesSize ? values[j] : null;
            if (value != null) {
                if (!value.startsWith("\"") && !value.endsWith("\"")) {
                    output.put(headerKey.trim(), value.trim());
                } else {
                    LOGGER.info("seems the value starts with double quote, seems shd append !! ");
                    StringBuilder sb = new StringBuilder(value);
                    while (++j < valuesSize) {
                        String temp = values[j];
                        sb.append(",");
                        sb.append(temp);
                        if (!temp.endsWith("\"")) continue;
                        break;
                    }
                    output.put(headerKey.trim(), sb.toString());
                }
            }
            ++i;
            ++j;
        }
        return output.size() > 0 ? output : null;
    }

    protected NamedPattern getCustomPatternFor(String key) {
        return this.customFormatMapping.get(key);
    }

    protected void updateCustomLearning(String key, NamedPattern np) {
        LOGGER.info("RegExPopulator.updateCustomLearning() Updating mapping for Key ::: " + key + " with Pattern " + np);
        this.customFormatMapping.put(key, np);
        LOGGER.info("RegExPopulator.updateCustomLearning() " + this.customFormatMapping);
    }

    protected void removeCustomLearning(String key) {
        LOGGER.info("RegExPopulator.updateCustomLearning() Updating mapping for Key ::: " + key);
        this.customFormatMapping.remove(key);
        LOGGER.info("RegExPopulator.removeCustomLearning() " + this.customFormatMapping);
    }

    public NamedPattern findPatternForUnSupportedLog(String sampleLog) {
        NamedPattern finalPatternForThisLog = null;
        NamedPattern finalDateFormat = null;
        NamedPattern finalTimeFormat = null;
        NamedMatcher matching = null;
        int timeStart = -1;
        int timeEnd = -1;
        int dateStart = -1;
        int dateEnd = -1;
        List formats = (List)this.dScanner.getAvailablePatternList().get("dateFormats");
        finalDateFormat = this.findMatchingFormat(sampleLog, formats);
        LOGGER.info("RegExPopulator.identifyFormat() FinalDateFormat is ::::::: " + finalDateFormat);
        if (finalDateFormat != null && (matching = finalDateFormat.matcher((CharSequence)sampleLog)).find()) {
            dateStart = matching.start();
            dateEnd = matching.end();
            matching = null;
        }
        formats = null;
        formats = (List)this.dScanner.getAvailablePatternList().get("timeFormats");
        LOGGER.info("FormatIdentifier:::: going to check if the following time formats match .......... " + formats);
        finalTimeFormat = this.findMatchingFormat(sampleLog, formats);
        LOGGER.info("RegExPopulator.identifyFormat() FinalTimeFormat is ::::::: " + finalTimeFormat);
        if (finalTimeFormat != null && (matching = finalTimeFormat.matcher((CharSequence)sampleLog)).find()) {
            timeStart = matching.start();
            timeEnd = matching.end();
        }
        if (finalDateFormat == null && finalTimeFormat == null) {
            LOGGER.info(" Both Time and Date format is null, so returing null .... ");
            return null;
        }
        LOGGER.info("RegExPopulator.identifyFormat() date start is --> " + dateStart + " and time start is -->" + timeStart);
        StringBuilder sb = new StringBuilder();
        sb.append("(?s)");
        if (dateStart < 0 && timeStart < 0) {
            return null;
        }
        if (dateStart != 0 || timeStart != 0) {
            sb.append("^.*?");
        }
        if (dateStart == timeStart) {
            LOGGER.log(Level.WARNING, "Seems both dateStart and timeStart is same. So using the pattern UniversalLogParserConstants.PATTERN_IF_NO_DATE_OR_TIME_EXISTS");
            return UniversalLogParserConstants.PATTERN_IF_NO_DATE_OR_TIME_EXISTS;
        }
        boolean isDateFirst = dateStart == 0 ? true : dateStart < timeStart;
        LOGGER.info("RegExPopulator.identifyFormat() date start : " + dateStart + " , time start : " + timeStart + " , date end : " + dateEnd + " , time end : " + timeEnd);
        if (isDateFirst) {
            boolean shdAppendWildCardMatch;
            boolean bl = shdAppendWildCardMatch = Math.abs(dateEnd - timeStart) > 1;
            if (finalDateFormat != null) {
                sb.append(finalDateFormat.namedPattern());
            }
            if (finalTimeFormat != null) {
                sb.append(shdAppendWildCardMatch ? "\\W*.*?" : "\\W*");
                sb.append(finalTimeFormat.namedPattern());
            }
        } else {
            boolean shdAppendWildCardMatch;
            boolean bl = shdAppendWildCardMatch = Math.abs(timeEnd - dateStart) > 1;
            if (finalTimeFormat != null) {
                sb.append(finalTimeFormat.namedPattern());
            }
            if (finalDateFormat != null) {
                sb.append(shdAppendWildCardMatch ? "\\W*.*?" : "\\W*");
                sb.append(finalDateFormat.namedPattern());
            }
        }
        sb.append(".*");
        LOGGER.info(" Finally Pattern Found to parse the log :::: " + sampleLog + " \n is ::::: " + sb.toString());
        finalPatternForThisLog = NamedPattern.compile((String)sb.toString());
        return finalPatternForThisLog;
    }

    private NamedPattern findMatchingFormat(String sampleLog, List formats) {
        boolean matchFound = false;
        int size = formats.size();
        LOGGER.info(" SIZE IS ::::::::::: " + size);
        NamedMatcher nm = null;
        NamedPattern matchingPattern = null;
        for (int i = 0; i < size; ++i) {
            NamedPattern np = (NamedPattern)formats.get(i);
            nm = np.matcher((CharSequence)sampleLog);
            if (nm.find()) {
                matchFound = true;
                LOGGER.info(" Match Found Pattern is ::::: " + np.namedPattern());
                matchingPattern = np;
                break;
            }
            LOGGER.info(" Match Failed for Pattern ::::: " + np.namedPattern());
        }
        return matchFound ? matchingPattern : null;
    }

    private void close(FileReader fReader, BufferedReader bReader) {
        try {
            if (fReader != null) {
                fReader.close();
            }
            if (bReader != null) {
                bReader.close();
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private void markOrResetPosition(BufferedReader bReader, boolean isMark) {
        try {
            if (bReader.markSupported()) {
                if (isMark) {
                    bReader.mark(1);
                } else {
                    bReader.reset();
                }
            }
        }
        catch (Exception ioExp) {
            ioExp.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String sampleLog = "STATUS | wrapper  | 2011/09/27 15:50:58 | ManageEngine Firewall Analyzer 7.0 installed.";
        FormatIdentifier fi = new FormatIdentifier();
        fi.findPatternForUnSupportedLog(sampleLog);
    }
}

