/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.univlogparser;

import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.la.univlogparser.DefaultUnifier;
import com.adventnet.la.univlogparser.TimeUtil;
import com.adventnet.la.univlogparser.UniversalLogParserConstants;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.adventnet.sa.server.imp.AbstractEncryptionHandler;
import com.adventnet.sa.server.imp.Encryption256Bit;
import com.adventnet.sa.server.imp.EncryptionAPI;
import com.adventnet.sa.server.lc.UploadUtils;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.parser.DbUtil;
import com.adventnet.sa.server.parser.RecordWriter;
import com.adventnet.sa.server.parser.SeverityRecord;
import com.adventnet.sa.server.univlogparser.FormatIdentifier;
import com.google.code.regexp.NamedMatcher;
import com.google.code.regexp.NamedPattern;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ImportHandler {
    private String importedFromHost = null;
    private String fileName;
    private BufferedReader bReader;
    private long formatID;
    private LinkedList<Record> storage;
    private boolean isMarkSupported;
    private String[] logHeaders;
    private int linesAppended;
    private String logType;
    private ArchiveFileManager afManager;
    private String[] severityFieldNames = new String[]{"SEVERITY", "PRIORITY", "PRI"};
    private ArrayList sevDetails = new ArrayList();
    private RecordWriter sevRecordwriter = null;
    private TimeUtil tUtil = new TimeUtil();
    private long appID;
    private long iLID;
    private String tableName = "app_hr_trend_sa";
    private String recordMarker = null;
    private int noOfRecordsProcessed = 0;
    private long minTime;
    private long maxTime;
    private String appKey;
    private String formatName;
    private NotificationManager nfManager = null;
    private LogForwarderFilter logforwarder = null;
    private ZipFile zipFile = null;
    private Enumeration enu = null;
    private NamedPattern regexForCsv = null;
    private boolean regexFound = false;
    private static final Logger LOGGER = Logger.getLogger(ImportHandler.class.getName());
    private boolean isEncryptedFile = false;
    private AbstractEncryptionHandler encryptionBaseObj = null;

    public ImportHandler(String importedFromHost, String fileName, BufferedReader reader, long formatID, Enumeration en, ZipFile zipFile, boolean isEncryptedFile) {
        this(importedFromHost, fileName, reader, formatID);
        this.zipFile = zipFile;
        this.enu = en;
        this.isEncryptedFile = isEncryptedFile;
    }

    public ImportHandler(String importedFromHost, String fileName, BufferedReader reader, long formatID) {
        this.importedFromHost = importedFromHost;
        this.fileName = fileName;
        this.bReader = reader;
        this.formatID = formatID;
        this.storage = new LinkedList();
        if (reader != null) {
            this.sevRecordwriter = new RecordWriter(this.tableName);
        }
        this.nfManager = NotificationManager.getInstance();
        this.logforwarder = LogForwarderFilter.getInstance();
    }

    public void startLogImport() {
        this.appKey = DbUtil.get_instance().getFormatName(this.formatID);
        this.isMarkSupported = this.bReader.markSupported();
        this.markOrResetPosition(this.bReader, true);
        int formatIdentified = -1;
        LOGGER.log(Level.FINE, "ImportHandler.startImportLog() Value of formatID value is ::::::::: " + this.formatID);
        String pattern = SystemCustomPatternHandler.getInstance().getDateTimePattern(this.formatID);
        LOGGER.log(Level.FINE, "ImportHandler.startImportLog() Value of pattern corresponding to formatID is :::::: " + pattern);
        if (this.formatID > 0L && pattern == null) {
            formatIdentified = FormatIdentifier.getInstance().identifyFormat(this.bReader);
            LOGGER.log(Level.FINE, "ImportHandler.startImportLog() Value of format identified is :::::: " + formatIdentified);
        }
        this.markOrResetPosition(this.bReader, false);
        this.startLogImport(this.bReader, formatIdentified);
    }

    protected void startLogImport(BufferedReader bReader, int formatIdentified) {
        this.markOrResetPosition(bReader, true);
        switch (formatIdentified) {
            case 1: {
                this.logType = this.importedFromHost + "-Key_Value_Pair";
                if (this.parseKeyValueFormat(bReader)) break;
                this.formatID = -1L;
                formatIdentified = -1;
                this.startLogImport();
                break;
            }
            case 2: {
                this.logType = this.importedFromHost + "-Comma_Separated";
                if (this.parseLogUsingCommaSeparatedFormat(bReader)) break;
                this.formatID = -1L;
                formatIdentified = -1;
                this.startLogImport();
                break;
            }
            default: {
                this.markOrResetPosition(bReader, false);
                this.logType = this.importedFromHost + "-" + this.fileName;
                if (this.logType.length() > 50) {
                    String s = new File(this.fileName).getName();
                    int hostLen = this.importedFromHost.length() + 1;
                    if (s.length() + hostLen > 50) {
                        this.logType = this.importedFromHost + "-" + this.fileName.substring(this.fileName.length() - (50 - hostLen));
                    }
                }
                this.parseUnSupportedLog(bReader);
            }
        }
    }

    private boolean parseLogUsingCommaSeparatedFormat(BufferedReader bReader) {
        return this.parseLogStandardFormat(bReader, "(?s),", UniversalLogParserConstants.COMMA_SEPARATED_FIELDS_FIRST_LINE_FIND, false);
    }

    private boolean parseLogStandardFormat(BufferedReader bReader, String delimiter, Pattern pattern, boolean useMatch) {
        boolean toReturn = true;
        int headerSize = this.logHeaders != null ? this.logHeaders.length : 0;
        DefaultUnifier unifier = new DefaultUnifier();
        String line = null;
        try {
            while (bReader != null) {
                boolean condition;
                line = this.getRecord(bReader);
                if (line == null) {
                    this.closeReaderObj(bReader);
                    if (this.zipFile == null) break;
                    bReader = this.getReaderObj();
                    continue;
                }
                String string = line = line != null ? line.trim() : null;
                if (line == null) continue;
                LOGGER.log(Level.FINER, "ImportFile.parseLogUsingCommaSeparatedFormat() Line to parse is :::::::::::::: " + line);
                Matcher m = pattern.matcher(line);
                boolean bl = condition = useMatch ? m.matches() : m.find();
                if (condition) {
                    Record toParse;
                    boolean proceed;
                    if (this.logHeaders == null) {
                        String[] tempHeaders = line.split(delimiter);
                        if (tempHeaders.length <= 1) continue;
                        this.logHeaders = tempHeaders;
                        continue;
                    }
                    if (!this.regexFound) {
                        NamedPattern np;
                        this.regexForCsv = np = FormatIdentifier.getInstance().findPatternForUnSupportedLog(line);
                        this.regexFound = true;
                    }
                    this.linesAppended = 1;
                    Record record = new Record(this.importedFromHost, line);
                    if (this.storage.size() > 0 && !(proceed = this.parseCompleteLog(toParse = this.storage.poll(), delimiter, unifier))) break;
                    this.storage.add(record);
                    continue;
                }
                boolean maxLinesReached = this.appendToExistingAndCheckForMaxLines(line);
                if (!maxLinesReached) continue;
                this.parseCompleteLog(this.storage.poll(), delimiter, unifier);
                toReturn = false;
                break;
            }
            if (this.storage.size() == 1) {
                Record record = this.storage.poll();
                this.parseCompleteLog(record, delimiter, unifier);
                if (toReturn) {
                    this.setRecordMarker(record.getData());
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return toReturn;
    }

    private boolean parseCompleteLog(Record toParse, String delimiter, DefaultUnifier unifier) {
        ++this.noOfRecordsProcessed;
        String lineToParse = toParse.getData();
        LOGGER.finer("ImportHandler.parseCompleteLog() Log to parse is ::::::: " + lineToParse + " Delimiter to use is " + delimiter);
        String[] values = lineToParse != null ? lineToParse.split(delimiter) : null;
        int length = values != null ? values.length : -1;
        Hashtable output = this.populateValueBasedOnHeaderInfo(values);
        NamedPattern np = this.regexForCsv;
        NamedMatcher nm = np.matcher((CharSequence)lineToParse);
        if (nm.matches()) {
            Map attributes = nm.namedGroups();
            output.putAll(attributes);
        }
        if (output != null) {
            output.put("FORMATID", this.formatID);
            output = unifier.recordParsed(this.importedFromHost, output);
            output.put("RAWLOG", lineToParse);
            this.updateFormatAndAddUserDefinedFields(output);
            return this.store(output, lineToParse);
        }
        return true;
    }

    private Hashtable populateValueBasedOnHeaderInfo(String[] values) {
        int headerSize = this.logHeaders.length;
        int valuesSize = values.length;
        Hashtable<String, String> output = new Hashtable<String, String>();
        int i = 0;
        int j = 0;
        while (i < headerSize) {
            String value;
            String key = this.logHeaders[i];
            String string = value = j < valuesSize ? values[j] : null;
            if (value != null) {
                key = this.getTrimmedKey(key);
                if (!value.startsWith("\"") && !value.endsWith("\"")) {
                    output.put(key.trim(), value.trim());
                } else {
                    LOGGER.log(Level.FINE, "ImportLog.populateValueBasedOnHeaderInfo() seems the value starts with double quote, seems shd append !! ");
                    StringBuilder sb = new StringBuilder(value);
                    while (++j < valuesSize) {
                        String temp = values[j];
                        sb.append(",");
                        sb.append(temp);
                        if (!temp.endsWith("\"")) continue;
                        break;
                    }
                    output.put(key.trim(), sb.toString());
                }
            }
            ++i;
            ++j;
        }
        return output.size() > 0 ? output : null;
    }

    private String getTrimmedKey(String key) {
        return key.trim().replaceAll("[\\s+-/\\\\]", "_").replaceAll(":", "");
    }

    private boolean parseKeyValueFormat(BufferedReader bReader) {
        boolean toReturn = true;
        String line = null;
        DefaultUnifier unifier = new DefaultUnifier();
        try {
            int noOfTimesParsingFailed = 0;
            while (bReader != null) {
                line = this.getRecord(bReader);
                if (line == null) {
                    this.closeReaderObj(bReader);
                    if (this.zipFile != null) {
                        bReader = this.getReaderObj();
                        continue;
                    }
                } else {
                    if ("".equals(line.trim())) continue;
                    Matcher m = UniversalLogParserConstants.KEY_VALUE_PAIR_FORMAT.matcher(line);
                    Hashtable output = new Hashtable();
                    while (m.find()) {
                        String key = m.group(1);
                        String value = m.group(2);
                        String string = value = value == null ? m.group(3) : value;
                        if (key == null || value == null) continue;
                        key = this.getTrimmedKey(key);
                        output.put(key.trim(), value.trim());
                    }
                    int size = output.size();
                    int n = noOfTimesParsingFailed = size > 1 ? 0 : ++noOfTimesParsingFailed;
                    if (noOfTimesParsingFailed >= 5) {
                        toReturn = false;
                    } else {
                        if ((output = unifier.recordParsed(this.importedFromHost, output)) == null) continue;
                        output.put("FORMATID", this.formatID);
                        output.put("RAWLOG", line);
                        this.updateFormatAndAddUserDefinedFields(output);
                        ++this.noOfRecordsProcessed;
                        boolean proceedMore = this.store(output, line);
                        if (proceedMore) {
                            this.recordMarker = line;
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return toReturn;
    }

    private boolean parseUnSupportedLog(BufferedReader bReader) {
        boolean toReturn = true;
        String line = null;
        String key = this.importedFromHost + "-" + this.fileName;
        boolean alreadyMarked = false;
        int linesSkipped = 0;
        try {
            while (bReader != null) {
                NamedMatcher nm;
                line = this.getRecord(bReader);
                if (line == null) {
                    this.closeReaderObj(bReader);
                    if (this.zipFile == null) break;
                    bReader = this.getReaderObj();
                    continue;
                }
                if ("".equals(line = line != null ? line.trim() : null) || line == null) continue;
                NamedPattern np = FormatIdentifier.getInstance().getCustomPatternFor(key);
                if (np == null) {
                    np = FormatIdentifier.getInstance().findPatternForUnSupportedLog(line);
                    if (np == null) {
                        ++linesSkipped;
                        if (!alreadyMarked) {
                            this.markOrResetPosition(bReader, true);
                            alreadyMarked = true;
                        }
                        if (linesSkipped == 5) {
                            FormatIdentifier.getInstance().updateCustomLearning(key, UniversalLogParserConstants.PATTERN_IF_NO_DATE_OR_TIME_EXISTS);
                            this.markOrResetPosition(bReader, false);
                            alreadyMarked = false;
                            continue;
                        }
                        LOGGER.log(Level.FINE, "ImportFile.parseUsingCustomFormat() Since NP is null, I am continuing .... ");
                        continue;
                    }
                    FormatIdentifier.getInstance().updateCustomLearning(key, np);
                    if (alreadyMarked) {
                        this.markOrResetPosition(bReader, false);
                        alreadyMarked = false;
                    }
                }
                if ((nm = np.matcher((CharSequence)line)).matches()) {
                    boolean status;
                    LOGGER.log(Level.FINE, "ImportFile.parseUsingCustomFormat() Match is true !! ");
                    Record r = new Record(this.importedFromHost, line);
                    if (this.storage.size() > 0 && !(status = this.parseCompleteLog(np, key))) {
                        toReturn = false;
                        break;
                    }
                    this.storage.add(r);
                    this.linesAppended = 0;
                    continue;
                }
                LOGGER.log(Level.FINE, "ImportFile.parseUsingCustomFormat() Match is false !! ");
                if (!this.appendToExistingAndCheckForMaxLines(line)) continue;
                this.parseCompleteLog(np, key);
                toReturn = false;
                break;
            }
            if (this.storage.size() == 1) {
                Record lastRecord = this.storage.peek();
                LOGGER.log(Level.FINE, "ImportFile.parseUsingPreTrainedFormat() Inside storage size is 1 !! ");
                NamedPattern np = FormatIdentifier.getInstance().getCustomPatternFor(key);
                this.parseCompleteLog(np, key);
                this.setRecordMarker(lastRecord.getData());
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return toReturn;
    }

    protected boolean parseCompleteLog(NamedPattern np, String key) {
        boolean toReturn = true;
        Record toParse = this.getRecordToParse();
        String lineToParse = toParse.getData();
        NamedMatcher nm = np.matcher((CharSequence)lineToParse);
        if (nm.matches()) {
            Hashtable<String, Object> output = new Hashtable<String, Object>();
            Map attributes = nm.namedGroups();
            if (attributes != null) {
                ++this.noOfRecordsProcessed;
                output.putAll(attributes);
                if (this.formatID < 0L) {
                    output.put("HOSTTYPE", this.logType);
                } else {
                    output.put("FORMATID", this.formatID);
                }
                this.tUtil.handleDateTime(output);
                output.put("RAWLOG", lineToParse);
                this.updateFormatAndAddUserDefinedFields(output);
                this.store(output, lineToParse);
            }
        } else {
            LOGGER.log(Level.FINE, "ImportFile.parseCompleteLog() Custom Format, Match Status is false for line  " + lineToParse);
            toReturn = false;
        }
        return toReturn;
    }

    protected Record getRecordToParse() {
        return this.storage.size() == 1 ? this.storage.poll() : null;
    }

    protected void updateFormatAndAddUserDefinedFields(Hashtable output) {
        output.remove("HOSTTYPE");
        output.put("FORMATID", this.formatID);
        SystemCustomPatternHandler.getInstance().parse(output);
        LOGGER.log(Level.FINER, "ImportHandler.updateFormatAndAddUserDefinedFields() before returning attributes are :::::: " + output);
    }

    protected boolean store(Hashtable output, String log) {
        LOGGER.log(Level.FINE, " Size of storage is " + this.storage.size());
        try {
            if (this.afManager != null) {
                if (this.formatName == null) {
                    this.formatName = DbUtil.get_instance().getFormatName((Long)output.get("FORMATID"));
                }
                this.afManager.archiveAppLog(this.formatName, this.importedFromHost, this.appKey == null ? this.formatName : this.appKey, log);
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, " Exception occurred while archiving the data. Exception is {0} ", exp);
        }
        try {
            this.updateSeverityDetails(output);
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "UnSupportedLogHandler.store() Exception while updating Severity information into DB !! ");
            exp.printStackTrace();
        }
        this.addToLuceneBuffer(output);
        if (this.nfManager != null) {
            this.nfManager.notify((Hashtable)output.clone());
        }
        return true;
    }

    public void setAppID(Long appID) {
        this.appID = appID;
    }

    public void setImportedAppLogsID(Long iLID) {
        this.iLID = iLID;
    }

    public void setArchiveManager(ArchiveFileManager afManager) {
        if (afManager != null) {
            this.afManager = afManager;
        }
    }

    private void updateSeverityDetails(Hashtable paramMap) {
        String severityVal = "INFORMATION";
        String severityKey = null;
        Set keys = paramMap.keySet();
        for (String fieldName : this.severityFieldNames) {
            if (!keys.contains(fieldName = fieldName.trim())) {
                if (keys.contains(fieldName.toLowerCase())) {
                    severityKey = fieldName.toLowerCase();
                    break;
                }
            } else {
                severityKey = fieldName;
                break;
            }
            LOGGER.log(Level.FINER, "NOTHING MATCHED ... so returning .....");
        }
        int severity = 3;
        if (severityKey != null) {
            Object sVal = paramMap.get(severityKey);
            if (sVal instanceof String) {
                if (severityVal.equalsIgnoreCase("CRITICAL")) {
                    severity = 0;
                } else if (severityVal.equalsIgnoreCase("ERROR")) {
                    severity = 1;
                } else if (severityVal.equalsIgnoreCase("WARNING")) {
                    severity = 2;
                }
            } else if (sVal instanceof Number) {
                severity = ((Number)sVal).intValue();
            } else {
                severityVal = "INFORMATION";
            }
        }
        SeverityRecord record = new SeverityRecord();
        record.setHost(this.importedFromHost);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = (String)paramMap.get("TIME");
            Date date = time != null ? sdf.parse(time) : new Date();
            long timeInMills = date.getTime();
            paramMap.put("HOURINMILLIS", "" + timeInMills);
            paramMap.put("HOUROFDAY", "" + date.getHours());
            paramMap.put("HOUR", "" + sdf.format(date));
        }
        catch (ParseException pExp) {
            pExp.printStackTrace();
        }
        record.setHourInMillis(new Long((String)paramMap.get("HOURINMILLIS")));
        record.setHourOfDay((String)paramMap.get("HOUROFDAY"));
        record.setHour((String)paramMap.get("HOUR"));
        int pos = Collections.binarySearch(this.sevDetails, record, new Comparator(){

            public int compare(Object o1, Object o2) {
                SeverityRecord r1 = (SeverityRecord)o1;
                SeverityRecord r2 = (SeverityRecord)o2;
                int retVal = r1.getHourInMillis().compareTo(r2.getHourInMillis());
                return retVal;
            }
        });
        if (pos >= 0) {
            ((SeverityRecord)this.sevDetails.get(pos)).incCount(severity);
        } else {
            record.incCount(severity);
            this.sevDetails.add(-pos - 1, record);
        }
        if (this.sevDetails.size() >= 10) {
            RecordWriter writer = this.sevRecordwriter;
            writer.addToFile(this.appID, this.sevDetails);
            this.sevDetails.clear();
        }
        paramMap.put("COMMON_SEVERITY", severityVal);
    }

    private void addToLuceneBuffer(Hashtable paramMap) {
        String common_Sev = (String)paramMap.get("COMMON_SEVERITY");
        if (common_Sev == null) {
            common_Sev = "information";
        }
        paramMap.put("COMMON_SEVERITY", common_Sev);
        if (this.appID > 0L) {
            paramMap.put("APPID", this.appID);
        }
        if (this.importedFromHost != null) {
            paramMap.put("HOSTNAME", this.importedFromHost);
        }
        LogIndexingAPI.getInstance().indexRecord((Object)paramMap);
        UploadUtils.uploadLogs(paramMap);
        try {
            this.logforwarder.filterAndForward(paramMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long time = Long.parseLong((String)paramMap.get("HOURINMILLIS"));
        if (this.minTime == 0L) {
            this.minTime = time;
        }
        if (time > this.maxTime) {
            this.maxTime = time;
        }
        if (time < this.minTime) {
            this.minTime = time;
        }
    }

    public void close() {
        LOGGER.log(Level.FINER, "ImportHandler.close() Called ..... ");
        LogIndexingAPI.getInstance().fflush();
        this.sevRecordwriter.addToFile(this.appID, this.sevDetails);
        this.sevDetails.clear();
        this.sevRecordwriter.shutDown();
        this.storage = null;
    }

    public String getRecordMarker() {
        return this.recordMarker;
    }

    public int getRecordsProcessedCount() {
        return this.noOfRecordsProcessed;
    }

    public void incrementRecordsProcessedCount() {
        ++this.noOfRecordsProcessed;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    private void validate(BufferedReader reader) throws IOException {
        if (reader == null) {
            throw new IOException("Reader passed is null");
        }
    }

    private boolean appendToExistingAndCheckForMaxLines(String line) {
        if (this.storage.size() == 0) {
            LOGGER.log(Level.INFO, "Storage is :::: " + this.storage);
            return false;
        }
        Record frmStorage = this.storage.peek();
        StringBuilder sb = new StringBuilder(frmStorage.getData());
        sb.append("\n");
        sb.append(line);
        frmStorage.setData(sb.toString());
        ++this.linesAppended;
        return this.linesAppended > 750;
    }

    private void setRecordMarker(String lastRecord) {
        if (lastRecord != null) {
            this.recordMarker = lastRecord;
        }
    }

    public void setHeaderInfo(String[] headers) {
        this.logHeaders = headers;
    }

    public String getHeaderInfo() {
        if (this.logHeaders == null) {
            return null;
        }
        StringBuilder sb = null;
        for (String temp : this.logHeaders) {
            sb = sb == null ? new StringBuilder() : sb.append(",");
            sb.append(temp);
        }
        return sb.toString();
    }

    private void markOrResetPosition(BufferedReader bReader, boolean isMark) {
        this.markOrResetPosition(bReader, isMark, this.isMarkSupported);
    }

    protected void markOrResetPosition(BufferedReader bReader, boolean isMark, boolean isMarkSupported) {
        try {
            if (isMarkSupported) {
                if (isMark) {
                    bReader.mark(1);
                } else {
                    bReader.reset();
                }
            }
        }
        catch (Exception ioExp) {
            ioExp.printStackTrace();
        }
    }

    private BufferedReader getReaderObj() {
        BufferedReader readerObj = null;
        try {
            while (this.enu.hasMoreElements()) {
                Object entry;
                if (this.zipFile != null) {
                    entry = (ZipEntry)this.enu.nextElement();
                    if (((ZipEntry)entry).getName().equals("archivedesc.properties") || ((ZipEntry)entry).getName().endsWith(".sgn")) continue;
                    readerObj = new BufferedReader(new InputStreamReader(this.zipFile.getInputStream((ZipEntry)entry), "UTF8"));
                    LOGGER.log(Level.INFO, "Data is null, opening new file :: " + ((ZipEntry)entry).getName());
                    if (((ZipEntry)entry).getName().endsWith("_enc")) {
                        this.isEncryptedFile = true;
                        this.encryptionBaseObj = ((ZipEntry)entry).getName().endsWith("_256_enc") ? Encryption256Bit.getInstance(((ZipEntry)entry).getName()) : EncryptionAPI.getInstance(((ZipEntry)entry).getName());
                    } else {
                        this.isEncryptedFile = false;
                    }
                } else {
                    entry = (File)this.enu.nextElement();
                    readerObj = new BufferedReader(new FileReader((File)entry));
                }
                if (!readerObj.ready()) {
                    this.isEncryptedFile = false;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return readerObj;
    }

    private void closeReaderObj(BufferedReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isEncryptedFile = false;
    }

    private String getRecord(BufferedReader br) {
        String record = null;
        if (br == null) {
            return record;
        }
        if (this.isEncryptedFile) {
            record = this.encryptionBaseObj.readEncryptedLine(br);
            if (record != null) {
                record = this.encryptionBaseObj.decryptLog(record, false);
            }
        } else {
            try {
                record = br.readLine();
            }
            catch (IOException ex) {
                Logger.getLogger(ImportHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return record;
    }

    class Record {
        private String host;
        private String data;

        Record(String host, String data) {
            this.host = host;
            this.data = data;
        }

        String getData() {
            return this.data;
        }

        void setData(String data) {
            this.data = data;
        }

        String getHost() {
            return this.host;
        }
    }
}

