/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.univlogparser;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LineBasedMultipartStream {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte DASH = 45;
    public static final int HEADER_PART_SIZE_MAX = 10240;
    protected static final int DEFAULT_BUFSIZE = 4096;
    protected static final byte[] HEADER_SEPARATOR = new byte[]{13, 10, 13, 10};
    protected static final byte[] FIELD_SEPARATOR = new byte[]{13, 10};
    protected static final byte[] STREAM_TERMINATOR = new byte[]{45, 45};
    protected static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
    private static final int KEEP_REGION_PAD = 3;
    private InputStream input;
    private int boundaryLength;
    private int keepRegion;
    private byte[] boundary;
    private int bufSize;
    private byte[] buffer;
    private int head;
    private int tail;
    private String headerEncoding;
    private int startLineNumber = 0;
    private int reqLines = 50;
    private boolean terminateProcess = false;
    private byte[] newLine = System.getProperty("line.separator").getBytes();
    private int visitCount = 0;
    private static final Logger LOGGER = Logger.getLogger(LineBasedMultipartStream.class.getName());

    public LineBasedMultipartStream() {
    }

    public LineBasedMultipartStream(InputStream input, byte[] boundary, int bufSize, int startLineNumber, int reqLines) {
        this.input = input;
        this.bufSize = bufSize;
        this.buffer = new byte[bufSize];
        this.startLineNumber = startLineNumber;
        this.reqLines = reqLines;
        this.boundary = new byte[boundary.length + BOUNDARY_PREFIX.length];
        this.boundaryLength = boundary.length + BOUNDARY_PREFIX.length;
        this.keepRegion = boundary.length + 3;
        System.arraycopy(BOUNDARY_PREFIX, 0, this.boundary, 0, BOUNDARY_PREFIX.length);
        System.arraycopy(boundary, 0, this.boundary, BOUNDARY_PREFIX.length, boundary.length);
        this.head = 0;
        this.tail = 0;
    }

    public LineBasedMultipartStream(InputStream input, byte[] boundary, int startLineNumber, int reqLines) throws IOException {
        this(input, boundary, 4096, startLineNumber, reqLines);
    }

    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public void setHeaderEncoding(String encoding) {
        this.headerEncoding = encoding;
    }

    public byte readByte() throws IOException {
        LOGGER.log(Level.FINER, "Inside readByte()... head = {0} && tail ={1}", new Object[]{this.head, this.tail});
        if (this.head == this.tail) {
            LOGGER.log(Level.FINER, "Inside readByte()...head == tail..,input = {0}", this.input);
            this.head = 0;
            this.tail = this.input.read(this.buffer, this.head, this.bufSize);
            LOGGER.log(Level.FINER, "Inside readByte()... inside... buffer= {0}", (Object)this.buffer);
            if (this.tail == -1) {
                throw new IOException("No more data is available");
            }
        }
        return this.buffer[this.head++];
    }

    public boolean readBoundary() throws MalformedStreamException {
        boolean nextChunk;
        block6: {
            if (this.terminateProcess) {
                return false;
            }
            byte[] marker = new byte[2];
            nextChunk = false;
            this.head += this.boundaryLength;
            try {
                marker[0] = this.readByte();
                if (marker[0] == 10) {
                    return true;
                }
                marker[1] = this.readByte();
                if (LineBasedMultipartStream.arrayequals(marker, STREAM_TERMINATOR, 2)) {
                    nextChunk = false;
                    break block6;
                }
                if (LineBasedMultipartStream.arrayequals(marker, FIELD_SEPARATOR, 2)) {
                    nextChunk = true;
                    break block6;
                }
                throw new MalformedStreamException("Unexpected characters follow a boundary");
            }
            catch (IOException e) {
                throw new MalformedStreamException("Stream ended unexpectedly");
            }
        }
        return nextChunk;
    }

    public void setBoundary(byte[] boundary) throws IllegalBoundaryException {
        if (boundary.length != this.boundaryLength - BOUNDARY_PREFIX.length) {
            throw new IllegalBoundaryException("The length of a boundary token can not be changed");
        }
        System.arraycopy(boundary, 0, this.boundary, BOUNDARY_PREFIX.length, boundary.length);
    }

    public String readHeaders() throws MalformedStreamException {
        int i = 0;
        byte[] b = new byte[1];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int sizeMax = 10240;
        int size = 0;
        while (i < HEADER_SEPARATOR.length) {
            try {
                b[0] = this.readByte();
            }
            catch (IOException e) {
                throw new MalformedStreamException("Stream ended unexpectedly");
            }
            i = b[0] == HEADER_SEPARATOR[i] ? ++i : 0;
            if (++size > sizeMax) continue;
            baos.write(b[0]);
        }
        String headers = null;
        if (this.headerEncoding != null) {
            try {
                headers = baos.toString(this.headerEncoding);
            }
            catch (UnsupportedEncodingException e) {
                headers = baos.toString();
            }
        } else {
            headers = baos.toString();
        }
        return headers;
    }

    public int readBodyData(OutputStream output) throws MalformedStreamException, IOException {
        boolean done = false;
        int pad = 0;
        int bytesRead = 0;
        int total = 0;
        boolean dataRead = false;
        boolean checkUTF16 = true;
        boolean isUTF16 = false;
        while (!done) {
            int pos = this.findSeparator();
            if (pos != -1) {
                LOGGER.log(Level.FINER, "Boundary position found");
                if (!dataRead) {
                    if (isUTF16) {
                        byte[] tmp = new byte[pos - this.head];
                        System.arraycopy(this.buffer, this.head, tmp, 0, tmp.length);
                        String dataVal = new String(tmp, "UTF-16");
                        output.write(dataVal.getBytes());
                    } else {
                        output.write(this.buffer, this.head, pos - this.head);
                    }
                }
                total += pos - this.head;
                this.head = pos;
                done = true;
                continue;
            }
            pad = this.tail - this.head > this.keepRegion ? (pad > 0 && pad < this.keepRegion ? pad : this.keepRegion) : this.tail - this.head;
            LOGGER.log(Level.FINER, "Buffer Len = {0} , head = {1} , tail = {2} , pad = {3}", new Object[]{this.buffer.length, this.head, this.tail, pad});
            if (!dataRead) {
                if (this.visitCount >= this.reqLines) {
                    output.write(this.buffer, this.head, this.tail - this.head - pad);
                } else {
                    int endLimit = this.tail - this.head - pad;
                    LOGGER.log(Level.FINER, "EndLimit -> {0}", endLimit);
                    BufferedReader lReader = null;
                    if (checkUTF16) {
                        try {
                            int startInt = this.head;
                            isUTF16 = this.buffer[startInt] == -1 && this.buffer[startInt + 1] == -2 || this.buffer[startInt] == -2 && this.buffer[startInt + 1] == -1;
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                        checkUTF16 = false;
                        LOGGER.log(Level.INFO, "ISUTF16 Format = {0}", isUTF16);
                    }
                    lReader = isUTF16 ? new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.buffer, this.head, endLimit), "UTF-16")) : new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.buffer, this.head, endLimit)));
                    String currline = lReader.readLine();
                    String nextLine = null;
                    while ((nextLine = lReader.readLine()) != null && this.visitCount < this.reqLines) {
                        byte[] thisLine = currline.getBytes();
                        output.write(thisLine);
                        output.write(this.newLine);
                        LOGGER.log(Level.FINER, "CurrentLine = {0}", currline);
                        currline = nextLine;
                        ++this.visitCount;
                        LOGGER.log(Level.FINER, "Inside loop visitCount = {0}", this.visitCount);
                    }
                    output.flush();
                    boolean bl = dataRead = this.visitCount >= this.reqLines;
                    if (!dataRead) {
                        if (currline != null) {
                            pad = isUTF16 ? new String(currline.getBytes("UTF-16")).length() + 1 : currline.length();
                            LOGGER.log(Level.FINER, "UNFlushed Line (nextReadLine) = {0}", currline);
                        }
                    } else {
                        LOGGER.log(Level.WARNING, "Termination the input stream processing as we get the required {0} lines", this.reqLines);
                        done = true;
                        this.terminateProcess = true;
                    }
                    LOGGER.log(Level.FINER, "DataRead.. After Inner While Loop END......visitCount = {0} && reqLines = {1} head = {2} Tail = {3} && Pad = {4}", new Object[]{this.visitCount, this.reqLines, this.head, this.tail, pad});
                }
            }
            if (this.tail - this.head - pad > 0) {
                total += this.tail - this.head - pad;
            }
            int bufferStart = 0;
            if (isUTF16) {
                bufferStart = 2;
                this.buffer[0] = -1;
                this.buffer[1] = -2;
            }
            if (pad > 0) {
                System.arraycopy(this.buffer, this.tail - pad, this.buffer, bufferStart, pad);
            }
            this.head = 0;
            bytesRead = this.input.read(this.buffer, pad + bufferStart, this.bufSize - (pad + bufferStart));
            LOGGER.log(Level.FINER, "Reloaded Buffer data size = {0}", bytesRead);
            if (bytesRead != -1) {
                this.tail = pad + bytesRead;
                continue;
            }
            output.write(this.buffer, 0, pad);
            output.flush();
            total += pad;
            throw new MalformedStreamException("Stream ended unexpectedly");
        }
        output.flush();
        return total;
    }

    public int discardBodyData() throws MalformedStreamException, IOException {
        boolean done = false;
        int total = 0;
        while (!done) {
            int pos = this.findSeparator();
            if (pos != -1) {
                total += pos - this.head;
                this.head = pos;
                done = true;
                continue;
            }
            int pad = this.tail - this.head > this.keepRegion ? this.keepRegion : this.tail - this.head;
            total += this.tail - this.head - pad;
            System.arraycopy(this.buffer, this.tail - pad, this.buffer, 0, pad);
            this.head = 0;
            int bytesRead = this.input.read(this.buffer, pad, this.bufSize - pad);
            if (bytesRead != -1) {
                this.tail = pad + bytesRead;
                continue;
            }
            total += pad;
            throw new MalformedStreamException("Stream ended unexpectedly");
        }
        return total;
    }

    public boolean skipPreamble() throws IOException {
        System.arraycopy(this.boundary, 2, this.boundary, 0, this.boundary.length - 2);
        this.boundaryLength = this.boundary.length - 2;
        try {
            this.discardBodyData();
            boolean bl = this.readBoundary();
            return bl;
        }
        catch (MalformedStreamException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            System.arraycopy(this.boundary, 0, this.boundary, 2, this.boundary.length - 2);
            this.boundaryLength = this.boundary.length;
            this.boundary[0] = 13;
            this.boundary[1] = 10;
        }
    }

    public static boolean arrayequals(byte[] a, byte[] b, int count) {
        for (int i = 0; i < count; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    protected int findByte(byte value, int pos) {
        for (int i = pos; i < this.tail; ++i) {
            if (this.buffer[i] != value) continue;
            return i;
        }
        return -1;
    }

    protected int findSeparator() {
        int first;
        int match = 0;
        int maxpos = this.tail - this.boundaryLength;
        for (first = this.head; first <= maxpos && match != this.boundaryLength; ++first) {
            if ((first = this.findByte(this.boundary[0], first)) == -1 || first > maxpos) {
                return -1;
            }
            for (match = 1; match < this.boundaryLength && this.buffer[first + match] == this.boundary[match]; ++match) {
            }
        }
        if (match == this.boundaryLength) {
            return first - 1;
        }
        return -1;
    }

    public String toString() {
        StringBuffer sbTemp = new StringBuffer();
        sbTemp.append("boundary='");
        sbTemp.append(String.valueOf(this.boundary));
        sbTemp.append("'\nbufSize=");
        sbTemp.append(this.bufSize);
        return sbTemp.toString();
    }

    public static class IllegalBoundaryException
    extends IOException {
        public IllegalBoundaryException() {
        }

        public IllegalBoundaryException(String message) {
            super(message);
        }
    }

    public static class MalformedStreamException
    extends IOException {
        public MalformedStreamException() {
        }

        public MalformedStreamException(String message) {
            super(message);
        }
    }
}

