/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.univlogparser;

import com.adventnet.sa.server.univlogparser.LineBasedMultipartStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;

public class LineDiskFileUpload
extends DiskFileUpload {
    private DefaultFileItemFactory fileItemFactory;
    private long sizeMax = -1L;
    private int startLineNumber = 0;
    private int reqLines = 50;
    private String headerEncoding;

    public LineDiskFileUpload() {
        this.fileItemFactory = new DefaultFileItemFactory();
    }

    public LineDiskFileUpload(int startLineNumber, int reqLines) {
        this.fileItemFactory = new DefaultFileItemFactory();
        this.startLineNumber = startLineNumber;
        this.reqLines = reqLines;
    }

    public LineDiskFileUpload(DefaultFileItemFactory fileItemFactory) {
        this.fileItemFactory = fileItemFactory;
    }

    public FileItemFactory getFileItemFactory() {
        return this.fileItemFactory;
    }

    public void setFileItemFactory(FileItemFactory factory) {
        this.fileItemFactory = (DefaultFileItemFactory)factory;
    }

    public int getSizeThreshold() {
        return this.fileItemFactory.getSizeThreshold();
    }

    public void setSizeThreshold(int sizeThreshold) {
        this.fileItemFactory.setSizeThreshold(sizeThreshold);
    }

    public String getRepositoryPath() {
        return this.fileItemFactory.getRepository().getPath();
    }

    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public void setHeaderEncoding(String encoding) {
        this.headerEncoding = encoding;
        super.setHeaderEncoding(encoding);
    }

    public void setRepositoryPath(String repositoryPath) {
        this.fileItemFactory.setRepository(new File(repositoryPath));
    }

    public List parseRequest(HttpServletRequest req, int sizeThreshold, long sizeMax, String path) throws FileUploadException {
        this.setSizeThreshold(sizeThreshold);
        this.sizeMax = sizeMax;
        this.setSizeMax(sizeMax);
        this.setRepositoryPath(path);
        return this.parseRequest(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List parseRequest(RequestContext ctx) throws FileUploadException {
        if (ctx == null) {
            throw new NullPointerException("ctx parameter");
        }
        ArrayList<FileItem> items = new ArrayList<FileItem>();
        String contentType = ctx.getContentType();
        if (null == contentType || !contentType.toLowerCase().startsWith("multipart/")) {
            throw new FileUploadBase.InvalidContentTypeException("the request doesn't contain a multipart/form-data or multipart/mixed stream, content type header is " + contentType);
        }
        int requestSize = ctx.getContentLength();
        if (requestSize == -1) {
            throw new FileUploadBase.UnknownSizeException("the request was rejected because its size is unknown");
        }
        if (this.sizeMax >= 0L && (long)requestSize > this.sizeMax) {
            throw new FileUploadBase.SizeLimitExceededException("the request was rejected because its size (" + requestSize + ") exceeds the configured maximum (" + this.sizeMax + ")", (long)requestSize, this.sizeMax);
        }
        String charEncoding = this.headerEncoding;
        if (charEncoding == null) {
            charEncoding = ctx.getCharacterEncoding();
        }
        try {
            byte[] boundary = this.getBoundary(contentType);
            if (boundary == null) {
                throw new FileUploadException("the request was rejected because no multipart boundary was found");
            }
            InputStream input = ctx.getInputStream();
            LineBasedMultipartStream multi = new LineBasedMultipartStream(input, boundary, this.startLineNumber, this.reqLines);
            multi.setHeaderEncoding(charEncoding);
            boolean nextPart = multi.skipPreamble();
            while (nextPart) {
                Map headers = this.parseHeaders(multi.readHeaders());
                String fieldName = this.getFieldName(headers);
                if (fieldName != null) {
                    String subContentType = this.getHeader(headers, "Content-type");
                    if (subContentType != null && subContentType.toLowerCase().startsWith("multipart/mixed")) {
                        byte[] subBoundary = this.getBoundary(subContentType);
                        multi.setBoundary(subBoundary);
                        boolean nextSubPart = multi.skipPreamble();
                        while (nextSubPart) {
                            headers = this.parseHeaders(multi.readHeaders());
                            if (this.getFileName(headers) != null) {
                                FileItem item = this.createItem(headers, false);
                                try (OutputStream os = item.getOutputStream();){
                                    multi.readBodyData(os);
                                }
                                items.add(item);
                            } else {
                                multi.discardBodyData();
                            }
                            nextSubPart = multi.readBoundary();
                        }
                        multi.setBoundary(boundary);
                    } else {
                        FileItem item = this.createItem(headers, this.getFileName(headers) == null);
                        try (OutputStream os = item.getOutputStream();){
                            multi.readBodyData(os);
                        }
                        items.add(item);
                    }
                } else {
                    multi.discardBodyData();
                }
                nextPart = multi.readBoundary();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FileUploadException("Processing of multipart/form-data request failed. " + e.getMessage());
        }
        return items;
    }
}

