/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.univlogparser;

import com.adventnet.sa.server.univlogparser.CustomFileTransferUtil;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPReply;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class LineFTPClient
extends FTPClient {
    private int maxLinesTobeTransferred = 50;
    private int startLineNumber = 0;
    private int alreadyReadLines = 0;
    private String remoteFileName = null;
    private String localFilePath = null;
    private CustomFileTransferUtil cftUtil = null;
    private BufferedReader lin = null;
    private static final Logger LOGGER = Logger.getLogger(LineFTPClient.class.getName());

    public LineFTPClient(String hostName, int ftpPort, int startLineNumber, int maxLinesTobeTransferred, String fileName) throws Exception {
        super(hostName, ftpPort);
        this.startLineNumber = startLineNumber;
        this.maxLinesTobeTransferred = maxLinesTobeTransferred;
        this.remoteFileName = fileName;
        this.cftUtil = new CustomFileTransferUtil(fileName, null);
    }

    public String getLocalFilePath() {
        return this.localFilePath;
    }

    public void get(String local, String remoteFile) throws IOException, FTPException {
        File l = new File(local);
        this.localFilePath = l.getName().equals(this.remoteFileName) ? new File(l.getParentFile(), this.cftUtil.getLocalFileName()).getPath() : local;
        super.get(this.localFilePath, remoteFile);
    }

    public void validateTransfer() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.readReply();
        String code = reply.getReplyCode();
        if (code.equals("450")) {
            throw new FTPException(reply);
        }
    }

    public int readChunk(BufferedInputStream bis, byte[] chunk, int chunksize) throws IOException {
        if (this.alreadyReadLines > this.maxLinesTobeTransferred) {
            return -1;
        }
        if (this.cftUtil.getInputStream() == null) {
            this.cftUtil.setInputStream(this.getInputStream());
        }
        BufferedReader bufferedReader = this.lin = this.lin == null ? this.cftUtil.getInputReaderObj(bis) : this.lin;
        if (this.lin == null) {
            return -1;
        }
        String line = null;
        int start = 0;
        byte[] newLine = System.getProperty("line.separator").getBytes();
        int newLineLen = newLine.length;
        int totalBytesRead = 0;
        line = this.cftUtil.readLineFromReader(this.lin);
        while (this.lin != null && this.alreadyReadLines < this.maxLinesTobeTransferred && line != null && totalBytesRead + line.length() + newLineLen + 50 < chunksize) {
            byte[] readBytes = line.getBytes();
            int readLen = readBytes.length;
            if (readLen == 0 || line.trim().length() == 0) {
                line = this.cftUtil.readLineFromReader(this.lin);
                continue;
            }
            System.arraycopy(readBytes, 0, chunk, start, readLen);
            System.arraycopy(newLine, 0, chunk, start += readLen, newLineLen);
            start += newLineLen;
            totalBytesRead += readLen + newLineLen;
            ++this.alreadyReadLines;
            line = this.cftUtil.readLineFromReader(this.lin);
            if (line != null || !this.cftUtil.isZIPStream()) continue;
            this.lin = this.cftUtil.getBufferedReaderForZipStream();
            if (this.lin == null) continue;
            line = this.cftUtil.readLineFromReader(this.lin);
        }
        if (line == null) {
            try {
                this.lin.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.lin = null;
        }
        return start > 0 ? start : -1;
    }

    public boolean isUnSupported() {
        return this.cftUtil.isUnSupported();
    }

    protected void closeDataSocket(InputStream stream) {
        super.closeDataSocket(stream);
        this.cftUtil.closeAllStreams();
    }
}

