/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.univlogparser;

import com.adventnet.sa.server.parser.RecordWriter;
import com.adventnet.sa.server.parser.SeverityRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecordWriterWrapper {
    private final String tableName = "app_hr_trend_sa";
    private static RecordWriter sevRecordwriter = null;
    private TreeMap<Long, List<SeverityRecord>> appIDVsSeverityHolder = new TreeMap();
    private int noOfRecords = 0;
    private static final Logger LOGGER = Logger.getLogger(RecordWriterWrapper.class.getName());
    private boolean isProcessing = true;
    private static RecordWriterWrapper wrapper = null;

    private RecordWriterWrapper() {
        this.initFile();
    }

    public static synchronized RecordWriterWrapper getInstance() {
        if (wrapper == null) {
            wrapper = new RecordWriterWrapper();
        }
        return wrapper;
    }

    private void initFile() {
        if (sevRecordwriter == null) {
            sevRecordwriter = new RecordWriter("app_hr_trend_sa");
            LOGGER.log(Level.INFO, " initFile() called and Severity RecordWriter instance created ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSeverityRecord(Long appID, SeverityRecord record) {
        if (!this.isProcessing) {
            return;
        }
        ++this.noOfRecords;
        List<SeverityRecord> appIDSpecific = this.appIDVsSeverityHolder.get(appID);
        if (appIDSpecific == null) {
            appIDSpecific = new ArrayList<SeverityRecord>();
            this.appIDVsSeverityHolder.put(appID, appIDSpecific);
        }
        appIDSpecific.add(record);
        if (this.noOfRecords > 300) {
            TreeMap<Long, List<SeverityRecord>> toFlush = null;
            RecordWriterWrapper recordWriterWrapper = this;
            synchronized (recordWriterWrapper) {
                toFlush = this.appIDVsSeverityHolder;
                this.appIDVsSeverityHolder = new TreeMap();
                this.noOfRecords = 0;
            }
            this.flushContents(toFlush);
        }
    }

    private void flushContents(TreeMap toFlush) {
        if (toFlush != null) {
            Set appAppIds = toFlush.keySet();
            for (Long tempAPPID : appAppIds) {
                ArrayList sevRecords = (ArrayList)toFlush.get(tempAPPID);
                if (sevRecords == null || sevRecords.size() <= 0) continue;
                sevRecordwriter.addToFile(tempAPPID, sevRecords);
            }
        }
    }

    public void close() {
        if (sevRecordwriter != null) {
            try {
                this.isProcessing = false;
                this.flushContents(this.appIDVsSeverityHolder);
                this.appIDVsSeverityHolder.clear();
            }
            catch (Exception exp) {
                LOGGER.log(Level.WARNING, "Error occurred while executing RecordWriterWrapper's close ... ", exp);
            }
            sevRecordwriter.shutDown();
        }
    }
}

