/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.univlogparser;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.sa.server.EAService;
import com.adventnet.sa.server.parser.SeverityRecord;
import com.adventnet.sa.server.univlogparser.FormatIdentifier;
import com.adventnet.sa.server.univlogparser.RecordWriterWrapper;
import com.google.code.regexp.NamedMatcher;
import com.google.code.regexp.NamedPattern;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SyslogHandler {
    private Map<String, TreeMap> learnings = Collections.synchronizedMap(new TreeMap());
    private String[] defaultFacilities = System.getProperty("localFacility", "Local6").split(",");
    private HashSet<String> facilityValues = new HashSet<String>(Arrays.asList(this.defaultFacilities));
    private boolean isULPEnabled = "true".equals(System.getProperty("liveULP", "true"));
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private HashMap appIDVsFormatID = new HashMap();
    private static final Logger LOGGER = Logger.getLogger(SyslogHandler.class.getName());

    public void parseLog(String receivedFrom, String sourcePort, Hashtable parsedContents) {
        if (!EAService.showPremiumFeatures()) {
            return;
        }
        String logType = ((String)parsedContents.get("HOSTTYPE")).toLowerCase();
        String facility = (String)parsedContents.get("FACILITY");
        sourcePort = sourcePort == null ? "514" : sourcePort;
        String key = receivedFrom + "-" + sourcePort;
        if (this.isULPEnabled && "unix".equals(logType) && this.facilityValues.contains(facility.trim())) {
            long formatID = this.getFormatIDFromLearning(receivedFrom, key);
            if (formatID < 0L) {
                this.findFormatAndParse(receivedFrom, sourcePort, parsedContents);
                this.addUserDefinedFields(parsedContents);
            } else {
                String msg = (String)parsedContents.get("MESSAGE");
                this.parseUsingFormatID(msg, formatID, parsedContents, key);
            }
            this.updateSeverityInformation(receivedFrom, parsedContents);
        } else {
            this.addUserDefinedFields(parsedContents);
        }
    }

    public void clearLearnings() {
        this.learnings.clear();
    }

    private long getFormatIDFromLearning(String receivedFrom, String key) {
        Map hostportVsFormatMap = this.learnings.get(receivedFrom);
        long val = -1L;
        try {
            val = hostportVsFormatMap == null ? -1L : (Long)hostportVsFormatMap.get(key);
        }
        catch (NullPointerException ne) {
            LOGGER.log(Level.FINER, "Key = {0} is unavailable in hostportVsFormatMap {1}", new Object[]{key, hostportVsFormatMap});
            val = -1L;
        }
        return val;
    }

    private void updateFormatIDLearning(String receivedFrom, String key, long formatID) {
        TreeMap<String, Long> hostportVsFormatMap = this.learnings.get(receivedFrom);
        if (hostportVsFormatMap == null) {
            hostportVsFormatMap = new TreeMap<String, Long>();
            this.learnings.put(receivedFrom, hostportVsFormatMap);
        }
        hostportVsFormatMap.put(key, formatID);
    }

    private void addUserDefinedFields(Hashtable parsedContents) {
        if (EAService.showPremiumFeatures()) {
            SystemCustomPatternHandler.getInstance().parse(parsedContents);
            LOGGER.finer("SyslogHandler.addUserDefinedFields() after adding user defined fields, the Parsed Contents is : " + parsedContents);
        }
    }

    private Long getAPPID(Long formatID, Long receivedFrom) {
        Long appid = (Long)this.appIDVsFormatID.get(formatID);
        if (appid == null) {
            try {
                SelectQueryImpl sql = new SelectQueryImpl(new Table("AppResources"));
                sql.addSelectColumn(new Column("AppResources", "*"));
                Criteria hostCriteria = new Criteria(new Column("AppResources", "HOSTID"), (Object)receivedFrom, 0);
                Criteria formatIDCriteria = new Criteria(new Column("AppResources", "FORMATID"), (Object)formatID, 0);
                sql.setCriteria(hostCriteria.and(formatIDCriteria));
                DataObject dobj = DataAccess.get((SelectQuery)sql);
                appid = (Long)dobj.getFirstValue("AppResources", "APPID");
            }
            catch (Exception exp) {
                LOGGER.log(Level.INFO, "Tried to get the Application ID for combination of FormatID " + formatID + " and HostID " + receivedFrom);
            }
        }
        return appid;
    }

    private void updateSeverityInformation(String receivedFrom, Hashtable parsedContents) {
        try {
            parsedContents.put("COMMON_SEVERITY", "INFORMATION");
            Long appID = this.getAPPID((Long)parsedContents.get("FORMATID"), (Long)parsedContents.get("HOSTID"));
            if (appID == null) {
                LOGGER.log(Level.WARNING, "Unable to get appid for " + parsedContents);
                return;
            }
            parsedContents.put("APPID", appID);
            int severity = 3;
            SeverityRecord record = new SeverityRecord();
            record.setHost(receivedFrom);
            try {
                Long time = (Long)parsedContents.get("TIME");
                Date date = time != null ? new Date(time) : new Date();
                long timeInMills = date.getTime();
                parsedContents.put("HOURINMILLIS", "" + timeInMills);
                parsedContents.put("HOUROFDAY", "" + date.getHours());
                parsedContents.put("HOUR", "" + this.sdf.format(date));
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            record.setHourInMillis(new Long((String)parsedContents.get("HOURINMILLIS")));
            record.setHourOfDay((String)parsedContents.get("HOUROFDAY"));
            record.setHour((String)parsedContents.get("HOUR"));
            record.incCount(severity);
            RecordWriterWrapper.getInstance().addSeverityRecord(appID, record);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void parseUsingFormatID(String msg, long formatID, Hashtable parsedContents, String key) {
        if (SystemCustomPatternHandler.getInstance().isKeyValOrCsvType(formatID)) {
            Hashtable keyValuePairs = FormatIdentifier.getInstance().parseKeyValuePairLog(msg);
            if (keyValuePairs != null) {
                parsedContents.putAll(keyValuePairs);
                parsedContents.put("IndexAll", "true");
            }
        } else {
            NamedMatcher nm;
            NamedPattern np;
            String patternString = SystemCustomPatternHandler.getInstance().getDateTimePattern(formatID);
            if (patternString != null && (np = NamedPattern.compile((String)patternString)) != null && msg != null && (nm = np.matcher((CharSequence)msg)).matches()) {
                Map attributes = nm.namedGroups();
                parsedContents.putAll(attributes);
            }
        }
        parsedContents.put("IndexAll", "true");
        parsedContents.put("FORMATID", formatID);
        parsedContents.remove("HOSTTYPE");
        this.addUserDefinedFields(parsedContents);
    }

    private void findFormatAndParse(String receivedFrom, String sourcePort, Hashtable parsedContents) {
        String key = receivedFrom + "-" + sourcePort;
        String msg = (String)parsedContents.get("MESSAGE");
        long formatID = SystemCustomPatternHandler.getInstance().getExistingFormatId(key);
        if (formatID < 0L) {
            int type = FormatIdentifier.getInstance().identifyFormat(msg);
            if (type == 1) {
                Hashtable keyValuePairs = FormatIdentifier.getInstance().parseKeyValuePairLog(msg);
                if (keyValuePairs != null) {
                    parsedContents.putAll(keyValuePairs);
                    parsedContents.put("IndexAll", "true");
                }
                formatID = SystemCustomPatternHandler.getInstance().getFormatId(parsedContents, receivedFrom + "-Key_Value_Pair", true);
            } else {
                formatID = SystemCustomPatternHandler.getInstance().getFormatId(parsedContents, key);
            }
            this.addEntryInAppResources(formatID, (Long)parsedContents.get("HOSTID"));
            this.updateFormatIDLearning(receivedFrom, key, formatID);
            parsedContents.put("FORMATID", formatID);
            parsedContents.remove("HOSTTYPE");
        } else {
            this.parseUsingFormatID(msg, formatID, parsedContents, key);
        }
    }

    private void addEntryInAppResources(Long formatID, Long receivedFrom) {
        try {
            Long appId = this.getAPPID(formatID, receivedFrom);
            if (appId == null) {
                Row appResourcesRow = new Row("AppResources");
                appResourcesRow.set("HOSTID", (Object)receivedFrom);
                appResourcesRow.set("FORMATID", (Object)formatID);
                appResourcesRow.set("FGROUP", (Object)"unsupported_apps");
                WritableDataObject toAdd = new WritableDataObject();
                toAdd.addRow(appResourcesRow);
                toAdd = DataAccess.add((DataObject)toAdd);
                Long appID = (Long)toAdd.getFirstValue("AppResources", "APPID");
                if (appID != null) {
                    this.appIDVsFormatID.put(formatID, appID);
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }
}

