/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.xml.Do2XmlConverter;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.io.file.FileHandler;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.Credential;
import java.io.File;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.util.URLEncoder;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;

public class CommonUtil {
    private static final Logger LOGGER = Logger.getLogger(CommonUtil.class.getName());
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static boolean isDemo = false;
    private static String demoStartDate = "2016-05-21 00:00:00";
    private static String demoEndDate = "2017-05-21 00:00:00";
    public static final String CLIENT_TIME_ZONE = "clientTimeZoneID";
    public static final URLEncoder URLENCODER = new URLEncoder();
    public static final CharSequenceTranslator ESCAPE_JAVA = new LookupTranslator((CharSequence[][])new String[][]{{"\"", "\\\""}, {"\\", "\\\\"}}).with(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.JAVA_CTRL_CHARS_ESCAPE())});
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int EXCEPTION = -1;

    public static boolean isPingable(InetAddress addr) {
        try {
            String cmd = "";
            cmd = ServerDetailsBean.getInstance().isWindows() ? "ping -n 1 " + addr.getHostAddress() : "ping -c 1 " + addr.getHostAddress();
            Process myProcess = Runtime.getRuntime().exec(cmd);
            myProcess.waitFor();
            return myProcess.exitValue() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDemo() {
        return isDemo;
    }

    public static String getDemoStartDate() {
        return demoStartDate;
    }

    public static String getDemoEndDate() {
        return demoEndDate;
    }

    public static String getCurrentDataBaseName() {
        return PersistenceInitializer.getConfigurationValue((String)"DBName");
    }

    public static Object getSysConfiguration(String parameter) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)parameter, 0);
            DataObject keyStoreDO = DataAccess.get((String)"SystemConfigurations", (Criteria)criteria);
            if (!keyStoreDO.isEmpty()) {
                return keyStoreDO.getFirstRow("SystemConfigurations").get("CONF_VALUE");
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return null;
    }

    public static Map<String, String> getSysConfigurations(String[] parameters) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)parameters, 8);
            DataObject keyStoreDO = DataAccess.get((String)"SystemConfigurations", (Criteria)criteria);
            Iterator itr = keyStoreDO.getRows("SystemConfigurations");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                result.put((String)row.get("CONF_NAME"), (String)row.get("CONF_VALUE"));
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return result;
    }

    public static boolean updateSysConfiguration(String parameter, Object value, boolean flag) {
        boolean status = true;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)parameter, 0);
            DataObject keyStoreDO = DataAccess.get((String)"SystemConfigurations", (Criteria)criteria);
            if (!keyStoreDO.isEmpty()) {
                Row row = keyStoreDO.getFirstRow("SystemConfigurations");
                LOGGER.info("SysParameter updated");
                if (flag) {
                    row.set("CONF_VALUE", value);
                    keyStoreDO.updateRow(row);
                } else {
                    keyStoreDO.deleteRow(row);
                }
            } else if (flag) {
                LOGGER.info("SysParameter Created");
                Row row = new Row("SystemConfigurations");
                row.set("CONF_NAME", (Object)parameter);
                row.set("CONF_VALUE", value);
                keyStoreDO.addRow(row);
            } else {
                LOGGER.info("Unknown Action");
            }
            DataAccess.update((DataObject)keyStoreDO);
        }
        catch (Exception e) {
            status = false;
            LOGGER.info("Exception while updating configuration : " + e.getMessage());
        }
        return status;
    }

    public static HashMap<String, String> findHostCredentialDetails(Row hdRow) throws DataAccessException {
        HashMap<String, String> hostDetails = new HashMap<String, String>();
        String domainName = (String)hdRow.get("DOMAIN_NAME");
        if (hdRow.get("USERNAME") != null) {
            LOGGER.info("findHostCredentialDetails called for non-inherirted device");
            hostDetails.put("USERNAME", CommonUtil.checkCredeintials((String)hdRow.get("USERNAME")));
            String password = CommonUtil.checkCredeintials((String)hdRow.get("PASSWORD"));
            if (password != null) {
                password = EnDecryptImplSingleton.getInstance().decrypt(password);
            }
            hostDetails.put("PASSWORD", password);
            hostDetails.put("DOMAIN_NAME", domainName);
            return hostDetails;
        }
        LOGGER.info("findHostCredentialDetails called for domain or workgroup device");
        if (hdRow.get("DOMAIN_ID") != null) {
            DataObject dobj = DataAccess.get(Arrays.asList("ADSDomainConfiguration", "ADSCredentials"), (Criteria)new Criteria(Column.getColumn((String)"ADSDomainConfiguration", (String)"DOMAIN_ID"), hdRow.get("DOMAIN_ID"), 0));
            if (!dobj.isEmpty() || dobj.containsTable("ADSCredentials")) {
                Row crdRow = dobj.getFirstRow("ADSCredentials");
                Row domainDetails = dobj.getFirstRow("ADSDomainConfiguration");
                Credential crd = Credential.getCredential((String)crdRow.get("USER_NAME"), (String)crdRow.get("PASSWORD"), null, null);
                crd.resolveDomainAndUserName();
                hostDetails.put("USERNAME", CommonUtil.checkCredeintials(crd.getUserName()));
                hostDetails.put("PASSWORD", CommonUtil.checkCredeintials(crd.getPassword()));
                if (crd.getDomain() != null) {
                    hostDetails.put("DOMAIN_NAME", crd.getDomain());
                } else {
                    hostDetails.put("DOMAIN_NAME", (String)domainDetails.get("DOMAIN_FLAT_NAME"));
                }
            } else {
                hostDetails.put("USERNAME", "");
                hostDetails.put("PASSWORD", "");
            }
        } else if (hdRow.get("WORKGROUP_ID") != null) {
            DataObject dobj = DataAccess.get(Arrays.asList("ELAWorkgroupConfiguration", "ADSCredentials"), (Criteria)new Criteria(Column.getColumn((String)"ELAWorkgroupConfiguration", (String)"WORKGROUP_ID"), hdRow.get("WORKGROUP_ID"), 0));
            if (!dobj.isEmpty() || dobj.containsTable("ADSCredentials")) {
                Row crdRow = dobj.getFirstRow("ADSCredentials");
                Credential crd = Credential.getCredential((String)crdRow.get("USER_NAME"), (String)crdRow.get("PASSWORD"), null, null);
                hostDetails.put("USERNAME", CommonUtil.checkCredeintials((String)crdRow.get("USER_NAME")));
                hostDetails.put("PASSWORD", CommonUtil.checkCredeintials((String)crdRow.get("PASSWORD")));
                hostDetails.put("DOMAIN_NAME", crd.getDomain());
            } else {
                hostDetails.put("USERNAME", "");
                hostDetails.put("PASSWORD", "");
            }
        } else {
            hostDetails.put("USERNAME", "");
            hostDetails.put("PASSWORD", "");
            LOGGER.info("Authetication less access in findHostCredentialDetails");
        }
        return hostDetails;
    }

    private static String checkCredeintials(String crd) {
        if (crd == null) {
            LOGGER.info("Credentials has null value");
            return "";
        }
        return crd;
    }

    public static String getArchiveLocation(String homeDir) {
        String path = null;
        try {
            Criteria criteria = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"sysArchiveLocation", 0);
            DataObject dataObject = DataAccess.get((String)"SystemConfigurations", (Criteria)criteria);
            path = (String)dataObject.getFirstValue("SystemConfigurations", "CONF_VALUE");
            if ("archive".equals(path)) {
                path = homeDir + File.separator + path;
            }
        }
        catch (DataAccessException e) {
            LOGGER.info("Exception while accessing Archive Files : " + e.getMessage());
        }
        return path;
    }

    public static String getIndexLocation(String homeDir) {
        String path = null;
        try {
            Criteria criteria = new Criteria(new Column("IndexConfigurations", "CONF_NAME"), (Object)"indexPath", 0);
            DataObject dataObject = DataAccess.get((String)"IndexConfigurations", (Criteria)criteria);
            path = (String)dataObject.getFirstValue("IndexConfigurations", "CONF_VALUE");
            if ("indexes".equals(path)) {
                path = homeDir + File.separator + "server" + File.separator + path;
            }
        }
        catch (DataAccessException exp) {
            LOGGER.info("Exception while accessing Files : " + exp.getMessage());
        }
        return path;
    }

    public static int checkTableForValue(String tableName, String columnName, String queryValue, int queryType) {
        try {
            DataObject doo = DataAccess.get((String)tableName, (Criteria)new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)queryValue, queryType));
            if (doo.isEmpty()) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            LOGGER.info("Exception thrown while checking host/agent exists");
            e.printStackTrace();
            return -1;
        }
    }

    public static Long getSysEvtColID() {
        try {
            String elaServerIP = InetAddressHandler.getLocalHost().getHostAddress();
            Criteria criteria = new Criteria(Column.getColumn((String)"SyslogServers", (String)"HOSTIP"), (Object)elaServerIP, 0);
            DataObject dataObject = PersistenceDBUtil.getPersistenceLite().get("SyslogServers", criteria);
            if (!dataObject.isEmpty()) {
                LOGGER.info("SysEvtCol ID collected by check IP address");
                return (Long)dataObject.getFirstValue("SyslogServers", "SLID");
            }
            LOGGER.info("Unable to collect sysevtcol id using ip address");
            return CommonUtil.getSysEvtColID_backup();
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return CommonUtil.getSysEvtColID_backup();
        }
    }

    private static Long getSysEvtColID_backup() {
        Long slid = new Long(1L);
        Criteria criteria = new Criteria(Column.getColumn((String)"SyslogServers", (String)"PORTS"), (Object)"-", 1);
        try {
            DataObject slDO = PersistenceDBUtil.getPersistenceLite().get("SyslogServers", criteria);
            if (slDO.size("SyslogServers") > 0) {
                LOGGER.info("SysEvtCol ID collected by check ports value");
                return (Long)slDO.getFirstValue("SyslogServers", "SLID");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, " Exception while getting SLID : {0}", e);
            e.printStackTrace();
        }
        LOGGER.info("Returning default ID, unable to find is using predefined condns");
        return slid;
    }

    public static TimeZone getTimezoneFromOffset(String offset) {
        if (offset != null) {
            return TimeZone.getTimeZone(offset);
        }
        return TimeZone.getDefault();
    }

    public static void formXmlForLogFormats() {
        try {
            String path = System.getProperty("server.home") + File.separator + "data" + File.separator + "logFormats";
            File pathfile = new File(path);
            if (pathfile.exists()) {
                pathfile.delete();
            }
            pathfile.mkdir();
            Table table = new Table("Parser_LogFormats");
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn((String)"Parser_LogFormats", (String)"*"));
            query.setCriteria(new Criteria(Column.getColumn((String)"Parser_LogFormats", (String)"IS_FILE_IMPORT_SUPPORTED"), (Object)true, 1));
            DataObject tempDO = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            Iterator keyIT = tempDO.getRows("Parser_LogFormats");
            while (keyIT.hasNext()) {
                Row row = (Row)keyIT.next();
                String logFormat = (String)row.get("FORMAT_NAME");
                DataObject formatDO = CommonUtil.getformatDOByName(logFormat);
                logFormat = logFormat.replaceAll(" ", "_");
                Do2XmlConverter.transform((DataObject)formatDO, (String)(path + File.separator + logFormat + ".xml"), (boolean)true, null, (boolean)false, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static DataObject getformatDOByName(String logFormat) {
        try {
            Table table1 = new Table("Parser_LogFormats");
            Table table2 = new Table("Parser_Locale2FormatMapping");
            Table table3 = new Table("Parser_Rules");
            Table table4 = new Table("Parser_Attributes");
            Table table5 = new Table("Parser_RuleType");
            Table table6 = new Table("Parser_ApplyWhen");
            Table table7 = new Table("Parser_Locale");
            SelectQueryImpl query = new SelectQueryImpl(table1);
            Join join1 = new Join(table1, table2, new String[]{"FORMAT_ID"}, new String[]{"FORMAT_ID"}, 1);
            Join join2 = new Join(table2, table3, new String[]{"LOCALEMAP_ID"}, new String[]{"LOCALEMAP_ID"}, 1);
            Join join3 = new Join(table3, table4, new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1);
            Join join4 = new Join(table3, table5, new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1);
            Join join5 = new Join(table3, table6, new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1);
            Join join6 = new Join(table2, table7, new String[]{"LOCALE_ID"}, new String[]{"LOCALE_ID"}, 1);
            query.addJoin(join1);
            query.addJoin(join2);
            query.addJoin(join3);
            query.addJoin(join4);
            query.addJoin(join5);
            query.addJoin(join6);
            query.addSelectColumn(Column.getColumn((String)"Parser_LogFormats", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"Parser_Rules", (String)"*"));
            query.addSelectColumn(new Column("Parser_Locale2FormatMapping", "*"));
            query.addSelectColumn(Column.getColumn((String)"Parser_Attributes", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"Parser_RuleType", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"Parser_ApplyWhen", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"Parser_Locale", (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"Parser_Rules", (String)"PRIORITY"), false));
            Criteria cri = new Criteria(Column.getColumn((String)"Parser_LogFormats", (String)"FORMAT_NAME"), (Object)logFormat, 0);
            cri = cri.and(new Criteria(Column.getColumn((String)"Parser_Rules", (String)"IS_ENABLE"), (Object)true, 0));
            query.setCriteria(cri);
            return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long getDateOlderThanDWS() {
        try {
            Table table = new Table("DataManagementTiming");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            Column col = new Column("DataManagementTiming", "TIMER_NAME");
            Criteria cri = new Criteria(col, (Object)"SYS_DATA_WINDOW", 0);
            sql.setCriteria(cri);
            sql.addSelectColumn(new Column("DataManagementTiming", "*"));
            DataObject doo = DataAccess.constructDataObject();
            doo = DataAccess.get((SelectQuery)sql);
            long days = 1L;
            if (!doo.isEmpty()) {
                days = new Long((String)doo.getFirstValue("DataManagementTiming", "TIMESTAMP")).intValue();
            }
            long olderTime = System.currentTimeMillis() - days * 86400000L;
            LOGGER.log(Level.INFO, "current time:" + System.currentTimeMillis() + " days:" + days + " olderTime:" + olderTime);
            return olderTime;
        }
        catch (Exception e) {
            return 1L;
        }
    }

    public static boolean isMailServerConfigured() {
        return "true".equalsIgnoreCase((String)CommonUtil.getSysConfiguration("IS_MAIL_SERVER_CONFIGURED"));
    }

    public static void setMailServerConfigured() {
        CommonUtil.updateSysConfiguration("IS_MAIL_SERVER_CONFIGURED", "true", true);
    }

    public static Process executeBatch(String batchName, String arguments) throws Exception {
        String commandToExecute = "";
        commandToExecute = ServerDetailsBean.getInstance().isWindows() ? "cmd  /c .\\" + batchName + " " + arguments : "sh " + batchName + ".sh " + arguments;
        LOGGER.log(Level.INFO, "Batch Command to execute {0}", commandToExecute);
        Process proc = Runtime.getRuntime().exec(commandToExecute);
        return proc;
    }

    static {
        Properties prop = null;
        try {
            prop = FileHandler.filetoProperties(System.getProperty("server.home") + File.separator + "conf" + File.separator + "demo.conf");
        }
        catch (BaseStatusCode elaErrorHandler) {
            LOGGER.info(elaErrorHandler.toString());
        }
        if (prop.containsKey("demo.isDemo")) {
            isDemo = prop.getProperty("demo.isDemo").equalsIgnoreCase("TRUE");
        }
        if (prop.containsKey("demo.startDate")) {
            demoStartDate = prop.getProperty("demo.startDate");
        }
        if (prop.containsKey("demo.endDate")) {
            demoEndDate = prop.getProperty("demo.endDate");
        }
    }

    public static enum SlUpdateConstants {
        HOSTADD,
        HOSTDELETE,
        HOSTUPDATE,
        HOSTENABLE,
        HOSTDISABLE,
        SCANNOW,
        DOMAIN,
        WORKGROUP,
        LOGLEVEL,
        FILTER,
        SECSTATUS;

    }
}

