/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.util;

import com.manageengine.ads.fw.util.XMLHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class CsrFileGenerator {
    private static Logger out = Logger.getLogger("ADSLogger");
    private static String tmpPath = ".." + File.separator + "jre" + File.separator + "bin" + File.separator + "ssl.keystore";
    private static String oldpfx = ".." + File.separator + "conf" + File.separator + "selfsigned.pfx";
    private static String oldca = ".." + File.separator + "Certificates" + File.separator + "ca.crt";
    private static StringBuilder executableKeytool = null;

    static {
        String osName = System.getProperty("os.name");
        executableKeytool = osName == null || osName.toUpperCase().contains("WINDOWS") ? new StringBuilder("..").append(File.separator).append("jre").append(File.separator).append("bin").append(File.separator).append("keytool.exe") : new StringBuilder("..").append(File.separator).append("jre").append(File.separator).append("bin").append(File.separator).append("keytool");
    }

    public static String getSanCommand(String name) {
        return "SAN=dns:" + name;
    }

    public static JSONObject createCSR(JSONObject sslSettings) throws Exception {
        ArrayList<String> cmdList = new ArrayList<String>();
        String password = sslSettings.getString("PASSWORD").replaceAll(" ", "\\ ");
        File keyFile = new File(tmpPath);
        if (keyFile.exists()) {
            File bckFile = new File(".." + File.separator + "jre" + File.separator + "bin" + File.separator + "ssl_" + System.currentTimeMillis() + ".keystore");
            keyFile.renameTo(bckFile);
        }
        cmdList.add(executableKeytool.toString());
        cmdList.add("-genkey");
        cmdList.add("-alias");
        cmdList.add("tomcat");
        cmdList.add("-keyalg");
        cmdList.add("RSA");
        cmdList.add("-keypass");
        cmdList.add(password);
        cmdList.add("-storePass");
        cmdList.add(password);
        String keyLength = "2048";
        if (sslSettings.getString("KEY_LENGTH") != null && !sslSettings.getString("KEY_LENGTH").equals("")) {
            keyLength = sslSettings.getString("KEY_LENGTH");
        }
        cmdList.add("-keysize");
        cmdList.add(keyLength);
        String validity = sslSettings.getString("VALIDITY");
        if (validity != null && !validity.equals("")) {
            cmdList.add("-validity");
            cmdList.add(validity);
        }
        cmdList.add("-dName");
        StringBuilder keyCmd = new StringBuilder();
        keyCmd.append("CN=").append(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("COMMON_NAME")));
        keyCmd.append(", OU=").append(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("OU")));
        keyCmd.append(", O=").append(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("ORGANIZATION")));
        keyCmd.append(", L=").append(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("LOCALITY")));
        keyCmd.append(", S=").append(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("STATE")));
        keyCmd.append(", C=").append(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("COUNTRY_CODE")));
        cmdList.add(keyCmd.toString());
        JSONObject jstatus = new JSONObject();
        cmdList.add("-keystore");
        cmdList.add(tmpPath);
        cmdList.add("-ext");
        cmdList.add(CsrFileGenerator.getSanCommand(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("COMMON_NAME"))));
        String status = CsrFileGenerator.processCmd(cmdList);
        out.log(Level.INFO, "Keystore Creation completed");
        if (status != null && status.equals("success")) {
            File tempCSRFile;
            cmdList.clear();
            keyFile = new File(".." + File.separator + "Certificates");
            if (!keyFile.exists()) {
                keyFile.mkdir();
            }
            if ((tempCSRFile = new File(".." + File.separator + "Certificates" + File.separator + "ssl.csr")).exists()) {
                File bckFile = new File(".." + File.separator + "Certificates" + File.separator + "ssl_" + System.currentTimeMillis() + ".csr");
                tempCSRFile.renameTo(bckFile);
            }
            cmdList.add(executableKeytool.toString());
            cmdList.add("-certreq");
            cmdList.add("-alias");
            cmdList.add("tomcat");
            cmdList.add("-keyalg");
            cmdList.add("RSA");
            cmdList.add("-storepass");
            cmdList.add(password);
            cmdList.add("-keystore");
            cmdList.add(tmpPath);
            cmdList.add("-file");
            cmdList.add(".." + File.separator + "Certificates" + File.separator + "ssl.csr");
            cmdList.add("-ext");
            cmdList.add(CsrFileGenerator.getSanCommand(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("COMMON_NAME"))));
            status = CsrFileGenerator.processCmd(cmdList);
            out.log(Level.INFO, "CSR Creation completed");
        }
        try {
            if (status != null && status.equals("success")) {
                jstatus.put("sSTATUS", (Object)"ads.admin.ssl_tool.csr_generation_success");
            } else {
                jstatus.put("eSTATUS", (Object)CsrFileGenerator.errorHandler(status));
            }
        }
        catch (Exception e) {
            out.log(Level.INFO, " ", e);
            throw new Exception(e);
        }
        return jstatus;
    }

    public static String createSelfSignedCertificate(JSONObject sslSettings) throws Exception {
        ArrayList<String> cmdList = new ArrayList<String>();
        String password = sslSettings.getString("PASSWORD");
        File keyFile = new File(oldpfx);
        if (keyFile.exists()) {
            File bckFile = new File(".." + File.separator + "conf" + File.separator + "selfsigned_" + System.currentTimeMillis() + ".pfx");
            keyFile.renameTo(bckFile);
        }
        cmdList.add(executableKeytool.toString());
        cmdList.add("-genkeypair");
        cmdList.add("-alias");
        cmdList.add("tomcat");
        cmdList.add("-keyalg");
        cmdList.add("RSA");
        cmdList.add("-keypass");
        cmdList.add(password);
        cmdList.add("-storePass");
        cmdList.add(password);
        String keyLength = "2048";
        if (sslSettings.getString("KEY_LENGTH") != null && !sslSettings.getString("KEY_LENGTH").equals("")) {
            keyLength = sslSettings.getString("KEY_LENGTH");
        }
        cmdList.add("-keysize");
        cmdList.add(keyLength);
        String validity = sslSettings.getString("VALIDITY");
        if (validity != null && !validity.equals("")) {
            cmdList.add("-validity");
            cmdList.add(validity);
        }
        cmdList.add("-dName");
        StringBuilder keyCmd = new StringBuilder();
        keyCmd.append("CN=").append(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("COMMON_NAME")));
        keyCmd.append(", OU=").append(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("OU")));
        keyCmd.append(", O=").append(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("ORGANIZATION")));
        keyCmd.append(", L=").append(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("LOCALITY")));
        keyCmd.append(", S=").append(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("STATE")));
        keyCmd.append(", C=").append(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("COUNTRY_CODE")));
        cmdList.add(keyCmd.toString());
        cmdList.add("-ext");
        cmdList.add(CsrFileGenerator.getSanCommand(CsrFileGenerator.escapeSpecialChar(sslSettings.getString("COMMON_NAME"))));
        JSONObject jstatus = new JSONObject();
        cmdList.add("-keystore");
        cmdList.add(oldpfx);
        cmdList.add("-storetype");
        cmdList.add("pkcs12");
        String status = CsrFileGenerator.processCmd(cmdList);
        out.log(Level.INFO, "PFX Creation completed");
        if ((status == null || !status.equals("success")) && keyFile.exists()) {
            File bckFile = new File(oldpfx);
            keyFile.renameTo(bckFile);
        }
        return status;
    }

    public static JSONObject applySelfSignedCertificate(JSONObject sslSettings) throws Exception {
        JSONObject jstatus = new JSONObject();
        XMLHandler serverXML = new XMLHandler("server.xml");
        if (serverXML.getConnectionSettings().getString("SSL").equalsIgnoreCase("FALSE")) {
            jstatus.put("eSTATUS", (Object)"ads.admin.ssl_tool.apply_selfsigned_certificate_no_ssl");
            return jstatus;
        }
        String status = CsrFileGenerator.createSelfSignedCertificate(sslSettings);
        if (status != null && status.equals("success")) {
            jstatus.put("sSTATUS", (Object)"ads.admin.ssl_tool.apply_selfsigned_certificate_success");
            CsrFileGenerator.ExtractRootCertificate(sslSettings);
            if (!serverXML.updatePFXCertificateSettings("selfsigned.pfx", sslSettings.getString("PASSWORD"))) {
                jstatus.put("eSTATUS", (Object)"ads.admin.ssl_tool.apply_selfsigned_certificate_falied");
            }
        } else {
            jstatus.put("eSTATUS", (Object)CsrFileGenerator.errorHandler(status));
        }
        return jstatus;
    }

    private static void ExtractRootCertificate(JSONObject sslSettings) {
        try {
            File caCert;
            ArrayList<String> cmdList = new ArrayList<String>();
            String password = sslSettings.getString("PASSWORD");
            File certDir = new File(".." + File.separator + "Certificates");
            if (!certDir.exists()) {
                out.log(Level.INFO, "Created Certificate directory");
                certDir.mkdir();
            }
            if ((caCert = new File(oldca)).exists()) {
                File bckFile = new File(".." + File.separator + "Certificates" + File.separator + "ca_" + System.currentTimeMillis() + ".crt");
                caCert.renameTo(bckFile);
            }
            cmdList.add(executableKeytool.toString());
            cmdList.add("-exportcert");
            cmdList.add("-alias");
            cmdList.add("tomcat");
            cmdList.add("-rfc");
            cmdList.add("-file");
            cmdList.add(oldca);
            cmdList.add("-storePass");
            cmdList.add(password);
            cmdList.add("-keystore");
            cmdList.add(oldpfx);
            cmdList.add("-storetype");
            cmdList.add("pkcs12");
            String status = CsrFileGenerator.processCmd(cmdList);
            out.log(Level.INFO, "Extract process completed");
            if ((status == null || !status.equals("success")) && caCert.exists()) {
                File bckFile = new File(oldca);
                caCert.renameTo(bckFile);
                out.log(Level.WARNING, "Root certificate extraction failed");
            } else {
                out.log(Level.WARNING, "Root certificate extracted to " + oldca);
            }
        }
        catch (Exception ex) {
            out.log(Level.WARNING, "Root certificate extraction failed");
        }
    }

    public static String processCmd(ArrayList<String> cmdList) throws Exception {
        String message = "success";
        try {
            String line = null;
            Process p = Runtime.getRuntime().exec(cmdList.toArray(new String[cmdList.size()]));
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = in.readLine()) != null) {
                message = line;
                out.log(Level.INFO, message);
            }
            p.waitFor();
            in.close();
        }
        catch (Exception e) {
            out.log(Level.INFO, " ", e);
            throw new Exception(e);
        }
        return message;
    }

    private static String errorHandler(String errMsg) {
        if (errMsg.contains("Key pair not generated, alias <tomcat> already exists")) {
            return "ads.admin.ssl_tool.error.keypair_exists";
        }
        if (errMsg.contains("The system cannot find the path specified")) {
            return "ads.admin.ssl_tool.error.path_not_exist";
        }
        if (errMsg.contains("Keystore was tampered with, or password was incorrect")) {
            return "ads.admin.ssl_tool.error.keystore_not_exist";
        }
        if (errMsg.contains("RSA keys must be at least 512 bits long")) {
            return "ads.admin.ssl_tool.error.keysize_min";
        }
        if (errMsg.contains("Key password must be at least 6 characters")) {
            return "ads.admin.ssl_tool.error.password_len";
        }
        if (errMsg.contains("Cannot run program")) {
            return "ads.admin.ssl_tool.error.command_error";
        }
        if (errMsg.contains("Keystore file does not exist")) {
            return "ads.admin.ssl_tool.error.keystore_not_exist";
        }
        if (errMsg.contains("java.io.IOException") || errMsg.contains("Exception")) {
            return "ads.admin.ssl_tool.error.invalid_entries";
        }
        return errMsg;
    }

    private static String escapeSpecialChar(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"\"", ",", ";"};
        String ret = str;
        String[] stringArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (ret.contains(s)) {
                ret = ret.replaceAll(s, "\\\\" + s);
            }
            ++n2;
        }
        return ret;
    }
}

