/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class DBDiagnostics {
    private static final Logger LOGGER = Logger.getLogger(DBDiagnostics.class.getName());
    private ScheduledExecutorService scheduler = null;
    private static DBDiagnostics instance = null;
    private final int diagnostic_run_interval = 3600000;
    private Connection con = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static synchronized DBDiagnostics getInstance() {
        if (instance == null) {
            instance = new DBDiagnostics();
        }
        return instance;
    }

    private DBDiagnostics() {
    }

    public void runPeriodically() {
        String dbType = System.getProperty("DBType", "mysql");
        if ("mysql".equals(dbType)) {
            this.scheduler = Executors.newScheduledThreadPool(1);
            this.scheduler.scheduleAtFixedRate(new DBChecker(), 3600000L, 3600000L, TimeUnit.MILLISECONDS);
        }
    }

    private void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    private class DBChecker
    implements Runnable {
        private DBChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.info("Running DBDiagnostics");
            HashSet<String> tableNames = new HashSet<String>();
            Statement stmt = null;
            try {
                DBDiagnostics.this.con = RelationalAPI.getInstance().getConnection();
                stmt = DBDiagnostics.this.con.createStatement();
                ResultSet rs = stmt.executeQuery("select TABLE_NAME from MetaTable where TABLE_NAME = LOOKUP_TABLENAME");
                while (rs.next()) {
                    tableNames.add(rs.getString("TABLE_NAME"));
                }
                tableNames.add("EventLog_Hr_Trend_Base");
                tableNames.add("SysLog_Hr_Trend_Base");
                tableNames.add("Comp_SysLog_Hr_Trend_Base");
                this.checkTables(tableNames);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (DBDiagnostics.this.con != null) {
                    try {
                        DBDiagnostics.this.con.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                DBDiagnostics.this.con = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkTables(HashSet<String> tableNames) {
            for (String tableName : tableNames) {
                Statement stmt = null;
                try {
                    stmt = DBDiagnostics.this.con.createStatement();
                    ResultSet rs = null;
                    String query = "check table " + tableName;
                    long startTime = System.currentTimeMillis();
                    LOGGER.fine("Checking table " + tableName);
                    rs = stmt.executeQuery(query);
                    long timeTaken = System.currentTimeMillis() - startTime;
                    LOGGER.fine("Time taken to execute [" + query + "] is [" + timeTaken + "]");
                    while (rs.next()) {
                        String msgType = rs.getString("Msg_type");
                        String msgText = rs.getString("Msg_text");
                        LOGGER.fine("Got msgType:" + msgType + " msgText:" + msgText);
                        if (!"error".equalsIgnoreCase(msgType)) continue;
                        boolean result = false;
                        result = msgText.contains("Incorrect information in file") || msgText.contains("Can't find file") ? this.repairTable(tableName, true) : this.repairTable(tableName, false);
                        if (!result) continue;
                        this.updateDB(tableName, msgText);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    if (stmt == null) continue;
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean repairTable(String tableName, boolean useFrm) {
            boolean result = false;
            LOGGER.info("Repairing table " + tableName + " using USE_FRM:" + useFrm);
            String query = "repair table " + tableName;
            if (useFrm) {
                query = query + " USE_FRM";
            }
            Statement stmt = null;
            try {
                stmt = DBDiagnostics.this.con.createStatement();
                ResultSet rs = null;
                long startTime = System.currentTimeMillis();
                rs = stmt.executeQuery(query);
                long timeTaken = System.currentTimeMillis() - startTime;
                LOGGER.fine("Time taken to execute [" + query + "] is [" + timeTaken + "]");
                if (rs.next()) {
                    String msgText = rs.getString("Msg_text");
                    if (msgText != null && (msgText.contains("Incorrect information in file") || msgText.contains("Can't find file")) && !useFrm) {
                        result = this.repairTable(tableName, true);
                    } else {
                        LOGGER.info("Successfully repaired table " + tableName + " message:" + msgText);
                        result = true;
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            return result;
        }

        private void updateDB(String tableName, String errorMsg) {
            Row r = new Row("RepairedTablesInfo");
            r.set("TIMESTAMP", (Object)DBDiagnostics.this.dateFormat.format(new Date()));
            r.set("TABLE_NAME", (Object)tableName);
            r.set("ERROR_DETAILS", (Object)errorMsg);
            r.set("STATUS", (Object)"SUCCESS");
            try {
                DataObject dObj = DataAccess.constructDataObject();
                dObj.addRow(r);
                DataAccess.add((DataObject)dObj);
            }
            catch (DataAccessException dae) {
                dae.printStackTrace();
            }
        }
    }
}

