/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.QueryConstructionException;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Logger;

public class DBUtil {
    private static final Logger LOGGER = Logger.getLogger(DBUtil.class.getName());
    public static final String PGSQL_CIPHER_ALGO = "aes256";

    public static boolean deleteExistingRows(String tableName, Criteria criteria, boolean ... flag) {
        try {
            DataAccess.delete((String)tableName, (Criteria)criteria);
            return true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static boolean updateDataObject(DataObject dobJ, boolean ... flag) {
        try {
            PersistenceDBUtil.getPersistence((boolean[])flag).update(dobJ);
            return true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static void deleteRow(Row row, boolean ... flag) {
        try {
            PersistenceDBUtil.getPersistence((boolean[])flag).delete(row);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static DataObject createNewRowGETDO(Row newRow, boolean ... flag) throws DataAccessException {
        DataObject dobJ = PersistenceDBUtil.getPersistence((boolean[])flag).constructDataObject();
        dobJ.addRow(newRow);
        return DBUtil.updateAndGetDO(dobJ, flag);
    }

    public static void createNewRow(Row newRow, boolean ... flag) {
        try {
            DataObject dobJ = DataAccess.constructDataObject();
            dobJ.addRow(newRow);
            DBUtil.updateDataObject(dobJ, flag);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static DataObject updateAndGetDO(DataObject dobJ, boolean ... flag) throws DataAccessException {
        return PersistenceDBUtil.getPersistence((boolean[])flag).update(dobJ);
    }

    public static void dropTable(String tableName) {
        try {
            DataAccess.dropTable((String)tableName);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static void closeStmtAndConnection(Statement stmt, Connection con) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exp) {
            LOGGER.info("Exception while closing the statement");
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception exp) {
            LOGGER.info("Exception while closing the connection");
        }
    }

    public static void closeResultSetOrDataSet(ResultSet rs, DataSet ds) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exp) {
            LOGGER.info("Exception while closing Resultset");
        }
        try {
            if (ds != null) {
                ds.close();
            }
        }
        catch (Exception exp) {
            LOGGER.info("Exception while closing DataSet");
        }
    }

    public static int getCountInt(String tableName, Criteria crit) {
        int count = -1;
        Object countObject = DBUtil.getCount(tableName, crit);
        if (countObject != null) {
            if (countObject instanceof Integer) {
                count = (Integer)countObject;
            } else if (countObject instanceof Long) {
                count = ((Long)countObject).intValue();
            }
        }
        return count;
    }

    public static long getCountLong(String tableName, Criteria crit) {
        long count = -1L;
        Object countObject = DBUtil.getCount(tableName, crit);
        if (countObject != null) {
            if (countObject instanceof Integer) {
                count = ((Integer)countObject).intValue();
            } else if (countObject instanceof Long) {
                count = (Long)countObject;
            }
        }
        return count;
    }

    public static int getTotalIntCount(SelectQuery passedQuery) {
        Object dummyValue = DBUtil.getTotalCountFromQuery(passedQuery);
        return dummyValue == null ? -1 : Integer.parseInt(dummyValue.toString());
    }

    public static long getTotalCount(SelectQuery passedQuery) {
        Object dummyValue = DBUtil.getTotalCountFromQuery(passedQuery);
        return dummyValue == null ? -1L : Long.parseLong(dummyValue.toString());
    }

    public static int getTotalIntCountDirect(SelectQuery passedQuery) {
        Object dummyValue = DBUtil.getCount(passedQuery);
        return dummyValue == null ? -1 : Integer.parseInt(dummyValue.toString());
    }

    public static long getTotalCountDirect(SelectQuery passedQuery) {
        Object dummyValue = DBUtil.getCount(passedQuery);
        return dummyValue == null ? -1L : Long.parseLong(dummyValue.toString());
    }

    public static int getTotalIntCountNonMickey(SelectQuery passedQuery) {
        Object dummyValue = DBUtil.getRawCount(passedQuery);
        return dummyValue == null ? -1 : Integer.parseInt(dummyValue.toString());
    }

    public static long getTotalLongCountNonMickey(SelectQuery passedQuery) {
        Object dummyValue = DBUtil.getRawCount(passedQuery);
        return dummyValue == null ? -1L : Long.parseLong(dummyValue.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTotalLongCountArchiveTable(SelectQuery passedQuery) {
        Long count;
        block5: {
            Connection connection = null;
            DataSet dataSet = null;
            count = -1L;
            try {
                RelationalAPI relapi = RelationalAPI.getInstance();
                connection = relapi.getConnection();
                dataSet = relapi.getArchiveAdapter().getArchiveData(passedQuery, connection);
                dataSet.next();
                count = dataSet.getAsLong(1);
                DBUtil.closeResultSetOrDataSet(null, dataSet);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                DBUtil.closeResultSetOrDataSet(null, dataSet);
                DBUtil.closeStmtAndConnection(null, connection);
            }
            DBUtil.closeStmtAndConnection(null, connection);
        }
        return count;
    }

    private static Object getTotalCountFromQuery(SelectQuery passedQuery) {
        if (passedQuery == null) {
            throw new IllegalArgumentException("Invalid  parameter");
        }
        SelectQuery selectQuery = (SelectQuery)passedQuery.clone();
        ArrayList sortColumns = (ArrayList)selectQuery.getSortColumns();
        for (SortColumn column : sortColumns) {
            selectQuery.removeSortColumn(column);
        }
        ArrayList selectColumns = (ArrayList)selectQuery.getSelectColumns();
        for (Column column : selectColumns) {
            selectQuery.removeSelectColumn(column);
        }
        selectQuery.addSelectColumn(Column.getColumn(null, (String)"*").count());
        return DBUtil.getCount(selectQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getCount(String tableName, Criteria crit) {
        Connection connection = null;
        DataSet dataSet = null;
        Integer count = -1;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            Column countColumn = Column.getColumn(null, (String)"*");
            sq.addSelectColumn(countColumn.count());
            sq.setCriteria(crit);
            Object object = DBUtil.getCount((SelectQuery)sq);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeResultSetOrDataSet(null, dataSet);
            DBUtil.closeStmtAndConnection(null, connection);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Object getCount(SelectQuery selectQuery) {
        Object count;
        block7: {
            Connection conn = null;
            count = null;
            DataSet ds = null;
            try {
                RelationalAPI relapi = RelationalAPI.getInstance();
                conn = relapi.getConnection();
                ds = relapi.executeQuery((Query)selectQuery, conn);
                ds.next();
                count = ds.getValue(1);
                DBUtil.closeResultSetOrDataSet(null, ds);
            }
            catch (QueryConstructionException e) {
                e.printStackTrace();
                break block7;
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DBUtil.closeResultSetOrDataSet(null, ds);
                DBUtil.closeStmtAndConnection(null, conn);
            }
            DBUtil.closeStmtAndConnection(null, conn);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Object getRawCount(SelectQuery selectQuery) {
        Object count;
        block7: {
            Connection conn = null;
            count = null;
            DataSet ds = null;
            try {
                RelationalAPI relapi = RelationalAPI.getInstance();
                conn = relapi.getConnection();
                String query = relapi.getDBAdapter().getSQLGenerator().getSQLForSelect((Query)selectQuery);
                ds = relapi.executeQuery(query, conn);
                ds.next();
                count = ds.getValue(1);
                DBUtil.closeResultSetOrDataSet(null, ds);
            }
            catch (QueryConstructionException e) {
                e.printStackTrace();
                break block7;
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DBUtil.closeResultSetOrDataSet(null, ds);
                DBUtil.closeStmtAndConnection(null, conn);
            }
            DBUtil.closeStmtAndConnection(null, conn);
        }
        return count;
    }
}

