/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.util;

import com.adventnet.sa.server.util.XmlFileresolver;
import com.adventnet.sym.security.server.EventlogpersUtil;
import com.manageengine.ads.fw.util.XMLHandler;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class DerivedXMLHandler
extends XMLHandler {
    protected String templatePath = null;
    private static Object writeBlock = new Object();

    public DerivedXMLHandler(String fileName, String template) throws Exception {
        super(fileName);
        this.templatePath = ".." + File.separator + "conf" + File.separator + template;
        this.parseXmlfile();
    }

    public DerivedXMLHandler(String fileName) throws Exception {
        super(fileName);
        this.parseXmlfile();
    }

    public void parseXml() {
    }

    public void parseXmlfile() throws Exception {
        try {
            this.document = this.getDocumentBuilder(false).parse(new File(this.fileName));
        }
        catch (Exception exp) {
            exp.printStackTrace();
            this.document = this.getDocumentBuilder(true).parse(new File(this.fileName));
        }
        this.rootElement = this.document.getDocumentElement();
    }

    private DocumentBuilder getDocumentBuilder(boolean tryWithTemplate) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (tryWithTemplate && this.templatePath != null) {
            builder.setEntityResolver(new XmlFileresolver(this.templatePath));
        }
        return builder;
    }

    public String getSessionvalue() {
        try {
            return this.rootElement.getElementsByTagName("session-timeout").item(0).getChildNodes().item(0).getNodeValue();
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return "";
        }
    }

    public void updateConnectionSettings(HttpServletRequest request) {
        String checkSSL = request.getParameter("SSL");
        try {
            String http = request.getParameter("HTTP");
            String https = request.getParameter("HTTPS");
            if (checkSSL.equalsIgnoreCase("TRUE")) {
                String isHttp = super.getConnectionSettings("scheme", "http", "port");
                if (isHttp == null) {
                    this.createDefaultHttpConnector(http, https);
                } else {
                    super.updateConnectionSettings("scheme", "http", "port", http);
                    super.updateConnectionSettings("scheme", "http", "redirectPort", https);
                }
                String isExists = super.getConnectionSettings("scheme", "https", "port");
                if (isExists == null) {
                    JSONObject conRow = this.getNewSSLRowProperties(https);
                    this.findOrCreateKeyStoreFile(request, conRow);
                    super.createRow("Service", "Connector", conRow);
                } else {
                    super.updateConnectionSettings("scheme", "https", "port", https);
                }
            } else {
                super.deleteRow("Connector", "scheme", "https");
                String isHttp = super.getConnectionSettings("scheme", "http", "port");
                if (isHttp == null) {
                    this.createDefaultHttpConnector(http, https);
                } else {
                    super.updateConnectionSettings("scheme", "http", "port", http);
                }
            }
            this.writeDocTofile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createDefaultHttpConnector(String http, String https) {
        try {
            JSONObject conRow = this.defaultHttpRowProperties(http, https);
            super.createRow("Service", "Connector", conRow);
            this.writeDocTofile();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDocTofile() {
        Object object = writeBlock;
        synchronized (object) {
            super.writeToFile();
        }
    }

    private void findOrCreateKeyStoreFile(HttpServletRequest request, JSONObject conRow) throws JSONException {
        String keyStorefile = this.getConnectionSettings("scheme", "https", "keystoreFile");
        File keyStoreFile = null;
        if (keyStorefile != null) {
            keyStoreFile = new File(keyStorefile);
        }
        if (keyStorefile != null && keyStoreFile.exists() && !keyStoreFile.getName().equals(EventlogpersUtil.keystoredefaultfile)) {
            conRow.put("keystoreFile", (Object)keyStoreFile);
            conRow.put("keystorePass", (Object)super.getConnectionSettings("scheme", "https", "keystorePass"));
            conRow.put("keystoreType", (Object)super.getConnectionSettings("scheme", "https", "keystoreType"));
        } else {
            conRow.put("keystoreFile", (Object)("./conf/" + EventlogpersUtil.keystoredefaultfile));
            conRow.put("keystorePass", (Object)EventlogpersUtil.keystorepassword);
        }
    }

    private JSONObject getNewSSLRowProperties(String https) throws JSONException {
        JSONObject conRow = new JSONObject();
        conRow.put("port", (Object)https);
        conRow.put("name", (Object)"SSL");
        conRow.put("maxThreads", (Object)"150");
        conRow.put("minSpareThreads", (Object)"25");
        conRow.put("maxSpareThreads", (Object)"75");
        conRow.put("enableLookups", (Object)"false");
        conRow.put("disableUploadTimeout", (Object)"true");
        conRow.put("acceptCount", (Object)"100");
        conRow.put("debug", (Object)"0");
        conRow.put("scheme", (Object)"https");
        conRow.put("secure", (Object)"true");
        conRow.put("clientAuth", (Object)"false");
        conRow.put("SSLProtocol", (Object)"TLSv1.1+TLSv1.2");
        conRow.put("emptySessionPath", (Object)"true");
        conRow.put("SSLEnabled", (Object)"true");
        conRow.put("connectionTimeout", (Object)"20000");
        conRow.put("ciphers", (Object)"TLS_RSA_WITH_AES_128_CBC_SHA,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA,TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384,TLS_DHE_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_RSA_WITH_AES_256_GCM_SHA384,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA256,TLS_DHE_RSA_WITH_AES_256_CBC_SHA256");
        return conRow;
    }

    private JSONObject defaultHttpRowProperties(String http, String redirectPort) throws JSONException {
        JSONObject conRow = new JSONObject();
        conRow.put("port", (Object)http);
        conRow.put("name", (Object)"WebServer");
        conRow.put("maxThreads", (Object)"150");
        conRow.put("minSpareThreads", (Object)"25");
        conRow.put("maxSpareThreads", (Object)"75");
        conRow.put("enableLookups", (Object)"false");
        conRow.put("disableUploadTimeout", (Object)"true");
        conRow.put("acceptCount", (Object)"100");
        conRow.put("scheme", (Object)"http");
        conRow.put("secure", (Object)"false");
        conRow.put("clientAuth", (Object)"false");
        conRow.put("SSLEnabled", (Object)"false");
        conRow.put("connectionTimeout", (Object)"20000");
        conRow.put("redirectPort", (Object)redirectPort);
        conRow.put("URIEncoding", (Object)"UTF-8");
        conRow.put("compressableMimeType", (Object)"text/html,text/xml");
        conRow.put("compression", (Object)"force");
        conRow.put("compressionMinSize", (Object)"1024");
        conRow.put("noCompressionUserAgents", (Object)"gozilla, traviata");
        conRow.put("protocol", (Object)"HTTP/1.1");
        return conRow;
    }
}

