/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.LaUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.la.util.SmtpMailer;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sa.server.util.DBUtil;
import com.adventnet.sa.server.util.SpaceCalculator;
import com.zoho.za.dae.utils.DAEUtils;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiskSpaceUtil {
    private static final Logger LOGGER = Logger.getLogger(DiskSpaceUtil.class.getName());
    public static final int RUN_NOW = 1;
    public static final int CONVERT_HOUR_TO_DAILY = 2;
    public static final int CONVERT_DAILY_TO_MONTHLY = 3;
    public static final String TABLE_NAME = "Eventlog_DiskSpaceHistory";
    private static boolean loadDataFromDisk = false;

    public static void callByCategory(int flag) {
        switch (flag) {
            case 1: {
                DiskSpaceUtil.startDiskspaceAnalysis();
                break;
            }
            case 2: {
                DiskSpaceUtil.convertHourlyDataToMonthlyData();
                break;
            }
            case 3: {
                DiskSpaceUtil.convertDailyDataTOMonthlyData();
                break;
            }
            default: {
                LOGGER.info("Invlid option called : " + flag);
            }
        }
    }

    public static Row getDiskUsageDetails(Long sec) {
        if (loadDataFromDisk) {
            return DiskSpaceUtil.getDiskSpaceDetails(sec);
        }
        return DiskSpaceUtil.getExistingDiskDetailsRow(sec);
    }

    public static synchronized void setDataCollectionFlag(boolean flag) {
        if (flag) {
            loadDataFromDisk = true;
        } else if (loadDataFromDisk) {
            loadDataFromDisk = false;
            new Thread(){

                @Override
                public void run() {
                    DiskSpaceUtil.startDiskspaceAnalysis();
                }
            }.start();
        }
    }

    private static Row getExistingDiskDetailsRow(Long sec) {
        try {
            LOGGER.info("Getting existing DataFrom DiskSpaceHistory");
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)TABLE_NAME));
            query.addSelectColumn(Column.getColumn((String)TABLE_NAME, (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)TABLE_NAME, (String)"ENTRY_TIME"), false));
            query.setRange(new Range(0, 1));
            query.setCriteria(new Criteria(Column.getColumn((String)TABLE_NAME, (String)"DATA_TYPE"), (Object)"HOURLY", 0));
            DataObject dobj = DataAccess.get((SelectQuery)query);
            if (!dobj.isEmpty()) {
                return dobj.getFirstRow(TABLE_NAME);
            }
        }
        catch (Exception exp) {
            LOGGER.info("Unable to find Existing Data");
        }
        LOGGER.info("No Data Found From DiskSpace History");
        return DiskSpaceUtil.getDiskSpaceDetails(sec);
    }

    private static void startDiskspaceAnalysis() {
        LOGGER.info("startDiskspaceAnalysis called");
        Row row = DiskSpaceUtil.getDiskSpaceDetails(300L);
        row.set("DATA_TYPE", (Object)"HOURLY");
        DBUtil.createNewRow(row, new boolean[0]);
        LOGGER.info("startDiskspaceAnalysis Completed");
    }

    public static void diskSpaceAlertNotification(Row r, Map diskDetailsMap) {
        ProductBundle bundle = ProductBundle.getInstance();
        String lowDiskAlert = (String)CommonUtil.getSysConfiguration("lowDiskAlert");
        String diskAlertStatus = (String)CommonUtil.getSysConfiguration("diskAlertStatus");
        if ((lowDiskAlert == null || "true".equals(lowDiskAlert)) && diskAlertStatus != null && !diskAlertStatus.equals("1")) {
            LOGGER.info("Low Disk space alert notification criteria matched");
            StringBuilder message = new StringBuilder();
            message.append(bundle.getString("DiskSpaceAlert.Message1") + " <br />");
            message.append(bundle.getString("DiskSpaceAlert.Message2") + " <br /><br />");
            DecimalFormat format = new DecimalFormat(".##");
            double remainingSpace = Double.parseDouble(format.format((Long)r.get("PRODUCT_DISK_SPACE_REMAINING") / 1024L / 1024L));
            double minDiskSpace = Double.parseDouble(System.getProperty("EC_diskSpace", "5.0"));
            if (remainingSpace < minDiskSpace && remainingSpace > 0.0) {
                message.append(bundle.getString("hostdetails.Name") + " : " + bundle.getString("NewTop.LocalDrive") + "<br />");
                message.append(bundle.getString("LowDisk.Drive") + " : " + diskDetailsMap.get("SERVER_DIR") + "<br />");
                message.append(bundle.getString("LowDisk.used") + " : " + diskDetailsMap.get("SERVER_USED_GB") + bundle.getString("elaconfig.lowdiskGB") + "<br />");
                message.append(bundle.getString("LowDisk.avail") + " " + diskDetailsMap.get("SERVER_FREE_GB") + bundle.getString("elaconfig.lowdiskGB") + "<br /><br />");
            }
            if (((Boolean)diskDetailsMap.get("DB_CHANGED")).booleanValue() && (Double)diskDetailsMap.get("DB_FREE_GB") < minDiskSpace) {
                message.append(bundle.getString("hostdetails.Name") + " : " + bundle.getString("settings.Database") + "<br />");
                message.append(bundle.getString("LowDisk.Drive") + " : " + diskDetailsMap.get("DB_DIR") + "<br />");
                message.append(bundle.getString("LowDisk.used") + " : " + diskDetailsMap.get("DB_USED_GB") + bundle.getString("elaconfig.lowdiskGB") + "<br />");
                message.append(bundle.getString("LowDisk.avail") + " " + diskDetailsMap.get("DB_FREE_GB") + bundle.getString("elaconfig.lowdiskGB") + "<br /><br />");
            }
            if (((Boolean)diskDetailsMap.get("ARCHIVE_CHANGED")).booleanValue() && Double.parseDouble(format.format((Long)r.get("ARCHIVE_DISK_SPACE_REMAINING") / 1024L / 1024L)) < minDiskSpace) {
                message.append(bundle.getString("hostdetails.Name") + " : " + bundle.getString("LowDisk.archive") + "<br />");
                message.append(bundle.getString("LowDisk.Drive") + " : " + diskDetailsMap.get("ARCHIVE_DIR") + "<br />");
                message.append(bundle.getString("LowDisk.used") + " : " + diskDetailsMap.get("ARCHIVE_USED_GB") + bundle.getString("elaconfig.lowdiskGB") + "<br />");
                message.append(bundle.getString("LowDisk.avail") + " " + diskDetailsMap.get("ARCHIVE_FREE_GB") + bundle.getString("elaconfig.lowdiskGB") + "<br /><br />");
            }
            if (((Boolean)diskDetailsMap.get("INDEX_CHANGED")).booleanValue() && Double.parseDouble(format.format((Long)r.get("INDEX_DISK_SPACE_REMAINING") / 1024L / 1024L)) < minDiskSpace) {
                message.append(bundle.getString("hostdetails.Name") + " : " + bundle.getString("LowDisk.rawIndex") + "<br />");
                message.append(bundle.getString("LowDisk.Drive") + " : " + diskDetailsMap.get("INDEX_DIR") + "<br />");
                message.append(bundle.getString("LowDisk.used") + " : " + diskDetailsMap.get("INDEX_USED_GB") + bundle.getString("elaconfig.lowdiskGB") + "<br />");
                message.append(bundle.getString("LowDisk.avail") + " : " + diskDetailsMap.get("INDEX_FREE_GB") + bundle.getString("elaconfig.lowdiskGB") + "<br /><br />");
            }
            message.append(bundle.getString("DiskSpaceAlert.Message4"));
            message.append(" " + minDiskSpace + bundle.getString("DiskSpaceAlert.Message5"));
            LOGGER.info("Low Disk space alert mail called with message : " + message);
            DiskSpaceUtil.sendNotification(message.toString());
        }
    }

    private static void sendNotification(String message) {
        ProductBundle bundle = ProductBundle.getInstance();
        Map mailServerSettings = null;
        Map<String, String> sysConfigurationDetails = null;
        try {
            String[] sysConf = new String[]{"DiskSpaceMailID", "DiskSpaceSubject"};
            mailServerSettings = LaUtil.getMailAttributes();
            sysConfigurationDetails = CommonUtil.getSysConfigurations(sysConf);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception occurred while fetching data from table");
            e.printStackTrace();
        }
        try {
            if (mailServerSettings != null) {
                SmtpMailer mailer;
                String mailresult;
                String from;
                String server = (String)mailServerSettings.get("SmtpServer");
                String port = (String)mailServerSettings.get("SmtpServerPort");
                String username = (String)mailServerSettings.get("uName");
                String password = (String)mailServerSettings.get("pWord");
                String to = from = (String)mailServerSettings.get("fromId");
                String tls = (String)mailServerSettings.get("tls");
                String subject = bundle.getString("DiskSpaceAlert.Subject");
                if (sysConfigurationDetails != null) {
                    String value;
                    if (sysConfigurationDetails.containsKey("DiskSpaceMailID") && !"".equals((value = sysConfigurationDetails.get("DiskSpaceMailID")).trim())) {
                        to = value.trim();
                    }
                    if (sysConfigurationDetails.containsKey("DiskSpaceSubject") && !"".equals((value = sysConfigurationDetails.get("DiskSpaceSubject")).trim())) {
                        subject = value.trim();
                    }
                }
                if ((mailresult = (mailer = new SmtpMailer(server, from, to, subject, null, username, password, port, tls)).sendMessage(message)) == null) {
                    DataObject dataObject = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"diskAlertStatus", 0));
                    Row r = dataObject.getFirstRow("SystemConfigurations");
                    r.set("CONF_VALUE", (Object)"1");
                    dataObject.updateRow(r);
                    DataAccess.update((DataObject)dataObject);
                    LOGGER.log(Level.INFO, "Disk Space Alert email sent successfully");
                } else {
                    LOGGER.log(Level.INFO, "Problem while sending Low Disk Alert Email");
                }
            } else {
                LOGGER.log(Level.INFO, "Mail Server Not configured and Disk space alert not sent");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception occurred while sending disk space alert email");
            e.printStackTrace();
        }
    }

    private static void convertDailyDataTOMonthlyData() {
        LOGGER.info("DiskSpaceMonitor Monthly data conversion called");
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)TABLE_NAME, (String)"DATA_TYPE"), (Object)"DAILY", 0);
            DataObject dobJ = DataAccess.get((String)TABLE_NAME, (Criteria)criteria);
            if (!dobJ.isEmpty()) {
                DiskSpaceUtil.findAverageSizeAndUpdate(dobJ, "MONTHLY", criteria);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        LOGGER.info("DiskSpaceMonitor Monthly data conversion Completed");
    }

    private static Row getDiskSpaceDetails(Long secs) {
        long time = System.currentTimeMillis();
        LOGGER.fine("DiskSpaceMonitor immediate Load call Invoked");
        LinkedHashMap<String, String> hasHMap = DiskSpaceUtil.collectFilesList();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Row row = new Row(TABLE_NAME);
        row.set("ENTRY_TIME", (Object)System.currentTimeMillis());
        for (Map.Entry<String, String> entryset : hasHMap.entrySet()) {
            File file;
            String columnName = entryset.getKey();
            if (columnName.endsWith("_DISK_TOTAL_SPACE")) {
                file = DiskSpaceUtil.getFileObject(entryset.getValue(), true);
                row.set(columnName, (Object)DiskSpaceUtil.callCustomTimerTask(executor, file, 2, secs));
                continue;
            }
            if (columnName.endsWith("_DISK_SPACE_REMAINING")) {
                file = DiskSpaceUtil.getFileObject(entryset.getValue(), true);
                row.set(columnName, (Object)DiskSpaceUtil.callCustomTimerTask(executor, file, 1, secs));
                continue;
            }
            file = DiskSpaceUtil.getFileObject(entryset.getValue(), false);
            row.set(columnName, (Object)DiskSpaceUtil.callCustomTimerTask(executor, file, 0, secs));
        }
        LOGGER.fine("DiskSpaceMonitor immediate Load call Exit  Time taken : " + (System.currentTimeMillis() - time));
        return row;
    }

    private static void convertHourlyDataToMonthlyData() {
        LOGGER.fine("DiskSpaceMonitor Daily Data Conversion called");
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)TABLE_NAME, (String)"DATA_TYPE"), (Object)"HOURLY", 0);
            DataObject dobJ = DataAccess.get((String)TABLE_NAME, (Criteria)criteria);
            if (!dobJ.isEmpty()) {
                DiskSpaceUtil.findAverageSizeAndUpdate(dobJ, "DAILY", criteria);
                DiskSpaceUtil.startDiskspaceAnalysis();
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        LOGGER.fine("DiskSpaceMonitor Daily Data Conversion Completed");
    }

    private static void findAverageSizeAndUpdate(DataObject dobJ, String dataType, Criteria criteria) throws DataAccessException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        String serverDir = System.getProperty("server.dir");
        String archiveLocation = CommonUtil.getArchiveLocation(serverDir);
        String indexLocation = DAEUtils.getESPath();
        Row row = new Row(TABLE_NAME);
        row.set("ENTRY_TIME", (Object)System.currentTimeMillis());
        row.set("PRODUCT_DIR_SIZE", (Object)DiskSpaceUtil.findAverage(dobJ, "PRODUCT_DIR_SIZE"));
        row.set("DATABASE_DIR_SIZE", (Object)DiskSpaceUtil.findAverage(dobJ, "DATABASE_DIR_SIZE"));
        row.set("DATA_DIR_SIZE", (Object)DiskSpaceUtil.findAverage(dobJ, "DATA_DIR_SIZE"));
        row.set("LOGS_DIR_SIZE", (Object)DiskSpaceUtil.findAverage(dobJ, "LOGS_DIR_SIZE"));
        row.set("ARCHIVE_DIR_SIZE", (Object)DiskSpaceUtil.findAverage(dobJ, "ARCHIVE_DIR_SIZE"));
        row.set("INDEX_DIR_SIZE", (Object)DiskSpaceUtil.findAverage(dobJ, "INDEX_DIR_SIZE"));
        DiskSpaceUtil.fillOrUpdateDiskSpace(row, executor, "PRODUCT", serverDir);
        if (archiveLocation != null) {
            DiskSpaceUtil.fillOrUpdateDiskSpace(row, executor, "ARCHIVE", archiveLocation);
        }
        if (indexLocation != null) {
            DiskSpaceUtil.fillOrUpdateDiskSpace(row, executor, "INDEX", indexLocation);
        }
        row.set("DATA_TYPE", (Object)dataType);
        DBUtil.deleteExistingRows(TABLE_NAME, criteria, new boolean[0]);
        DBUtil.createNewRow(row, new boolean[0]);
    }

    private static void fillOrUpdateDiskSpace(Row row, ExecutorService executor, String type, String location) {
        File file = DiskSpaceUtil.getFileObject(location, true);
        row.set(type + "_DISK_TOTAL_SPACE", (Object)DiskSpaceUtil.callTimerTask(executor, file, 2));
        row.set(type + "_DISK_SPACE_REMAINING", (Object)DiskSpaceUtil.callTimerTask(executor, file, 1));
    }

    private static File getFileObject(String location, boolean flag) {
        File file = new File(location);
        if (file.exists()) {
            return file;
        }
        if (flag && (file = file.getParentFile()).exists()) {
            return file;
        }
        return null;
    }

    private static Long callTimerTask(ExecutorService executor, File file, int flag) {
        if (file == null) {
            return 0L;
        }
        Future<Long> future = executor.submit(new SpaceCalculator(file, flag));
        try {
            return future.get(5L, TimeUnit.MINUTES);
        }
        catch (Exception exp) {
            LOGGER.info("Exception in Min Timer task, Time : 5 minutes and Exception details : " + exp.getMessage());
            return 0L;
        }
    }

    private static Long callCustomTimerTask(ExecutorService executor, File file, int flag, Long sec) {
        if (file == null) {
            return 0L;
        }
        Future<Long> future = executor.submit(new SpaceCalculator(file, flag));
        try {
            return future.get(sec, TimeUnit.SECONDS);
        }
        catch (Exception exp) {
            LOGGER.info("Exception in Timer task, Time :" + sec + " seconds and  Exception details : " + exp.getMessage());
            return 0L;
        }
    }

    private static Long findAverage(DataObject dobJ, String columnName) throws DataAccessException {
        Long size = 0L;
        Long index = 0L;
        Iterator itr = dobJ.getRows(TABLE_NAME);
        while (itr.hasNext()) {
            Long fileSize;
            Row row = (Row)itr.next();
            if (row.get(columnName) == null || (fileSize = (Long)row.get(columnName)) == null || fileSize == 0L) continue;
            size = size + fileSize;
            Long l = index;
            Long l2 = index = Long.valueOf(index + 1L);
        }
        if (size != 0L && index != 0L) {
            size = size / index;
        }
        return size;
    }

    private static LinkedHashMap<String, String> collectFilesList() {
        LinkedHashMap<String, String> hasHMap = new LinkedHashMap<String, String>();
        String homeDir = System.getProperty("server.dir");
        String dbHomeDir = System.getProperty("db.home");
        String archiveLocation = CommonUtil.getArchiveLocation(homeDir);
        String indexLocation = DAEUtils.getESPath();
        hasHMap.put("PRODUCT_DISK_TOTAL_SPACE", homeDir);
        hasHMap.put("PRODUCT_DISK_SPACE_REMAINING", homeDir);
        hasHMap.put("PRODUCT_DIR_SIZE", homeDir);
        hasHMap.put("DATABASE_DIR_SIZE", dbHomeDir);
        hasHMap.put("DATA_DIR_SIZE", homeDir + File.separator + "data");
        hasHMap.put("LOGS_DIR_SIZE", homeDir + File.separator + "logs");
        if (archiveLocation != null) {
            hasHMap.put("ARCHIVE_DIR_SIZE", archiveLocation);
            hasHMap.put("ARCHIVE_DISK_TOTAL_SPACE", archiveLocation);
            hasHMap.put("ARCHIVE_DISK_SPACE_REMAINING", archiveLocation);
        }
        if (indexLocation != null) {
            hasHMap.put("INDEX_DIR_SIZE", indexLocation);
            hasHMap.put("INDEX_DISK_TOTAL_SPACE", indexLocation);
            hasHMap.put("INDEX_DISK_SPACE_REMAINING", indexLocation);
        }
        return hasHMap;
    }
}

