/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.sa.server.EAService;
import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.adventnet.sa.server.dbsync.domain.DomainSyncHandler;
import com.adventnet.sa.server.lc.VCenterTaskScheduler;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sa.server.util.DBUtil;
import com.adventnet.sym.winaccess.InstallAgentThread;
import com.manageengine.ads.fw.dbsync.DBSynchronizer;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.config.technician.TechnicianUtil;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.management.AddOrUpdateEventlogDevice;
import com.manageengine.ela.server.common.executors.processor.extended.CommonFixedThreadExecutor;
import com.manageengine.ela.server.common.executors.queue.priority.PriorityQueueFieldRunnable;
import com.manageengine.ela.server.common.handlers.domain.DomainHandler;
import com.manageengine.ela.server.common.license.ProductsAndComponents;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import com.manageengine.ela.server.common.util.Priority;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class HostDBHandler {
    private static final Logger LOGGER = Logger.getLogger(HostDBHandler.class.getName());
    public static Long windowsGroupId = new Long(2L);
    private static Persistence persistence = PersistenceDBUtil.getPersistence();
    public static HashMap<Long, HashMap<String, String>> hostNameVsTypeMap = new HashMap();

    public static void addNewEventlogHost(String name, String dns_name, Long domainID, String seqNumber, String hostType, int hostStatus, boolean isInherited) throws Exception {
        JSONObject deviceDetails = new JSONObject();
        deviceDetails.put("NAME", (Object)InetAddressHandler.getNameFromFQDN(name));
        deviceDetails.put("FQDN", (Object)dns_name);
        JSONObject properties = new JSONObject();
        properties.put("SOURCE_PRODUCT", (Object)seqNumber);
        properties.put("DEVICE_TYPE", (Object)hostType);
        properties.put("STATUS", hostStatus);
        properties.put("DOMAIN_ID", (Object)domainID);
        properties.put("IS_INHERITED", isInherited);
        properties.put("DEVICE_SOURCE_ID", 7);
        properties.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.WINDOWS);
        properties.put("CUSTOM_DEVICE_DETAILS", (Object)deviceDetails);
        AddOrUpdateEventlogDevice.addDevice(properties, new ResponseBuilder(), TechnicianUtil.getDefaultAdminUserID(), true);
    }

    public static boolean deleteHostsCache(Long hostID) {
        try {
            if (hostNameVsTypeMap.containsKey(hostID)) {
                hostNameVsTypeMap.remove(hostID);
            }
            LOGGER.info("Successfully deleted hostCache : " + hostID);
            return true;
        }
        catch (Exception exp) {
            LOGGER.info("Unable to Delete HostCache for hostID : " + hostID);
            exp.printStackTrace();
            return false;
        }
    }

    public static boolean addOrUpdateHostsCache(DataObject dobj) throws DataAccessException {
        boolean result = true;
        Iterator hItr = null;
        Iterator htItr = null;
        try {
            hItr = dobj.getRows("Hosts");
            htItr = dobj.getRows("HostDetails");
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
        if (hItr == null || htItr == null) {
            return false;
        }
        while (hItr.hasNext() && htItr.hasNext()) {
            try {
                Row hostRow = (Row)hItr.next();
                Row hostDetails = (Row)htItr.next();
                if (hostRow.get("HOST_ID") instanceof UniqueValueHolder) {
                    DataAccess.generateValues((Row)hostRow);
                }
                Long hostID = (Long)hostRow.get("HOST_ID");
                LOGGER.fine("HostID derived from Row   ref.ID: " + hostID);
                if (!"Windows".equalsIgnoreCase((String)hostDetails.get("TYPE"))) {
                    LOGGER.info("Skipping non-windows host   ref.ID: " + hostID);
                    return false;
                }
                HashMap<String, String> hostMap = new HashMap<String, String>();
                hostMap.put("HOST_NAME", (String)hostRow.get("HOST_NAME"));
                hostMap.put("TYPE", (String)hostDetails.get("TYPE"));
                if (hostDetails.get("LOG_COLLECTION_STATUS") != null) {
                    hostMap.put("LOG_COLLECTION_STATUS", hostDetails.get("LOG_COLLECTION_STATUS").toString());
                }
                if (hostDetails.get("DOMAIN_ID") != null) {
                    hostMap.put("DOMAIN_NAME", DomainHandler.getDomainName((Long)hostDetails.get("DOMAIN_ID")));
                } else if (hostDetails.get("DOMAIN_NAME") != null) {
                    hostMap.put("DOMAIN_NAME", (String)hostDetails.get("DOMAIN_NAME"));
                }
                hostNameVsTypeMap.put(hostID, hostMap);
            }
            catch (Exception exp) {
                result = false;
                LOGGER.info("#### unable to add HostCache for DO : " + dobj);
                exp.printStackTrace();
            }
        }
        return result;
    }

    public static Long getDomainID(String domainName) throws Exception {
        JSONObject jsop = ADSDomainHandler.getDomainDetails((String)domainName);
        if (jsop == null || jsop.length() == 0 || jsop.isNull("DOMAIN_ID")) {
            LOGGER.info("Unknown inherited Host  Domain not Found in DomainCOnfiguration : " + domainName);
            return null;
        }
        return jsop.getLong("DOMAIN_ID");
    }

    public static boolean deleteHost(Properties hostProp) throws Exception {
        Long hostId = null;
        if (hostProp.containsKey("ELA_HOST_ID")) {
            hostId = (Long)hostProp.get("ELA_HOST_ID");
        } else if (hostProp.containsKey("NAME") && hostProp.containsKey("DOMAIN_NAME")) {
            hostId = HostDBHandler.getHostId(hostProp);
        }
        if (hostId == null) {
            LOGGER.info("Host Not found : " + hostProp);
            return false;
        }
        DataObject doo = persistence.get("SLUPDATE", new Criteria(Column.getColumn((String)"SLUPDATE", (String)"SERVICEID"), (Object)hostId, 0));
        Iterator itr = doo.getRows("SLUPDATE");
        while (itr.hasNext()) {
            Row slRow = (Row)itr.next();
            persistence.delete(slRow);
        }
        boolean deleteInherited = true;
        DataObject hostDO = HostDBHandler.getDeleteDataObject(hostId.toString(), deleteInherited);
        Row r1 = null;
        Row hRow = hostDO.getRow("Hosts");
        String dns_name = (String)hRow.get("DNS_NAME");
        Row hdRow = hostDO.getRow("HostDetails", new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)hostId, 0));
        Long slid = (Long)hdRow.get("SLID");
        Row slRow = hostDO.getRow("SyslogServers", new Criteria(Column.getColumn((String)"SyslogServers", (String)"SLID"), (Object)slid, 0));
        if (slRow != null && "-".equals((String)slRow.get("PORTS"))) {
            HashMap agentDetails = new HashMap();
            HostDBHandler.populateAgentDetails(agentDetails, slid, hdRow, slRow);
            HostDBHandler.updateAgentSLId(slid, HostDBHandler.getSLID(), "HOSTDELETE");
            InstallAgentThread uninstallAgent = new InstallAgentThread(agentDetails, false);
            uninstallAgent.start();
            Row agentRow = new Row("SyslogServers");
            agentRow.set("SLID", (Object)slid);
            persistence.delete(agentRow);
        }
        HostDBHandler.deleteNotifications(hostId, dns_name);
        HostDBHandler.deleteFilters(dns_name, hostId);
        HostDBHandler.deleteApplicationsEnteries(hostId);
        HostDBHandler.deleteAddOnEnteries(dns_name, hostId);
        r1 = new Row("Hosts");
        r1.set("HOST_ID", (Object)hostId);
        persistence.delete(r1);
        HostDBHandler.slupdateForDelete(slid, hostId);
        persistence.delete(new Criteria(Column.getColumn((String)"LogCollectionAlert", (String)"HOST_ID"), (Object)hostId, 0));
        return true;
    }

    public static void updateHost(DataObject normalDevice, Row row, Integer status, boolean ... flag) throws Exception {
        Long hostId = (Long)row.get("HOST_ID");
        row.set("LOG_COLLECTION_STATUS", (Object)status);
        normalDevice.updateRow(row);
        DBUtil.updateDataObject(normalDevice, flag);
        HostDBHandler.slupdateForEnableDisable(hostId, status);
    }

    public static Long getHostId(Properties hostProp) throws Exception {
        String domainName;
        String hostName = hostProp.getProperty("NAME");
        DataObject doo = HostDBHandler.getHostDO(hostName, domainName = hostProp.getProperty("DOMAIN_NAME"));
        Row row = doo.getFirstRow("HostDetails");
        if (row == null) {
            return null;
        }
        return (Long)row.get("HOST_ID");
    }

    public static Long getHostId(DataObject dobj, String domainName) throws Exception {
        Row row = HostDBHandler.getHostDetailsRow(dobj, domainName);
        if (row == null) {
            return null;
        }
        return (Long)row.get("HOST_ID");
    }

    public static Row getHostDetailsRow(DataObject doo, String domainName) throws DataAccessException {
        if (!doo.isEmpty() && doo.containsTable("HostDetails")) {
            Criteria crit = new Criteria(Column.getColumn((String)"HostDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            return doo.getRow("HostDetails", crit);
        }
        return null;
    }

    public static Row getHostDetailsRow(Long host_id) throws DataAccessException {
        DataObject doo = HostDBHandler.getHostDetailsDO(host_id);
        if (!doo.isEmpty() && doo.containsTable("HostDetails")) {
            return doo.getFirstRow("HostDetails");
        }
        return null;
    }

    public static Row getSyncedDeviceDetailsRow(DataObject doo, String deviceName) throws DataAccessException {
        if (!doo.isEmpty()) {
            Criteria crit = HostDBHandler.getDeviceCriteria(deviceName);
            crit = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), doo.getRow("Hosts", crit).get("HOST_ID"), 0);
            return doo.getRow("HostDetails", crit);
        }
        LOGGER.info("Unable to find HostDetails row for : " + deviceName);
        return null;
    }

    public static Row getHostDetailsRow(DataObject doo, String domainName, String hostName) throws DataAccessException {
        if (!doo.isEmpty()) {
            Criteria crit = HostDBHandler.getDeviceCriteria(hostName);
            Iterator itr = doo.getRows("Hosts", crit);
            while (itr.hasNext()) {
                Row hostRow = (Row)itr.next();
                crit = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), hostRow.get("HOST_ID"), 0);
                Row hostdetailsRow = doo.getRow("HostDetails", crit);
                String domainname = hostdetailsRow != null ? (String)hostdetailsRow.get("DOMAIN_NAME") : null;
                if (domainname == null || !domainname.equalsIgnoreCase(domainName)) continue;
                return hostdetailsRow;
            }
            LOGGER.info("Unable to find HostDetails row for : " + hostName + "  With domain : " + domainName);
        }
        return null;
    }

    public static Row getHostDetailsRow(DataObject dobj) {
        try {
            return dobj.getFirstRow("HostDetails");
        }
        catch (Exception exp) {
            LOGGER.info("Unable to find Hostdetails Row");
            return null;
        }
    }

    public static DataObject getInheritedDeviceDO(String deviceName, String domainName) throws DataAccessException {
        Row domainDetailsRow = DomainSyncHandler.getDomainDetailsRow(domainName);
        if (domainDetailsRow != null) {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("Hosts");
            tableList.add("HostDetails");
            tableList.add(ADSDomainHandler.tableName);
            Criteria mainCriteria = HostDBHandler.getDeviceCriteria(deviceName);
            mainCriteria = mainCriteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"DOMAIN_ID"), domainDetailsRow.get("DOMAIN_ID"), 0));
            return persistence.get(tableList, mainCriteria);
        }
        return null;
    }

    public static DataObject getHostDO(String hostName, String domainName) throws DataAccessException {
        Row domainDetailsRow = DomainSyncHandler.getDomainDetailsRow(domainName);
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("Hosts");
        tableList.add("HostDetails");
        Criteria mainCriteria = HostDBHandler.getDeviceCriteria(hostName);
        mainCriteria = domainDetailsRow != null ? mainCriteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"DOMAIN_ID"), domainDetailsRow.get("DOMAIN_ID"), 0)) : mainCriteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0, false));
        DataObject doo = persistence.get(tableList, mainCriteria);
        return doo;
    }

    public static Criteria getDeviceCriteria(String deviceName) {
        Criteria mainCriteria = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_NAME"), (Object)deviceName, 0);
        mainCriteria = mainCriteria.or(new Criteria(Column.getColumn((String)"Hosts", (String)"DNS_NAME"), (Object)deviceName, 0));
        mainCriteria = mainCriteria.or(new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_IPADDRESS"), (Object)deviceName, 0));
        mainCriteria = mainCriteria.or(new Criteria(Column.getColumn((String)"Hosts", (String)"DNS_FULLNAME"), (Object)deviceName, 0));
        return mainCriteria;
    }

    public static Row getHostDetailsRow(String hostName) throws DataAccessException {
        DataObject doo = persistence.get("Hosts", HostDBHandler.getDeviceCriteria(hostName));
        return doo.getFirstRow("Hosts");
    }

    public static DataObject getHostDetailsDO(String hostName) throws DataAccessException {
        return persistence.get(Arrays.asList("Hosts", "HostDetails"), HostDBHandler.getDeviceCriteria(hostName));
    }

    public static DataObject getHostDetailsDO(Long host_id) throws DataAccessException {
        Criteria crit = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)host_id, 0);
        return persistence.get(Arrays.asList("Hosts", "HostDetails"), crit);
    }

    public static Long getSLID() {
        Long slid = ServerDetailsBean.getInstance().getSysEvtColID();
        return slid != null ? slid : 1L;
    }

    public static void updateAgentSLId(Long agentId, Long slid, String sysevtaction) throws Exception {
        try {
            LOGGER.log(Level.INFO, " Deleting Agent from SyslogServers : {0}", agentId);
            DataObject doo = persistence.get("SyslogServers", new Criteria(Column.getColumn((String)"SyslogServers", (String)"SLID"), (Object)agentId, 0));
            Row slRow = doo.getFirstRow("SyslogServers");
            persistence.delete(slRow);
            Table hTable = Table.getTable((String)"HostDetails");
            SelectQueryImpl sql = new SelectQueryImpl(hTable);
            sql.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"*"));
            sql.setCriteria(new Criteria(Column.getColumn((String)"HostDetails", (String)"SLID"), (Object)agentId, 0));
            DataObject db = persistence.get((SelectQuery)sql);
            Iterator it = db.getRows("HostDetails");
            while (it.hasNext()) {
                Row hdRow = (Row)it.next();
                hdRow.set("SLID", (Object)slid);
                db.updateRow(hdRow);
                Row slUpdate = new Row("SLUPDATE");
                slUpdate.set("SLID", (Object)slid);
                slUpdate.set("SERVICETYPE", (Object)EAService.getSLUpdateConstant(sysevtaction));
                slUpdate.set("SERVICEID", (Object)((Long)hdRow.get("HOST_ID")));
                db.addRow(slUpdate);
            }
            persistence.update(db);
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Exception While updating SLID ::::::" + ex);
            ex.printStackTrace();
        }
    }

    public static Long getSLID(Long hostId) throws Exception {
        Criteria c = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)hostId, 0);
        DataObject doo = persistence.get("HostDetails", c);
        if (doo.size("HostDetails") > 0) {
            return (Long)doo.getFirstValue("HostDetails", "SLID");
        }
        return HostDBHandler.getSLID();
    }

    public static void addLogCollectionEntry(Row hostRow, Long id) throws Exception {
        HostDBHandler.addLogCollectionEntry((Long)hostRow.get("HOST_ID"), id);
    }

    public static void addLogCollectionEntry(Long hostID, Long id) throws Exception {
        SelectQueryImpl sqlQuery = new SelectQueryImpl(Table.getTable((String)"LogCollectionAlert"));
        sqlQuery.addSelectColumn(Column.getColumn((String)"LogCollectionAlert", (String)"*"));
        sqlQuery.setCriteria(new Criteria(Column.getColumn((String)"LogCollectionAlert", (String)"GROUPID"), (Object)id, 0));
        DataObject doo = persistence.get((SelectQuery)sqlQuery);
        if (doo.size("LogCollectionAlert") > 0) {
            Row newhid = new Row("LogCollectionAlert");
            newhid.set("HOST_ID", (Object)hostID);
            newhid.set("STATUS", (Object)new Integer(0));
            newhid.set("GROUPID", (Object)id);
            doo.addRow(newhid);
            persistence.update(doo);
        }
    }

    public static HashMap populateAgentDetails(HashMap agentDetails, Long slid, Row hdRow, Row slRow) throws Exception {
        agentDetails.put("SLID", slid.toString());
        agentDetails.put("HostName", (String)slRow.get("HOST_NAME"));
        agentDetails.put("UserName", (String)hdRow.get("USERNAME"));
        agentDetails.put("Password", (String)hdRow.get("PASSWORD"));
        HashMap<String, String> map = CommonUtil.findHostCredentialDetails(hdRow);
        agentDetails.put("UserName", map.get("USERNAME"));
        agentDetails.put("Password", map.get("PASSWORD"));
        agentDetails.put("DomainName", map.get("DOMAIN_NAME"));
        return agentDetails;
    }

    public static DataObject getDeleteDataObject(String hostIds, boolean ... flag) throws Exception {
        SelectQueryImpl hostSql = new SelectQueryImpl(Table.getTable((String)"Hosts"));
        hostSql.addSelectColumn(Column.getColumn(null, (String)"*"));
        hostSql.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 1));
        hostSql.addJoin(new Join("Hosts", "SyslogServers", new String[]{"HOST_NAME"}, new String[]{"HOST_NAME"}, 1));
        Criteria criteria = null;
        if (flag.length > 0 && flag[0]) {
            criteria = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)hostIds.split(","), 8);
        } else {
            Criteria crit = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)hostIds.split(","), 8);
            criteria = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"ISINHERITED"), (Object)new Integer(0), 0));
        }
        hostSql.setCriteria(criteria);
        DataObject hostDO = persistence.get((SelectQuery)hostSql);
        return hostDO;
    }

    public static DataObject getDeleteDataObject(Long[] hostIds, boolean ... flag) throws Exception {
        SelectQueryImpl hostSql = new SelectQueryImpl(Table.getTable((String)"Hosts"));
        hostSql.addSelectColumn(Column.getColumn(null, (String)"*"));
        hostSql.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 1));
        hostSql.addJoin(new Join("Hosts", "SyslogServers", new String[]{"HOST_NAME"}, new String[]{"HOST_NAME"}, 1));
        Criteria criteria = null;
        if (flag.length > 0 && flag[0]) {
            criteria = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)hostIds, 8);
        } else {
            Criteria crit = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)hostIds, 8);
            criteria = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"ISINHERITED"), (Object)new Integer(0), 0));
        }
        hostSql.setCriteria(criteria);
        DataObject hostDO = persistence.get((SelectQuery)hostSql);
        return hostDO;
    }

    public static void deleteNotifications(Long hostId, String dns_name) throws Exception {
        Row row;
        Row r2;
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"HostNotification"));
        sql.addSelectColumn(Column.getColumn(null, (String)"*"));
        String[] columns = new String[]{"NOTIFID"};
        sql.addJoin(new Join("HostNotification", "NotfnConfiguration", columns, columns, 1));
        sql.addJoin(new Join("HostNotification", "NotificationType", columns, columns, 1));
        sql.setCriteria(new Criteria(Column.getColumn((String)"HostNotification", (String)"HOSTID"), (Object)hostId, 0));
        DataObject doo = persistence.get((SelectQuery)sql);
        Iterator itr = doo.getRows("HostNotification");
        while (itr.hasNext()) {
            Row r22 = (Row)itr.next();
            Long notifid = (Long)r22.get("NOTIFID");
            Long hostid = (Long)r22.get("HOSTID");
            NotificationManager.getInstance().removeConfiguredHost(notifid, hostid);
            persistence.delete(r22);
        }
        SelectQueryImpl squel = new SelectQueryImpl(Table.getTable((String)"LACriteria"));
        squel.addSelectColumn(Column.getColumn((String)"LACriteria", (String)"*"));
        squel.setCriteria(new Criteria(Column.getColumn((String)"LACriteria", (String)"CRITERIA_NAME"), (Object)dns_name, 0));
        DataObject dob = persistence.get((SelectQuery)squel);
        Iterator iter = null;
        itr = doo.getRows("NotfnConfiguration");
        while (itr.hasNext()) {
            r2 = (Row)itr.next();
            iter = dob.getRows("LACriteria");
            while (iter.hasNext()) {
                row = (Row)itr.next();
                if (r2.get("NOTIFID") != row.get("CRIT_ID")) continue;
                persistence.delete(r2);
            }
        }
        itr = doo.getRows("NotificationType");
        while (itr.hasNext()) {
            r2 = (Row)itr.next();
            iter = dob.getRows("LACriteria");
            while (iter.hasNext()) {
                row = (Row)itr.next();
                if (r2.get("NOTIFID") != row.get("CRIT_ID")) continue;
                persistence.delete(r2);
            }
        }
        persistence.delete(new Criteria(Column.getColumn((String)"LACriteria", (String)"CRITERIA_NAME"), (Object)dns_name, 0));
    }

    public static void deleteFilters(String dns_name, Long hostId) throws Exception {
        Column col = Column.getColumn((String)"Filters", (String)"FILTERNAME");
        String filName_unix = dns_name + "_Profile_SysTime";
        String filName_win = dns_name + "_Profile_EvtTime";
        Criteria cri = new Criteria(col, (Object)filName_win, 0).or(col, (Object)filName_unix, 0);
        persistence.delete(cri);
        Criteria cr = new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"HOST_NAME", 0).and(Column.getColumn((String)"LAExpression", (String)"VALUE"), (Object)dns_name, 0);
        persistence.delete(cr);
        cr = new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"HOST_NAME", 0).and(Column.getColumn((String)"LAExpression", (String)"VALUE"), (Object)("" + hostId), 0);
        persistence.delete(cr);
        cr = new Criteria(Column.getColumn((String)"ReportConfig", (String)"PROFILENAME"), (Object)(dns_name + "_Profile"), 0);
        persistence.delete(cr);
    }

    public static void deleteHostArchiveEntries(Long hostId, String hostName) throws Exception {
        persistence.delete(new Criteria(Column.getColumn((String)"SysArchivedFiles", (String)"HOST_ID"), (Object)hostId, 0));
        persistence.delete(new Criteria(Column.getColumn((String)"ArchiveFlatFiles", (String)"HOST_ID"), (Object)hostId, 0));
        ArchiveFileManager.getInstance().deleteDeviceArchiveHandler(hostName);
    }

    public static void deleteApplicationsEnteries(Long hostId) throws Exception {
        Criteria cr = new Criteria(Column.getColumn((String)"ImportedLogs", (String)"HOST_ID"), (Object)hostId, 0);
        persistence.delete(cr);
        cr = new Criteria(Column.getColumn((String)"AppResources", (String)"HOSTID"), (Object)hostId, 0);
        DataObject dataObject = persistence.get("AppResources", cr);
        Long[] appIds = null;
        if (dataObject.size("AppResources") > 0) {
            appIds = new Long[dataObject.size("AppResources")];
            int i = 0;
            Iterator iterator = dataObject.getRows("AppResources");
            while (iterator.hasNext()) {
                Row row2 = (Row)iterator.next();
                appIds[i++] = (Long)row2.get("APPID");
            }
            LOGGER.info("Deleting the application with host id " + hostId);
            PersistenceDBUtil.getPersistence().delete(cr);
            cr = new Criteria(Column.getColumn((String)"ImportedAppLogs", (String)"APPID"), (Object)appIds, 8);
            persistence.delete(cr);
            cr = new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"APPID", 0).and(Column.getColumn((String)"LAExpression", (String)"VALUE"), (Object)appIds, 8);
            persistence.delete(cr);
        }
    }

    public static void deleteAddOnEnteries(String dns_name, Long hostId) throws Exception {
        Criteria cr = new Criteria(Column.getColumn((String)"SyslogAddons", (String)"HOSTID"), (Object)hostId, 0);
        persistence.delete(cr);
        cr = new Criteria(Column.getColumn((String)"VulnAppDetails", (String)"HOSTID"), (Object)hostId, 0);
        persistence.delete(cr);
        try {
            SelectQueryImpl hostSelectSql = new SelectQueryImpl(Table.getTable((String)"AddOnHosts"));
            hostSelectSql.addSelectColumn(Column.getColumn((String)"AddOnHosts", (String)"*"));
            hostSelectSql.addSelectColumn(Column.getColumn((String)"AddOnHostDetails", (String)"*"));
            hostSelectSql.addJoin(new Join("AddOnHosts", "AddOnHostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 1));
            hostSelectSql.setCriteria(new Criteria(Column.getColumn((String)"AddOnHosts", (String)"HOSTID"), (Object)hostId, 0));
            DataObject dobj = persistence.get((SelectQuery)hostSelectSql);
            Iterator it = dobj.getRows("AddOnHostDetails");
            while (it.hasNext()) {
                Row rows = (Row)it.next();
                String hostGrp = (String)rows.get("HOST_TYPE");
                Long addOnHostId = (Long)rows.get("HOST_ID");
                if ("vCenter".equals(hostGrp)) {
                    VCenterTaskScheduler.clearCache(dns_name);
                    DataAccess.delete((String)"Schedule", (Criteria)new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)(dns_name + "_vCenterSchedule"), 0));
                }
                cr = new Criteria(Column.getColumn((String)"AddOnHosts", (String)"HOST_ID"), (Object)addOnHostId, 0);
                persistence.delete(cr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void slupdateForDelete(Long slid, Long hostId) throws Exception {
        HostDBHandler.addSlUpdateRow(hostId, HostDBHandler.getServiceType(CommonUtil.SlUpdateConstants.HOSTDELETE));
    }

    public static Row getSLUpdateRow(Row hostDetails, int status) {
        Long serviceType = HostDBHandler.getServiceTypeEnableDisable(status);
        Long deviceID = (Long)hostDetails.get("HOST_ID");
        Long slid = (Long)hostDetails.get("SLID");
        if (slid == null) {
            slid = HostDBHandler.getSLID();
        }
        return HostDBHandler.getSlUpdateRow(deviceID, serviceType, slid);
    }

    public static Long getServiceTypeEnableDisable(int status) {
        if (status == 1) {
            return HostDBHandler.getServiceType(CommonUtil.SlUpdateConstants.HOSTENABLE);
        }
        if (status == 2) {
            return HostDBHandler.getServiceType(CommonUtil.SlUpdateConstants.SCANNOW);
        }
        return HostDBHandler.getServiceType(CommonUtil.SlUpdateConstants.HOSTDISABLE);
    }

    public static Long getServiceType(CommonUtil.SlUpdateConstants constant) {
        switch (constant) {
            case HOSTDISABLE: {
                return EAService.getSLUpdateConstant("HOSTDISABLE");
            }
            case HOSTENABLE: {
                return EAService.getSLUpdateConstant("HOSTENABLE");
            }
            case SCANNOW: {
                return EAService.getSLUpdateConstant("SCANNOW");
            }
            case HOSTADD: {
                return EAService.getSLUpdateConstant("HOSTADD");
            }
            case HOSTDELETE: {
                return EAService.getSLUpdateConstant("HOSTDELETE");
            }
            case HOSTUPDATE: {
                return EAService.getSLUpdateConstant("HOSTUPDATE");
            }
            case DOMAIN: {
                return EAService.getSLUpdateConstant("DOMAIN");
            }
            case WORKGROUP: {
                return EAService.getSLUpdateConstant("WORKGROUP");
            }
            case LOGLEVEL: {
                return EAService.getSLUpdateConstant("LOGLEVEL");
            }
            case SECSTATUS: {
                return EAService.getSLUpdateConstant("SECSTATUS");
            }
        }
        return null;
    }

    public static void slupdateForEnableDisable(Long hostId, int status) {
        Long type = HostDBHandler.getServiceTypeEnableDisable(status);
        try {
            HostDBHandler.addSlUpdateRow(hostId, type);
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Unable to update slupdateRow please Note this  host_id : " + hostId + "  status : " + status);
        }
    }

    public static boolean addSlUpdateRow(Long hostId, Long serviceType) throws Exception {
        Long slID = HostDBHandler.getSLID(hostId);
        return HostDBHandler.addSlUpdateRow(hostId, serviceType, slID);
    }

    public static boolean deleteSLUpdateServiceID(String ... hostId) {
        boolean result = false;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SLUPDATE", (String)"SERVICEID"), (Object)hostId, 8);
            DBUtil.deleteExistingRows("SLUPDATE", crit, true);
            result = true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return result;
    }

    public static boolean deleteSLUpdateServiceID(Long[] hostId) {
        boolean result = false;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SLUPDATE", (String)"SERVICEID"), (Object)hostId, 8);
            DBUtil.deleteExistingRows("SLUPDATE", crit, true);
            result = true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return result;
    }

    public static boolean addSlUpdateRow(Long hostId, Long serviceType, Long slid) {
        boolean result = false;
        try {
            Row slUpdate = HostDBHandler.getSlUpdateRow(hostId, serviceType, slid);
            DBUtil.createNewRow(slUpdate, true);
            result = true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return result;
    }

    public static Row getSlUpdateRow(Long hostId, Long serviceType, Long slid) {
        Row slUpdate = new Row("SLUPDATE");
        slUpdate.set("SLID", (Object)slid);
        slUpdate.set("SERVICEID", (Object)hostId);
        slUpdate.set("SERVICETYPE", (Object)serviceType);
        return slUpdate;
    }

    public static int getEabledWindowsDeviceCount(int type) {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"HostDetails"));
        query.addSelectColumn(Column.getColumn(null, (String)"*").count());
        Criteria crit = new Criteria(Column.getColumn((String)"HostDetails", (String)"LOG_COLLECTION_STATUS"), (Object)0, 1);
        crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"ISINHERITED"), (Object)0, 0));
        crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)"Windows", 0));
        if (type == 1) {
            crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"SUBTYPE"), (Object)"*WKS*", 3));
        } else if (type == 2) {
            crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"SUBTYPE"), (Object)"*WKS*", 2));
        }
        query.setCriteria(crit);
        return DBUtil.getTotalIntCount((SelectQuery)query);
    }

    public static Integer getEabledELAHostCount(boolean isServerAlone) {
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"HostDetails"));
            query.addSelectColumn(Column.getColumn(null, (String)"*").count());
            Criteria crit = new Criteria(Column.getColumn((String)"HostDetails", (String)"LOG_COLLECTION_STATUS"), (Object)0, 1);
            crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"ISINHERITED"), (Object)0, 0));
            if (isServerAlone) {
                crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"SUBTYPE"), (Object)"*WKS*", 3));
            }
            query.setCriteria(crit);
            return DBUtil.getTotalIntCount((SelectQuery)query);
        }
        catch (Exception exp) {
            LOGGER.info("Exception while getting total host Count details : " + exp.getMessage());
            return -1;
        }
    }

    public static Object getParentProductSeqNumber() throws DataAccessException {
        Criteria crit = new Criteria(Column.getColumn((String)"ADSProductParams", (String)"PARAM_NAME"), (Object)"PARENT_APP_SEQNO", 0);
        DataObject dobj = com.manageengine.ads.fw.util.CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSProductParams", crit);
        if (!dobj.isEmpty()) {
            return dobj.getFirstValue("ADSProductParams", "PARAM_VALUE");
        }
        return null;
    }

    public static synchronized void synchronizeNow(final String message, boolean directCall) {
        try {
            if (com.manageengine.ads.fw.util.CommonUtil.isProductIntegrated((String)ProductsAndComponents.LOG360.getProductName())) {
                LOGGER.log(Level.INFO, "Calling Synchronize , " + message);
                CommonFixedThreadExecutor.getInstance().execute(new PriorityQueueFieldRunnable(Priority.MEDIUM){

                    @Override
                    public void run() {
                        LOGGER.info("Triggered from wait state for syn : " + message);
                        DBSynchronizer.syncWithSubscribers();
                    }
                });
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static void reloadHoastCache() throws DataAccessException {
        hostNameVsTypeMap.clear();
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("Hosts");
        tableList.add("HostDetails");
        DataObject dobj = persistence.get(tableList, new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)"Windows", 0));
        HostDBHandler.addOrUpdateHostsCache(dobj);
    }

    public static boolean isLocalDevice(String hostName, String domainName) {
        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"Hosts"));
        sq.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 1));
        Column col = Column.getColumn((String)"Hosts", (String)"HOST_ID");
        sq.addSelectColumn(col.count());
        Criteria crit = HostDBHandler.getDeviceCriteria(hostName);
        crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"ISINHERITED"), (Object)0, 0));
        Row domainDetailsRow = DomainSyncHandler.getDomainDetailsRow(domainName);
        crit = domainDetailsRow != null ? crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"DOMAIN_ID"), domainDetailsRow.get("DOMAIN_ID"), 0)) : crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0, false));
        sq.setCriteria(crit);
        return DBUtil.getTotalIntCount((SelectQuery)sq) == 1;
    }
}

