/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.QueryConstructionException;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.dbsync.host.HostActionDetails;
import com.adventnet.sa.server.dbsync.host.HostBatchExecutor;
import com.adventnet.sa.server.util.DBUtil;
import com.adventnet.sa.server.util.HostDBHandler;
import com.manageengine.ads.fw.api.RestAPI;
import com.manageengine.ads.fw.api.RestAPIUtil;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ads.fw.service.util.ProductUniqueSeqGenerator;
import com.manageengine.ads.fw.util.CommonUtil;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.device.LogCollectionStatus;
import com.manageengine.ela.server.common.license.LicenseComponents;
import com.manageengine.ela.server.common.license.LicenseHandler;
import com.manageengine.ela.server.common.license.ProductsAndComponents;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InheritedHostHandler {
    private static final String HOSTDETAILS_API = "GET_HOST_LICENSE_DETAILS";
    private static final String CONVERT_HOST_API = "CONVERT_HOST_AND_INHERITEDHOST";
    private static Persistence persistenceLite = PersistenceDBUtil.getPersistenceLite();
    private static final Logger LOGGER = Logger.getLogger(InheritedHostHandler.class.getName());
    private static final int DC_ENABLED = 3;
    private static final int DC_DISABLED = 4;
    private static final int MEMBER_SERVER_ENABLED = 16;
    private static final int MEMBER_SERVER_DISABLED = 32;
    private static final int WORK_STATION_ENABLED = 4096;
    private static final int WORK_STATION_DISABLED = 8192;
    private static final int DOMAIN_CONTROLLER = 101;
    private static final int MEMBER_SERVER = 201;
    private static final int WORKSTATION = 301;
    private static final int FILESERVER = 501;

    public static boolean addInheritedHost(Properties hostProp) throws Exception {
        String seqNumber = hostProp.getProperty("PRODUCT_SEQ_NUMBER");
        String name = hostProp.containsKey("HOST_NAME") ? hostProp.getProperty("HOST_NAME") : hostProp.getProperty("NAME");
        String domainName = hostProp.getProperty("DOMAIN_NAME");
        Long domainID = HostDBHandler.getDomainID(domainName);
        if (domainID == null) {
            throw new Exception("Unknown inherited Host  Domain not Found in DomainConfiguration");
        }
        DataObject doo = HostDBHandler.getHostDO(name, domainName);
        Row row = HostDBHandler.getHostDetailsRow(doo);
        if (seqNumber == null) {
            int hostStatus = InheritedHostHandler.getInheritedHostStatus(hostProp);
            LOGGER.info("WARNING : Request processed based on Old ADAP request  addInheritedHost");
            if (row == null) {
                HostDBHandler.addNewEventlogHost(name, null, domainID, null, null, hostStatus, true);
            } else {
                LOGGER.info("Host Already exists");
            }
            return true;
        }
        InheritedHostHandler.handleInheritedHostBasedOnLicense(domainID, doo, row, hostProp);
        return true;
    }

    private static boolean handleInheritedHostBasedOnLicense(Long domainID, DataObject doo, Row row, Properties hostProp) throws Exception {
        String source_product = hostProp.getProperty("PRODUCT_SEQ_NUMBER");
        String hostName = hostProp.containsKey("HOST_NAME") ? hostProp.getProperty("HOST_NAME") : hostProp.getProperty("NAME");
        String domainName = hostProp.getProperty("DOMAIN_NAME");
        String dns_name = hostProp.getProperty("DNS_NAME");
        boolean isOriginLicensed = hostProp.containsKey("LICENSE_CODE") && hostProp.getProperty("LICENSE_CODE").equalsIgnoreCase("R");
        boolean isLicensed = false;
        if (LicenseHandler.getInstance().getLicenseType() == LicenseComponents.LicenseType.REGISTERED) {
            isLicensed = true;
        }
        int licensedServerhostCount = LicenseHandler.getInstance().getnoOfWindowsServerDevicesForADAP();
        int licensedWorkstationCount = LicenseHandler.getInstance().getnoOfWindowsWorkstationDevicesForADAP();
        int totalServerHostCount = HostDBHandler.getEabledWindowsDeviceCount(1);
        int totalWorkStationCount = HostDBHandler.getEabledWindowsDeviceCount(2);
        Integer device_type = InheritedHostHandler.findHostType(hostProp);
        int orgDeviceStatus = InheritedHostHandler.getInheritedHostStatus(hostProp);
        int hostStatus = LogCollectionStatus.DISABLED.getStatus();
        if (device_type != 301) {
            hostStatus = orgDeviceStatus;
        } else if (!ServerDetailsBean.getInstance().isWorkstationFormADAPallowed()) {
            LOGGER.fine("ADAP Workstations are not allowed in EventlogAnalyzer");
            return false;
        }
        LOGGER.info("Device Name :" + hostName + "   device_type : " + device_type);
        LOGGER.info("License Status licensedServerhostCount : " + licensedServerhostCount + "    totalServerHostCount : " + totalServerHostCount + "   licensedWorkstationCount : " + licensedWorkstationCount + "   totalWorkStationCount : " + totalWorkStationCount);
        if (row != null) {
            if (isOriginLicensed && !isLicensed || device_type == 101) {
                LOGGER.info("Going to convert it to inheritedHost " + hostName);
                InheritedHostHandler.convertToInheritedHost(doo, row, source_product);
                return true;
            }
            if (device_type == 201 && licensedServerhostCount > totalServerHostCount || device_type == 301 && licensedWorkstationCount > totalWorkStationCount) {
                if (InheritedHostHandler.switchHostAndInheritedHost(hostName, domainName, source_product, "TRUE", device_type, orgDeviceStatus)) {
                    LOGGER.info("Remote Machine device converted to synced device");
                    InheritedHostHandler.convertToLocalHost(doo, row, source_product);
                } else {
                    LOGGER.info("Remote Machine rejected request to convert to synced device");
                    InheritedHostHandler.convertToInheritedHost(doo, row, source_product);
                }
            } else {
                LOGGER.info("License count not satisfied going to convert local device as synced device");
                InheritedHostHandler.convertToInheritedHost(doo, row, source_product);
            }
        } else if (!isOriginLicensed && isLicensed) {
            if ((device_type == 201 && licensedServerhostCount > totalServerHostCount || device_type == 301 && licensedWorkstationCount > totalWorkStationCount) && InheritedHostHandler.switchHostAndInheritedHost(hostName, domainName, source_product, "TRUE", device_type, orgDeviceStatus)) {
                LOGGER.info("Identified as Member server, HostBatchExecutor adding it to Local Host");
                HostDBHandler.addNewEventlogHost(hostName, dns_name, domainID, ProductUniqueSeqGenerator.getCurrentSeqNumber(), InheritedHostHandler.getHostType(device_type), hostStatus, false);
            } else {
                LOGGER.info("Licensed Host Count Exceeded or unable to Contact Source product, going to add as inherited Device");
                HostDBHandler.addNewEventlogHost(hostName, dns_name, domainID, source_product, InheritedHostHandler.getHostType(device_type), hostStatus, true);
            }
        } else {
            LOGGER.info("HostBatchExecutor adding it to Inherited Host");
            if (device_type == 201 || device_type == 301) {
                LOGGER.info("Identified as supported adap device, Going to convert Target device as Local host");
                if (InheritedHostHandler.switchHostAndInheritedHost(hostName, domainName, source_product, "FALSE", device_type, orgDeviceStatus)) {
                    LOGGER.info("Requested action success, adding as synced device");
                    HostDBHandler.addNewEventlogHost(hostName, dns_name, domainID, source_product, InheritedHostHandler.getHostType(device_type), hostStatus, true);
                } else {
                    LOGGER.info("Requested action failed, adding as local device");
                    HostDBHandler.addNewEventlogHost(hostName, dns_name, domainID, ProductUniqueSeqGenerator.getCurrentSeqNumber(), InheritedHostHandler.getHostType(device_type), LogCollectionStatus.DISABLED.getStatus(), false);
                }
            } else {
                LOGGER.info("Identified as non-supported adap device, adding as synced host");
                HostDBHandler.addNewEventlogHost(hostName, dns_name, domainID, source_product, InheritedHostHandler.getHostType(device_type), hostStatus, true);
            }
        }
        return true;
    }

    private static String getHostType(Integer host_type) {
        String host_string = null;
        switch (host_type) {
            case 301: {
                host_string = "WINDOWS WORKSTATION WKS";
                break;
            }
            case 101: {
                host_string = "WINDOWS DOMAIN CONTROLLER";
                break;
            }
            case 201: 
            case 501: {
                host_string = "WINDOWS MEMBER SERVER";
                break;
            }
            default: {
                host_string = "WINDOWS WORKSTATION WKS";
            }
        }
        return host_string;
    }

    private static Integer findHostType(Properties hostProp) {
        int host_type = 301;
        try {
            if (hostProp.containsKey("HOST_TYPE")) {
                host_type = Integer.parseInt(hostProp.getProperty("HOST_TYPE"));
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return host_type;
    }

    public static void addActionInqueue(String source_product, String domainName, String hostName, int hostStatus, String flg) throws DataAccessException {
        HostActionDetails details = new HostActionDetails(hostName, flg, domainName, hostStatus);
        HostBatchExecutor.add(source_product, domainName, details);
    }

    private static int getInheritedHostStatus(Properties hostProp) {
        int status = 1;
        int statusVal = 0;
        if (hostProp.containsKey("HOST_STATUS")) {
            status = Integer.parseInt(hostProp.getProperty("HOST_STATUS"));
        } else if (hostProp.containsKey("MACHINE_TYPE")) {
            statusVal = Integer.parseInt(hostProp.getProperty("MACHINE_TYPE"));
            if (statusVal == 16 || statusVal == 4096) {
                status = LogCollectionStatus.ENABLED.getStatus();
            } else if (statusVal == 32 || statusVal == 8192) {
                status = LogCollectionStatus.DISABLED.getStatus();
            }
        } else if (hostProp.containsKey("ADMIN_STATUS")) {
            statusVal = Integer.parseInt(hostProp.getProperty("ADMIN_STATUS"));
            if (statusVal == 3) {
                status = LogCollectionStatus.ENABLED.getStatus();
            } else if (statusVal == 4) {
                status = LogCollectionStatus.DISABLED.getStatus();
            }
        }
        return status;
    }

    public static boolean updateInheritedHost(Properties hostProp) throws Exception {
        int status = InheritedHostHandler.getInheritedHostStatus(hostProp);
        String hostName = hostProp.getProperty("NAME");
        String source_product = hostProp.getProperty("PRODUCT_SEQ_NUMBER");
        DataObject doo = HostDBHandler.getInheritedDeviceDO(hostName, hostProp.getProperty("DOMAIN_NAME"));
        if (doo == null) {
            LOGGER.info("WARNING : Invalid domain devices sycned from adap ");
            return false;
        }
        Row hostDetails = HostDBHandler.getHostDetailsRow(doo);
        if (source_product == null) {
            LOGGER.info("WARNING : Request processed based on Old ADAP request  updateInheritedHost");
            InheritedHostHandler.updateLogCollectionStatus(doo, status);
        } else if (InheritedHostHandler.validateInheritedHost(hostDetails, source_product)) {
            String old_seqNumber = (String)hostDetails.get("SOURCE_PRODUCT");
            if (old_seqNumber == null) {
                LOGGER.info("WARNING : Request processed based on Old ADAP request  updateInheritedHost");
                InheritedHostHandler.updateLogCollectionStatus(doo, status);
            } else {
                InheritedHostHandler.inheritedHostBatchupdate(doo, status);
            }
        } else {
            LOGGER.info("Target Host not found or Source Product Not matching for host : " + hostName + "  source_product : " + source_product);
            return false;
        }
        return true;
    }

    public static String inheritedHostBatchupdate(DataObject doo, Integer status) throws Exception {
        String error = null;
        if (status == 1) {
            error = InheritedHostHandler.enableHostBasedOnLicenseCount(doo, status);
        } else if (status == 2) {
            error = InheritedHostHandler.updateSacnNowBasedOnHostStatus(doo, status);
        } else {
            InheritedHostHandler.updateLogCollectionStatus(doo, status);
        }
        return error;
    }

    private static String updateSacnNowBasedOnHostStatus(DataObject doo, Integer status) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"LOG_COLLECTION_STATUS"), (Object)0, 1);
        Iterator itr = doo.getRows("HostDetails", criteria);
        if (itr.hasNext()) {
            InheritedHostHandler.updateLogCollectionStatus(itr, doo, status);
        }
        criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"LOG_COLLECTION_STATUS"), (Object)1, 1);
        Join join = new Join("HostDetails", "Hosts", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 1);
        itr = doo.getRows("Hosts", criteria, join);
        if (itr.hasNext()) {
            JSONObject json = InheritedHostHandler.collectHosstDetails(itr, doo);
            return InheritedHostHandler.enableHostBasedOnLicenseCount(doo, json, status);
        }
        return null;
    }

    public static void updateLogCollectionStatus(DataObject doo, Integer status) throws DataAccessException {
        Iterator itr = doo.getRows("HostDetails");
        InheritedHostHandler.updateLogCollectionStatus(itr, doo, status);
    }

    public static void updateLogCollectionStatus(Iterator<?> itr, DataObject doo, Integer status) throws DataAccessException {
        while (itr.hasNext()) {
            Row hostDetails = (Row)itr.next();
            hostDetails.set("LOG_COLLECTION_STATUS", (Object)status);
            doo.updateRow(hostDetails);
            DBUtil.updateDataObject(doo, true);
            HostDBHandler.slupdateForEnableDisable((Long)hostDetails.get("HOST_ID"), status);
        }
    }

    private static String enableHostBasedOnLicenseCount(DataObject doo, Integer status) throws Exception {
        JSONObject hostDetails = InheritedHostHandler.collectHosstDetails(doo);
        return InheritedHostHandler.enableHostBasedOnLicenseCount(doo, hostDetails, status);
    }

    private static String enableHostBasedOnLicenseCount(DataObject doo, JSONObject hostDetails, Integer status) throws Exception {
        String response = null;
        Iterator sourceProducts = hostDetails.keys();
        while (sourceProducts.hasNext()) {
            String sourceProduct = (String)sourceProducts.next();
            JSONObject json = hostDetails.getJSONObject(sourceProduct);
            String message = InheritedHostHandler.handleWithMultipleDomains(doo, json, sourceProduct, status);
            if (message == null) continue;
            response = message;
        }
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String handleWithMultipleDomains(DataObject doo, JSONObject hostDetails, String sourceProduct, Integer status) throws Exception {
        String response = null;
        Integer inheritedServerHostCount = InheritedHostHandler.getEabledInheritedHostCount(sourceProduct, true);
        Integer inheritedWksHostCount = InheritedHostHandler.getEabledInheritedHostCount(sourceProduct, false);
        Integer totalHostCount = inheritedServerHostCount + inheritedWksHostCount;
        Iterator domains = hostDetails.keys();
        while (domains.hasNext()) {
            int server_Count;
            JSONArray hostNames;
            String domain = (String)domains.next();
            JSONObject result = InheritedHostHandler.getResultFromRemoteHost(sourceProduct, domain, hostNames = hostDetails.getJSONArray(domain), inheritedServerHostCount, inheritedWksHostCount);
            int workstationCount = result.has("WORKSTATION_HOST_COUNT") ? result.getInt("WORKSTATION_HOST_COUNT") : 0;
            int n = server_Count = result.has("SERVER_HOST_COUNT") ? result.getInt("SERVER_HOST_COUNT") : 0;
            if (result.has("eMESSAGE")) {
                return result.getString("eMESSAGE");
            }
            for (int index = 0; index < hostNames.length(); ++index) {
                Integer n2;
                Integer n3;
                Row hostdetails = HostDBHandler.getSyncedDeviceDetailsRow(doo, hostNames.getString(index));
                String hostType = (String)hostdetails.get("SUBTYPE");
                if (result.has("STATUS") && result.getBoolean("STATUS")) {
                    if (hostType == null) {
                        InheritedHostHandler.updateHostRowAndSlid(doo, hostdetails, status);
                    }
                    if (hostType.toUpperCase().contains("WKS")) {
                        InheritedHostHandler.updateHostRowAndSlid(doo, hostdetails, status);
                        n3 = inheritedWksHostCount;
                        n2 = inheritedWksHostCount = Integer.valueOf(inheritedWksHostCount + 1);
                    } else if (!hostType.toUpperCase().contains("WKS")) {
                        InheritedHostHandler.updateHostRowAndSlid(doo, hostdetails, status);
                        n3 = inheritedServerHostCount;
                        n2 = inheritedServerHostCount = Integer.valueOf(inheritedServerHostCount + 1);
                    } else {
                        InheritedHostHandler.updateHostRowAndSlid(doo, hostdetails, status);
                    }
                    n3 = totalHostCount;
                    n2 = totalHostCount = Integer.valueOf(totalHostCount + 1);
                } else if (hostType == null) {
                    if (workstationCount + server_Count <= totalHostCount) return "eventlog.inheritedhost.status.message.license.limit";
                    InheritedHostHandler.updateHostRowAndSlid(doo, hostdetails, status);
                    n3 = totalHostCount;
                    n2 = totalHostCount = Integer.valueOf(totalHostCount + 1);
                } else if (hostType.toUpperCase().contains("WKS")) {
                    if (workstationCount > inheritedWksHostCount) {
                        InheritedHostHandler.updateHostRowAndSlid(doo, hostdetails, status);
                        n3 = inheritedWksHostCount;
                        n2 = inheritedWksHostCount = Integer.valueOf(inheritedWksHostCount + 1);
                    } else {
                        response = "eventlog.inheritedhost.status.message.license.limit";
                    }
                } else if (!hostType.toUpperCase().contains("WKS")) {
                    if (server_Count > inheritedServerHostCount) {
                        InheritedHostHandler.updateHostRowAndSlid(doo, hostdetails, status);
                        n3 = inheritedServerHostCount;
                        n2 = inheritedServerHostCount = Integer.valueOf(inheritedServerHostCount + 1);
                    } else {
                        response = "eventlog.inheritedhost.status.message.license.limit";
                    }
                } else {
                    if (workstationCount + server_Count <= totalHostCount) return "eventlog.inheritedhost.status.message.license.limit";
                    InheritedHostHandler.updateHostRowAndSlid(doo, hostdetails, status);
                    n3 = totalHostCount;
                    n2 = totalHostCount = Integer.valueOf(totalHostCount + 1);
                }
                LOGGER.info(" Host " + hostNames.getString(index) + "  Successfully processed");
            }
            LOGGER.info(domain + " Doamin Host Successfully processed");
        }
        return response;
    }

    private static void updateHostRowAndSlid(DataObject doo, Row hostdetails, Integer status) throws Exception {
        hostdetails.set("LOG_COLLECTION_STATUS", (Object)status);
        doo.updateRow(hostdetails);
        DBUtil.updateDataObject(doo, true);
        HostDBHandler.slupdateForEnableDisable((Long)hostdetails.get("HOST_ID"), status);
    }

    private static JSONObject collectHosstDetails(DataObject doo) throws DataAccessException, JSONException {
        Iterator itr = doo.getRows("Hosts");
        return InheritedHostHandler.collectHosstDetails(itr, doo);
    }

    private static JSONObject collectHosstDetails(Iterator<?> itr, DataObject doo) throws DataAccessException, JSONException {
        JSONObject hostDetails = new JSONObject();
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            String hostName = (String)row.get("HOST_NAME");
            Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), row.get("HOST_ID"), 0);
            row = doo.getRow("HostDetails", criteria);
            Row doaminDetails = doo.getRow(ADSDomainHandler.tableName, new Criteria(Column.getColumn((String)ADSDomainHandler.tableName, (String)"DOMAIN_ID"), row.get("DOMAIN_ID"), 0));
            InheritedHostHandler.checkAndUpdateHostDetails((String)doaminDetails.get("DOMAIN_NAME"), (String)row.get("SOURCE_PRODUCT"), hostName, hostDetails);
        }
        return hostDetails;
    }

    private static boolean checkAndUpdateHostDetails(String domainName, String source_product, String hostName, JSONObject hostDetails) throws JSONException {
        if (source_product == null || domainName == null) {
            LOGGER.info("Invalid details source_product or domainName becomes Null " + source_product + "  " + domainName);
            return false;
        }
        if (hostDetails.has(source_product)) {
            JSONObject product = hostDetails.getJSONObject(source_product);
            if (product.has(domainName)) {
                JSONArray array = product.getJSONArray(domainName);
                array.put((Object)hostName);
            } else {
                JSONArray array = new JSONArray();
                array.put((Object)hostName);
                product.put(domainName, (Object)array);
            }
        } else {
            JSONObject product = new JSONObject();
            JSONArray array = new JSONArray();
            array.put((Object)hostName);
            product.put(domainName, (Object)array);
            hostDetails.put(source_product, (Object)product);
        }
        return true;
    }

    @Deprecated
    public static String updateInheritedHost(DataObject doo, Long hostId, Integer status) throws Exception {
        String message = null;
        String source_product = null;
        String domain = null;
        JSONArray hostnames = new JSONArray();
        Row hostDetails = null;
        Row host = null;
        if (doo.isEmpty()) {
            return "Unable to find requested host";
        }
        Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)hostId, 0);
        hostDetails = doo.getRow("HostDetails", criteria);
        criteria = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)hostId, 0);
        try {
            host = doo.getRow("Hosts", criteria);
            if (host.get("HOST_NAME") != null) {
                hostnames.put((Object)((String)host.get("HOST_NAME")));
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        source_product = (String)hostDetails.get("SOURCE_PRODUCT");
        domain = (String)hostDetails.get("DOMAIN_NAME");
        hostDetails.set("LOG_COLLECTION_STATUS", (Object)status);
        doo.updateRow(hostDetails);
        Integer workstation = InheritedHostHandler.getEabledInheritedHostCount(source_product, false);
        Integer server = InheritedHostHandler.getEabledInheritedHostCount(source_product, true);
        Integer inheritedHostCount = workstation + server;
        if (status == 1) {
            JSONObject result = InheritedHostHandler.getResultFromRemoteHost(source_product, domain, hostnames, server, workstation);
            if (result.has("eMESSAGE")) {
                message = result.getString("eMESSAGE");
            } else if (result.has("STATUS") && result.getBoolean("STATUS")) {
                persistenceLite.update(doo);
                HostDBHandler.slupdateForEnableDisable(hostId, status);
            } else if (result.has("HOST_COUNT")) {
                if (result.getInt("HOST_COUNT") < inheritedHostCount) {
                    persistenceLite.update(doo);
                    HostDBHandler.slupdateForEnableDisable(hostId, status);
                } else {
                    message = "eventlog.inheritedhost.status.message.license.limit";
                }
            } else {
                message = "eventlog.inheritedhost.status.message.component.down";
            }
        } else {
            persistenceLite.update(doo);
            HostDBHandler.slupdateForEnableDisable(hostId, status);
        }
        return message;
    }

    public static boolean checkAnddeleteHost(Properties hostProperties) throws Exception {
        String hostName = hostProperties.getProperty("NAME");
        String domain = hostProperties.getProperty("DOMAIN_NAME");
        String source_product = hostProperties.getProperty("PRODUCT_SEQ_NUMBER");
        if (source_product == null) {
            LOGGER.info("WARNING : Request processed based on Old ADAP request  checkAnddeleteHost");
            HostBatchExecutor.removeHost(source_product, domain, hostName);
            HostDBHandler.deleteHost(hostProperties);
        } else if (InheritedHostHandler.validateInheritedHost(hostName, domain, source_product)) {
            HostBatchExecutor.removeHost(source_product, domain, hostName);
            HostDBHandler.deleteHost(hostProperties);
        } else {
            LOGGER.info("Target Host not found or Source Product Not matching for host : " + hostName + "  source_product : " + source_product);
            return false;
        }
        return true;
    }

    private static boolean switchHostAndInheritedHost(String hostName, String domainName, String source_product, String isInherited, int device_type, int status) throws Exception {
        try {
            if (domainName == null || hostName == null) {
                LOGGER.fine("Unable to process request hostname or domain name becomes null  : " + hostName + " , " + domainName);
                return false;
            }
            Object parentProduct = HostDBHandler.getParentProductSeqNumber();
            Properties params = new Properties();
            params.setProperty("DOMAIN_NAME", domainName);
            params.setProperty("HOST_NAME", hostName);
            params.setProperty("SEQUENCE_ID", ProductUniqueSeqGenerator.getCurrentSeqNumber());
            params.setProperty("DESTINATION_SEQUENCE_NUMBER", source_product);
            params.setProperty("CHANGETO_INHERITED", isInherited);
            params.setProperty("ADD_REQUEST_INITIATED_BY", source_product);
            params.setProperty("DEVICE_STATUS", status == 0 ? "false" : "true");
            if (device_type == 301) {
                params.setProperty("CURRENT_ENABLED_COUNT", "" + LicenseHandler.getInstance().getConfiguredELAWindowsWorkstations());
                params.setProperty("CURRENT_LICENSED_COUNT", "" + LicenseHandler.getInstance().getnoOfWindowsWorkstationDevicesForADAP());
            } else {
                params.setProperty("CURRENT_ENABLED_COUNT", "" + LicenseHandler.getInstance().getConfiguredELAWindowsServerDevices());
                params.setProperty("CURRENT_LICENSED_COUNT", "" + LicenseHandler.getInstance().getnoOfWindowsServerDevicesForADAP());
            }
            Criteria crit = new Criteria(Column.getColumn((String)"ADSProductDetails", (String)"SEQUENCE_ID"), parentProduct, 0);
            DataObject dobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSProductDetails", crit);
            if (!dobj.isEmpty()) {
                RestAPI api = new RestAPI();
                api.execute(RestAPIUtil.getAPIId((Long)((Long)dobj.getFirstValue("ADSProductDetails", "PRODUCT_ID")), (String)CONVERT_HOST_API), params);
                JSONObject responseResult = api.getResponseJSON();
                LOGGER.info("responseResult in ADAP: " + responseResult);
                if (responseResult.has("sSTATUS") && responseResult.getString("sSTATUS").equalsIgnoreCase("SUCCESS")) {
                    return true;
                }
                LOGGER.info("Failed to Update Details in remote server for host  : " + hostName + " details : " + responseResult);
                return false;
            }
            LOGGER.info("Unable to Find product API");
            return false;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    private static void updateNewSequenceNumber(String newSeqNumber, DataObject dobj) throws DataAccessException {
        boolean status = false;
        Row row = dobj.getFirstRow("HostDetails");
        String oldSeqNumber = (String)row.get("SOURCE_PRODUCT");
        if (oldSeqNumber == null) {
            status = true;
            row.set("SOURCE_PRODUCT", (Object)oldSeqNumber);
        } else if (newSeqNumber != null && !newSeqNumber.equals(oldSeqNumber)) {
            status = true;
            row.set("SOURCE_PRODUCT", (Object)newSeqNumber);
        }
        if (status) {
            dobj.updateRow(row);
            persistenceLite.update(dobj);
        }
    }

    public static boolean convertToInheritedHost(String hostName, String domainName, String source_product) throws DataAccessException {
        DataObject doo = HostDBHandler.getHostDO(hostName, domainName);
        Row row = HostDBHandler.getHostDetailsRow(doo);
        return InheritedHostHandler.convertToInheritedHost(doo, row, source_product);
    }

    public static boolean convertToInheritedHost(DataObject doo, Row row, String source_product) throws DataAccessException {
        boolean result = true;
        if (row != null) {
            row.set("SOURCE_PRODUCT", (Object)source_product);
            row.set("LOG_COLLECTION_STATUS", (Object)1);
            row.set("ISINHERITED", (Object)1);
            doo.updateRow(row);
            DBUtil.updateDataObject(doo, true);
        } else {
            result = false;
        }
        return result;
    }

    public static boolean convertToLocalHost(String hostName, String domainName, String source_product) throws DataAccessException, JSONException {
        DataObject doo = HostDBHandler.getHostDO(hostName, domainName);
        Row row = HostDBHandler.getHostDetailsRow(doo);
        return InheritedHostHandler.convertToLocalHost(doo, row, source_product);
    }

    public static boolean convertToLocalHost(DataObject doo, Row row, String source_product) throws DataAccessException, JSONException {
        boolean result = true;
        if (row != null) {
            row.set("ISINHERITED", (Object)0);
            row.set("SOURCE_PRODUCT", (Object)ProductUniqueSeqGenerator.getCurrentSeqNumber());
            doo.updateRow(row);
            DBUtil.updateDataObject(doo, true);
        } else {
            result = false;
        }
        return result;
    }

    private static JSONObject getResultFromRemoteHost(String sourceProduct, String domainName, JSONArray hostnames, Integer serverCount, Integer workstation) throws Exception {
        JSONObject responseResult = null;
        JSONObject resultObj = new JSONObject();
        try {
            Properties params = new Properties();
            if (sourceProduct == null) {
                throw new Exception("Unable to find Source Product");
            }
            if (domainName != null) {
                params.setProperty("DOMAIN_NAME", domainName);
            }
            if (hostnames != null) {
                params.setProperty("HOST_NAME", hostnames.toString());
            }
            params.setProperty("DESTINATION_SEQUENCE_NUMBER", sourceProduct);
            Object parentProduct = HostDBHandler.getParentProductSeqNumber();
            params.setProperty("SEQUENCE_ID", ProductUniqueSeqGenerator.getCurrentSeqNumber());
            params.setProperty("ENABLED_SERVER_HOST_COUNT", "" + serverCount);
            params.setProperty("ENABLED_WORKSTATION_HOST_COUNT", "" + workstation);
            Criteria crit = new Criteria(Column.getColumn((String)"ADSProductDetails", (String)"SEQUENCE_ID"), parentProduct, 0);
            DataObject dobj = persistenceLite.get("ADSProductDetails", crit);
            if (!dobj.isEmpty()) {
                RestAPI api = new RestAPI();
                api.execute(RestAPIUtil.getAPIId((Long)((Long)dobj.getFirstValue("ADSProductDetails", "PRODUCT_ID")), (String)HOSTDETAILS_API), params);
                responseResult = api.getResponseJSON();
            }
            LOGGER.info("Response From Remote Machine : " + responseResult);
            InheritedHostHandler.loadResultObject(responseResult, resultObj);
            LOGGER.info("Resolved Result  : " + resultObj);
        }
        catch (Exception exp) {
            resultObj.put("eMESSAGE", (Object)"Unable to Connect to remote Machine");
        }
        return resultObj;
    }

    private static void loadResultObject(JSONObject responseResult, JSONObject resultObj) throws JSONException {
        if (responseResult != null) {
            if (responseResult.has("IS_VALID")) {
                if (!responseResult.getBoolean("IS_VALID")) {
                    resultObj.put("eMESSAGE", (Object)"eventlog.inheritedhost.status.message.license.limit");
                } else {
                    resultObj.put("STATUS", (Object)"TRUE");
                }
            } else if (responseResult.has("IS_LICENSE_EXPIRED")) {
                resultObj.put("eMESSAGE", (Object)"eventlog.inheritedhost.status.message.license.expired");
            } else if (responseResult.has("HOST_COUNT") || responseResult.has("SERVER_HOST_COUNT") || responseResult.has("WORKSTATION_HOST_COUNT")) {
                if (responseResult.has("HOST_COUNT")) {
                    resultObj.put("HOST_COUNT", responseResult.getInt("HOST_COUNT"));
                }
                if (responseResult.has("SERVER_HOST_COUNT")) {
                    resultObj.put("SERVER_HOST_COUNT", responseResult.getInt("SERVER_HOST_COUNT"));
                }
                if (responseResult.has("WORKSTATION_HOST_COUNT")) {
                    resultObj.put("WORKSTATION_HOST_COUNT", responseResult.getInt("WORKSTATION_HOST_COUNT"));
                }
            } else {
                resultObj.put("eMESSAGE", (Object)"eventlog.inheritedhost.status.message.component.down");
            }
        } else {
            resultObj.put("eMESSAGE", (Object)"eventlog.inheritedhost.status.message.component.down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer getEabledInheritedHostCount(Object sourceProduct, boolean isServer) throws SQLException, QueryConstructionException {
        Integer count = null;
        try (Connection con = null;){
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"HostDetails"));
            query.addSelectColumn(Column.getColumn(null, (String)"*").count());
            Criteria crit = new Criteria(Column.getColumn((String)"HostDetails", (String)"LOG_COLLECTION_STATUS"), (Object)0, 1);
            crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"SOURCE_PRODUCT"), sourceProduct, 0));
            crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"ISINHERITED"), (Object)1, 0));
            if (isServer) {
                crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"SUBTYPE"), null, 1));
                crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"SUBTYPE"), (Object)"*WKS*", 3));
            } else {
                crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"SUBTYPE"), null, 1));
                crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"SUBTYPE"), (Object)"*WKS*", 2));
            }
            query.setCriteria(crit);
            RelationalAPI api = RelationalAPI.getInstance();
            con = api.getConnection();
            DataSet dataSet = api.executeQuery((Query)query, con);
            while (dataSet.next()) {
                count = (Integer)dataSet.getValue(1);
            }
            dataSet.close();
        }
        return count;
    }

    public static boolean validateInheritedHost(String hostName, String domainName, String source_product) throws DataAccessException {
        DataObject doo = HostDBHandler.getHostDO(hostName, domainName);
        Row hostDetails = HostDBHandler.getHostDetailsRow(doo);
        return InheritedHostHandler.validateInheritedHost(hostDetails, source_product);
    }

    public static boolean validateInheritedHost(Row hostDetails, String source_product) throws DataAccessException {
        if (hostDetails == null) {
            return false;
        }
        String old_seqNumber = (String)hostDetails.get("SOURCE_PRODUCT");
        Integer isInherited = (Integer)hostDetails.get("ISINHERITED");
        return isInherited == 1 && (old_seqNumber == null || source_product != null && source_product.equals(old_seqNumber));
    }

    public static boolean publishLicenseStatus() {
        boolean result;
        block4: {
            result = true;
            if (!CommonUtil.isProductIntegrated((String)ProductsAndComponents.LOG360.getProductName())) {
                return false;
            }
            try {
                Object parentProduct = HostDBHandler.getParentProductSeqNumber();
                Criteria crit = new Criteria(Column.getColumn((String)"ADSProductDetails", (String)"SEQUENCE_ID"), parentProduct, 0);
                DataObject dobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSProductDetails", crit);
                if (!dobj.isEmpty()) {
                    Properties params = new Properties();
                    params.setProperty("SEQUENCE_ID", ProductUniqueSeqGenerator.getCurrentSeqNumber());
                    params.setProperty("LICENSE_CODE", LicenseHandler.getInstance().getLicenseType().getLicenseCode());
                    RestAPI api = new RestAPI();
                    api.execute(RestAPIUtil.getAPIId((Long)((Long)dobj.getFirstValue("ADSProductDetails", "PRODUCT_ID")), (String)"UPDATE_HOST_LICENSE_STATUS"), params);
                }
            }
            catch (Exception exp) {
                String message = exp.getMessage();
                if (!"00000002".equals(message) && !"00000011".equals(message)) break block4;
                result = false;
            }
        }
        return result;
    }
}

