/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class RegistryUtil {
    private static String[] regSearchLocations = new String[]{"HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall", "HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall"};
    private static String pathExtractionCommand = "reg query %s /f \"%s\" /d /s /e";
    private static String dataExtractionCommand = "reg query %s /v \"%s\"";
    public static final String LEAD_PRODUCT = "LeadProduct";

    public static String getValueByKey(String softwareName, String key) throws Exception {
        String result = null;
        String command = null;
        for (String searchLocation : regSearchLocations) {
            command = String.format(pathExtractionCommand, searchLocation, softwareName.trim());
            List<String> resultList = RegistryUtil.execute(command);
            String dataPath = RegistryUtil.getDataPath(resultList);
            if (dataPath == null) continue;
            command = String.format(dataExtractionCommand, dataPath, key);
            resultList = RegistryUtil.execute(command);
            result = RegistryUtil.getData(resultList, key);
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> execute(String command) throws Exception {
        ArrayList<String> dataList = null;
        Process process = Runtime.getRuntime().exec(command);
        String line = null;
        try (BufferedReader in = null;){
            in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            dataList = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                if (line.equals("")) continue;
                dataList.add(line);
            }
        }
        return dataList;
    }

    private static String getDataPath(List<String> dataList) {
        String result = null;
        if (dataList != null) {
            for (String data : dataList) {
                String compareData = data.toUpperCase();
                if (compareData.indexOf("UNINSTALL") == -1) continue;
                result = data.trim();
            }
        }
        return result;
    }

    private static String getData(List<String> dataList, String name) {
        String result = null;
        if (dataList != null) {
            for (String data : dataList) {
                String[] dataArray;
                if (data.indexOf(name) == -1 || (dataArray = (data = data.trim().replace("   ", "  ")).split("  ")).length != 3) continue;
                result = dataArray[2];
            }
        }
        return result;
    }
}

