/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WrapperUtil {
    public static final String SERVICE_NAME = "EventLog Analyzer";
    public static boolean isServiceInstalled = false;
    public static boolean isAdminProcess = false;
    private static int setInstallStatus = 0;
    private static int setAdminStatus = 0;
    private static final Logger LOGGER = Logger.getLogger("WrapperUtil");
    private static String slsType = null;
    private static String installCommand = null;
    private static String uninstallCommand = null;
    private static String serviceStatus = null;

    public static boolean checkIswindows() {
        return slsType != null && slsType.toUpperCase().contains("WINDOWS");
    }

    public static boolean getAdminStatus() {
        return isAdminProcess;
    }

    public static boolean checkRootProcess() {
        block4: {
            try {
                if (setAdminStatus != 0) break block4;
                isAdminProcess = false;
                String command = "id -u";
                Process p = Runtime.getRuntime().exec(command);
                BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = reader.readLine();
                while (line != null) {
                    if ("0".equals(line.trim())) {
                        isAdminProcess = true;
                        break;
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return isAdminProcess;
    }

    public static boolean checkAdminProcess() {
        try {
            if (setAdminStatus == 0) {
                String command = "reg query \"HKU\\S-1-5-19\"";
                Process p = Runtime.getRuntime().exec(command);
                p.waitFor();
                int exitValue = p.exitValue();
                isAdminProcess = 0 == exitValue;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return isAdminProcess;
    }

    public static boolean isInstalledAsService() {
        try {
            if (setInstallStatus == 0) {
                if (WrapperUtil.executeCommand(serviceStatus, "Service is installed", "Unable")) {
                    isServiceInstalled = true;
                }
                setInstallStatus = 1;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return isServiceInstalled;
    }

    public static boolean installAsService() {
        try {
            WrapperUtil.installService(installCommand);
            setInstallStatus = 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return isServiceInstalled;
    }

    private static void installService(String cmd) throws IOException, InterruptedException {
        if (WrapperUtil.executeCommand(cmd, "service installed", "Unable to install")) {
            isServiceInstalled = true;
        }
    }

    public static boolean uninstallAsService() {
        try {
            if (WrapperUtil.executeCommand(uninstallCommand, "service removed", "is not installed")) {
                isServiceInstalled = false;
            }
            setInstallStatus = 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return !isServiceInstalled;
    }

    public static boolean installAsService(String userName, String password) {
        try {
            String crdHandling = "\"wrapper.ntservice.account=\"" + userName + "\" wrapper.ntservice.password=\"" + password + "\"" + " wrapper.ntservice.interactive=FALSE\"";
            crdHandling = " \"1\"  " + crdHandling;
            if (WrapperUtil.checkIswindows()) {
                WrapperUtil.installService(installCommand + crdHandling);
            } else {
                WrapperUtil.installService(installCommand);
            }
            setInstallStatus = 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return isServiceInstalled;
    }

    private static boolean executeCommand(String command, String successTxt, String errTxt) throws IOException, InterruptedException {
        LOGGER.info("Server Installed in OS : " + slsType);
        Process process = Runtime.getRuntime().exec(command);
        process.waitFor();
        process.getOutputStream().close();
        if (!WrapperUtil.CheckForErrorStream(process.getErrorStream(), errTxt)) {
            return false;
        }
        BufferedReader tst = new BufferedReader(new InputStreamReader(process.getInputStream()));
        return WrapperUtil.checkResultData(tst, successTxt);
    }

    private static boolean CheckForErrorStream(InputStream errorStream, String errorTxt) throws IOException, InterruptedException {
        int Count = 0;
        BufferedReader tst = new BufferedReader(new InputStreamReader(errorStream));
        while (!tst.ready()) {
            Thread.sleep(100L);
            if (++Count <= 5) continue;
        }
        if (tst.ready()) {
            return !WrapperUtil.checkResultData(tst, errorTxt);
        }
        return true;
    }

    private static boolean checkResultData(BufferedReader reader, String condnTxt) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            LOGGER.log(Level.INFO, line);
            if (line.contains(SERVICE_NAME) && line.contains(condnTxt)) {
                return true;
            }
            line = reader.readLine();
        }
        return false;
    }

    static {
        try {
            slsType = System.getProperty("os.name");
            if (!WrapperUtil.checkIswindows()) {
                installCommand = "sh configureAsService.sh -i";
                uninstallCommand = "sh configureAsService.sh -e";
                serviceStatus = "sh configureAsService.sh -q";
                WrapperUtil.checkRootProcess();
            } else {
                installCommand = "cmd /c start /b service.bat -i";
                uninstallCommand = "cmd /c start /b service.bat -r";
                serviceStatus = "cmd /c start /b service.bat -q";
                WrapperUtil.checkAdminProcess();
            }
            LOGGER.log(Level.INFO, "Server OS : " + slsType);
            LOGGER.log(Level.INFO, "IsAdministrator : " + isAdminProcess);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, e.getMessage());
        }
    }
}

