/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.vul;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.sa.server.lc.Log;
import com.adventnet.sa.server.lc.LogDataIndexer;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.vul.VulnDetails;
import com.adventnet.sa.server.vul.VulnHandler;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NMAPImport
implements VulnHandler {
    private NotificationManager nfManager = null;

    @Override
    public String importLog(VulnDetails vuln) {
        this.nfManager = NotificationManager.getInstance();
        String status = "Success";
        int cnt = 0;
        try {
            File file = new File(vuln.getfileLoc());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList nodeLst = doc.getElementsByTagName("nmaprun");
            ArrayList<String> portScanData = new ArrayList<String>();
            ArrayList<String> reasonData = new ArrayList<String>();
            ArrayList<String> protocolSet = new ArrayList<String>();
            ArrayList<String> stateSet = new ArrayList<String>();
            ArrayList<String> nameSet = new ArrayList<String>();
            ArrayList<String> ipSet = new ArrayList<String>();
            ArrayList<String> osSet = new ArrayList<String>();
            ArrayList<String> osType = new ArrayList<String>();
            ArrayList<String> osVendor = new ArrayList<String>();
            String ipAddress = "";
            String protocol = "";
            String portState = "";
            String osItem = "";
            String nameItem = "";
            String reason = "";
            String osList = "";
            String portItem = "";
            for (int s = 0; s < nodeLst.getLength(); ++s) {
                Node fstNode;
                Element baseElmnt = (Element)nodeLst.item(s);
                String reportTime = "";
                if (baseElmnt.hasAttribute("start")) {
                    reportTime = baseElmnt.getAttributes().getNamedItem("start").getNodeValue();
                }
                if ((fstNode = nodeLst.item(s)).getNodeType() != 1) continue;
                Element fstElmnt = (Element)fstNode;
                NodeList fstNmElmntLst = fstElmnt.getElementsByTagName("host");
                for (int i = 0; i < fstNmElmntLst.getLength(); ++i) {
                    Element fstNmElmnt = (Element)fstNmElmntLst.item(i);
                    String startTime = "";
                    if (fstNmElmnt.hasAttribute("starttime")) {
                        startTime = fstNmElmnt.getAttributes().getNamedItem("starttime").getNodeValue();
                    }
                    if (fstNmElmnt.hasChildNodes()) {
                        NodeList riBody = fstNmElmnt.getChildNodes();
                        for (int x = 0; x < riBody.getLength(); ++x) {
                            if (riBody.item(x).getNodeName() == "address" && riBody.item(x).getAttributes().getNamedItem("addrtype").getNodeValue().compareTo("ipv4") == 0) {
                                ipAddress = riBody.item(x).getAttributes().getNamedItem("addr").getNodeValue();
                            }
                            if (!riBody.item(x).hasChildNodes()) continue;
                            if (riBody.item(x).getNodeName() == "ports") {
                                NodeList portBody = riBody.item(x).getChildNodes();
                                for (int y = 0; y < portBody.getLength(); ++y) {
                                    if (portBody.item(y).getNodeName() != "port") continue;
                                    portItem = portBody.item(y).getAttributes().getNamedItem("portid").getNodeValue();
                                    protocol = portBody.item(y).getAttributes().getNamedItem("protocol").getNodeValue();
                                    NodeList subBody = portBody.item(y).getChildNodes();
                                    for (int z = 0; z < subBody.getLength(); ++z) {
                                        try {
                                            if (subBody.item(z).getNodeName() == "state") {
                                                portState = subBody.item(z).getAttributes().getNamedItem("state").getNodeValue();
                                            }
                                            if (subBody.item(z).getNodeName() == "reason") {
                                                reason = subBody.item(z).getAttributes().getNamedItem("reason").getNodeValue();
                                            }
                                            if (subBody.item(z).getNodeName() != "service") continue;
                                            nameItem = subBody.item(z).getAttributes().getNamedItem("name").getNodeValue();
                                            ipSet.add(ipAddress);
                                            nameSet.add(nameItem);
                                            portScanData.add(portItem);
                                            stateSet.add(portState);
                                            protocolSet.add(protocol);
                                            reasonData.add(reason);
                                            continue;
                                        }
                                        catch (Exception err) {
                                            err.printStackTrace();
                                        }
                                    }
                                }
                            }
                            if (riBody.item(x).getNodeName() != "os") continue;
                            NodeList osBody = riBody.item(x).getChildNodes();
                            int pos = 0;
                            for (int t = 0; t < osBody.getLength(); ++t) {
                                if (osBody.item(t).getNodeName() != "osmatch") continue;
                                osSet.add(osBody.item(t).getAttributes().getNamedItem("name").getNodeValue());
                                NodeList osclassBody = osBody.item(t).getChildNodes();
                                for (int y = 0; y < osclassBody.getLength(); ++y) {
                                    if (osclassBody.item(y).getNodeName() != "osclass") continue;
                                    osType.add(pos, osclassBody.item(y).getAttributes().getNamedItem("type").getNodeValue());
                                    osVendor.add(pos, osclassBody.item(y).getAttributes().getNamedItem("vendor").getNodeValue());
                                }
                                ++pos;
                            }
                            for (int a = 0; a < osSet.size(); ++a) {
                                String osT = "-";
                                String osV = "-";
                                try {
                                    osT = (String)osType.get(a);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    osV = (String)osVendor.get(a);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                osList = (String)osSet.get(a) + "(OS Type = " + osT + ", Vendor = " + osV + " ) , " + osList;
                            }
                        }
                    }
                    for (int a = 0; a < portScanData.size(); ++a) {
                        Hashtable<String, Object> nMap = new Hashtable<String, Object>();
                        nMap.put("DEVICENAME", ipSet.get(a));
                        nMap.put("PORT", portScanData.get(a));
                        nMap.put("SERVICENAME", nameSet.get(a));
                        nMap.put("STATUS", stateSet.get(a));
                        nMap.put("OSLIST", osList);
                        nMap.put("PROTOCOL", protocolSet.get(a));
                        nMap.put("REASON", reasonData.get(a));
                        String temp = "HostName: " + (String)ipSet.get(a) + " Port: " + (String)portScanData.get(a) + " Reason: " + (String)reasonData.get(a);
                        nMap.put("MESSAGE", temp);
                        Date current = null;
                        try {
                            long stime;
                            if (!"".equals(startTime) && (stime = Long.parseLong(startTime)) != 0L) {
                                current = new Date(stime * 1000L);
                            }
                            if (!"".equals(reportTime) && null == current) {
                                long rTime = Long.parseLong(reportTime);
                                current = new Date(rTime * 1000L);
                            }
                            if (null == current) {
                                current = new Date();
                            }
                        }
                        catch (Exception er) {
                            current = new Date();
                        }
                        SimpleDateFormat dd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String date = dd.format(current);
                        nMap.put("SOURCETYPE", "NMAP");
                        nMap.put("CORRELATE", "true");
                        nMap.put("HOSTTYPE", "NMAP");
                        nMap.put("HOSTID", vuln.gethostId());
                        nMap.put("VULAPPID", vuln.getvulAppId());
                        nMap.put("SECAPPNAME", vuln.getappType());
                        nMap.put("HOSTNAME", vuln.getscannerName());
                        nMap.put("TIME", date);
                        Log log = new Log();
                        log.parseLog("NMAP", nMap);
                        SystemCustomPatternHandler.getInstance().parse((Hashtable)log);
                        LogIndexingAPI.getInstance().generateLogUniqueID((Map)log);
                        Hashtable mapToNotifier = (Hashtable)nMap.clone();
                        mapToNotifier.put("UUID", log.get("$id$"));
                        LogDataIndexer.getInstance().indexLogData(log);
                        this.nfManager.notify(mapToNotifier);
                        ++cnt;
                    }
                    ipSet.clear();
                    nameSet.clear();
                    portScanData.clear();
                    protocolSet.clear();
                    reasonData.clear();
                    stateSet.clear();
                    osSet.clear();
                    osType.clear();
                    osVendor.clear();
                    osList = "";
                }
            }
        }
        catch (Exception e) {
            status = "Failure";
            e.printStackTrace();
        }
        if (cnt == 0) {
            status = "Failure";
        }
        try {
            UpdateQueryImpl u = new UpdateQueryImpl("VulnAppDetails");
            u.setCriteria(new Criteria(new Column("VulnAppDetails", "VULAPPID"), (Object)vuln.getvulAppId(), 0));
            u.setUpdateColumn("STATUS", (Object)status);
            DataAccess.update((UpdateQuery)u);
        }
        catch (Exception er) {
            er.printStackTrace();
        }
        return status;
    }
}

