/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.vul;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.sa.server.lc.Log;
import com.adventnet.sa.server.lc.LogDataIndexer;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.vul.VulnDetails;
import com.adventnet.sa.server.vul.VulnHandler;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NessusImport
implements VulnHandler {
    private NotificationManager nfManager = null;

    @Override
    public String importLog(VulnDetails vuln) {
        this.nfManager = NotificationManager.getInstance();
        String status = "Success";
        int cnt = 0;
        try {
            String[] severityLevel = new String[]{"Informational", "Low", "Medium", "High", "Critical"};
            String host = null;
            boolean m = false;
            boolean u = false;
            String hostSet = "-";
            File file = new File(vuln.getfileLoc());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList nodeLst = doc.getElementsByTagName("ReportHost");
            for (int s = 0; s < nodeLst.getLength(); ++s) {
                Node fstNode = nodeLst.item(s);
                if (fstNode.getNodeType() != 1) continue;
                Element fstElmnt = (Element)fstNode;
                host = fstElmnt.getAttributes().getNamedItem("name").getNodeValue();
                NodeList fstNmElmntLst = fstElmnt.getElementsByTagName("ReportItem");
                NodeList tag = fstElmnt.getElementsByTagName("tag");
                String osType = "";
                String host_ip = "";
                String fqdn = "";
                String netbios = "";
                String date_start = "";
                String date = "";
                for (int v = 0; v < tag.getLength(); ++v) {
                    Element tagElement = (Element)tag.item(v);
                    if ("operating-system".equals(tagElement.getAttributes().getNamedItem("name").getNodeValue())) {
                        osType = tagElement.getFirstChild().getNodeValue();
                        continue;
                    }
                    if ("host-ip".equals(tagElement.getAttributes().getNamedItem("name").getNodeValue())) {
                        host_ip = tagElement.getFirstChild().getNodeValue();
                        continue;
                    }
                    if ("host-fqdn".equals(tagElement.getAttributes().getNamedItem("name").getNodeValue())) {
                        fqdn = tagElement.getFirstChild().getNodeValue();
                        continue;
                    }
                    if ("netbios-name".equals(tagElement.getAttributes().getNamedItem("name").getNodeValue())) {
                        netbios = tagElement.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (!"HOST_START".equals(tagElement.getAttributes().getNamedItem("name").getNodeValue())) continue;
                    date_start = tagElement.getFirstChild().getNodeValue();
                }
                SimpleDateFormat dd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                SimpleDateFormat format = new SimpleDateFormat("E MMM dd HH:mm:ss yyyy");
                Date vdate = new Date();
                try {
                    if (!date_start.equals("")) {
                        vdate = format.parse(date_start);
                    }
                }
                catch (Exception er) {
                    vdate = new Date();
                }
                date = dd.format(vdate);
                for (int i = 0; i < fstNmElmntLst.getLength(); ++i) {
                    try {
                        String pluginId = "";
                        String pluginFamily = "";
                        String pluginName = "";
                        String svcName = "";
                        String port = "";
                        String protocol = "";
                        String cvs_score = "";
                        String desc = "";
                        String fname = "";
                        String plugin_mod_date = "";
                        String plugin_pub_date = "";
                        String plugin_type = "";
                        String risk_factor = "";
                        String script_version = "";
                        String solution = "";
                        String synopsis = "";
                        String plugin_output = "";
                        int severity = 1;
                        String hostName = "";
                        String bid = "";
                        String cve = "";
                        String cvs_temp_score = "";
                        String cvs_vector = "";
                        String cvs_temp_vector = "";
                        String exploit_available = "";
                        String vuln_pub_date = "";
                        String xref = "";
                        String see_also = "";
                        String exploit_ease = "";
                        String osv = "";
                        String patch_pub_date = "";
                        String explo_fram_canvas = "";
                        String metasploit_name = "";
                        String exploit_fram_meta = "";
                        String exploit_fram_core = "";
                        String canvas_pack = "";
                        String plugin_version = "";
                        String compl_info = "";
                        String compl_result = "";
                        String compl_actval = "";
                        String compl_checkid = "";
                        String comp_auditfile = "";
                        String comp_checkname = "";
                        Element fstNmElmnt = (Element)fstNmElmntLst.item(i);
                        pluginId = fstNmElmnt.getAttributes().getNamedItem("pluginID").getNodeValue();
                        pluginFamily = fstNmElmnt.getAttributes().getNamedItem("pluginFamily").getNodeValue();
                        pluginName = fstNmElmnt.getAttributes().getNamedItem("pluginName").getNodeValue();
                        svcName = fstNmElmnt.getAttributes().getNamedItem("svc_name").getNodeValue();
                        port = fstNmElmnt.getAttributes().getNamedItem("port").getNodeValue();
                        protocol = fstNmElmnt.getAttributes().getNamedItem("protocol").getNodeValue();
                        try {
                            severity = Integer.parseInt(fstNmElmnt.getAttributes().getNamedItem("severity").getNodeValue());
                        }
                        catch (Exception er) {
                            er.printStackTrace();
                        }
                        String severityOut = severityLevel[severity];
                        hostName = host;
                        if (fstNmElmnt.hasChildNodes()) {
                            NodeList riBody = fstNmElmnt.getChildNodes();
                            for (int x = 0; x < riBody.getLength(); ++x) {
                                if (!riBody.item(x).hasChildNodes()) continue;
                                if (riBody.item(x).getNodeName() == "cvss_base_score") {
                                    cvs_score = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "fname") {
                                    fname = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "plugin_modification_date") {
                                    plugin_mod_date = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "script_version") {
                                    script_version = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "synopsis") {
                                    synopsis = riBody.item(x).getFirstChild().getNodeValue();
                                    synopsis = synopsis.replaceAll("\\r|\\n", " ");
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "description") {
                                    desc = riBody.item(x).getFirstChild().getNodeValue();
                                    desc = desc.replaceAll("\\r|\\n", " ");
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "risk_factor") {
                                    risk_factor = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "solution") {
                                    solution = riBody.item(x).getFirstChild().getNodeValue();
                                    solution = solution.replaceAll("\\r|\\n", " ");
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "plugin_publication_date") {
                                    plugin_pub_date = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "bid") {
                                    bid = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "cve") {
                                    cve = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "cvss_temporal_score") {
                                    cvs_temp_score = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "cvss_temporal_vector") {
                                    cvs_temp_vector = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "cvss_vector") {
                                    cvs_vector = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "exploit_available") {
                                    exploit_available = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "exploitability_ease") {
                                    exploit_ease = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "osvdb") {
                                    osv = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "see_also") {
                                    see_also = riBody.item(x).getFirstChild().getNodeValue();
                                    see_also = see_also.replaceAll("\\r|\\n", " ");
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "vuln_publication_date") {
                                    vuln_pub_date = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "xref") {
                                    xref = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "plugin_output") {
                                    plugin_output = riBody.item(x).getFirstChild().getNodeValue();
                                    plugin_output = plugin_output.replaceAll("\\r|\\n", " ");
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "patch_publication_date") {
                                    patch_pub_date = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "exploit_framework_canvas") {
                                    explo_fram_canvas = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "metasploit_name") {
                                    metasploit_name = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "exploit_framework_metasploit") {
                                    exploit_fram_meta = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "exploit_framework_core") {
                                    exploit_fram_core = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "canvas_package") {
                                    canvas_pack = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "plugin_type") {
                                    plugin_type = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "plugin_version") {
                                    plugin_version = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "cm:compliance-info") {
                                    compl_info = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "cm:compliance-result") {
                                    compl_result = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "cm:compliance-actual-value") {
                                    compl_actval = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "cm:compliance-check-id") {
                                    compl_checkid = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() == "cm:compliance-audit-file") {
                                    comp_auditfile = riBody.item(x).getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (riBody.item(x).getNodeName() != "cm:compliance-check-name") continue;
                                comp_checkname = riBody.item(x).getFirstChild().getNodeValue();
                            }
                        }
                        ++cnt;
                        Hashtable<String, Object> nessusMap = new Hashtable<String, Object>();
                        nessusMap.put("OS", osType);
                        nessusMap.put("HOSTIP", host_ip);
                        nessusMap.put("FQDN", fqdn);
                        nessusMap.put("NETBIOS", netbios);
                        nessusMap.put("PLUGINID", pluginId);
                        nessusMap.put("GROUP", pluginFamily);
                        nessusMap.put("VULNNAME", pluginName);
                        nessusMap.put("MESSAGE", pluginName);
                        nessusMap.put("SERVICENAME", svcName);
                        nessusMap.put("PORT", port);
                        nessusMap.put("PROTOCOL", protocol);
                        nessusMap.put("SEVERITYLEVEL", severityOut);
                        nessusMap.put("DEVICENAME", hostName);
                        nessusMap.put("CVSSBASESCORE", cvs_score);
                        nessusMap.put("FNAME", fname);
                        nessusMap.put("PLUGINMODDATE", plugin_mod_date);
                        nessusMap.put("SCRIPTVER", script_version);
                        nessusMap.put("SYNOPSIS", synopsis);
                        nessusMap.put("DESCRIPTION", desc);
                        nessusMap.put("RISKFACTOR", risk_factor);
                        nessusMap.put("SOLUTION", solution);
                        nessusMap.put("PLUGINPUBDATE", plugin_pub_date);
                        nessusMap.put("BID", bid);
                        nessusMap.put("CVE", cve);
                        nessusMap.put("CVSSTEMPSCORE", cvs_temp_score);
                        nessusMap.put("CVSSTEMPVECT", cvs_temp_vector);
                        nessusMap.put("CVSSVECT", cvs_vector);
                        nessusMap.put("EXPLOITAVAIL", exploit_available);
                        nessusMap.put("EXPLOITEASE", exploit_ease);
                        nessusMap.put("OSVDB", osv);
                        nessusMap.put("SEEALSO", see_also);
                        nessusMap.put("VULNPUBDATE", vuln_pub_date);
                        nessusMap.put("XREF", xref);
                        nessusMap.put("PLUGINOUTPUT", plugin_output);
                        nessusMap.put("PATCHPUBDATE", patch_pub_date);
                        nessusMap.put("EXPLOITFRAMCAN", explo_fram_canvas);
                        nessusMap.put("METASPLOITNAME", metasploit_name);
                        nessusMap.put("EXPLOITFRAMEMETA", exploit_fram_meta);
                        nessusMap.put("EXPLOITFRAMECORE", exploit_fram_core);
                        nessusMap.put("CANVASPACK", canvas_pack);
                        nessusMap.put("PLUGINVERSION", plugin_version);
                        nessusMap.put("PLUGINTYPE", plugin_type);
                        nessusMap.put("COMPLIANCEINFO", compl_info);
                        nessusMap.put("COMPLIANCERESULT", compl_result);
                        nessusMap.put("COMPLIANCEACTVALUE", compl_actval);
                        nessusMap.put("COMPLIANCECHECKID", compl_checkid);
                        nessusMap.put("COMPLIANCEAUDITFILE", comp_auditfile);
                        nessusMap.put("COMPLIANCECHECKNAME", comp_checkname);
                        nessusMap.put("CORRELATE", "true");
                        nessusMap.put("HOSTID", vuln.gethostId());
                        nessusMap.put("VULAPPID", vuln.getvulAppId());
                        nessusMap.put("SECAPPNAME", vuln.getappType());
                        nessusMap.put("HOSTNAME", vuln.getscannerName());
                        nessusMap.put("SOURCETYPE", "NESSUS");
                        nessusMap.put("TIME", date);
                        Log log = new Log();
                        nessusMap.put("HOSTTYPE", "Nessus");
                        log.parseLog("Nessus", nessusMap);
                        LogIndexingAPI.getInstance().generateLogUniqueID((Map)log);
                        Hashtable mapToNotifier = (Hashtable)nessusMap.clone();
                        mapToNotifier.put("UUID", log.get("$id$"));
                        SystemCustomPatternHandler.getInstance().parse((Hashtable)log);
                        LogDataIndexer.getInstance().indexLogData(log);
                        this.nfManager.notify(mapToNotifier);
                        continue;
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            status = "Failure";
            e.printStackTrace();
        }
        if (cnt == 0) {
            status = "Failure";
        }
        try {
            UpdateQueryImpl up = new UpdateQueryImpl("VulnAppDetails");
            up.setCriteria(new Criteria(new Column("VulnAppDetails", "VULAPPID"), (Object)vuln.getvulAppId(), 0));
            up.setUpdateColumn("STATUS", (Object)status);
            DataAccess.update((UpdateQuery)up);
        }
        catch (Exception er) {
            er.printStackTrace();
        }
        return status;
    }
}

