/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.vul;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.sa.server.lc.Log;
import com.adventnet.sa.server.lc.LogDataIndexer;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.vul.VulnDetails;
import com.adventnet.sa.server.vul.VulnHandler;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NexposeImport
implements VulnHandler {
    int cnt = 0;
    private NotificationManager nfManager = null;

    @Override
    public String importLog(VulnDetails vuln) {
        this.nfManager = NotificationManager.getInstance();
        String status = "Success";
        try {
            File file = new File(vuln.getfileLoc());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList nodeLst = doc.getElementsByTagName("node");
            for (int s = 0; s < nodeLst.getLength(); ++s) {
                Hashtable<String, Object> nodeMap = new Hashtable<String, Object>();
                Node fstNode = nodeLst.item(s);
                if (fstNode.getNodeType() != 1) continue;
                Element fstElmnt = (Element)fstNode;
                NamedNodeMap fstnode = fstElmnt.getAttributes();
                String host = fstnode.getNamedItem("address") == null ? null : fstnode.getNamedItem("address").getNodeValue();
                String deviceId = fstnode.getNamedItem("device-id") == null ? null : fstnode.getNamedItem("device-id").getNodeValue();
                String siteName = fstnode.getNamedItem("site-name") == null ? null : fstnode.getNamedItem("site-name").getNodeValue();
                String siteImportance = fstnode.getNamedItem("site-importance") == null ? null : fstnode.getNamedItem("site-importance").getNodeValue();
                String scanTemplate = fstnode.getNamedItem("scan-template") == null ? null : fstnode.getNamedItem("scan-template").getNodeValue();
                String riskScore = fstnode.getNamedItem("risk-score") == null ? null : fstnode.getNamedItem("risk-score").getNodeValue();
                NodeList osBody = fstElmnt.getElementsByTagName("os");
                Node osnode = osBody.item(0);
                if (osnode.getNodeType() == 1) {
                    Element osElmnt = (Element)osnode;
                    String osname = osElmnt.getAttributes() == null ? null : osElmnt.getAttributes().getNamedItem("vendor").getNodeValue();
                    this.mapping(nodeMap, "OS", osname);
                }
                this.mapping(nodeMap, "DEVICENAME", host);
                this.mapping(nodeMap, "DEVICEID", deviceId);
                this.mapping(nodeMap, "SITENAME", siteName);
                this.mapping(nodeMap, "SITEIMPORTANCE", siteImportance);
                this.mapping(nodeMap, "SCANTEMPLATE", scanTemplate);
                this.mapping(nodeMap, "RISKSCORE", riskScore);
                nodeMap.put("HOSTID", vuln.gethostId());
                nodeMap.put("VULAPPID", vuln.getvulAppId());
                nodeMap.put("SECAPPNAME", vuln.getappType());
                nodeMap.put("HOSTNAME", vuln.getscannerName());
                if (!fstElmnt.hasChildNodes()) continue;
                NodeList nodeBody = fstElmnt.getChildNodes();
                for (int x = 0; x < nodeBody.getLength(); ++x) {
                    Element endpsElmnt;
                    if (nodeBody.item(x).hasChildNodes() && nodeBody.item(x).getNodeName() == "tests") {
                        Element tstsElmnt = (Element)nodeBody.item(x);
                        if (!tstsElmnt.hasChildNodes()) continue;
                        NodeList tstsBody = tstsElmnt.getChildNodes();
                        for (int i = 0; i < tstsBody.getLength(); ++i) {
                            Hashtable<String, Object> testMap = new Hashtable<String, Object>();
                            testMap.putAll(nodeMap);
                            if (!tstsBody.item(i).hasChildNodes() || tstsBody.item(i).getNodeName() != "test") continue;
                            Element tstElmnt = (Element)tstsBody.item(i);
                            this.testElementMapping(tstElmnt, testMap, doc);
                        }
                        continue;
                    }
                    if (nodeBody.item(x).getNodeName() != "endpoints" || !(endpsElmnt = (Element)nodeBody.item(x)).hasChildNodes()) continue;
                    NodeList endpointsBody = endpsElmnt.getChildNodes();
                    for (int y = 0; y < endpointsBody.getLength(); ++y) {
                        String portStatus;
                        if (!endpointsBody.item(y).hasChildNodes() || endpointsBody.item(y).getNodeName() != "endpoint") continue;
                        Element endpElmnt = (Element)endpointsBody.item(y);
                        String protocol = endpElmnt.getAttributes().getNamedItem("protocol") == null ? null : endpElmnt.getAttributes().getNamedItem("protocol").getNodeValue();
                        String port = endpElmnt.getAttributes().getNamedItem("port") == null ? null : endpElmnt.getAttributes().getNamedItem("port").getNodeValue();
                        String string = portStatus = endpElmnt.getAttributes().getNamedItem("status") == null ? null : endpElmnt.getAttributes().getNamedItem("status").getNodeValue();
                        if (!endpElmnt.hasChildNodes()) continue;
                        NodeList endpointBody = endpElmnt.getChildNodes();
                        for (int z = 0; z < endpointBody.getLength(); ++z) {
                            Element servicesElmnt;
                            if (!endpointBody.item(z).hasChildNodes() || endpointBody.item(z).getNodeName() != "services" || !(servicesElmnt = (Element)endpointBody.item(z)).hasChildNodes()) continue;
                            NodeList servicesBody = servicesElmnt.getChildNodes();
                            for (int t = 0; t < servicesBody.getLength(); ++t) {
                                String service;
                                if (!servicesBody.item(t).hasChildNodes() || servicesBody.item(t).getNodeName() != "service") continue;
                                Element serviceElmnt = (Element)servicesBody.item(t);
                                String string2 = service = serviceElmnt.getAttributes().getNamedItem("name") == null ? null : serviceElmnt.getAttributes().getNamedItem("name").getNodeValue();
                                if (!serviceElmnt.hasChildNodes()) continue;
                                NodeList serviceBody = serviceElmnt.getChildNodes();
                                for (int u = 0; u < serviceBody.getLength(); ++u) {
                                    if (!serviceBody.item(u).hasChildNodes() || serviceBody.item(u).getNodeName() != "tests") continue;
                                    Element testsElmnt = (Element)serviceBody.item(u);
                                    if (!serviceElmnt.hasChildNodes()) continue;
                                    NodeList testsBody = testsElmnt.getChildNodes();
                                    for (int v = 0; v < testsBody.getLength(); ++v) {
                                        Hashtable<String, Object> endpointMap = new Hashtable<String, Object>();
                                        endpointMap.putAll(nodeMap);
                                        endpointMap.put("PORT", port);
                                        endpointMap.put("PROTOCOL", protocol);
                                        endpointMap.put("SERVICENAME", service);
                                        endpointMap.put("STATUS", portStatus);
                                        if (!testsBody.item(v).hasChildNodes() || testsBody.item(v).getNodeName() != "test") continue;
                                        Element testElmnt = (Element)testsBody.item(v);
                                        this.testElementMapping(testElmnt, endpointMap, doc);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            status = "Failure";
            e.printStackTrace();
        }
        if (this.cnt == 0) {
            status = "Failure";
        }
        try {
            UpdateQueryImpl up = new UpdateQueryImpl("VulnAppDetails");
            up.setCriteria(new Criteria(new Column("VulnAppDetails", "VULAPPID"), (Object)vuln.getvulAppId(), 0));
            up.setUpdateColumn("STATUS", (Object)status);
            DataAccess.update((UpdateQuery)up);
        }
        catch (Exception er) {
            er.printStackTrace();
        }
        return status;
    }

    private void testElementMapping(Element testElmnt, Hashtable testMap, Document doc) {
        NamedNodeMap tstnode = testElmnt.getAttributes();
        String vulId = tstnode.getNamedItem("id") == null ? null : tstnode.getNamedItem("id").getNodeValue();
        String key = tstnode.getNamedItem("key") == null ? null : tstnode.getNamedItem("key").getNodeValue();
        String vulStatus = tstnode.getNamedItem("status") == null ? null : tstnode.getNamedItem("status").getNodeValue();
        String scanId = tstnode.getNamedItem("scan-id") == null ? null : tstnode.getNamedItem("scan-id").getNodeValue();
        String vulSince = tstnode.getNamedItem("vulnerable-since") == null ? null : tstnode.getNamedItem("vulnerable-since").getNodeValue();
        vulSince = this.datetime(vulSince);
        String pciStatus = tstnode.getNamedItem("pci-compliance-status") == null ? null : tstnode.getNamedItem("pci-compliance-status").getNodeValue();
        this.mapping(testMap, "VULID", vulId);
        this.mapping(testMap, "KEY", key);
        this.mapping(testMap, "VULNSTATUS", vulStatus);
        this.mapping(testMap, "SCANID", scanId);
        this.mapping(testMap, "TIME", vulSince);
        this.mapping(testMap, "PCISTATUS", pciStatus);
        this.vulnerable(testMap, doc, vulId);
        ++this.cnt;
        testMap.put("CORRELATE", "true");
        testMap.put("SOURCETYPE", "NEXPOSE");
        Log log = new Log();
        testMap.put("HOSTTYPE", "Nexpose");
        log.parseLog("Nexpose", testMap);
        SystemCustomPatternHandler.getInstance().parse((Hashtable)log);
        LogIndexingAPI.getInstance().generateLogUniqueID((Map)log);
        Hashtable mapToNotifier = (Hashtable)testMap.clone();
        mapToNotifier.put("UUID", log.get("$id$"));
        LogDataIndexer.getInstance().indexLogData(log);
        this.nfManager.notify(mapToNotifier);
    }

    private void mapping(Hashtable map, String key, String value) {
        if (value != null && !value.isEmpty()) {
            map.put(key, value);
        }
    }

    private String riskFactor(String riskval) {
        Double var = Double.parseDouble(riskval);
        String riskFac = null;
        if (var >= 0.0 && var <= 3.9) {
            riskFac = "Low";
        } else if (var >= 4.0 && var <= 6.9) {
            riskFac = "Medium";
        } else if (var >= 7.0 && var <= 8.9) {
            riskFac = "High";
        } else if (var >= 9.0 && var <= 10.0) {
            riskFac = "Critical";
        }
        return riskFac;
    }

    private void vulnerable(Hashtable tempMap, Document doc, String vulId) {
        NodeList vulList = doc.getElementsByTagName("vulnerability");
        for (int k = 0; k < vulList.getLength(); ++k) {
            Element thrElmnt;
            NamedNodeMap thrnode;
            String vulnerabilityId;
            Node thrNode = vulList.item(k);
            if (thrNode.getNodeType() != 1 || !(vulnerabilityId = (thrnode = (thrElmnt = (Element)thrNode).getAttributes()).getNamedItem("id").getNodeValue()).equals(vulId)) continue;
            String vulTitle = thrnode.getNamedItem("title") == null ? null : thrnode.getNamedItem("title").getNodeValue();
            String severity = thrnode.getNamedItem("severity") == null ? null : thrnode.getNamedItem("severity").getNodeValue();
            String pciSeverity = thrnode.getNamedItem("pciSeverity") == null ? null : thrnode.getNamedItem("pciSeverity").getNodeValue();
            String cvss = thrnode.getNamedItem("cvssScore") == null ? null : thrnode.getNamedItem("cvssScore").getNodeValue();
            String risk = this.riskFactor(cvss);
            String cvssVect = thrnode.getNamedItem("cvssVector") == null ? null : thrnode.getNamedItem("cvssVector").getNodeValue();
            String Published = thrnode.getNamedItem("published") == null ? null : thrnode.getNamedItem("published").getNodeValue();
            String Added = thrnode.getNamedItem("added") == null ? null : thrnode.getNamedItem("added").getNodeValue();
            String Modified = thrnode.getNamedItem("modified") == null ? null : thrnode.getNamedItem("modified").getNodeValue();
            Published = this.datetime(Published);
            Added = this.datetime(Added);
            Modified = this.datetime(Modified);
            this.mapping(tempMap, "VULNNAME", vulTitle);
            this.mapping(tempMap, "MESSAGE", vulTitle);
            this.mapping(tempMap, "SEVERITYLEVEL", severity);
            this.mapping(tempMap, "PCISEVERITY", pciSeverity);
            this.mapping(tempMap, "CVSSBASESCORE", cvss);
            this.mapping(tempMap, "RISKFACTOR", risk);
            this.mapping(tempMap, "CVSSVECT", cvssVect);
            this.mapping(tempMap, "PUBDATE", Published);
            this.mapping(tempMap, "ADDDATE", Added);
            this.mapping(tempMap, "MODDATE", Modified);
        }
    }

    private String datetime(String param) {
        SimpleDateFormat dd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
        Date vdate = new Date();
        try {
            if (!param.equals("")) {
                vdate = format.parse(param);
            }
        }
        catch (Exception er) {
            vdate = new Date();
        }
        String date = dd.format(vdate);
        return date;
    }
}

