/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.vul;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.sa.server.lc.Log;
import com.adventnet.sa.server.lc.LogDataIndexer;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.vul.VulnDetails;
import com.adventnet.sa.server.vul.VulnHandler;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.elasticsearch.common.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OpenVasImport
implements VulnHandler {
    private NotificationManager nfManager = null;

    @Override
    public String importLog(VulnDetails vuln) {
        this.nfManager = NotificationManager.getInstance();
        String status = "Success";
        int cnt = 0;
        try {
            String scan_time = "";
            String date = "";
            Date vDate = null;
            SimpleDateFormat dd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            boolean timeParsed = false;
            File file = new File(vuln.getfileLoc());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList nodeLst = doc.getElementsByTagName("result");
            try {
                scan_time = doc.getElementsByTagName("scan_start").item(0).getFirstChild().getNodeValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!Strings.isNullOrEmpty((String)scan_time) && scan_time.length() > 10) {
                scan_time = scan_time.replaceAll("[a-zA-Z]", " ");
                try {
                    vDate = dd.parse(scan_time);
                    date = dd.format(vDate);
                    timeParsed = true;
                }
                catch (Exception e) {
                    timeParsed = false;
                }
            }
            if (!timeParsed) {
                vDate = new Date();
                date = dd.format(vDate);
            }
            for (int s = 0; s < nodeLst.getLength(); ++s) {
                try {
                    Element fstElmnt;
                    String oid = "";
                    String port = "";
                    String name = "";
                    String family = "";
                    String cvs_base = "";
                    String risk_factor = "";
                    String cve = "";
                    String bid = "";
                    String tags = "";
                    String threat = "";
                    String original_threat = "";
                    String description = "";
                    String subnet = "";
                    String host = "";
                    String xref = "";
                    String vulnId = "";
                    Node fstNode = nodeLst.item(s);
                    if (fstNode.getNodeType() == 1 && (fstElmnt = (Element)fstNode).hasChildNodes()) {
                        NodeList riBody = fstElmnt.getChildNodes();
                        for (int x = 0; x < riBody.getLength(); ++x) {
                            if (!riBody.item(x).hasChildNodes()) continue;
                            if (riBody.item(x).getNodeName() == "nvt") {
                                Element nvtElem = (Element)riBody.item(x);
                                oid = nvtElem.getAttributes().getNamedItem("oid").getNodeValue();
                                vulnId = oid.substring(oid.lastIndexOf(".") + 1, oid.length());
                                NodeList nvtBody = nvtElem.getChildNodes();
                                for (int y = 0; y < nvtBody.getLength(); ++y) {
                                    try {
                                        if (nvtBody.item(y).getNodeName() == "name") {
                                            name = nvtBody.item(y).getFirstChild().getNodeValue();
                                            continue;
                                        }
                                        if (nvtBody.item(y).getNodeName() == "family") {
                                            family = nvtBody.item(y).getFirstChild().getNodeValue();
                                            continue;
                                        }
                                        if (nvtBody.item(y).getNodeName() == "cvss_base") {
                                            cvs_base = nvtBody.item(y).getFirstChild().getNodeValue();
                                            continue;
                                        }
                                        if (nvtBody.item(y).getNodeName() == "risk_factor") {
                                            risk_factor = nvtBody.item(y).getFirstChild().getNodeValue();
                                            continue;
                                        }
                                        if (nvtBody.item(y).getNodeName() == "cve") {
                                            cve = nvtBody.item(y).getFirstChild().getNodeValue();
                                            continue;
                                        }
                                        if (nvtBody.item(y).getNodeName() == "bid") {
                                            bid = nvtBody.item(y).getFirstChild().getNodeValue();
                                            continue;
                                        }
                                        if (nvtBody.item(y).getNodeName() == "tags") {
                                            tags = nvtBody.item(y).getFirstChild().getNodeValue();
                                            continue;
                                        }
                                        if (nvtBody.item(y).getNodeName() != "xref") continue;
                                        xref = nvtBody.item(y).getFirstChild().getNodeValue();
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                continue;
                            }
                            if (riBody.item(x).getNodeName() == "subnet") {
                                subnet = riBody.item(x).getFirstChild().getNodeValue();
                                continue;
                            }
                            if (riBody.item(x).getNodeName() == "host") {
                                host = riBody.item(x).getFirstChild().getNodeValue();
                                continue;
                            }
                            if (riBody.item(x).getNodeName() == "port") {
                                port = riBody.item(x).getFirstChild().getNodeValue();
                                continue;
                            }
                            if (riBody.item(x).getNodeName() == "threat") {
                                threat = riBody.item(x).getFirstChild().getNodeValue();
                                continue;
                            }
                            if (riBody.item(x).getNodeName() == "description") {
                                description = riBody.item(x).getFirstChild().getNodeValue();
                                continue;
                            }
                            if (riBody.item(x).getNodeName() != "original_threat") continue;
                            original_threat = riBody.item(x).getFirstChild().getNodeValue();
                        }
                    }
                    Hashtable<String, Object> openVas = new Hashtable<String, Object>();
                    openVas.put("DEVICENAME", host);
                    openVas.put("VULID", vulnId);
                    openVas.put("PORT", port);
                    openVas.put("SUBNET", subnet);
                    openVas.put("DESCRIPTION", description);
                    openVas.put("RISKFACTOR", risk_factor);
                    openVas.put("SEVERITYLEVEL", original_threat);
                    openVas.put("THREAT", threat);
                    openVas.put("CVE", cve);
                    openVas.put("CVSSBASESCORE", cvs_base);
                    openVas.put("VULNNAME", name);
                    openVas.put("MESSAGE", name);
                    openVas.put("GROUP", family);
                    openVas.put("CORRELATE", "true");
                    openVas.put("TAGS", tags);
                    openVas.put("XREF", xref);
                    openVas.put("BID", bid);
                    openVas.put("SOURCETYPE", "OPENVAS");
                    openVas.put("HOSTID", vuln.gethostId());
                    openVas.put("VULAPPID", vuln.getvulAppId());
                    openVas.put("SECAPPNAME", vuln.getappType());
                    openVas.put("HOSTNAME", vuln.getscannerName());
                    openVas.put("HOSTTYPE", "OpenVas");
                    openVas.put("TIME", date);
                    Log log = new Log();
                    openVas.put("HOSTTYPE", "OpenVas");
                    log.parseLog("OpenVas", openVas);
                    SystemCustomPatternHandler.getInstance().parse((Hashtable)log);
                    LogIndexingAPI.getInstance().generateLogUniqueID((Map)log);
                    Hashtable mapToNotifier = (Hashtable)openVas.clone();
                    mapToNotifier.put("UUID", log.get("$id$"));
                    LogDataIndexer.getInstance().indexLogData(log);
                    this.nfManager.notify(mapToNotifier);
                    ++cnt;
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            status = "Failure";
            e.printStackTrace();
        }
        if (cnt == 0) {
            status = "Failure";
        }
        try {
            UpdateQueryImpl up = new UpdateQueryImpl("VulnAppDetails");
            up.setCriteria(new Criteria(new Column("VulnAppDetails", "VULAPPID"), (Object)vuln.getvulAppId(), 0));
            up.setUpdateColumn("STATUS", (Object)status);
            DataAccess.update((UpdateQuery)up);
        }
        catch (Exception er) {
            er.printStackTrace();
        }
        return status;
    }
}

