/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.vul;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.sa.server.lc.Log;
import com.adventnet.sa.server.lc.LogDataIndexer;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.vul.VulnDetails;
import com.adventnet.sa.server.vul.VulnHandler;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QualysImport
implements VulnHandler {
    private NotificationManager nfManager = null;

    @Override
    public String importLog(VulnDetails vuln) {
        this.nfManager = NotificationManager.getInstance();
        String status = "Success";
        int cnt = 0;
        try {
            String[] severityLevel = new String[]{"Minimal", "Medium", "Serious", "Critical", "Urgent"};
            String host = "";
            String ip = "";
            File file = new File(vuln.getfileLoc());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList scannodeLst = doc.getElementsByTagName("SCAN");
            String datescan = "";
            String date = "";
            for (int u = 0; u < scannodeLst.getLength(); ++u) {
                Node scanfstNode = scannodeLst.item(u);
                if (scanfstNode.getNodeType() != 1) continue;
                Element scanfstElmnt = (Element)scanfstNode;
                NodeList headerElemt = scanfstElmnt.getElementsByTagName("HEADER");
                for (int m = 0; m < headerElemt.getLength(); ++m) {
                    Node fstNode = headerElemt.item(m);
                    if (fstNode.getNodeType() != 1) continue;
                    Element fstElmnt = (Element)fstNode;
                    NodeList scanipChEl = fstElmnt.getElementsByTagName("KEY");
                    for (int sipc = 0; sipc < scanipChEl.getLength(); ++sipc) {
                        Element tagElement = (Element)scanipChEl.item(sipc);
                        if (!"DATE".equals(tagElement.getAttributes().getNamedItem("value").getNodeValue())) continue;
                        datescan = tagElement.getFirstChild().getNodeValue();
                    }
                }
            }
            SimpleDateFormat dd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            Date vdate = new Date();
            try {
                if (!datescan.equals("")) {
                    vdate = format.parse(datescan);
                }
            }
            catch (Exception er) {
                vdate = new Date();
            }
            date = dd.format(vdate);
            NodeList nodeLst = doc.getElementsByTagName("IP");
            for (int s = 0; s < nodeLst.getLength(); ++s) {
                String Os = "";
                String Netbios = "";
                Node fstNode = nodeLst.item(s);
                if (fstNode.getNodeType() != 1) continue;
                Element fstElmnt = (Element)fstNode;
                host = fstElmnt.getAttributes().getNamedItem("name").getNodeValue();
                ip = fstElmnt.getAttributes().getNamedItem("value").getNodeValue();
                NodeList ipChEl = fstElmnt.getChildNodes();
                for (int ipc = 0; ipc < ipChEl.getLength(); ++ipc) {
                    if (!ipChEl.item(ipc).hasChildNodes()) continue;
                    if (ipChEl.item(ipc).getNodeName() == "OS") {
                        Os = ipChEl.item(ipc).getFirstChild().getNodeValue();
                        continue;
                    }
                    if (ipChEl.item(ipc).getNodeName() != "NETBIOS_HOSTNAME") continue;
                    Netbios = ipChEl.item(ipc).getFirstChild().getNodeValue();
                }
                String[] qualysArray = new String[]{"VULNS", "INFOS", "SERVICES", "PRACTICES"};
                String[] qualyssecArray = new String[]{"VULN", "INFO", "SERVICE", "PRACTICE"};
                for (int q = 0; q < qualysArray.length; ++q) {
                    NodeList vulnsElemetLst = fstElmnt.getElementsByTagName(qualysArray[q]);
                    for (int l = 0; l < vulnsElemetLst.getLength(); ++l) {
                        Node vulNode = vulnsElemetLst.item(l);
                        if (vulNode.getNodeType() != 1) continue;
                        Element vulElem = (Element)vulNode;
                        NodeList vulCatList = vulElem.getElementsByTagName("CAT");
                        for (int i = 0; i < vulCatList.getLength(); ++i) {
                            String catvalue = "";
                            String port = "";
                            String protocol = "";
                            Element vulcatelm = (Element)vulCatList.item(i);
                            catvalue = vulcatelm.getAttributes().getNamedItem("value") != null ? vulcatelm.getAttributes().getNamedItem("value").getNodeValue() : "";
                            port = vulcatelm.getAttributes().getNamedItem("port") != null ? vulcatelm.getAttributes().getNamedItem("port").getNodeValue() : "";
                            protocol = vulcatelm.getAttributes().getNamedItem("protocol") != null ? vulcatelm.getAttributes().getNamedItem("protocol").getNodeValue() : "";
                            NodeList invulCatList = vulcatelm.getElementsByTagName(qualyssecArray[q]);
                            for (int j = 0; j < invulCatList.getLength(); ++j) {
                                try {
                                    ++cnt;
                                    StringBuilder venBuild = new StringBuilder();
                                    StringBuilder bugBuild = new StringBuilder();
                                    StringBuilder cveidBuild = new StringBuilder();
                                    StringBuilder exploits = new StringBuilder();
                                    StringBuilder malware = new StringBuilder();
                                    String title = "";
                                    String last_update = "";
                                    String cvss_base = "";
                                    String cvss_temporal = "";
                                    String pci_flag = "";
                                    String vendor_ref_list = "";
                                    String bug_id_list = "";
                                    String cve_id_list = "";
                                    String diagonis = "";
                                    String conseq = "";
                                    String solution = "";
                                    String result = "";
                                    String cvss_base_source = "";
                                    String compliance = "";
                                    String correlation = "";
                                    String vulNo = "";
                                    String vulncveid = "";
                                    int vulSeverity = 1;
                                    Element invulcatelm = (Element)invulCatList.item(j);
                                    vulNo = invulcatelm.getAttributes().getNamedItem("number").getNodeValue();
                                    try {
                                        vulSeverity = Integer.parseInt(invulcatelm.getAttributes().getNamedItem("severity").getNodeValue());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    String vulSeverityOut = severityLevel[vulSeverity - 1];
                                    String string = vulncveid = invulcatelm.getAttributes().getNamedItem("cveid") != null ? invulcatelm.getAttributes().getNamedItem("cveid").getNodeValue() : "";
                                    if (invulcatelm.hasChildNodes()) {
                                        NodeList vulBody = invulcatelm.getChildNodes();
                                        for (int x = 0; x < vulBody.getLength(); ++x) {
                                            int c;
                                            int a;
                                            if (!vulBody.item(x).hasChildNodes()) continue;
                                            if (vulBody.item(x).getNodeName() == "TITLE") {
                                                title = vulBody.item(x).getFirstChild().getNodeValue();
                                                continue;
                                            }
                                            if (vulBody.item(x).getNodeName() == "LAST_UPDATE") {
                                                last_update = vulBody.item(x).getFirstChild().getNodeValue();
                                                continue;
                                            }
                                            if (vulBody.item(x).getNodeName() == "CVSS_BASE") {
                                                cvss_base = vulBody.item(x).getFirstChild().getNodeValue();
                                                continue;
                                            }
                                            if (vulBody.item(x).getNodeName() == "CVSS_TEMPORAL") {
                                                cvss_temporal = vulBody.item(x).getFirstChild().getNodeValue();
                                                continue;
                                            }
                                            if (vulBody.item(x).getNodeName() == "PCI_FLAG") {
                                                pci_flag = vulBody.item(x).getFirstChild().getNodeValue();
                                                continue;
                                            }
                                            if (vulBody.item(x).getNodeName() == "VENDOR_REFERENCE_LIST") {
                                                Element venElem = (Element)vulBody.item(x);
                                                NodeList venList = venElem.getElementsByTagName("VENDOR_REFERENCE");
                                                for (a = 0; a < venList.getLength(); ++a) {
                                                    venBuild.append("VENDOR REFERENCE ID LIST " + (a + 1) + " ( ");
                                                    String venid = "";
                                                    String venurl = "";
                                                    Element venrefElem = (Element)venList.item(a);
                                                    if (!venrefElem.hasChildNodes()) continue;
                                                    NodeList venrefChild = venrefElem.getChildNodes();
                                                    for (c = 0; c < venrefChild.getLength(); ++c) {
                                                        if (!venrefChild.item(c).hasChildNodes()) continue;
                                                        if ("ID".equals(venrefChild.item(c).getNodeName())) {
                                                            venid = venrefChild.item(c).getFirstChild().getNodeValue();
                                                            venBuild.append("VENDOR REFERENCE ID = " + venid);
                                                            venBuild.append(" , ");
                                                            continue;
                                                        }
                                                        if (!"URL".equals(venrefChild.item(c).getNodeName())) continue;
                                                        venurl = venrefChild.item(c).getFirstChild().getNodeValue();
                                                        venBuild.append("VENDOR REFERENCE URL = " + venurl);
                                                        venBuild.append(" , ");
                                                    }
                                                    venBuild.append(" ) ");
                                                }
                                                continue;
                                            }
                                            if (vulBody.item(x).getNodeName() == "BUGTRAQ_ID_LIST") {
                                                Element bugelElem = (Element)vulBody.item(x);
                                                NodeList bugelList = bugelElem.getElementsByTagName("BUGTRAQ_ID");
                                                for (a = 0; a < bugelList.getLength(); ++a) {
                                                    bugBuild.append("BUGTRAQ ID LIST " + (a + 1) + " ( ");
                                                    String bugid = "";
                                                    String bugurl = "";
                                                    Element bugidElem = (Element)bugelList.item(a);
                                                    if (!bugidElem.hasChildNodes()) continue;
                                                    NodeList bugidChild = bugidElem.getChildNodes();
                                                    for (c = 0; c < bugidChild.getLength(); ++c) {
                                                        if (!bugidChild.item(c).hasChildNodes()) continue;
                                                        if ("ID".equals(bugidChild.item(c).getNodeName())) {
                                                            bugid = bugidChild.item(c).getFirstChild().getNodeValue();
                                                            bugBuild.append("BUGTRAQ ID = " + bugid);
                                                            bugBuild.append(" , ");
                                                            continue;
                                                        }
                                                        if (!"URL".equals(bugidChild.item(c).getNodeName())) continue;
                                                        bugurl = bugidChild.item(c).getFirstChild().getNodeValue();
                                                        bugBuild.append("BUGTRAQ URL = " + bugurl);
                                                        bugBuild.append(" , ");
                                                    }
                                                    bugBuild.append(" ) ");
                                                }
                                                continue;
                                            }
                                            if (vulBody.item(x).getNodeName() == "CVE_ID_LIST") {
                                                Element cvelElem = (Element)vulBody.item(x);
                                                NodeList cvelList = cvelElem.getElementsByTagName("CVE_ID");
                                                for (a = 0; a < cvelList.getLength(); ++a) {
                                                    cveidBuild.append("CVE ID LIST " + (a + 1) + " ( ");
                                                    String cveid = "";
                                                    String cveurl = "";
                                                    Element cveidElem = (Element)cvelList.item(a);
                                                    if (!cveidElem.hasChildNodes()) continue;
                                                    NodeList cveidChild = cveidElem.getChildNodes();
                                                    for (c = 0; c < cveidChild.getLength(); ++c) {
                                                        if (!cveidChild.item(c).hasChildNodes()) continue;
                                                        if ("ID".equals(cveidChild.item(c).getNodeName())) {
                                                            cveid = cveidChild.item(c).getFirstChild().getNodeValue();
                                                            cveidBuild.append("CVE ID = " + cveid);
                                                            cveidBuild.append(" , ");
                                                            continue;
                                                        }
                                                        if (!"URL".equals(cveidChild.item(c).getNodeName())) continue;
                                                        cveurl = cveidChild.item(c).getFirstChild().getNodeValue();
                                                        cveidBuild.append("CVE URL = " + cveurl);
                                                        cveidBuild.append(" , ");
                                                    }
                                                    cveidBuild.append(" ) ");
                                                }
                                                continue;
                                            }
                                            if (vulBody.item(x).getNodeName() == "DIAGNOSIS") {
                                                diagonis = vulBody.item(x).getFirstChild().getNodeValue();
                                                continue;
                                            }
                                            if (vulBody.item(x).getNodeName() == "CONSEQUENCE") {
                                                conseq = vulBody.item(x).getFirstChild().getNodeValue();
                                                continue;
                                            }
                                            if (vulBody.item(x).getNodeName() == "SOLUTION") {
                                                solution = vulBody.item(x).getFirstChild().getNodeValue();
                                                continue;
                                            }
                                            if (vulBody.item(x).getNodeName() == "COMPLIANCE") {
                                                compliance = vulBody.item(x).getFirstChild().getNodeValue();
                                                continue;
                                            }
                                            if (vulBody.item(x).getNodeName() == "CORRELATION") {
                                                int d;
                                                int c2;
                                                Element correlElem = (Element)vulBody.item(x);
                                                NodeList correlList = correlElem.getElementsByTagName("EXPLOITS");
                                                for (a = 0; a < correlList.getLength(); ++a) {
                                                    Element exploitElem = (Element)correlList.item(a);
                                                    NodeList exploitList = exploitElem.getElementsByTagName("EXPLT_SRC");
                                                    for (int b = 0; b < exploitList.getLength(); ++b) {
                                                        exploits.append(" Exploits Source " + (b + 1) + " = ( ");
                                                        String exsrcName = "";
                                                        Element exploitsrcElem = (Element)exploitList.item(b);
                                                        if (exploitsrcElem.hasChildNodes()) {
                                                            NodeList exploitChild = exploitsrcElem.getChildNodes();
                                                            for (c2 = 0; c2 < exploitChild.getLength(); ++c2) {
                                                                if (!exploitChild.item(c2).hasChildNodes()) continue;
                                                                if ("SRC_NAME".equals(exploitChild.item(c2).getNodeName())) {
                                                                    exsrcName = exploitChild.item(c2).getFirstChild().getNodeValue();
                                                                    exploits.append("Service Name = " + exsrcName);
                                                                    exploits.append(" , ");
                                                                    continue;
                                                                }
                                                                if (!"EXPLT_LIST".equals(exploitChild.item(c2).getNodeName())) continue;
                                                                Element expltlistElem = (Element)exploitChild.item(c2);
                                                                NodeList expllList = correlElem.getElementsByTagName("EXPLT");
                                                                for (d = 0; d < expllList.getLength(); ++d) {
                                                                    exploits.append(" Exploit " + (d + 1) + " = ( ");
                                                                    String expltRef = "";
                                                                    String expltDesc = "";
                                                                    String expltLink = "";
                                                                    Element expltElem = (Element)expllList.item(d);
                                                                    if (!expltElem.hasChildNodes()) continue;
                                                                    NodeList expltChild = expltElem.getChildNodes();
                                                                    for (int e = 0; e < expltChild.getLength(); ++e) {
                                                                        if (!expltChild.item(e).hasChildNodes()) continue;
                                                                        if ("REF".equals(expltChild.item(e).getNodeName())) {
                                                                            expltRef = expltChild.item(e).getFirstChild().getNodeValue();
                                                                            exploits.append("Reference =" + expltRef);
                                                                            exploits.append(" , ");
                                                                            continue;
                                                                        }
                                                                        if ("DESC".equals(expltChild.item(e).getNodeName())) {
                                                                            expltDesc = expltChild.item(e).getFirstChild().getNodeValue();
                                                                            exploits.append("Description =" + expltDesc);
                                                                            exploits.append(" , ");
                                                                            continue;
                                                                        }
                                                                        if (!"LINK".equals(expltChild.item(e).getNodeName())) continue;
                                                                        expltLink = expltChild.item(e).getFirstChild().getNodeValue();
                                                                        exploits.append("Link =" + expltLink);
                                                                        exploits.append(" , ");
                                                                    }
                                                                    exploits.append(" ) ");
                                                                }
                                                            }
                                                        }
                                                        exploits.append(" ) ");
                                                    }
                                                }
                                                Element malwareElem = (Element)vulBody.item(x);
                                                NodeList malwList = malwareElem.getElementsByTagName("MALWARE");
                                                for (a = 0; a < malwList.getLength(); ++a) {
                                                    Element malElem = (Element)malwList.item(a);
                                                    NodeList malList = malElem.getElementsByTagName("MW_SRC");
                                                    for (int b = 0; b < malList.getLength(); ++b) {
                                                        malware.append(" Malware Source " + (b + 1) + " = ( ");
                                                        String mlsrcName = "";
                                                        Element malsrcElem = (Element)malList.item(b);
                                                        if (malsrcElem.hasChildNodes()) {
                                                            NodeList malChild = malsrcElem.getChildNodes();
                                                            for (c2 = 0; c2 < malChild.getLength(); ++c2) {
                                                                if (!malChild.item(c2).hasChildNodes()) continue;
                                                                if ("SRC_NAME".equals(malChild.item(c2).getNodeName())) {
                                                                    mlsrcName = malChild.item(c2).getFirstChild().getNodeValue();
                                                                    malware.append("Service Name = " + mlsrcName);
                                                                    malware.append(" , ");
                                                                    continue;
                                                                }
                                                                if (!"MW_LIST".equals(malChild.item(c2).getNodeName())) continue;
                                                                Element mallistElem = (Element)malChild.item(c2);
                                                                NodeList malllList = malwareElem.getElementsByTagName("MW_INFO");
                                                                for (d = 0; d < malllList.getLength(); ++d) {
                                                                    malware.append(" Malware " + (d + 1) + " = ( ");
                                                                    String mid = "";
                                                                    String mtype = "";
                                                                    String mplatform = "";
                                                                    String mrating = "";
                                                                    String mlink = "";
                                                                    String malias = "";
                                                                    Element malwElem = (Element)malllList.item(d);
                                                                    if (!malwElem.hasChildNodes()) continue;
                                                                    NodeList malwChild = malwElem.getChildNodes();
                                                                    for (int e = 0; e < malwChild.getLength(); ++e) {
                                                                        if (!malwChild.item(e).hasChildNodes()) continue;
                                                                        if ("MW_ID".equals(malwChild.item(e).getNodeName())) {
                                                                            mid = malwChild.item(e).getFirstChild().getNodeValue();
                                                                            malware.append("Malware Id =" + mid);
                                                                            malware.append(" , ");
                                                                            continue;
                                                                        }
                                                                        if ("MW_TYPE".equals(malwChild.item(e).getNodeName())) {
                                                                            mtype = malwChild.item(e).getFirstChild().getNodeValue();
                                                                            malware.append("Malware Type =" + mtype);
                                                                            malware.append(" , ");
                                                                            continue;
                                                                        }
                                                                        if ("MW_PLATFORM".equals(malwChild.item(e).getNodeName())) {
                                                                            mplatform = malwChild.item(e).getFirstChild().getNodeValue();
                                                                            malware.append("Malware Platform =" + mplatform);
                                                                            malware.append(" , ");
                                                                            continue;
                                                                        }
                                                                        if ("MW_RATING".equals(malwChild.item(e).getNodeName())) {
                                                                            mrating = malwChild.item(e).getFirstChild().getNodeValue();
                                                                            malware.append("Malware Rating =" + mrating);
                                                                            malware.append(" , ");
                                                                            continue;
                                                                        }
                                                                        if ("MW_LINK".equals(malwChild.item(e).getNodeName())) {
                                                                            mlink = malwChild.item(e).getFirstChild().getNodeValue();
                                                                            malware.append("Malware Link =" + mlink);
                                                                            malware.append(" , ");
                                                                            continue;
                                                                        }
                                                                        if (!"MW_ALIAS".equals(malwChild.item(e).getNodeName())) continue;
                                                                        malias = malwChild.item(e).getFirstChild().getNodeValue();
                                                                        malware.append("Malware Alias =" + mlink);
                                                                        malware.append(" , ");
                                                                    }
                                                                    malware.append(" ) ");
                                                                }
                                                            }
                                                        }
                                                        malware.append(" ) ");
                                                    }
                                                }
                                                continue;
                                            }
                                            if (vulBody.item(x).getNodeName() != "RESULT") continue;
                                            result = vulBody.item(x).getFirstChild().getNodeValue();
                                        }
                                    }
                                    Hashtable<String, Object> qualysMap = new Hashtable<String, Object>();
                                    qualysMap.put("DEVICENAME", host);
                                    qualysMap.put("HOSTIP", ip);
                                    qualysMap.put("GROUP", catvalue);
                                    qualysMap.put("PORT", port);
                                    qualysMap.put("PROTOCOL", protocol);
                                    qualysMap.put("VULNO", vulNo);
                                    qualysMap.put("SEVERITYLEVEL", vulSeverityOut);
                                    qualysMap.put("CVE", vulncveid);
                                    qualysMap.put("VULNNAME", title);
                                    qualysMap.put("MESSAGE", title);
                                    qualysMap.put("LAST_UPDATE", last_update);
                                    qualysMap.put("CVSSBASESCORE", cvss_base);
                                    qualysMap.put("CVSSTEMPSCORE", cvss_temporal);
                                    qualysMap.put("PCI_FLAG", pci_flag);
                                    qualysMap.put("VENDOR_REFERENCE_LIST", venBuild.toString());
                                    qualysMap.put("BUGTRAQ_ID_LIST", bugBuild.toString());
                                    qualysMap.put("CVE_ID_LIST", cveidBuild.toString());
                                    qualysMap.put("DIAGNOSIS", diagonis);
                                    qualysMap.put("CONSEQUENCE", conseq);
                                    qualysMap.put("SOLUTION", solution);
                                    qualysMap.put("EXPLOITS", exploits.toString());
                                    qualysMap.put("MALWARE", malware.toString());
                                    qualysMap.put("RESULT", result);
                                    qualysMap.put("OS", Os);
                                    qualysMap.put("NETBIOS", Netbios);
                                    qualysMap.put("TIME", date);
                                    qualysMap.put("SOURCETYPE", "QUALYS");
                                    qualysMap.put("QUALYSTYPE", qualysArray[q]);
                                    qualysMap.put("HOSTTYPE", "Qualys");
                                    qualysMap.put("CORRELATE", "true");
                                    qualysMap.put("HOSTID", vuln.gethostId());
                                    qualysMap.put("VULAPPID", vuln.getvulAppId());
                                    qualysMap.put("SECAPPNAME", vuln.getappType());
                                    qualysMap.put("HOSTNAME", vuln.getscannerName());
                                    Log log = new Log();
                                    log.parseLog("Qualys", qualysMap);
                                    SystemCustomPatternHandler.getInstance().parse((Hashtable)log);
                                    LogIndexingAPI.getInstance().generateLogUniqueID((Map)log);
                                    Hashtable mapToNotifier = (Hashtable)qualysMap.clone();
                                    mapToNotifier.put("UUID", log.get("$id$"));
                                    LogDataIndexer.getInstance().indexLogData(log);
                                    this.nfManager.notify(mapToNotifier);
                                    continue;
                                }
                                catch (Exception err) {
                                    err.printStackTrace();
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exp) {
            status = "Failure";
            exp.printStackTrace();
        }
        if (cnt == 0) {
            status = "Failure";
        }
        try {
            UpdateQueryImpl u = new UpdateQueryImpl("VulnAppDetails");
            u.setCriteria(new Criteria(new Column("VulnAppDetails", "VULAPPID"), (Object)vuln.getvulAppId(), 0));
            u.setUpdateColumn("STATUS", (Object)status);
            DataAccess.update((UpdateQuery)u);
        }
        catch (Exception er) {
            er.printStackTrace();
        }
        return status;
    }
}

