/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.util.dm;

import com.adventnet.la.util.dm.DMProcessConfig;
import com.adventnet.la.util.dm.DMProcessHandler;
import com.adventnet.la.util.dm.DMTask;
import com.adventnet.la.util.dm.DMTaskConfig;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.database.BulkUploadDetailsBean;
import com.manageengine.ela.server.common.database.DataBaseSpecificActions;
import com.manageengine.ela.server.common.database.DatabaseBulkUploadHandler;
import com.manageengine.ela.server.common.database.DatabaseType;
import com.manageengine.ela.server.common.database.handlers.DataBaseHandlerFactory;
import com.manageengine.ela.server.common.io.file.FileHandler;
import java.io.File;
import java.io.FileFilter;
import java.sql.Statement;
import java.util.logging.Logger;
import org.apache.commons.io.filefilter.WildcardFilter;

public class BaseTablePopulationHandler
extends DMProcessHandler {
    private static final Logger LOGGER = Logger.getLogger(BaseTablePopulationHandler.class.getName());
    private static final String TRENDSPATH;
    private static final String UNPROCCESSEDTRENDSPATH;
    DMProcessConfig config = null;
    DMTaskConfig taskConfig = null;
    DMTask task = null;

    public void setConfig(DMProcessConfig config, DMTaskConfig taskConfig, DMTask task) {
        this.config = config;
        this.taskConfig = taskConfig;
        this.task = task;
        super.setConfig(config, taskConfig, task);
    }

    public synchronized void executeProcess(Statement statement) throws Exception {
        File trendDirectory = new File(TRENDSPATH);
        if (!trendDirectory.exists()) {
            trendDirectory.mkdir();
        }
        String[] tableNames = this.config.getParameter("tableName").toString().split(":");
        String[] searchStrings = this.config.getParameter("searchString").toString().split(":");
        String[] columnOrders = this.config.getParameter("columnOrder").toString().split(":");
        DataBaseSpecificActions handler = DataBaseHandlerFactory.getInstance().getDataBaseHandler();
        for (int i = 0; i < tableNames.length; ++i) {
            BulkUploadDetailsBean bean = new BulkUploadDetailsBean();
            DatabaseBulkUploadHandler.loadDetailsBean(bean, tableNames[i], columnOrders[i]);
            bean.setCharacterFormat(true);
            bean.setDeleteAfterDump(false);
            if (!DatabaseType.POSTGRES.getDatabaseName().equalsIgnoreCase(ServerDetailsBean.getInstance().getCurrentDataBase())) {
                bean.setFieldTerminator("|**|");
                bean.setStartingString("|**|");
            }
            if (DatabaseType.MSSQL.getDatabaseName().equalsIgnoreCase(ServerDetailsBean.getInstance().getCurrentDataBase())) {
                bean.setNullValueForEmptyColumn(false);
                bean.setLineTerminator("|**|**|\\n");
            }
            if (DatabaseType.MYSQL.getDatabaseName().equalsIgnoreCase(ServerDetailsBean.getInstance().getCurrentDataBase())) {
                bean.setColumnOrder(null);
                bean.setLineTerminator("|**|**|");
            }
            WildcardFilter searchFilter = new WildcardFilter(searchStrings[i]);
            File[] files = trendDirectory.listFiles((FileFilter)searchFilter);
            for (int j = 0; j < files.length; ++j) {
                File dest;
                boolean status = true;
                String fileName = files[j].getCanonicalPath();
                String query = handler.loadDumpDataQuery(bean, fileName);
                if (query != null) {
                    status = handler.dumpData(query);
                }
                if (status) {
                    FileHandler.deleteFile(fileName);
                    continue;
                }
                LOGGER.severe("Problem with the bulkupload hence moving the file " + fileName + " to unprocessed folder");
                File source = new File(fileName);
                File unprocessedDir = new File(UNPROCCESSEDTRENDSPATH);
                if (!unprocessedDir.exists()) {
                    unprocessedDir.mkdir();
                }
                if (FileHandler.renameFile(source, dest = new File(UNPROCCESSEDTRENDSPATH + File.separator + source.getName()))) continue;
                LOGGER.severe("Cannot move the invalid trend file " + source.getAbsolutePath());
                FileHandler.deleteFile(dest);
            }
        }
    }

    static {
        StringBuilder trends = new StringBuilder(System.getProperty("server.home"));
        trends.append(File.separator);
        trends.append("data");
        trends.append(File.separator);
        StringBuilder unprocessed = new StringBuilder(trends.toString());
        trends.append("trends");
        unprocessed.append("unprocessed_trends");
        TRENDSPATH = trends.toString();
        UNPROCCESSEDTRENDSPATH = unprocessed.toString();
    }
}

