/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.winaccess;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sym.winaccess.AgentConstants;
import com.adventnet.sym.winaccess.AgentInstaller;
import com.adventnet.sym.winaccess.SyMException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgentStatusUpdate
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(AgentStatusUpdate.class.getName());
    AgentInstaller agentInstall = AgentInstaller.getInstance();
    private Long slId = null;
    private static final int SERVICE_STOPPED = 1;
    private static final int SERVICE_START_PENDING = 2;
    private static final int SERVICE_STOP_PENDING = 3;
    private static final int SERVICE_RUNNING = 4;
    private static final int SERVICE_CONTINUE_PENDING = 5;
    private static final int SERVICE_PAUSE_PENDING = 6;
    private static final int SERVICE_PAUSED = 7;
    private static ScheduledThreadPoolExecutor statusScheduler = null;
    private static ScheduledFuture schFuture = null;
    public static HashMap agentTaskMap = null;

    public AgentStatusUpdate(Long agentId) {
        this.slId = agentId;
    }

    @Override
    public void run() {
        AgentStatusUpdate.setAgentStatus(this.slId, this.agentInstall);
    }

    public static void setAgentStatus(Long slId, AgentInstaller agentInstall) {
        block6: {
            try {
                Table slTable = new Table("SyslogServers");
                SelectQueryImpl sql = new SelectQueryImpl(slTable);
                sql.addSelectColumn(new Column("SyslogServers", "*"));
                sql.addSelectColumn(new Column("HostDetails", "*"));
                sql.addSelectColumn(new Column("Hosts", "*"));
                Criteria slCrit = new Criteria(new Column("SyslogServers", "SLID"), (Object)slId, 0);
                sql.setCriteria(slCrit);
                sql.addJoin(new Join("SyslogServers", "Hosts", new String[]{"HOST_NAME"}, new String[]{"HOST_NAME"}, 2));
                sql.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
                DataObject agentObj = DataAccess.get((SelectQuery)sql);
                if (agentObj.isEmpty()) break block6;
                Row slRow = agentObj.getRow("SyslogServers");
                Row hdRow = agentObj.getRow("HostDetails");
                HashMap<String, String> hostmap = CommonUtil.findHostCredentialDetails(hdRow);
                String agentMachineName = (String)slRow.get("HOST_NAME");
                String agentUName = hostmap.get("USERNAME");
                String agentDName = hostmap.get("DOMAIN_NAME");
                Integer prev_error_code = (Integer)slRow.get("ERROR_CODE");
                if (prev_error_code == null) {
                    prev_error_code = 0;
                    LOGGER.log(Level.WARNING, "previous error code null for agentMachine:" + agentMachineName);
                }
                if (agentDName == null || agentDName.trim().equals("")) {
                    agentDName = agentMachineName;
                }
                String agentPwd = hostmap.get("PASSWORD");
                LOGGER.log(Level.INFO, " Fetching Status of Agent :: " + agentMachineName);
                AgentConstants agentStatus = AgentConstants.AGENT_RUNNING;
                int error_code = 0;
                int new_error_code = 0;
                String error_details = "";
                try {
                    error_code = agentInstall.GetServiceStatus(agentMachineName, agentDName, agentUName, agentPwd);
                    error_details = AgentStatusUpdate.getErrorDetails(error_code);
                    agentStatus = AgentStatusUpdate.getAgentStatus(error_code);
                    new_error_code = error_code == 3 || error_code == 1 ? (prev_error_code != 2 ? 1 : 2) : (error_code == 2 || error_code == 4 ? 0 : 1002);
                }
                catch (SyMException ex) {
                    new_error_code = ex.getErrorCode();
                    error_details = ex.getMessage();
                    agentStatus = AgentConstants.AGENT_STATUS_UNAVAILABLE;
                }
                LOGGER.log(Level.INFO, "prev_error_code:" + prev_error_code + ",new_error_code:" + new_error_code + ",service_status_code:" + error_code + " Error details : " + error_details);
                AgentStatusUpdate.UpdateAgentDetails(new Long(slId), agentStatus.toString(), new Integer(new_error_code), error_details);
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, " Exception while Installing Agent : {0}", e);
                e.printStackTrace();
            }
        }
    }

    public static void startAgentStatusThread() throws Exception {
        LOGGER.log(Level.INFO, " Updating AgentStatusThread State..");
        statusScheduler = new ScheduledThreadPoolExecutor(1);
        agentTaskMap = new HashMap();
        String[] params = new String[]{"AGENT_INSTALLATION_FAILURE", "AGENT_UNINSTALLATION_FAILURE"};
        SelectQueryImpl sql = new SelectQueryImpl(new Table("SyslogServers"));
        sql.addSelectColumn(new Column("SyslogServers", "*"));
        Criteria slCrit = new Criteria(new Column("SyslogServers", "SLID"), (Object)new Long("1"), 1);
        slCrit = slCrit.and(new Column("SyslogServers", "STATUS"), (Object)params, 9);
        sql.setCriteria(slCrit);
        DataObject doo = DataAccess.get((SelectQuery)sql);
        Iterator slItr = doo.getRows("SyslogServers");
        while (slItr.hasNext()) {
            Row slRow = (Row)slItr.next();
            Long slId = (Long)slRow.get("SLID");
            LOGGER.log(Level.INFO, " Adding Task to Scheduler :: " + slId);
            AgentStatusUpdate agentTask = new AgentStatusUpdate(slId);
            ScheduledFuture taskID = AgentStatusUpdate.addTaskToExecutor(agentTask);
            agentTaskMap.put(slId, taskID);
        }
    }

    public static ScheduledFuture addTaskToExecutor(Runnable task) throws Exception {
        schFuture = statusScheduler.scheduleAtFixedRate(task, 300L, 900L, TimeUnit.SECONDS);
        return schFuture;
    }

    public void removeTaskFromExecutor(Long agentId) {
        Object taskID = agentTaskMap.remove(agentId);
        if (taskID != null) {
            boolean stat = ((ScheduledFuture)taskID).cancel(true);
            LOGGER.log(Level.INFO, " Removing Task from Scheduler :: " + agentId + " :: " + stat);
            statusScheduler.purge();
        }
    }

    public static void shutdown() {
        statusScheduler.shutdown();
    }

    private static String getErrorDetails(int error_code) {
        switch (error_code) {
            case 1: {
                return "Service is not running";
            }
            case 2: {
                return "Service is starting";
            }
            case 3: {
                return "Service is stopping";
            }
            case 4: {
                return "Service is running";
            }
            case 5: {
                return "Service continue is pending";
            }
            case 6: {
                return "Service pause is pending";
            }
            case 7: {
                return "Service is paused";
            }
        }
        return "Service status unavailable";
    }

    private static AgentConstants getAgentStatus(int error_code) {
        switch (error_code) {
            case 1: {
                return AgentConstants.AGENT_STOPPED;
            }
            case 2: {
                return AgentConstants.AGENT_RUNNING;
            }
            case 3: {
                return AgentConstants.AGENT_STOPPED;
            }
            case 4: {
                return AgentConstants.AGENT_RUNNING;
            }
            case 5: {
                return AgentConstants.AGENT_PAUSED;
            }
            case 6: {
                return AgentConstants.AGENT_PAUSED;
            }
            case 7: {
                return AgentConstants.AGENT_PAUSED;
            }
        }
        return AgentConstants.AGENT_STATUS_UNAVAILABLE;
    }

    public static void startAgent(Long agentId) {
        try {
            DataObject agentObj = AgentStatusUpdate.getAgentDetailsDO(agentId);
            if (!agentObj.isEmpty()) {
                Row slRow = agentObj.getRow("SyslogServers");
                Row hdRow = agentObj.getRow("HostDetails");
                HashMap<String, String> hostmap = CommonUtil.findHostCredentialDetails(hdRow);
                String agentMachineName = (String)slRow.get("HOST_NAME");
                String agentUName = hostmap.get("USERNAME");
                String agentDName = hostmap.get("DOMAIN_NAME");
                if (agentDName == null || agentDName.trim().equals("")) {
                    agentDName = agentMachineName;
                }
                String agentPwd = hostmap.get("PASSWORD");
                LOGGER.log(Level.INFO, " Starting Agent Service in :: " + agentMachineName);
                try {
                    AgentInstaller.StartService(agentMachineName, agentDName, agentUName, agentPwd);
                }
                catch (SyMException ex) {
                    AgentStatusUpdate.UpdateAgentDetails(new Long(agentId), AgentConstants.AGENT_STATUS_UNAVAILABLE.toString(), new Integer(ex.getErrorCode()), ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void stopAgent(Long agentId) {
        block6: {
            try {
                DataObject agentObj = AgentStatusUpdate.getAgentDetailsDO(agentId);
                if (agentObj.isEmpty()) break block6;
                Row slRow = agentObj.getRow("SyslogServers");
                Row hdRow = agentObj.getRow("HostDetails");
                HashMap<String, String> hostmap = CommonUtil.findHostCredentialDetails(hdRow);
                String agentMachineName = (String)slRow.get("HOST_NAME");
                String agentUName = hostmap.get("USERNAME");
                String agentDName = hostmap.get("DOMAIN_NAME");
                if (agentDName == null || agentDName.trim().equals("")) {
                    agentDName = agentMachineName;
                }
                String agentPwd = hostmap.get("PASSWORD");
                LOGGER.log(Level.INFO, " Stopping Agent Service in :: " + agentMachineName);
                boolean status = false;
                int error_code = 1;
                String error_details = AgentConstants.AGENT_RUNNING.toString();
                AgentConstants agentStatus = AgentConstants.AGENT_RUNNING;
                try {
                    status = AgentInstaller.StopService(agentMachineName, agentDName, agentUName, agentPwd);
                    if (status) {
                        error_code = 1;
                        error_details = AgentConstants.AGENT_STOPPED.toString();
                        agentStatus = AgentConstants.AGENT_STOPPED;
                    }
                }
                catch (SyMException ex) {
                    error_code = ex.getErrorCode();
                    error_details = ex.getMessage();
                    agentStatus = AgentConstants.AGENT_STATUS_UNAVAILABLE;
                }
                AgentStatusUpdate.UpdateAgentDetails(new Long(agentId), agentStatus.toString(), new Integer(error_code), error_details);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void restartAgent(Long agentId) {
        try {
            DataObject agentObj = AgentStatusUpdate.getAgentDetailsDO(agentId);
            if (!agentObj.isEmpty()) {
                Row slRow = agentObj.getRow("SyslogServers");
                Row hdRow = agentObj.getRow("HostDetails");
                HashMap<String, String> hostmap = CommonUtil.findHostCredentialDetails(hdRow);
                String agentMachineName = (String)slRow.get("HOST_NAME");
                String agentUName = hostmap.get("USERNAME");
                String agentDName = hostmap.get("DOMAIN_NAME");
                if (agentDName == null || agentDName.trim().equals("")) {
                    agentDName = agentMachineName;
                }
                String agentPwd = hostmap.get("PASSWORD");
                LOGGER.log(Level.INFO, " Restarting Agent Service in :: " + agentMachineName);
                try {
                    AgentInstaller.RestartService(agentMachineName, agentDName, agentUName, agentPwd);
                }
                catch (SyMException ex) {
                    AgentStatusUpdate.UpdateAgentDetails(new Long(agentId), AgentConstants.AGENT_STATUS_UNAVAILABLE.toString(), new Integer(ex.getErrorCode()), ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static DataObject getAgentDetailsDO(Long agentId) throws DataAccessException {
        Table slTable = new Table("SyslogServers");
        SelectQueryImpl sql = new SelectQueryImpl(slTable);
        sql.addSelectColumn(new Column("SyslogServers", "*"));
        sql.addSelectColumn(new Column("HostDetails", "*"));
        sql.addSelectColumn(new Column("Hosts", "*"));
        Criteria slCrit = new Criteria(new Column("SyslogServers", "SLID"), (Object)agentId, 0);
        sql.setCriteria(slCrit);
        sql.addJoin(new Join("SyslogServers", "HostDetails", new String[]{"SLID"}, new String[]{"SLID"}, 2));
        sql.addJoin(new Join("SyslogServers", "Hosts", new String[]{"HOST_NAME"}, new String[]{"HOST_NAME"}, 2));
        return DataAccess.get((SelectQuery)sql);
    }

    public static void UpdateAgentDetails(Long agentId, String status, Integer error_code, String error_details) {
        try {
            DataObject doo = DataAccess.get((String)"SyslogServers", (Criteria)new Criteria(new Column("SyslogServers", "SLID"), (Object)agentId, 0));
            Row slRow = doo.getFirstRow("SyslogServers");
            slRow.set("STATUS", (Object)status);
            slRow.set("ERROR_CODE", (Object)error_code);
            slRow.set("ERROR_DETAILS", (Object)error_details);
            doo.updateRow(slRow);
            DataAccess.update((DataObject)doo);
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Exception While updating SLID ::::::" + ex);
            ex.printStackTrace();
        }
    }
}

