/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.winaccess;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.LAClientUtil;
import com.adventnet.la.util.LAInstallUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sym.winaccess.AgentConstants;
import com.adventnet.sym.winaccess.AgentInstaller;
import com.adventnet.sym.winaccess.AgentStatusUpdate;
import com.adventnet.sym.winaccess.AgentUpgrader;
import com.adventnet.sym.winaccess.SyMException;
import com.adventnet.tools.prevalent.Wield;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgentUpdate
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(AgentUpdate.class.getName());
    AgentInstaller agentInstall = AgentInstaller.getInstance();

    @Override
    public void run() {
        LOGGER.info("In agent update");
        try {
            String serverProtocol = LAClientUtil.getWebProtocol();
            String serverDbType = System.getProperty("DBType", "mysql");
            String serverPort = this.getWebPort(serverProtocol);
            Table slTable = new Table("SyslogServers");
            String licenseType = this.getLicenseType();
            SelectQueryImpl sql = new SelectQueryImpl(slTable);
            sql.addSelectColumn(new Column("SyslogServers", "*"));
            sql.addSelectColumn(new Column("HostDetails", "*"));
            sql.addSelectColumn(new Column("Hosts", "*"));
            Criteria slCrit = new Criteria(new Column("SyslogServers", "PORTS"), (Object)"-", 0);
            sql.setCriteria(slCrit);
            sql.addJoin(new Join("SyslogServers", "Hosts", new String[]{"HOST_NAME"}, new String[]{"HOST_NAME"}, 2));
            sql.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
            DataObject agentObj = DataAccess.get((SelectQuery)sql);
            Iterator iter = agentObj.getRows("SyslogServers");
            while (iter.hasNext()) {
                Row slRow = (Row)iter.next();
                Row hRow = agentObj.getRow("Hosts", new Criteria(new Column("Hosts", "DNS_NAME"), slRow.get("HOST_NAME"), 0));
                Row hdRow = agentObj.getRow("HostDetails", new Criteria(new Column("HostDetails", "HOST_ID"), hRow.get("HOST_ID"), 0));
                Long slid = (Long)slRow.get("SLID");
                String agentMachineName = (String)slRow.get("HOST_NAME");
                String agentUName = (String)hdRow.get("USERNAME");
                HashMap<String, String> map = CommonUtil.findHostCredentialDetails(hdRow);
                String agentDName = map.get("DOMAIN_NAME");
                agentUName = map.get("USERNAME");
                String agentPwd = map.get("PASSWORD");
                if (agentDName == null || agentDName.trim().equals("")) {
                    agentDName = agentMachineName;
                }
                LOGGER.info("Updating details for agent :" + agentMachineName);
                try {
                    AgentInstaller.UpdateAgent(serverProtocol, serverPort, serverDbType, agentMachineName, agentUName, agentDName, agentPwd);
                    AgentStatusUpdate.setAgentStatus(slid, this.agentInstall);
                    DataObject doo = DataAccess.get((String)"SyslogServers", (Criteria)new Criteria(new Column("SyslogServers", "SLID"), (Object)slid, 0));
                    Row agentRow = doo.getFirstRow("SyslogServers");
                    if ("Professional".equals(licenseType) && "AGENT_RUNNING".equals(agentRow.get("STATUS"))) {
                        LOGGER.info("Stopping agent " + agentMachineName);
                        AgentStatusUpdate.stopAgent((Long)agentRow.get("SLID"));
                        continue;
                    }
                    if ("AGENT_STOPPED".equals(agentRow.get("STATUS"))) {
                        LOGGER.info("Starting agent " + agentMachineName);
                        AgentStatusUpdate.restartAgent((Long)agentRow.get("SLID"));
                        continue;
                    }
                    if (60011 != (Integer)agentRow.get("ERROR_CODE")) continue;
                    AgentUpgrader agentUpgrader = new AgentUpgrader(new Long(slid));
                    agentUpgrader.start();
                }
                catch (SyMException ex) {
                    AgentStatusUpdate.UpdateAgentDetails(new Long(slid), AgentConstants.AGENT_STATUS_UNAVAILABLE.toString(), new Integer(ex.getErrorCode()), ex.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, " Exception while Updating Agent Details : {0}", e);
            e.printStackTrace();
        }
    }

    private String getWebPort(String webProtocol) {
        String homeDir = System.getProperty("server.home") + File.separator + "conf" + File.separator + "server.xml";
        int port = LAInstallUtil.getWebServerPort((String)homeDir);
        return Integer.toString(port);
    }

    private String getLicenseType() {
        Wield w = Wield.getInstance();
        String userType = w.getUserType();
        String licenseType = w.getLicenseTypeString();
        if (licenseType.equals("Professional-NG")) {
            licenseType = "Professional";
        }
        return licenseType;
    }
}

