/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.winaccess;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.LAClientUtil;
import com.adventnet.la.util.LAInstallUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.ELSInitializer;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sym.winaccess.AgentConstants;
import com.adventnet.sym.winaccess.AgentInstaller;
import com.adventnet.sym.winaccess.AgentStatusUpdate;
import com.adventnet.sym.winaccess.SyMException;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgentUpgrader
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(AgentUpgrader.class.getName());
    AgentInstaller agentInstall = AgentInstaller.getInstance();
    private Long slId = null;
    private String agentInstallDir = null;

    public AgentUpgrader(Long agentId, String installDir) {
        this.slId = agentId;
        this.agentInstallDir = installDir;
    }

    public AgentUpgrader(Long agentId) {
        this.slId = agentId;
        this.agentInstallDir = "C:\\Program files(x86)\\EventLogAnalyzer_Agent\\bin\\";
    }

    private String getAgentVersion() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SystemConfigurations"));
            query.addSelectColumn(new Column("SystemConfigurations", "*"));
            Criteria version = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"AGENT_VERSION", 0);
            query.setCriteria(version);
            DataObject doo = DataAccess.get((SelectQuery)query);
            Row r = doo.getRow("SystemConfigurations");
            return (String)r.get("CONF_VALUE");
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
            return "";
        }
    }

    private String getWebPort(String webProtocol) {
        String homeDir = System.getProperty("jboss.home.dir") + File.separator + "server" + File.separator + "default" + File.separator + "conf" + File.separator + "sample-bindings.xml";
        int port = LAInstallUtil.getWebServerPort((String)homeDir);
        return Integer.toString(port);
    }

    @Override
    public void run() {
        try {
            Thread.sleep(2000L);
            boolean upgradeFinished = false;
            int retries = 0;
            String srcDir = System.getProperty("server.dir") + "\\lib\\native";
            while (!upgradeFinished) {
                upgradeFinished = true;
                AgentStatusUpdate.stopAgent(this.slId);
                AgentStatusUpdate.UpdateAgentDetails(new Long(this.slId), AgentConstants.AGENT_YET_TO_INSTALL.toString(), new Integer(60000), "Installation in Progress...");
                DataObject agentObj = AgentStatusUpdate.getAgentDetailsDO(this.slId);
                if (agentObj.isEmpty()) continue;
                Row slRow = agentObj.getRow("SyslogServers");
                Row hdRow = agentObj.getRow("HostDetails");
                HashMap<String, String> hostmap = CommonUtil.findHostCredentialDetails(hdRow);
                String agentMachineName = (String)slRow.get("HOST_NAME");
                String agentUName = hostmap.get("USERNAME");
                String agentDName = hostmap.get("DOMAIN_NAME");
                Long hostId = (Long)hdRow.get("HOST_ID");
                String agentPwd = hostmap.get("PASSWORD");
                if (agentDName == null || agentDName.trim().equals("")) {
                    agentDName = agentMachineName;
                }
                String serverProtocol = LAClientUtil.getWebProtocol();
                String serverPort = this.getWebPort(serverProtocol);
                String serverDbType = System.getProperty("DBType", "postgres");
                String serverVersion = ELSInitializer.getBuildNumber();
                String serverName = InetAddressHandler.getLocalHost().getHostName();
                String serverIPAddress = InetAddressHandler.getLocalHost().getHostAddress();
                String serverInsDir = System.getProperty("server.dir") + "\\";
                String agentWinDir = null;
                String agentVersion = "1.0";
                agentVersion = this.getAgentVersion();
                Hashtable hTable = null;
                try {
                    LOGGER.log(Level.INFO, "Getting WINDOWS directory.");
                    hTable = AgentInstaller.getWindowsDirectory(agentMachineName, agentDName, agentUName, agentPwd);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "Exception occured while getting WINDOWS directory for : " + agentMachineName);
                    LOGGER.log(Level.INFO, "Exception : " + ex);
                }
                LOGGER.info("DETAILS: " + hTable);
                if (hTable != null) {
                    agentWinDir = (String)hTable.get("WindowsDirectory");
                } else {
                    LOGGER.log(Level.INFO, "WINDOWS directory retrival using WMI failed for : " + agentMachineName);
                    agentWinDir = "C:\\WINDOWS\\";
                }
                LOGGER.log(Level.INFO, " agentInstallDir :: " + this.agentInstallDir);
                LOGGER.log(Level.INFO, " AgentUpgrader Domain Name :: " + agentDName);
                LOGGER.log(Level.INFO, " AgentUpgrader User Name: " + agentUName);
                int bSlashIndex = srcDir.indexOf("\\");
                if (bSlashIndex != -1) {
                    srcDir = srcDir.replace("\\", "\\\\");
                }
                if ((bSlashIndex = this.agentInstallDir.indexOf("\\")) != -1) {
                    this.agentInstallDir = this.agentInstallDir.replace("\\", "\\\\");
                }
                LOGGER.log(Level.INFO, " Source Dir :: " + srcDir);
                LOGGER.log(Level.INFO, " agentInstallDir :: " + this.agentInstallDir);
                int status = 0;
                try {
                    status = AgentInstaller.UpgradeAgent(agentMachineName, agentUName, agentDName, agentPwd, srcDir, this.agentInstallDir, serverName, serverIPAddress, serverProtocol, serverPort, serverDbType, serverVersion, serverInsDir, this.slId.toString(), agentWinDir, agentVersion);
                    if (status == 0) {
                        upgradeFinished = true;
                        continue;
                    }
                    if (++retries != 1) continue;
                    LOGGER.log(Level.INFO, " Upgrading Agent Service in :: " + agentMachineName + "failed..");
                    upgradeFinished = true;
                }
                catch (SyMException ex) {
                    AgentStatusUpdate.UpdateAgentDetails(new Long(this.slId), AgentConstants.AGENT_INSTALLATION_FAILURE.toString(), new Integer(ex.getErrorCode()), ex.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, " Exception while Upgrading Agent : {0}", e);
            e.printStackTrace();
        }
    }
}

