/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.winaccess;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.la.util.LAClientUtil;
import com.adventnet.la.util.LAInstallUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.EAService;
import com.adventnet.sa.server.ELSInitializer;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sym.winaccess.AgentConstants;
import com.adventnet.sym.winaccess.AgentInstaller;
import com.adventnet.sym.winaccess.SyMException;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstallAgentThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(InstallAgentThread.class.getName());
    private HashMap hostMap = null;
    private boolean isInstall = true;
    private static final int AGENT_INSTALLED = 0;
    private static final int NO_AGENT_AVAILABLE = 60001;
    private static final int UPDATED_SERVER_NAME_AND_PORT = 60002;
    private static final int SAME_AGENT_AVAILABLE = 60003;
    private static final int REQUIRES_UPGRADE = 60004;
    private static final int AGENT_ALREADY_INSTALLED_FROM_DIFF_SERVER = 60005;

    public InstallAgentThread(HashMap agentDetails, boolean install) {
        this.hostMap = agentDetails;
        this.isInstall = install;
    }

    public InstallAgentThread(Long hostId, boolean isInstall) {
        this.hostMap = this.getHostDetailsMap(hostId);
        this.isInstall = isInstall;
    }

    @Override
    public void run() {
        LOGGER.log(Level.INFO, "Inside InstallAgentThread ::::::");
        String srcDir = System.getProperty("server.home") + "\\lib\\native\\";
        String serverProtocol = LAClientUtil.getWebProtocol();
        String serverPort = this.getWebPort(serverProtocol);
        String serverDbType = System.getProperty("DBType", "postgres");
        String serverVersion = ELSInitializer.getBuildNumber();
        String serverInsDir = System.getProperty("server.home") + "\\";
        String agentWinDir = null;
        String agentVersion = "3.1";
        agentVersion = this.getAgentVersion();
        try {
            String serverName = InetAddressHandler.getLocalHost().getHostName();
            String serverIPAddress = InetAddressHandler.getLocalHost().getHostAddress();
            String agentId = (String)this.hostMap.get("SLID");
            String agentUName = (String)this.hostMap.get("UserName");
            String agentPwd = (String)this.hostMap.get("Password");
            String agentDName = (String)this.hostMap.get("DomainName");
            String agentMachineName = (String)this.hostMap.get("HostName");
            if (agentDName == null || agentDName.trim().equals("")) {
                agentDName = agentMachineName;
            }
            LOGGER.log(Level.INFO, " Install/UnInstall Agent :: " + agentMachineName + " :: isInstall :: " + this.isInstall);
            AgentConstants status = AgentConstants.AGENT_YET_TO_INSTALL;
            int error_code = 0;
            String error_details = "";
            try {
                AgentInstaller agentInstall = AgentInstaller.getInstance();
                Hashtable hTable = null;
                try {
                    LOGGER.log(Level.INFO, "Getting WINDOWS directory.");
                    hTable = AgentInstaller.getWindowsDirectory(agentMachineName, agentDName, agentUName, agentPwd);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "Exception occured while getting WINDOWS directory for : " + agentMachineName);
                    LOGGER.log(Level.INFO, "Exception : " + ex);
                }
                LOGGER.info("DETAILS: " + hTable);
                if (hTable != null) {
                    agentWinDir = (String)hTable.get("WindowsDirectory");
                } else {
                    LOGGER.log(Level.INFO, "WINDOWS directory retrival using WMI failed for : " + agentMachineName);
                    agentWinDir = "C:\\WINDOWS\\";
                }
                if (this.isInstall) {
                    try {
                        DataObject db = DataAccess.constructDataObject();
                        Row slUpdate = new Row("SLUPDATE");
                        slUpdate.set("SLID", (Object)((String)this.hostMap.get("SLID")));
                        slUpdate.set("SERVICETYPE", (Object)EAService.slUpdateConst.get("AGENTINSTALL"));
                        slUpdate.set("SERVICEID", (Object)((String)this.hostMap.get("SLID")));
                        db.addRow(slUpdate);
                        DataAccess.add((DataObject)db);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.INFO, "Agent Already Added. Reinstalling agent");
                    }
                }
                error_code = agentInstall.ManageAgent(this.isInstall, srcDir, serverName, serverIPAddress, serverProtocol, serverPort, serverDbType, serverVersion, serverInsDir, agentId, agentMachineName, agentUName, agentDName, agentPwd, agentWinDir, agentVersion);
                LOGGER.log(Level.INFO, " Installation Result: " + error_code);
                if (error_code == 60003) {
                    LOGGER.log(Level.INFO, "Agent Already Installed. Restarting Agent to update SLID.");
                    AgentInstaller.RestartService(agentMachineName, agentDName, agentUName, agentPwd);
                }
                error_details = this.getErrorDetails(error_code);
                if (this.isInstall && error_code == 60005) {
                    status = AgentConstants.AGENT_INSTALLATION_FAILURE;
                } else if (this.isInstall) {
                    status = AgentConstants.AGENT_INSTALLED;
                }
            }
            catch (SyMException ex) {
                status = AgentConstants.AGENT_INSTALLATION_FAILURE;
                error_code = ex.getErrorCode();
                error_details = ex.getMessage();
                LOGGER.log(Level.INFO, "Error occured While Installing Agent for Host :: " + agentMachineName);
            }
            if (this.isInstall) {
                if (error_code == 0) {
                    status = AgentConstants.AGENT_RUNNING;
                }
                this.UpdateAgentDetails(new Long(agentId), status.toString(), new Integer(error_code), error_details);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, " Exception while Installing Agent : {0}", e);
            e.printStackTrace();
        }
    }

    private String getAgentVersion() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SystemConfigurations"));
            query.addSelectColumn(new Column("SystemConfigurations", "*"));
            Criteria version = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"AGENT_VERSION", 0);
            query.setCriteria(version);
            DataObject doo = DataAccess.get((SelectQuery)query);
            Row r = doo.getRow("SystemConfigurations");
            return (String)r.get("CONF_VALUE");
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
            return "";
        }
    }

    private String getWebPort(String webProtocol) {
        String homeDir = System.getProperty("server.home") + File.separator + "conf" + File.separator + "server.xml";
        int port = LAInstallUtil.getWebServerPort((String)homeDir);
        return Integer.toString(port);
    }

    private String getErrorDetails(int error_code) {
        switch (error_code) {
            case 60001: {
                return "EventLog Agent is not installed in this computer.";
            }
            case 60002: {
                return "The Server Name and Server port have been successfully updated..";
            }
            case 60003: {
                return "Agent version is up-to-date.";
            }
            case 60004: {
                return "Agent needs to be upgraded. Uninstall the EventLog Agent and install again.";
            }
            case 0: {
                return "Service is running";
            }
            case 60005: {
                return "An Agent was already installed from a diff ELA Server.Uninstall the Agent from the other server and install again";
            }
        }
        return "";
    }

    private void UpdateAgentDetails(Long agentId, String status, Integer error_code, String error_details) {
        try {
            DataObject doo = DataAccess.get((String)"SyslogServers", (Criteria)new Criteria(new Column("SyslogServers", "SLID"), (Object)agentId, 0));
            Row slRow = doo.getFirstRow("SyslogServers");
            slRow.set("STATUS", (Object)status);
            slRow.set("ERROR_CODE", (Object)error_code);
            slRow.set("ERROR_DETAILS", (Object)error_details);
            doo.updateRow(slRow);
            DataAccess.update((DataObject)doo);
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Exception While updating SLID ::::::" + ex);
            ex.printStackTrace();
        }
    }

    private HashMap getHostDetailsMap(Long hostId) {
        HashMap<String, String> hostMap = new HashMap<String, String>();
        try {
            Table table = new Table("Hosts");
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(new Column("Hosts", "*"));
            query.addSelectColumn(new Column("HostDetails", "*"));
            query.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
            Criteria c = new Criteria(new Column("Hosts", "HOST_ID"), (Object)hostId, 0);
            query.setCriteria(c);
            DataObject dObj = DataAccess.get((SelectQuery)query);
            Iterator iter = dObj.getRows("Hosts");
            while (iter.hasNext()) {
                Row hRow = (Row)iter.next();
                hostMap.put("HostName", (String)hRow.get("HOST_NAME"));
            }
            iter = dObj.getRows("HostDetails");
            while (iter.hasNext()) {
                Row hdRow = (Row)iter.next();
                HashMap<String, String> hostmap = CommonUtil.findHostCredentialDetails(hdRow);
                hostMap.put("SLID", ((Long)hdRow.get("SLID")).toString());
                hostMap.put("UserName", hostmap.get("USERNAME"));
                hostMap.put("Password", EnDecryptImplSingleton.getInstance().decrypt(hostmap.get("PASSWORD")));
                hostMap.put("DomainName", hostmap.get("DOMAIN_NAME"));
            }
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
        }
        return hostMap;
    }
}

