/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.alert.schedule;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Criteria;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sa.server.util.DBUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ela.server.common.alerts.util.AlertUtil;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import java.util.ArrayList;
import java.util.List;

public class AlertTableArchiveTask
implements Task {
    public void executeTask(TaskContext taskInput) throws TaskExecutionException {
        if (!ServerDetailsBean.getInstance().isAdminServer()) {
            Long dateOlderThanDWS = CommonUtil.getDateOlderThanDWS();
            try {
                List tableDetails = AlertUtil.getArchivedTablesInfo(dateOlderThanDWS);
                if (tableDetails.size() > 0) {
                    ArrayList tablesToBeDeleted = new ArrayList();
                    for (int i = 0; i < tableDetails.size(); ++i) {
                        tablesToBeDeleted.add(tableDetails.get(i));
                    }
                    RelationalAPI.getInstance().getArchiveAdapter().deleteArchiveTable(tablesToBeDeleted);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            Criteria criteria = AlertUtil.getTimeBasedAlertCriteria("LAAlertAudit", null, dateOlderThanDWS);
            DBUtil.deleteExistingRows("LAAlertAudit", criteria, new boolean[0]);
        } else {
            try {
                this.stopTask();
            }
            catch (TaskExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public void stopTask() throws TaskExecutionException {
    }
}

