/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.application.others;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.cache.Cache;
import com.manageengine.ela.server.common.device.management.AddOrUpdateEventlogDevice;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.common.Strings;
import org.json.JSONArray;
import org.json.JSONObject;

public class ApplicationMgmtUtils {
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static final Logger LOGGER = Logger.getLogger(ApplicationMgmtUtils.class.getName());
    public static Map<String, Long> slUpdateConst = new HashMap<String, Long>();
    private static Cache<Long, String> appIdTrendTableNameCache = new Cache();

    public static Long getHostID(String host) {
        Long hostID = null;
        try {
            InetAddress address = InetAddressHandler.getInetAddress(host);
            if (address != null && (address.isAnyLocalAddress() || address.isLoopbackAddress() || InetAddress.getLocalHost().equals(address))) {
                address = InetAddress.getLocalHost();
            }
            DataObject dob = null;
            dob = address == null ? AddOrUpdateEventlogDevice.checkELADeviceAvailablity(host, host, host, host) : AddOrUpdateEventlogDevice.checkELADeviceAvailablity(InetAddressHandler.getNameFromFQDN(host), address.getHostName(), address.getCanonicalHostName(), address.getHostAddress());
            Iterator it = dob.getRows("Hosts");
            if (it.hasNext()) {
                Row r = (Row)it.next();
                hostID = (Long)r.get("HOST_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hostID;
    }

    public static Long getAppid(JSONObject details) {
        Long appid = null;
        try {
            long hostid = details.getLong("HOST_ID");
            String fgroup = details.getString("FGROUP");
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AppResources"));
            sq.addSelectColumn(Column.getColumn((String)"AppResources", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"AppResources", (String)"HOSTID"), (Object)hostid, 0);
            Criteria crit1 = new Criteria(Column.getColumn((String)"AppResources", (String)"FGROUP"), (Object)fgroup, 0);
            Criteria baseCrit = crit.and(crit1);
            sq.setCriteria(baseCrit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("AppResources");
            if (it.hasNext()) {
                Row r = (Row)it.next();
                appid = (Long)r.get("APPID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appid;
    }

    public static Long getSLID(Long hostId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)hostId, 0);
            DataObject doo = PERSISTENCELITE.get("HostDetails", c);
            if (doo.size("HostDetails") > 0) {
                return (Long)doo.getFirstValue("HostDetails", "SLID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.info("Returning default slid of 1");
        return ApplicationMgmtUtils.getSLID();
    }

    public static String getTrendTableName(Long appId) throws DataAccessException {
        if (appIdTrendTableNameCache.containsKey(appId) && !Strings.isNullOrEmpty((String)appIdTrendTableNameCache.get(appId))) {
            return appIdTrendTableNameCache.get(appId);
        }
        Criteria criteria = new Criteria(Column.getColumn((String)"AppResources", (String)"APPID"), (Object)appId, 0);
        DataObject dataObject = PERSISTENCELITE.get("AppResources", criteria);
        Row appResRow = dataObject.getRow("AppResources");
        Long formatId = (Long)appResRow.get("FORMATID");
        Criteria criteria1 = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATID"), (Object)formatId, 0);
        DataObject dataObject1 = PERSISTENCELITE.get("FormatDetails", criteria1);
        Row row = dataObject1.getRow("FormatDetails");
        appIdTrendTableNameCache.put(appId, (String)row.get("HRTRENDTABLENAME"));
        return (String)row.get("HRTRENDTABLENAME");
    }

    public static Long getSLID() {
        Long slid = new Long(1L);
        try {
            DataObject slDO = PERSISTENCELITE.get("SyslogServers", new Criteria(Column.getColumn((String)"SyslogServers", (String)"PORTS"), (Object)"-", 1));
            if (slDO.size("SyslogServers") > 0) {
                slid = (Long)slDO.getFirstValue("SyslogServers", "SLID");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, " Exception while getting SLID : {0}", e);
            e.printStackTrace();
        }
        return slid;
    }

    public static List<Long> getDeletedAppIDsFromSQLServers(List<Long> appids) {
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerDetails"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerDetails", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerDetails", (String)"APPID"), (Object)appids.toArray(new Long[appids.size()]), 8);
            sq.setCriteria(crit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Long currId = (Long)r.get("APPID");
                appids.remove(currId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appids;
    }

    public static void updateAppResources(List<Long> delAppIds) {
        try {
            List<Long> finalAppids = ApplicationMgmtUtils.getDeletedAppIDsFromSQLServers(delAppIds);
            JSONArray appids = new JSONArray();
            for (int i = 0; i < finalAppids.size(); ++i) {
                appids.put((Object)finalAppids.get(i).toString());
            }
            JSONObject json = new JSONObject();
            json.put("deletehosts", (Object)appids);
            ApplicationMgmtUtils.deleteAppServer(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getappHostFormatId(String formatname) {
        Long formatId = new Long(0L);
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("FormatDetails"));
            query.addSelectColumn(Column.getColumn((String)"FormatDetails", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATNAME"), (Object)formatname, 0);
            query.setCriteria(crit);
            DataObject obj = PERSISTENCELITE.get((SelectQuery)query);
            Iterator it = obj.getRows("FormatDetails");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                formatId = (Long)row.get("FORMATID");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return formatId.toString();
    }

    public static String getOrclFormatId() {
        Long formatId = new Long(0L);
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("FormatDetails"));
            query.addSelectColumn(Column.getColumn((String)"FormatDetails", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATNAME"), (Object)"oracleLogs", 0);
            query.setCriteria(crit);
            DataObject obj = PERSISTENCELITE.get((SelectQuery)query);
            Iterator it = obj.getRows("FormatDetails");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                formatId = (Long)row.get("FORMATID");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return formatId.toString();
    }

    public static String getMssqlFormatId() {
        Long formatId = new Long(0L);
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("FormatDetails"));
            query.addSelectColumn(Column.getColumn((String)"FormatDetails", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATNAME"), (Object)"mssqlauditLogs", 0);
            query.setCriteria(crit);
            DataObject obj = PERSISTENCELITE.get((SelectQuery)query);
            Iterator it = obj.getRows("FormatDetails");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                formatId = (Long)row.get("FORMATID");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return formatId.toString();
    }

    public static String getPrintServerFormatId() {
        Long formatId = new Long(0L);
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("FormatDetails"));
            query.addSelectColumn(Column.getColumn((String)"FormatDetails", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATNAME"), (Object)"PrinterLogs", 0);
            query.setCriteria(crit);
            DataObject obj = PERSISTENCELITE.get((SelectQuery)query);
            Iterator it = obj.getRows("FormatDetails");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                formatId = (Long)row.get("FORMATID");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return formatId.toString();
    }

    public static void getSLUpdateConstants() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SLUpdateConstant"));
            query.addSelectColumn(Column.getColumn((String)"SLUpdateConstant", (String)"*"));
            DataObject obj = PERSISTENCELITE.get((SelectQuery)query);
            Iterator iter = obj.getRows("SLUpdateConstant");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                slUpdateConst.put((String)row.get("NAME"), (Long)row.get("VALUE"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean deleteAppLogs(String formatId, String appId, Long hostId) {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("ReportConfig"));
            query.addSelectColumn(Column.getColumn((String)"ReportConfig", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"ReportConfigToFilters", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"Filters", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"FilterToLAExpression", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"LAExpression", (String)"*"));
            Join join = new Join("ReportConfig", "ReportConfigToFilters", new String[]{"REPORTID"}, new String[]{"REPORTID"}, 2);
            Join join2 = new Join("ReportConfigToFilters", "Filters", new String[]{"FILTERNAME"}, new String[]{"FILTERNAME"}, 2);
            Join join3 = new Join("Filters", "FilterToLAExpression", new String[]{"FILTERNAME"}, new String[]{"FILTERNAME"}, 2);
            Join join4 = new Join("FilterToLAExpression", "LAExpression", new String[]{"EXP_ID"}, new String[]{"EXP_ID"}, 2);
            query.addJoin(join);
            query.addJoin(join2);
            query.addJoin(join3);
            query.addJoin(join4);
            Criteria criteria = new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"APPID", 0).and(new Criteria(Column.getColumn((String)"LAExpression", (String)"VALUE"), (Object)appId, 0));
            query.setCriteria(criteria);
            DataObject dataObject = PERSISTENCELITE.get((SelectQuery)query);
            ArrayList<Object> reportIds = new ArrayList<Object>();
            Iterator iterator = dataObject.getRows("ReportConfig");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                reportIds.add(row.get("REPORTID"));
            }
            if (reportIds.size() > 0) {
                Long[] reportIdsArray = new Long[reportIds.size()];
                reportIdsArray = reportIds.toArray(reportIdsArray);
                Criteria criteria1 = new Criteria(Column.getColumn((String)"Hosts2ReportConfig", (String)"HOST_ID"), (Object)hostId, 0).and(new Criteria(Column.getColumn((String)"Hosts2ReportConfig", (String)"REPORTID"), (Object)reportIdsArray, 8));
                PERSISTENCELITE.delete(criteria1);
            }
            PERSISTENCELITE.delete(criteria);
            criteria = new Criteria(Column.getColumn((String)"ImportedAppLogs", (String)"FORMATID"), (Object)new Long(formatId), 0).and(new Criteria(Column.getColumn((String)"ImportedAppLogs", (String)"APPID"), (Object)new Long(appId), 0));
            PERSISTENCELITE.delete(criteria);
            criteria = new Criteria(Column.getColumn((String)"AppResources", (String)"APPID"), (Object)new Long(appId), 0);
            PERSISTENCELITE.delete(criteria);
            if (formatId.equals(ApplicationMgmtUtils.getOrclFormatId()) || formatId.equals(ApplicationMgmtUtils.getPrintServerFormatId()) || formatId.equals(ApplicationMgmtUtils.getMssqlFormatId()) || formatId.equals(ApplicationMgmtUtils.getappHostFormatId("TerminalLogs"))) {
                DataObject obj = PERSISTENCELITE.constructDataObject();
                Row slRow = new Row("SLUPDATE");
                slRow.set("SLID", (Object)ApplicationMgmtUtils.getSLID(hostId));
                ApplicationMgmtUtils.getSLUpdateConstants();
                slRow.set("SERVICETYPE", (Object)slUpdateConst.get("APPLICATION"));
                slRow.set("SERVICEID", (Object)hostId);
                obj.addRow(slRow);
                PERSISTENCELITE.update(obj);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Unable to delete application " + appId + " for Host " + hostId + " and format " + formatId);
            e.printStackTrace();
            return false;
        }
    }

    public static JSONArray getAllHosts(JSONObject sqlConfig) {
        JSONArray ret = new JSONArray();
        try {
            String table = "Hosts";
            JSONArray hostids = sqlConfig.getJSONArray("HOST_ID");
            Long[] hostid = new Long[hostids.length()];
            for (int i = 0; i < hostids.length(); ++i) {
                hostid[i] = hostids.getLong(i);
            }
            Map<Long, String> names = DeviceUtil.getDeviceNamesFromDeviceIDs(hostid);
            ret = new JSONArray();
            for (Map.Entry<Long, String> it : names.entrySet()) {
                ret.put((Object)it.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static JSONObject deleteAppServer(JSONObject req) {
        JSONObject res = new JSONObject();
        boolean flag = true;
        try {
            JSONArray appidArray = req.getJSONArray("deletehosts");
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AppResources"));
            sq.addSelectColumn(Column.getColumn((String)"AppResources", (String)"*"));
            Long[] appresourceids = new Long[appidArray.length()];
            for (int i = 0; i < appidArray.length(); ++i) {
                appresourceids[i] = appidArray.getLong(i);
            }
            Criteria crit = new Criteria(Column.getColumn((String)"AppResources", (String)"APPID"), (Object)appresourceids, 8);
            sq.setCriteria(crit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("AppResources");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Long appid = (Long)r.get("APPID");
                Long hostid = (Long)r.get("HOSTID");
                Long formatid = (Long)r.get("FORMATID");
                flag &= ApplicationMgmtUtils.deleteAppLogs(formatid.toString(), appid.toString(), hostid);
            }
            if (flag) {
                res.put("STATUS_CODE", 0);
                res.put("RESPONSE", (Object)"Success");
            } else {
                res.put("STATUS_CODE", 7430);
                res.put("RESPONSE", (Object)"Failed to delete Application Servers");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }
}

