/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.application.others;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.EAService;
import com.adventnet.sa.server.util.CommonUtil;
import com.manageengine.ela.server.application.others.ApplicationMgmtUtils;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class OtherServerOperations {
    private static final Logger LOGGER = Logger.getLogger(OtherServerOperations.class.getName());
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();

    public static JSONObject addAppServer(JSONObject req) {
        JSONObject res = new JSONObject();
        try {
            JSONArray hosts = req.getJSONArray("HOSTS");
            String formatname = req.getString("APPTYPE");
            LogSourceCategoryContainer.ApplicationCategory currentCategory = null;
            boolean isExternalApp = false;
            if (formatname.toLowerCase().equalsIgnoreCase("Oracle")) {
                currentCategory = LogSourceCategoryContainer.ApplicationCategory.WINDOWSORACLE;
            } else if (formatname.toLowerCase().equalsIgnoreCase("printer")) {
                currentCategory = LogSourceCategoryContainer.ApplicationCategory.WINDOWSPRINTSERVER;
            } else if (formatname.toLowerCase().equalsIgnoreCase("mssqlauditLogs")) {
                currentCategory = LogSourceCategoryContainer.ApplicationCategory.WINDOWSMSSQL;
            } else if (formatname.toLowerCase().equalsIgnoreCase("PMP")) {
                CommonUtil.updateSysConfiguration("MEApp_PMP", true, true);
                currentCategory = LogSourceCategoryContainer.ApplicationCategory.WINDOWSPMP;
                isExternalApp = true;
                ActivityUtil.enablePMPRules();
            } else if (formatname.toLowerCase().equalsIgnoreCase("OPM")) {
                CommonUtil.updateSysConfiguration("MEApp_OPM", true, true);
                currentCategory = LogSourceCategoryContainer.ApplicationCategory.WINDOWSOPM;
                isExternalApp = true;
            } else {
                currentCategory = LogSourceCategoryContainer.ApplicationCategory.WINDOWSTERMINALSERVER;
            }
            String formatId = ApplicationMgmtUtils.getappHostFormatId(currentCategory.getFormatName());
            ArrayList<String> errHosts = new ArrayList<String>();
            for (int i = 0; i < hosts.length(); ++i) {
                String orclHost = hosts.getString(i);
                try {
                    Long hostId = ApplicationMgmtUtils.getHostID(orclHost);
                    Table table = new Table("AppResources");
                    Column hostIdCol = Column.getColumn((String)"AppResources", (String)"HOSTID");
                    Column formatIdCol = Column.getColumn((String)"AppResources", (String)"FORMATID");
                    Criteria cri = new Criteria(hostIdCol, (Object)hostId, 0).and(formatIdCol, (Object)formatId, 0);
                    SelectQueryImpl query = new SelectQueryImpl(table);
                    query.setCriteria(cri);
                    query.addSelectColumn(Column.getColumn((String)"AppResources", (String)"*"));
                    DataObject dObj = PERSISTENCELITE.constructDataObject();
                    dObj = PERSISTENCELITE.get((SelectQuery)query);
                    if (dObj.isEmpty()) {
                        Row row = new Row("AppResources");
                        row.set("HOSTID", (Object)hostId);
                        row.set("FORMATID", (Object)formatId);
                        row.set("FGROUP", (Object)currentCategory.getFormatGroup());
                        if (isExternalApp) {
                            row.set("TYPE", (Object)2);
                        } else {
                            row.set("TYPE", (Object)1);
                        }
                        dObj.addRow(row);
                        dObj = PERSISTENCELITE.add(dObj);
                        DataObject obj = PERSISTENCELITE.constructDataObject();
                        Row slRow = new Row("SLUPDATE");
                        slRow.set("SLID", (Object)DeviceUtil.getSysEvtColID(hostId));
                        slRow.set("SERVICETYPE", (Object)EAService.slUpdateConst.get("APPLICATION"));
                        slRow.set("SERVICEID", (Object)hostId);
                        obj.addRow(slRow);
                        PERSISTENCELITE.update(obj);
                        continue;
                    }
                    errHosts.add(orclHost);
                    continue;
                }
                catch (Exception e) {
                    errHosts.add(orclHost);
                    LOGGER.log(Level.INFO, "Exception while adding Host {0} {1}", orclHost);
                }
            }
            if (errHosts.size() > 0) {
                res.put("STATUS_CODE", 7430);
                res.put("RESPONSE", (Object)new JSONArray(errHosts));
                return res;
            }
            res.put("STATUS_CODE", 0);
            res.put("RESPONSE", (Object)"Success");
        }
        catch (Exception e) {
            try {
                res.put("STATUS_CODE", 7430);
                res.put("STATUS_MSG", (Object)"Unable to add servers");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        return res;
    }
}

