/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.application.webserver.iis;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;

public class IISFormatUtil {
    public static Long getIISFormatId(String encoding, int rotationtype, String formatName, boolean isHttpCustomFields) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"IISLogFileDetails", (String)"ENCODING"), (Object)encoding, 0).and(new Criteria(Column.getColumn((String)"IISLogFileDetails", (String)"ROTATION_TYPE"), (Object)rotationtype, 0)).and(new Criteria(Column.getColumn((String)"IISLogFileDetails", (String)"FORMAT_NAME"), (Object)formatName, 0)).and(new Criteria(Column.getColumn((String)"IISLogFileDetails", (String)"IS_HTTP_CUSTOM_FIELDS"), (Object)isHttpCustomFields, 0));
        DataObject dataObject = PersistenceDBUtil.getPersistenceLite().get("IISLogFileDetails", criteria);
        Row row = dataObject.getRow("IISLogFileDetails");
        return (Long)row.get("FORMAT_ID");
    }

    public static String getSuffix(Long formatId) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"IISLogFileDetails", (String)"FORMAT_ID"), (Object)formatId, 0);
        DataObject dataObject = PersistenceDBUtil.getPersistenceLite().get("IISLogFileDetails", criteria);
        Row row = dataObject.getRow("IISLogFileDetails");
        return (String)row.get("SUFFIX");
    }

    public static String getPrefix(Long formatId) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"IISLogFileDetails", (String)"FORMAT_ID"), (Object)formatId, 0);
        DataObject dataObject = PersistenceDBUtil.getPersistenceLite().get("IISLogFileDetails", criteria);
        Row row = dataObject.getRow("IISLogFileDetails");
        return (String)row.get("PREFIX");
    }

    public static int getRotationType(Long formatId) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"IISLogFileDetails", (String)"FORMAT_ID"), (Object)formatId, 0);
        DataObject dataObject = PersistenceDBUtil.getPersistenceLite().get("IISLogFileDetails", criteria);
        Row row = dataObject.getRow("IISLogFileDetails");
        return (Integer)row.get("ROTATION_TYPE");
    }

    public static String getFilePattern(Long formatId, String rollover) throws DataAccessException {
        String basePattern;
        String prefix = IISFormatUtil.getPrefix(formatId);
        String suffix = IISFormatUtil.getSuffix(formatId);
        switch (rollover) {
            case "Daily": {
                basePattern = "${yy}${MM}${dd}";
                break;
            }
            case "Weekly": {
                basePattern = "${yy}${MM}${WW}";
                break;
            }
            case "Hourly": {
                basePattern = "${yy}${MM}${dd}${HH}";
                break;
            }
            case "Monthly": {
                basePattern = "${yy}${MM}";
                break;
            }
            default: {
                basePattern = "${{NUMBER_1}}";
            }
        }
        return prefix + basePattern + suffix;
    }

    public static String getDefaultFileNameForFileSizeRollover(Long formatId) throws DataAccessException {
        String prefix = IISFormatUtil.getPrefix(formatId);
        String suffix = IISFormatUtil.getSuffix(formatId);
        return prefix + "0" + suffix;
    }
}

