/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.application.webserver.iis;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.LuceneUtil;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.adventnet.sa.server.nf.NotificationManager;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.io.file.parser.ExtractedResultListener;
import com.manageengine.ela.server.common.io.file.parser.FileDetailsBean;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilter;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.LogBuilder;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import com.manageengine.ela.server.importlog.processors.BaseLogProcessorBean;
import com.manageengine.ela.server.importlog.report.ReportUtil;
import com.manageengine.ela.server.importlog.report.SubReportCounter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.Strings;
import org.json.JSONException;

public class IISLogCollector
implements ExtractedResultListener {
    private Long auditId;
    private String siteName;
    private Collection<String> colList = new LinkedHashSet<String>();
    private Long appId;
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private Long rotationType = null;
    private ArchiveFileManager archiveFileManager;
    private BaseLogProcessorBean baseLogProcessorBean;
    private NotificationManager nfManager;
    private LogForwarderFilter logforwarder = null;

    public IISLogCollector(Long auditId, String siteName, Long appId) {
        this.auditId = auditId;
        this.siteName = siteName;
        this.appId = appId;
        this.archiveFileManager = ArchiveFileManager.getInstance();
        this.nfManager = NotificationManager.getInstance();
        this.logforwarder = LogForwarderFilter.getInstance();
        this.baseLogProcessorBean = new BaseLogProcessorBean();
    }

    @Override
    public Object initialProcessor(LogProperties logProperties) throws DataAccessException {
        logProperties.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.baseLogProcessorBean.importFilters = logProperties.getImportFilters();
        this.baseLogProcessorBean.indexCount = 0L;
        this.baseLogProcessorBean.severityCounter.reset();
        this.baseLogProcessorBean.importedTime = System.currentTimeMillis();
        logProperties.setReportId(FormatIdentifier.getReportID("iis_w3cweb"));
        this.baseLogProcessorBean.reportApplyWhenConditions = ReportUtil.getApplyWhenConditions(logProperties.getReportId());
        this.baseLogProcessorBean.subReportCounter = new SubReportCounter(this.appId);
        this.baseLogProcessorBean.colList.clear();
        logProperties.setAppId(this.appId);
        Criteria criteria = new Criteria(Column.getColumn((String)"IISLogAuditDetails", (String)"AUDIT_ID"), (Object)this.auditId, 0);
        DataObject dataObject = PERSISTENCELITE.get("IISLogAuditDetails", criteria);
        Row iisFileAuditRow = dataObject.getRow("IISLogAuditDetails");
        iisFileAuditRow.set("START_TIME", (Object)System.currentTimeMillis());
        iisFileAuditRow.set("STATUS", (Object)12195L);
        dataObject.updateRow(iisFileAuditRow);
        PERSISTENCELITE.update(dataObject);
        return null;
    }

    @Override
    public void processResult(HashMap<String, Object> extractedFields, LogBuilder logBuilder, LogProperties logProperties) {
        try {
            String appKey;
            String deviceName = null;
            String logLine = (String)extractedFields.get("RAWLOG");
            String formatName = FormatIdentifier.getFormatName(FormatIdentifier.getFormatId(logProperties.getReportId()));
            if (logProperties.getLinkedDeviceId() > 0L) {
                deviceName = DeviceUtil.getDeviceName(logProperties.getLinkedDeviceId()).getDeviceName();
            }
            String string = appKey = deviceName != null ? deviceName + "_" + "iis_w3cweb" : "iis_w3cweb";
            if (!extractedFields.containsKey("SITE_NAME")) {
                extractedFields.put("SITE_NAME", this.siteName);
            }
            extractedFields.put("APPID", this.appId);
            extractedFields.put("HOSTTYPE", formatName);
            extractedFields.put("FORMATID", logProperties.getReportId());
            extractedFields.put("IMPORTED_TIME", this.baseLogProcessorBean.importedTime);
            extractedFields.put("RAWLOG", extractedFields.get("RAWLOG").toString().replaceAll("\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2}", ""));
            this.baseLogProcessorBean.insertToIndex(extractedFields, this.baseLogProcessorBean);
            extractedFields.put("RAWLOG", logLine);
            this.archiveFileManager.archiveAppLog(formatName, deviceName, appKey, logLine);
            this.nfManager.notify(new Hashtable<String, Object>(extractedFields));
            this.logforwarder.filterAndForward(new Hashtable<String, Object>(extractedFields));
            this.colList.addAll(extractedFields.keySet());
        }
        catch (DataAccessException | BaseStatusCode | IOException | JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean closeProcessor(ArrayList<FileDetailsBean> fileDetailsBeans, LogProperties logProperties) throws DataAccessException {
        this.baseLogProcessorBean.updateDbTrendCount(logProperties, this.baseLogProcessorBean, true);
        Long alreadyReadCount = 0L;
        String fileName = null;
        for (FileDetailsBean f : fileDetailsBeans) {
            alreadyReadCount = f.getLineCount();
            fileName = f.getFileName();
        }
        Criteria criteria = new Criteria(Column.getColumn((String)"IISLogAuditDetails", (String)"AUDIT_ID"), (Object)this.auditId, 0);
        DataObject dataObject = PERSISTENCELITE.get("IISLogAuditDetails", criteria);
        Row iisFileAuditRow = dataObject.getRow("IISLogAuditDetails");
        iisFileAuditRow.set("END_TIME", (Object)System.currentTimeMillis());
        iisFileAuditRow.set("ALREADY_READ_COUNT", (Object)alreadyReadCount);
        iisFileAuditRow.set("STATUS", (Object)12196L);
        iisFileAuditRow.set("FILE_NAME", (Object)fileName);
        if (logProperties.getHeaderLine() != null) {
            iisFileAuditRow.set("HEADER_FIELDS", (Object)logProperties.getHeaderLine());
        }
        dataObject.updateRow(iisFileAuditRow);
        PERSISTENCELITE.update(dataObject);
        this.colList.removeAll(Arrays.asList("APPID", "HOSTID", "DATE_STRING", "PARSER_KEY", "IMPORTED_TIME"));
        Criteria formatIdCriteria = new Criteria(Column.getColumn((String)"FormatFields", (String)"FORMATID"), (Object)logProperties.getReportId(), 0);
        DataObject formatFields = PERSISTENCELITE.get("FormatFields", formatIdCriteria);
        ArrayList<String> colList = new ArrayList<String>();
        if (!formatFields.isEmpty()) {
            Iterator formatFieldsIterator = formatFields.getRows("FormatFields");
            while (formatFieldsIterator.hasNext()) {
                Row formatFieldRow = (Row)formatFieldsIterator.next();
                String fieldName2 = (String)formatFieldRow.get("FIELDNAME");
                if (Strings.isNullOrEmpty((String)fieldName2)) continue;
                colList.add(fieldName2);
            }
        }
        List<String> newCol = this.colList.stream().filter(p -> !colList.contains(p)).collect(Collectors.toList());
        newCol.forEach(fieldName -> {
            try {
                Row row = new Row("FormatFields");
                row.set("FORMATID", (Object)logProperties.getReportId());
                row.set("FIELDNAME", fieldName);
                formatFields.addRow(row);
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        });
        if (newCol.size() > 0) {
            PERSISTENCELITE.update(formatFields);
        }
        List list = Stream.concat(this.baseLogProcessorBean.colList.stream(), colList.stream()).distinct().collect(Collectors.toList());
        LuceneUtil.addAppToColsMap((String)String.valueOf(logProperties.getReportId()), list);
        LuceneUtil.addViewColsMap((String)String.valueOf(logProperties.getReportId()), list);
        return true;
    }

    public Long getRotationType() {
        return this.rotationType;
    }

    public void setRotationType(Long rotationType) {
        this.rotationType = rotationType;
    }

    public Long getAuditId() {
        return this.auditId;
    }

    public void setAuditId(Long auditId) {
        this.auditId = auditId;
    }
}

