/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.application.webserver.iis;

import com.manageengine.ela.server.application.webserver.iis.IISLogProperties;
import com.manageengine.ela.server.application.webserver.iis.processor.IISLogProcessor;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutor;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutorImpl;
import com.manageengine.ela.server.common.executors.queue.CommonQueueImpl;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import java.util.logging.Logger;

public class IISLogManager {
    private static final Logger LOGGER = Logger.getLogger(IISLogManager.class.getName());
    private static CommonQueueImpl<IISLogProperties> logPropertiesCommonQueue = new CommonQueueImpl();
    private static IISLogManager iisLogManager = null;
    private static IISLogProcessor logProcessor = new IISLogProcessor((ConcurrentQueue<IISLogProperties>)logPropertiesCommonQueue);
    private static ProcessorPoolExecutor poolExecutor = new ProcessorPoolExecutorImpl<IISLogProperties>(logProcessor, 10);

    public static IISLogManager getInstance() throws IllegalAccessException {
        if (iisLogManager == null) {
            iisLogManager = new IISLogManager();
        }
        poolExecutor.addProcessor();
        return iisLogManager;
    }

    public void addNewFile(IISLogProperties logProperties) throws Exception {
        LOGGER.info("New Import File Arrived : " + logProperties.getCompleteFilePath());
        logPropertiesCommonQueue.add(logProperties);
    }

    public void shutdown() throws InterruptedException {
        poolExecutor.waitForCompletion();
        logProcessor.stopIfQueueIsEmpty();
    }
}

